//Copyright (C) 2013 Steve Taylor (steve98654@gmail.com), Davis E. King
//License: Boost Software License.  See LICENSE.txt for full license.
#ifndef DLIB_NUMERIC_CONSTANTs_H_
#define DLIB_NUMERIC_CONSTANTs_H_

namespace dlib 
{

    // pi -- Pi
    constexpr double pi = 3.1415926535897932384626433832795029L;

    // pi_2 -- Pi / 2
    constexpr double pi_2 = 1.5707963267948966192313216916397514L;
    
    // pi_3 -- Pi / 3
    constexpr double pi_3 = 1.0471975511965977461542144610931676L;

    // pi_4 -- Pi / 4
    constexpr double pi_4 = 0.7853981633974483096156608458198757L;

    // e  -- Euler's Constant
    constexpr double e = 2.7182818284590452353602874713526625L;
    constexpr double euler = e;

    // sqrt_2 -- The square root of 2
    constexpr double sqrt_2 = 1.4142135623730950488016887242096981L;

    // sqrt_3 -- The square root of 3
    constexpr double sqrt_3 = 1.7320508075688772935274463415058723L;

    // log10_2 -- The logarithm base 10 of two
    constexpr double log10_2 = 0.30102999566398119521;

    // light_spd -- The speed of light in vacuum in meters per second
    constexpr double light_spd = 2.99792458e8;

    // newton_G  -- Newton's gravitational constant (in metric units of m^3/(kg*s^2))
    constexpr double newton_G = 6.67384e-11;

    // planck_cst -- Planck's constant (in units of Joules * seconds) 
    constexpr double planck_cst = 6.62606957e-34;

    // golden_ratio -- The Golden Ratio
    constexpr double golden_ratio = 1.6180339887498948482;

    // euler_gamma -- The Euler Mascheroni Constant 
    constexpr double euler_gamma = 0.5772156649015328606065120900824024L;

    // catalan -- Catalan's Constant
    constexpr double catalan = 0.91596559417721901505;

    // glaisher -- Glaisher Kinkelin constant
    constexpr double glaisher = 1.2824271291006226369;

    // khinchin -- Khinchin's constant
    constexpr double khinchin = 2.6854520010653064453;

    // apery -- Apery's constant
    constexpr double apery = 1.2020569031595942854;
}

#endif //DLIB_NUMERIC_CONSTANTs_H_

