/****************************************************************************
**
** Copyright (C) 2021 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the release tools of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// constructor
function Component()
{
    // Windows on ARM requires host binaries so add a dependency to host binaries
    var hostDependencyStr = "";
    var hostDependency = component.value("Dependencies");
    if (hostDependency) {
        hostDependencyStr = "qt.qt6.622.win64_msvc2019_64"
        component.setValue("Dependencies", hostDependencyStr)
        }
}

Component.prototype.createOperations = function()
{
    component.createOperations();

    if (installer.value("os") == "win") {
        var targetDir = installer.value("TargetDir");
        var qtPath = targetDir + "/6.2.2/msvc2019_arm64";

        // CMake is installed under Tools by default for all Qt installations
        var cmakeBinary = targetDir + "/Tools/CMake_64/bin/cmake.exe";
        var platform = "windows";

        var qmakeScript = qtPath + "\\bin\\qmake.bat";
        var qtCMakeScript = qtPath + "\\bin\\qt-cmake.bat";
        var qtCMakePrivateScript = qtPath + "\\bin\\qt-cmake-private.bat";
        var qtCMakeStandaloneTestScript = qtPath + "\\bin\\qt-cmake-standalone-test.bat";
        var targetQtConf = qtPath + "\\bin\\target_qt.conf";
        var qtToolchainCmake = qtPath + "\\lib\\cmake\\Qt6\\qt.toolchain.cmake";
        var qtBuildInternalsExtraCmake = qtPath + "\\lib\\cmake\\Qt6BuildInternals\\QtBuildInternalsExtra.cmake";

        // Initialize variables used for patching host qmake location
        // Host is qmake installed via dependencies
        var originalQmakePath = "/Users/qt/work/install/bin\\qmake.exe";
        var newQmakePath = targetDir + "\\6.2.2\\msvc2019_64\\bin\\qmake.exe";

        // Initialize variables used for patching CMake to under Tools
        var originalSetCMakePath = "C:/CMake/bin/cmake.exe";
        var newSetCMakePath = cmakeBinary.replace(/\\/g, "/");

        // Set new patched values for target_qt.conf
        var originalHostPrefix = "HostPrefix=../../";
        var newHostPrefix = "HostPrefix=../../msvc2019_64";
        var originalHostData = "HostData=target";
        var newHostData = "HostData=../msvc2019_arm64";

        // Set new patched values for qt.toolchain.cmake
        // cmake paths can use forward slash instead of backslash in paths which is unusual for Windows
        // Make whole path using forward slash a.k.a Unix path notation instead of backslash
        var windowsTargetDir = targetDir;
        var unixTargetDir = windowsTargetDir.replace(/\\/g, "/");
        console.log("Converting path for cmake: ");
        console.log("  from windowsTargetDir: " + windowsTargetDir);
        console.log("  to unixTargetDir: " + unixTargetDir);

        // __qt_initial_qt_host_path
        var originalQtHostPath = "/Users/qt/work/install";
        var newQtHostPath = unixTargetDir + "/6.2.2/msvc2019_64";

        //__qt_initial_qt_host_path_cmake_dir
        var originalQtHostPathCmakeDir = "/Users/qt/work/install/lib/cmake";
        var newQtHostPathCmakeDir = unixTargetDir + "/6.2.2/msvc2019/lib/cmake";

        // Set new patched values for QtBuildInternalsExtra.cmake
        var originalQtHostTargetPath = "/Users/qt/work/install/target";
        var newQtHostTargetPath = qtPath;

        // Patch build time paths from target\bin\qmake(.bat) script
        console.log("Patching qmake script: " + qmakeScript);
        console.log("  from originalQmakePath: " + originalQmakePath);
        console.log("  to newQmakePath: " + newQmakePath);
        component.addOperation("Replace", qmakeScript, originalQmakePath, newQmakePath);

        // Patch build time CMake path from qt-cmake(.bat) script
        console.log("Patching CMake path from qt-cmake script: " + qtCMakeScript);
        console.log("  from originalSetCMakePath: " + originalSetCMakePath);
        console.log("  to newSetCMakePath: " + newSetCMakePath);
        component.addOperation("Replace", qtCMakeScript, originalSetCMakePath, newSetCMakePath);

        // Patch build time CMAke paths from qt-cmake-private(.bat) script
        console.log("Patching CMake path from qt-cmake-private script: " + qtCMakePrivateScript);
        console.log("  from originalSetCMakePath: " + originalSetCMakePath);
        console.log("  to newSetCMakePath: " + newSetCMakePath);
        component.addOperation("Replace", qtCMakePrivateScript, originalSetCMakePath, newSetCMakePath);

        // Patch Host Prefix and Host Data paths from target_qt.conf
        console.log("Patching Host Prefix and Host Data from target_qt.conf: " + targetQtConf);
        console.log("  from originalHostPrefix: " + originalHostPrefix);
        console.log("  to newHostPrefix: " + newHostPrefix);
        console.log("  from originalHostData: " + originalHostData);
        console.log("  to newHostData: " + newHostData);
        component.addOperation("Replace", targetQtConf, originalHostPrefix, newHostPrefix);
        component.addOperation("Replace", targetQtConf , originalHostData, newHostData);

        // Append target_qt.conf with relative paths to documentation and examples
        var targetQtConf_documentation = "Documentation=../../Docs/Qt-6.2.2";
        var targetQtConf_examples = "Examples=../../Examples/Qt-6.2.2";
        console.log("Appending " + targetQtConf_documentation + " and " + targetQtConf_examples + " to targetQtConf" + targetQtConf);
        component.addOperation("AppendFile", targetQtConf, targetQtConf_documentation);
        // Add a new line to targetQtConf which AppendFile operation doesn't add automatically
        // \r\n = CR + LF used as a new line character in Windows
        component.addOperation("AppendFile", targetQtConf, "\r\n");
        component.addOperation("AppendFile", targetQtConf, targetQtConf_examples);

        // Patch Qt install path from qt.toolchain.cmake
        console.log("Patching install path from qt.toolchain.cmake : " + qtToolchainCmake);
        console.log("set __qt_initial_qt_host_path");
        console.log("  from originalQtHostPath: " + originalQtHostPath);
        console.log("  to newQtHostPath: " + newQtHostPath);
        component.addOperation("Replace", qtToolchainCmake, originalQtHostPath, newQtHostPath);
        console.log("set __qt_initial_qt_host_path_cmake_dir");
        console.log("  from originalQtHostPathCmakeDir: " + originalQtHostPathCmakeDir);
        console.log("  to newQtHostPathCmakeDir: " + newQtHostPathCmakeDir);
        component.addOperation("Replace", qtToolchainCmake, originalQtHostPathCmakeDir, newQtHostPathCmakeDir);

        // Patch Qt install path from QtBuildInternalsExtra.cmake
        console.log("Patching install path from QtBuildInternalsExtra.cmake : " + qtBuildInternalsExtraCmake);
        console.log("  from originalQtHostTargetPath: " + originalQtHostTargetPath);
        console.log("  to newQtHostTargetPath: " + newQtHostTargetPath);
        component.addOperation("Replace", qtBuildInternalsExtraCmake, originalQtHostTargetPath, newQtHostTargetPath);

        addInitQtPatchOperation(component, platform, qtPath, qmakeScript, "emb-arm-qt5");

        if (installer.value("SDKToolBinary") == "")
            return;

        component.addOperation("Execute",
                               ["@SDKToolBinary@", "addQt",
                                "--id", component.name,
                                "--name", "Qt %{Qt:Version} MSVC2019 ARM64",
                                "--type", "Qt4ProjectManager.QtVersion.Desktop",
                                "--qmake", qmakeScript,
                                "UNDOEXECUTE",
                                "@SDKToolBinary@", "rmQt", "--id", component.name]);

        var kitName = component.name + "_kit";
        component.addOperation("Execute",
                               ["@SDKToolBinary@", "addKit",
                                "--id", kitName,
                                "--name", "Desktop Qt %{Qt:Version} MSVC2019 ARM64",
                                "--Ctoolchain", "arm-windows-msvc2019-pe-64bit",
                                "--Cxxtoolchain", "arm-windows-msvc2019-pe-64bit",
                                "--qt", component.name,
                                "--debuggerengine", "4",
                                "--devicetype", "Desktop",
                                "UNDOEXECUTE",
                                "@SDKToolBinary@", "rmKit", "--id", kitName]);

        // create qt.conf file
        createQtConfFiles(component, installer.value("TargetDir") + "/6.2.2/msvc2019_arm64", "Qt-6.2.2");

        // is this OpenSource installation?
        var isOpenSource = "true";
        if (['true', 'yes', '1'].indexOf(isOpenSource) >= 0) {
            // patch qconfig.pri
            var qconfigFile = qtPath + "/mkspecs/qconfig.pri";
            component.addOperation("LineReplace", qconfigFile, "QT_EDITION =", "QT_EDITION = OpenSource");
            component.addOperation("LineReplace", qconfigFile, "QT_LICHECK = licheck.exe", "QT_LICHECK =");
        }
    }
}

