// Copyright (C) 2017 Klaralvdalens Datakonsult AB (KDAB).
// SPDX-License-Identifier: LicenseRef-Qt-Commercial OR LGPL-3.0-only OR GPL-2.0-only OR GPL-3.0-only

#ifndef QT3DCORE_QARMATURE_P_H
#define QT3DCORE_QARMATURE_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists for the convenience
// of other Qt classes.  This header file may change from version to
// version without notice, or even be removed.
//
// We mean it.
//

#include <Qt3DCore/private/qcomponent_p.h>
#include <Qt3DCore/qarmature.h>

QT_BEGIN_NAMESPACE

namespace Qt3DCore {

class QAbstractSkeleton;

class Q_3DCORE_PRIVATE_EXPORT QArmaturePrivate : public Qt3DCore::QComponentPrivate
{
public:
    QArmaturePrivate();

    Q_DECLARE_PUBLIC(QArmature)

    QAbstractSkeleton *m_skeleton;
};

struct QArmatureData
{
    QNodeId skeletonId;
};

} // namespace Qt3DCore


QT_END_NAMESPACE

#endif // QT3DCORE_QARMATURE_P_H
