/****************************************************************************
**
** Copyright (C) 2024 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the release tools of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:GPL-EXCEPT$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3 as published by the Free Software
** Foundation with exceptions as appearing in the file LICENSE.GPL3-EXCEPT
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// constructor
function Component()
{
    // Add dynamic dependency for mingw TC for Android packages on Windows.
    if (installer.value("os") == "win") {
        var mingw_tc_component = "qt.tools.win64_mingw900"
        component.addDependency(mingw_tc_component);
    }

    // add automatic dependency to Android main node if it's selected
    dependencyStr = "qt.qt6.670.android"

    // For release builds set the dependency directly to the host binary
    var hostDependencyStr = "";
    if (installer.value("os") == "x11") {
        // Linux on ARM supported from Qt 6.7 onward
        if ("670" == "dev" || 67 >= 67) {
            if (systemInfo.currentCpuArchitecture == "arm64") {
                hostDependencyStr = "qt.qt6.670.linux_gcc_arm64"
            }
            else {
                hostDependencyStr = "qt.qt6.670.linux_gcc_64"
            }
        }
        else {
            hostDependencyStr = "qt.qt6.670.gcc_64"
        }
    }
    else if (installer.value("os") == "mac") {
        hostDependencyStr = "qt.qt6.670.clang_64"
    }
    else if (installer.value("os") == "win") {
        hostDependencyStr = "qt.qt6.670.win64_mingw"
    }
    component.addDependency(hostDependencyStr);

    // Set automatic dependencies
    // - for release builds add dependency to the main Android node
    component.addAutoDependOn(dependencyStr);
}

Component.prototype.createOperations = function()
{
    component.createOperations();

    // Set path to QT to a variable
    var pathToQt = qtPathUnixSeparators("/6.7.0/android_x86_64");

    // patch qmake (.bat)
    component.addOperation("Replace", pathToQt + qmakeScript_670(), originalQmakePath_670("Linux-RHEL_8_8-Clang-Android-Android_ANY-X86_64"), newQmakePath_670("6.7.0", "Linux-RHEL_8_8-Clang-Android-Android_ANY-X86_64"));

    // patch qt-cmake(.bat)
    component.addOperation("Replace", pathToQt + qtCMakeScript_670(), originalSetCmakePath_670("Linux-RHEL_8_8-Clang-Android-Android_ANY-X86_64"), newSetCMakePath_670(), "regex");

    // Patch build time CMAke paths from qt-cmake-private(.bat) script
    component.addOperation("Replace", pathToQt + qtCMakePrivateScript_670(), originalSetCmakePath_670("Linux-RHEL_8_8-Clang-Android-Android_ANY-X86_64"), newSetCMakePath_670(), "regex");

    // Patch qt-configure-module
    if (installer.value("os") === "x11") {
        component.addOperation("Replace", pathToQt + qtConfigureModuleScript_670(), original_QtProcessConfigureArgsCmakePath_670(), new_QtProcessConfigureArgsCmakePath_670());
    }

    // If we are using executables from windows in unix environment we need to add
    // execute rights for those; windows doesn't set it automatically at creating phase.

    if (fromWindowsToUnixFlag_670("Linux-RHEL_8_8-Clang-Android-Android_ANY-X86_64") == true) {
        console.log("Setting execute rights for needed files.");

        component.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qmakeScript_670());
        component.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qtCMakeScript_670());
        component.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qtPathsScript_670());
        component.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qtCMakePrivateScript_670());
        component.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qtCMakeStandaloneTestScript_670());
        component.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qtConfigureModuleScript_670());

        // scripts with '6' are available only from Qt 6.4.0 ->
        if ("670" == "dev" || 67 >= 64) {
            component.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qmake6Script_670());
            component.addOperation("Execute", "{0}", "chmod", "+x", pathToQt + qtPaths6Script_670());
            }
    }

    // Patch Host Prefix, Host Data and Host Spec paths from target_qt.conf
    component.addOperation("Replace", pathToQt + targetQtConf_670(), originalHostPrefix_670(), newHostPrefix_670("Linux-RHEL_8_8-Clang-Android-Android_ANY-X86_64"));

    component.addOperation("Replace", pathToQt + targetQtConf_670(), originalHostData_670(), newHostData_670("x86_64"));

    component.addOperation("Replace", pathToQt + targetQtConf_670(), originalHostSpec_670("Linux-RHEL_8_8-Clang-Android-Android_ANY-X86_64"), newHostSpec_670());

    // Patch HostLibraryExecutables from target_qt.conf
    component.addOperation("LineReplace", pathToQt + targetQtConf_670(), "HostLibraryExecutables=", "HostLibraryExecutables=" + newHostLibExecutables_670());

    // Append target_qt.conf with relative paths to documentation and examples
    component.addOperation("AppendFile", pathToQt + targetQtConf_670(), targetQtConfDocumentation_670("6.7.0"));

    // Add a new line to targetQtConf which AppendFile operation doesn't add automatically
    if (installer.value("os") == "win") {
        // \r\n = CR + LF used as a new line character in Windows
        component.addOperation("AppendFile", pathToQt + targetQtConf_670(), "\r\n");
    }
    else {
        // \n = LF (Line Feed) used as a new line character in Unix/macOS
        component.addOperation("AppendFile", pathToQt + targetQtConf_670(), "\n");
    }
    component.addOperation("AppendFile", pathToQt + targetQtConf_670(), targetQtConfExamples_670("6.7.0"));

    // Patch Qt install path from qt.toolchain.cmake
    component.addOperation("Replace", pathToQt + qtToolchainCmake_670(), originalQtHostPath_670("Linux-RHEL_8_8-Clang-Android-Android_ANY-X86_64"), newQtHostPath_670("6.7.0", "Linux-RHEL_8_8-Clang-Android-Android_ANY-X86_64"));

    // Patch Qt install paths from QtBuildInternalsExtra.cmake
    component.addOperation("Replace", pathToQt + qtBuildInternalsExtraCmake_670(), originalBIPrefix_670("6.7.0", "Linux-RHEL_8_8-Clang-Android-Android_ANY-X86_64"), installer.value("TargetDir"));

    component.addOperation("Replace", pathToQt + qtBuildInternalsExtraCmake_670(), originalHostTargetPath_670("Linux-RHEL_8_8-Clang-Android-Android_ANY-X86_64"), pathToQt);

    // Patch Qt install path from qtpaths(.bat)
    component.addOperation("Replace", pathToQt + qtPathsScript_670(), originalQtPathsPath_670("Linux-RHEL_8_8-Clang-Android-Android_ANY-X86_64"), newQtPathsPath_670("6.7.0", "Linux-RHEL_8_8-Clang-Android-Android_ANY-X86_64"));

    if ("670" == "dev" || 67 >= 64) {

        // Patch Qt install path from Qt6Dependencies.cmake if file exist; it isn't available before Qt 6.4.0
        component.addOperation("Replace", pathToQt + qt6DependenciesCMakePath_670(), originalQtHostPath_670("Linux-RHEL_8_8-Clang-Android-Android_ANY-X86_64"), newQtHostPath_670("6.7.0", "Linux-RHEL_8_8-Clang-Android-Android_ANY-X86_64"));

        // patch qmake6(.bat) if file exist; it isn't available before Qt 6.4.0
        component.addOperation("Replace", pathToQt + qmake6Script_670(), originalQmakePath_670("Linux-RHEL_8_8-Clang-Android-Android_ANY-X86_64"), newQmakePath_670("6.7.0", "Linux-RHEL_8_8-Clang-Android-Android_ANY-X86_64"));

        // Patch Qt install path from qtpaths6(.bat) if file exist; it isn't available before Qt 6.4.0
        component.addOperation("Replace", pathToQt + qtPaths6Script_670(), originalQtPathsPath_670("Linux-RHEL_8_8-Clang-Android-Android_ANY-X86_64"), newQtPathsPath_670("6.7.0", "Linux-RHEL_8_8-Clang-Android-Android_ANY-X86_64"));
    }

    // Patch default ndk host from qdevice.pri
    component.addOperation("LineReplace", pathToQt + qdeviceFile_670(), "DEFAULT_ANDROID_NDK_HOST =", "DEFAULT_ANDROID_NDK_HOST = " + newNDKHost_670());

    addInitQtPatchOperation(component, platformIdentification_670(), pathToQt, pathToQt + qmakeScript_670(), "emb-arm-qt5");

    if (installer.value("SDKToolBinary") == "")
        return;

    // add Qt into QtCreator
    component.addOperation("Execute",
                           ["@SDKToolBinary@", "addQt",
                            "--id", component.name,
                            "--name", "Qt %{Qt:Version} for Android x86_64",
                            "--type", "Qt4ProjectManager.QtVersion.Android",
                            "--qmake", pathToQt + qmakeScript_670(),
                            "UNDOEXECUTE",
                            "@SDKToolBinary@", "rmQt", "--id", component.name]);

    // create qt.conf file
    createQtConfFiles(component, installer.value("TargetDir") + "/6.7.0/android_x86_64", "Qt-6.7.0");

    // patch qconfig.pri
    // is this OpenSource installation?
    var isOpenSource = "true";
    if (['true', 'yes', '1'].indexOf(isOpenSource) >= 0) {
        component.addOperation("LineReplace", pathToQt + qconfigFile_670(), "QT_EDITION =", "QT_EDITION = OpenSource");
    }
}

