/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.11.1
 *
 * Copyright (c) 2024 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt5.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtSql.h"

#line 37 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtSql/qsqldatabase.sip"
#include <qsqldatabase.h>
#line 29 "/build/pyqt5/src/PyQt5-5.15.11/build/QtSql/sipQtSqlQSqlDatabase.cpp"

#line 27 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qstring.sip"
#include <qstring.h>
#line 33 "/build/pyqt5/src/PyQt5-5.15.11/build/QtSql/sipQtSqlQSqlDatabase.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtSql/qsqldriver.sip"
#include <qsqldriver.h>
#line 36 "/build/pyqt5/src/PyQt5-5.15.11/build/QtSql/sipQtSqlQSqlDatabase.cpp"
#line 28 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtSql/qtsqlglobal.sip"
#include <qtsqlglobal.h>
#line 39 "/build/pyqt5/src/PyQt5-5.15.11/build/QtSql/sipQtSqlQSqlDatabase.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtSql/qsqldatabase.sip"
#include <qsqldatabase.h>
#line 42 "/build/pyqt5/src/PyQt5-5.15.11/build/QtSql/sipQtSqlQSqlDatabase.cpp"
#line 36 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qstringlist.sip"
#include <qstringlist.h>
#line 45 "/build/pyqt5/src/PyQt5-5.15.11/build/QtSql/sipQtSqlQSqlDatabase.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtSql/qsqlerror.sip"
#include <qsqlerror.h>
#line 48 "/build/pyqt5/src/PyQt5-5.15.11/build/QtSql/sipQtSqlQSqlDatabase.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtSql/qsqlquery.sip"
#include <qsqlquery.h>
#line 51 "/build/pyqt5/src/PyQt5-5.15.11/build/QtSql/sipQtSqlQSqlDatabase.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtSql/qsqlrecord.sip"
#include <qsqlrecord.h>
#line 54 "/build/pyqt5/src/PyQt5-5.15.11/build/QtSql/sipQtSqlQSqlDatabase.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtSql/qsqlindex.sip"
#include <qsqlindex.h>
#line 57 "/build/pyqt5/src/PyQt5-5.15.11/build/QtSql/sipQtSqlQSqlDatabase.cpp"


PyDoc_STRVAR(doc_QSqlDatabase_open, "open(self) -> bool\n"
"open(self, user: Optional[str], password: Optional[str]) -> bool");

extern "C" {static PyObject *meth_QSqlDatabase_open(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_open(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QSqlDatabase, &sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->open();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QString* a1;
        int a1State = 0;
        ::QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1J1", &sipSelf, sipType_QSqlDatabase, &sipCpp, sipType_QString, &a0, &a0State, sipType_QString, &a1, &a1State))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->open(*a0, *a1);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSqlDatabase, sipName_open, doc_QSqlDatabase_open);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSqlDatabase_close, "close(self)");

extern "C" {static PyObject *meth_QSqlDatabase_close(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_close(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QSqlDatabase, &sipCpp))
        {
            sipCpp->close();

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QSqlDatabase, sipName_close, doc_QSqlDatabase_close);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSqlDatabase_isOpen, "isOpen(self) -> bool");

extern "C" {static PyObject *meth_QSqlDatabase_isOpen(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_isOpen(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QSqlDatabase, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isOpen();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSqlDatabase, sipName_isOpen, doc_QSqlDatabase_isOpen);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSqlDatabase_isOpenError, "isOpenError(self) -> bool");

extern "C" {static PyObject *meth_QSqlDatabase_isOpenError(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_isOpenError(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QSqlDatabase, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isOpenError();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSqlDatabase, sipName_isOpenError, doc_QSqlDatabase_isOpenError);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSqlDatabase_tables, "tables(self, type: QSql.TableType = QSql.Tables) -> list[str]");

extern "C" {static PyObject *meth_QSqlDatabase_tables(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_tables(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QSql::TableType a0 = QSql::Tables;
        const ::QSqlDatabase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_type,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|E", &sipSelf, sipType_QSqlDatabase, &sipCpp, sipType_QSql_TableType, &a0))
        {
            ::QStringList*sipRes;

            sipRes = new ::QStringList(sipCpp->tables(a0));

            return sipConvertFromNewType(sipRes, sipType_QStringList, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSqlDatabase, sipName_tables, doc_QSqlDatabase_tables);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSqlDatabase_primaryIndex, "primaryIndex(self, tablename: Optional[str]) -> QSqlIndex");

extern "C" {static PyObject *meth_QSqlDatabase_primaryIndex(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_primaryIndex(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QSqlDatabase, &sipCpp, sipType_QString, &a0, &a0State))
        {
            ::QSqlIndex*sipRes;

            sipRes = new ::QSqlIndex(sipCpp->primaryIndex(*a0));
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return sipConvertFromNewType(sipRes, sipType_QSqlIndex, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSqlDatabase, sipName_primaryIndex, doc_QSqlDatabase_primaryIndex);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSqlDatabase_record, "record(self, tablename: Optional[str]) -> QSqlRecord");

extern "C" {static PyObject *meth_QSqlDatabase_record(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_record(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QSqlDatabase, &sipCpp, sipType_QString, &a0, &a0State))
        {
            ::QSqlRecord*sipRes;

            sipRes = new ::QSqlRecord(sipCpp->record(*a0));
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return sipConvertFromNewType(sipRes, sipType_QSqlRecord, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSqlDatabase, sipName_record, doc_QSqlDatabase_record);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSqlDatabase_exec_, "exec_(self, query: Optional[str] = '') -> QSqlQuery");

extern "C" {static PyObject *meth_QSqlDatabase_exec_(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_exec_(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString& a0def = QString();
        const ::QString* a0 = &a0def;
        int a0State = 0;
        const ::QSqlDatabase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_query,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|J1", &sipSelf, sipType_QSqlDatabase, &sipCpp, sipType_QString, &a0, &a0State))
        {
            ::QSqlQuery*sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::QSqlQuery(sipCpp->exec(*a0));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return sipConvertFromNewType(sipRes, sipType_QSqlQuery, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSqlDatabase, sipName_exec_, doc_QSqlDatabase_exec_);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSqlDatabase_exec, "exec(self, query: Optional[str] = '') -> QSqlQuery");

extern "C" {static PyObject *meth_QSqlDatabase_exec(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_exec(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString& a0def = QString();
        const ::QString* a0 = &a0def;
        int a0State = 0;
        const ::QSqlDatabase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_query,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|J1", &sipSelf, sipType_QSqlDatabase, &sipCpp, sipType_QString, &a0, &a0State))
        {
            ::QSqlQuery*sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::QSqlQuery(sipCpp->exec(*a0));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return sipConvertFromNewType(sipRes, sipType_QSqlQuery, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSqlDatabase, sipName_exec, doc_QSqlDatabase_exec);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSqlDatabase_lastError, "lastError(self) -> QSqlError");

extern "C" {static PyObject *meth_QSqlDatabase_lastError(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_lastError(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QSqlDatabase, &sipCpp))
        {
            ::QSqlError*sipRes;

            sipRes = new ::QSqlError(sipCpp->lastError());

            return sipConvertFromNewType(sipRes, sipType_QSqlError, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSqlDatabase, sipName_lastError, doc_QSqlDatabase_lastError);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSqlDatabase_isValid, "isValid(self) -> bool");

extern "C" {static PyObject *meth_QSqlDatabase_isValid(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_isValid(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QSqlDatabase, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isValid();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSqlDatabase, sipName_isValid, doc_QSqlDatabase_isValid);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSqlDatabase_transaction, "transaction(self) -> bool");

extern "C" {static PyObject *meth_QSqlDatabase_transaction(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_transaction(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QSqlDatabase, &sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->transaction();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSqlDatabase, sipName_transaction, doc_QSqlDatabase_transaction);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSqlDatabase_commit, "commit(self) -> bool");

extern "C" {static PyObject *meth_QSqlDatabase_commit(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_commit(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QSqlDatabase, &sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->commit();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSqlDatabase, sipName_commit, doc_QSqlDatabase_commit);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSqlDatabase_rollback, "rollback(self) -> bool");

extern "C" {static PyObject *meth_QSqlDatabase_rollback(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_rollback(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QSqlDatabase, &sipCpp))
        {
            bool sipRes;

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->rollback();
            Py_END_ALLOW_THREADS

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSqlDatabase, sipName_rollback, doc_QSqlDatabase_rollback);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSqlDatabase_setDatabaseName, "setDatabaseName(self, name: Optional[str])");

extern "C" {static PyObject *meth_QSqlDatabase_setDatabaseName(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_setDatabaseName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        ::QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QSqlDatabase, &sipCpp, sipType_QString, &a0, &a0State))
        {
            sipCpp->setDatabaseName(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QSqlDatabase, sipName_setDatabaseName, doc_QSqlDatabase_setDatabaseName);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSqlDatabase_setUserName, "setUserName(self, name: Optional[str])");

extern "C" {static PyObject *meth_QSqlDatabase_setUserName(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_setUserName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        ::QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QSqlDatabase, &sipCpp, sipType_QString, &a0, &a0State))
        {
            sipCpp->setUserName(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QSqlDatabase, sipName_setUserName, doc_QSqlDatabase_setUserName);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSqlDatabase_setPassword, "setPassword(self, password: Optional[str])");

extern "C" {static PyObject *meth_QSqlDatabase_setPassword(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_setPassword(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        ::QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QSqlDatabase, &sipCpp, sipType_QString, &a0, &a0State))
        {
            sipCpp->setPassword(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QSqlDatabase, sipName_setPassword, doc_QSqlDatabase_setPassword);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSqlDatabase_setHostName, "setHostName(self, host: Optional[str])");

extern "C" {static PyObject *meth_QSqlDatabase_setHostName(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_setHostName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        ::QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QSqlDatabase, &sipCpp, sipType_QString, &a0, &a0State))
        {
            sipCpp->setHostName(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QSqlDatabase, sipName_setHostName, doc_QSqlDatabase_setHostName);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSqlDatabase_setPort, "setPort(self, p: int)");

extern "C" {static PyObject *meth_QSqlDatabase_setPort(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_setPort(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        ::QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QSqlDatabase, &sipCpp, &a0))
        {
            sipCpp->setPort(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QSqlDatabase, sipName_setPort, doc_QSqlDatabase_setPort);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSqlDatabase_setConnectOptions, "setConnectOptions(self, options: Optional[str] = '')");

extern "C" {static PyObject *meth_QSqlDatabase_setConnectOptions(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_setConnectOptions(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString& a0def = QString();
        const ::QString* a0 = &a0def;
        int a0State = 0;
        ::QSqlDatabase *sipCpp;

        static const char *sipKwdList[] = {
            sipName_options,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "B|J1", &sipSelf, sipType_QSqlDatabase, &sipCpp, sipType_QString, &a0, &a0State))
        {
            sipCpp->setConnectOptions(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QSqlDatabase, sipName_setConnectOptions, doc_QSqlDatabase_setConnectOptions);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSqlDatabase_databaseName, "databaseName(self) -> str");

extern "C" {static PyObject *meth_QSqlDatabase_databaseName(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_databaseName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QSqlDatabase, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->databaseName());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSqlDatabase, sipName_databaseName, doc_QSqlDatabase_databaseName);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSqlDatabase_userName, "userName(self) -> str");

extern "C" {static PyObject *meth_QSqlDatabase_userName(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_userName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QSqlDatabase, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->userName());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSqlDatabase, sipName_userName, doc_QSqlDatabase_userName);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSqlDatabase_password, "password(self) -> str");

extern "C" {static PyObject *meth_QSqlDatabase_password(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_password(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QSqlDatabase, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->password());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSqlDatabase, sipName_password, doc_QSqlDatabase_password);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSqlDatabase_hostName, "hostName(self) -> str");

extern "C" {static PyObject *meth_QSqlDatabase_hostName(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_hostName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QSqlDatabase, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->hostName());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSqlDatabase, sipName_hostName, doc_QSqlDatabase_hostName);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSqlDatabase_driverName, "driverName(self) -> str");

extern "C" {static PyObject *meth_QSqlDatabase_driverName(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_driverName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QSqlDatabase, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->driverName());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSqlDatabase, sipName_driverName, doc_QSqlDatabase_driverName);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSqlDatabase_port, "port(self) -> int");

extern "C" {static PyObject *meth_QSqlDatabase_port(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_port(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QSqlDatabase, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->port();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSqlDatabase, sipName_port, doc_QSqlDatabase_port);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSqlDatabase_connectOptions, "connectOptions(self) -> str");

extern "C" {static PyObject *meth_QSqlDatabase_connectOptions(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_connectOptions(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QSqlDatabase, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->connectOptions());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSqlDatabase, sipName_connectOptions, doc_QSqlDatabase_connectOptions);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSqlDatabase_connectionName, "connectionName(self) -> str");

extern "C" {static PyObject *meth_QSqlDatabase_connectionName(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_connectionName(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QSqlDatabase, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->connectionName());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSqlDatabase, sipName_connectionName, doc_QSqlDatabase_connectionName);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSqlDatabase_driver, "driver(self) -> Optional[QSqlDriver]");

extern "C" {static PyObject *meth_QSqlDatabase_driver(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_driver(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QSqlDatabase, &sipCpp))
        {
            ::QSqlDriver*sipRes;

            sipRes = sipCpp->driver();

            return sipConvertFromType(sipRes, sipType_QSqlDriver, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSqlDatabase, sipName_driver, doc_QSqlDatabase_driver);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSqlDatabase_addDatabase, "addDatabase(type: Optional[str], connectionName: Optional[str] = '') -> QSqlDatabase\n"
"addDatabase(driver: Optional[QSqlDriver], connectionName: Optional[str] = '') -> QSqlDatabase");

extern "C" {static PyObject *meth_QSqlDatabase_addDatabase(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_addDatabase(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QString& a1def = QLatin1String(QSqlDatabase::defaultConnection);
        const ::QString* a1 = &a1def;
        int a1State = 0;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_connectionName,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J1|J1", sipType_QString, &a0, &a0State, sipType_QString, &a1, &a1State))
        {
            ::QSqlDatabase*sipRes;

            sipRes = new ::QSqlDatabase(::QSqlDatabase::addDatabase(*a0, *a1));
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);

            return sipConvertFromNewType(sipRes, sipType_QSqlDatabase, SIP_NULLPTR);
        }
    }

    {
        ::QSqlDriver* a0;
        const ::QString& a1def = QLatin1String(QSqlDatabase::defaultConnection);
        const ::QString* a1 = &a1def;
        int a1State = 0;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_connectionName,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "J8|J1", sipType_QSqlDriver, &a0, sipType_QString, &a1, &a1State))
        {
            ::QSqlDatabase*sipRes;

            sipRes = new ::QSqlDatabase(::QSqlDatabase::addDatabase(a0, *a1));
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);

            return sipConvertFromNewType(sipRes, sipType_QSqlDatabase, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSqlDatabase, sipName_addDatabase, doc_QSqlDatabase_addDatabase);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSqlDatabase_cloneDatabase, "cloneDatabase(other: QSqlDatabase, connectionName: Optional[str]) -> QSqlDatabase\n"
"cloneDatabase(other: Optional[str], connectionName: Optional[str]) -> QSqlDatabase");

extern "C" {static PyObject *meth_QSqlDatabase_cloneDatabase(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_cloneDatabase(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSqlDatabase* a0;
        const ::QString* a1;
        int a1State = 0;

        if (sipParseArgs(&sipParseErr, sipArgs, "J9J1", sipType_QSqlDatabase, &a0, sipType_QString, &a1, &a1State))
        {
            ::QSqlDatabase*sipRes;

            sipRes = new ::QSqlDatabase(::QSqlDatabase::cloneDatabase(*a0, *a1));
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);

            return sipConvertFromNewType(sipRes, sipType_QSqlDatabase, SIP_NULLPTR);
        }
    }

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QString* a1;
        int a1State = 0;

        if (sipParseArgs(&sipParseErr, sipArgs, "J1J1", sipType_QString, &a0, &a0State, sipType_QString, &a1, &a1State))
        {
            ::QSqlDatabase*sipRes;

            sipRes = new ::QSqlDatabase(::QSqlDatabase::cloneDatabase(*a0, *a1));
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
            sipReleaseType(const_cast< ::QString *>(a1), sipType_QString, a1State);

            return sipConvertFromNewType(sipRes, sipType_QSqlDatabase, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSqlDatabase, sipName_cloneDatabase, doc_QSqlDatabase_cloneDatabase);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSqlDatabase_database, "database(connectionName: Optional[str] = '', open: bool = True) -> QSqlDatabase");

extern "C" {static PyObject *meth_QSqlDatabase_database(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_database(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString& a0def = QLatin1String(QSqlDatabase::defaultConnection);
        const ::QString* a0 = &a0def;
        int a0State = 0;
        bool a1 = 1;

        static const char *sipKwdList[] = {
            sipName_connectionName,
            sipName_open,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "|J1b", sipType_QString, &a0, &a0State, &a1))
        {
            ::QSqlDatabase*sipRes;

            sipRes = new ::QSqlDatabase(::QSqlDatabase::database(*a0, a1));
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return sipConvertFromNewType(sipRes, sipType_QSqlDatabase, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSqlDatabase, sipName_database, doc_QSqlDatabase_database);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSqlDatabase_removeDatabase, "removeDatabase(connectionName: Optional[str])");

extern "C" {static PyObject *meth_QSqlDatabase_removeDatabase(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_removeDatabase(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArgs, "J1", sipType_QString, &a0, &a0State))
        {
            ::QSqlDatabase::removeDatabase(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QSqlDatabase, sipName_removeDatabase, doc_QSqlDatabase_removeDatabase);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSqlDatabase_contains, "contains(connectionName: Optional[str] = '') -> bool");

extern "C" {static PyObject *meth_QSqlDatabase_contains(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_contains(PyObject *, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString& a0def = QLatin1String(QSqlDatabase::defaultConnection);
        const ::QString* a0 = &a0def;
        int a0State = 0;

        static const char *sipKwdList[] = {
            sipName_connectionName,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "|J1", sipType_QString, &a0, &a0State))
        {
            bool sipRes;

            sipRes = ::QSqlDatabase::contains(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSqlDatabase, sipName_contains, doc_QSqlDatabase_contains);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSqlDatabase_drivers, "drivers() -> list[str]");

extern "C" {static PyObject *meth_QSqlDatabase_drivers(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_drivers(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            ::QStringList*sipRes;

            sipRes = new ::QStringList(::QSqlDatabase::drivers());

            return sipConvertFromNewType(sipRes, sipType_QStringList, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSqlDatabase, sipName_drivers, doc_QSqlDatabase_drivers);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSqlDatabase_connectionNames, "connectionNames() -> list[str]");

extern "C" {static PyObject *meth_QSqlDatabase_connectionNames(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_connectionNames(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            ::QStringList*sipRes;

            sipRes = new ::QStringList(::QSqlDatabase::connectionNames());

            return sipConvertFromNewType(sipRes, sipType_QStringList, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSqlDatabase, sipName_connectionNames, doc_QSqlDatabase_connectionNames);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSqlDatabase_registerSqlDriver, "registerSqlDriver(name: Optional[str], creator: Optional[QSqlDriverCreatorBase])");

extern "C" {static PyObject *meth_QSqlDatabase_registerSqlDriver(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_registerSqlDriver(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        ::QSqlDriverCreatorBase* a1;

        if (sipParseArgs(&sipParseErr, sipArgs, "J1J:", sipType_QString, &a0, &a0State, sipType_QSqlDriverCreatorBase, &a1))
        {
            ::QSqlDatabase::registerSqlDriver(*a0, a1);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QSqlDatabase, sipName_registerSqlDriver, doc_QSqlDatabase_registerSqlDriver);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSqlDatabase_isDriverAvailable, "isDriverAvailable(name: Optional[str]) -> bool");

extern "C" {static PyObject *meth_QSqlDatabase_isDriverAvailable(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_isDriverAvailable(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;

        if (sipParseArgs(&sipParseErr, sipArgs, "J1", sipType_QString, &a0, &a0State))
        {
            bool sipRes;

            sipRes = ::QSqlDatabase::isDriverAvailable(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSqlDatabase, sipName_isDriverAvailable, doc_QSqlDatabase_isDriverAvailable);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSqlDatabase_setNumericalPrecisionPolicy, "setNumericalPrecisionPolicy(self, precisionPolicy: QSql.NumericalPrecisionPolicy)");

extern "C" {static PyObject *meth_QSqlDatabase_setNumericalPrecisionPolicy(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_setNumericalPrecisionPolicy(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QSql::NumericalPrecisionPolicy a0;
        ::QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BE", &sipSelf, sipType_QSqlDatabase, &sipCpp, sipType_QSql_NumericalPrecisionPolicy, &a0))
        {
            sipCpp->setNumericalPrecisionPolicy(a0);

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_QSqlDatabase, sipName_setNumericalPrecisionPolicy, doc_QSqlDatabase_setNumericalPrecisionPolicy);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QSqlDatabase_numericalPrecisionPolicy, "numericalPrecisionPolicy(self) -> QSql.NumericalPrecisionPolicy");

extern "C" {static PyObject *meth_QSqlDatabase_numericalPrecisionPolicy(PyObject *, PyObject *);}
static PyObject *meth_QSqlDatabase_numericalPrecisionPolicy(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QSqlDatabase *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QSqlDatabase, &sipCpp))
        {
            ::QSql::NumericalPrecisionPolicy sipRes;

            sipRes = sipCpp->numericalPrecisionPolicy();

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_QSql_NumericalPrecisionPolicy);
        }
    }

    sipNoMethod(sipParseErr, sipName_QSqlDatabase, sipName_numericalPrecisionPolicy, doc_QSqlDatabase_numericalPrecisionPolicy);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QSqlDatabase(void *, int);}
static void release_QSqlDatabase(void *sipCppV, int)
{
    delete reinterpret_cast< ::QSqlDatabase *>(sipCppV);
}


extern "C" {static void *array_QSqlDatabase(Py_ssize_t);}
static void *array_QSqlDatabase(Py_ssize_t sipNrElem)
{
    return new ::QSqlDatabase[sipNrElem];
}


extern "C" {static void array_delete_QSqlDatabase(void *);}
static void array_delete_QSqlDatabase(void *sipCpp)
{
    delete[] reinterpret_cast< ::QSqlDatabase *>(sipCpp);
}


extern "C" {static void assign_QSqlDatabase(void *, Py_ssize_t, void *);}
static void assign_QSqlDatabase(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QSqlDatabase *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QSqlDatabase *>(sipSrc);
}


extern "C" {static void *copy_QSqlDatabase(const void *, Py_ssize_t);}
static void *copy_QSqlDatabase(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QSqlDatabase(reinterpret_cast<const ::QSqlDatabase *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QSqlDatabase(sipSimpleWrapper *);}
static void dealloc_QSqlDatabase(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QSqlDatabase(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QSqlDatabase(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QSqlDatabase(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QSqlDatabase *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            sipCpp = new ::QSqlDatabase();

            return sipCpp;
        }
    }

    {
        const ::QSqlDatabase* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QSqlDatabase, &a0))
        {
            sipCpp = new ::QSqlDatabase(*a0);

            return sipCpp;
        }
    }

    {
        const ::QString* a0;
        int a0State = 0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J1", sipType_QString, &a0, &a0State))
        {
            sipCpp = new ::QSqlDatabase(*a0);
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);

            return sipCpp;
        }
    }

    {
        ::QSqlDriver* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J8", sipType_QSqlDriver, &a0))
        {
            sipCpp = new ::QSqlDatabase(a0);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_QSqlDatabase[] = {
    {sipName_addDatabase, SIP_MLMETH_CAST(meth_QSqlDatabase_addDatabase), METH_VARARGS|METH_KEYWORDS, doc_QSqlDatabase_addDatabase},
    {sipName_cloneDatabase, meth_QSqlDatabase_cloneDatabase, METH_VARARGS, doc_QSqlDatabase_cloneDatabase},
    {sipName_close, meth_QSqlDatabase_close, METH_VARARGS, doc_QSqlDatabase_close},
    {sipName_commit, meth_QSqlDatabase_commit, METH_VARARGS, doc_QSqlDatabase_commit},
    {sipName_connectOptions, meth_QSqlDatabase_connectOptions, METH_VARARGS, doc_QSqlDatabase_connectOptions},
    {sipName_connectionName, meth_QSqlDatabase_connectionName, METH_VARARGS, doc_QSqlDatabase_connectionName},
    {sipName_connectionNames, meth_QSqlDatabase_connectionNames, METH_VARARGS, doc_QSqlDatabase_connectionNames},
    {sipName_contains, SIP_MLMETH_CAST(meth_QSqlDatabase_contains), METH_VARARGS|METH_KEYWORDS, doc_QSqlDatabase_contains},
    {sipName_database, SIP_MLMETH_CAST(meth_QSqlDatabase_database), METH_VARARGS|METH_KEYWORDS, doc_QSqlDatabase_database},
    {sipName_databaseName, meth_QSqlDatabase_databaseName, METH_VARARGS, doc_QSqlDatabase_databaseName},
    {sipName_driver, meth_QSqlDatabase_driver, METH_VARARGS, doc_QSqlDatabase_driver},
    {sipName_driverName, meth_QSqlDatabase_driverName, METH_VARARGS, doc_QSqlDatabase_driverName},
    {sipName_drivers, meth_QSqlDatabase_drivers, METH_VARARGS, doc_QSqlDatabase_drivers},
    {sipName_exec, SIP_MLMETH_CAST(meth_QSqlDatabase_exec), METH_VARARGS|METH_KEYWORDS, doc_QSqlDatabase_exec},
    {sipName_exec_, SIP_MLMETH_CAST(meth_QSqlDatabase_exec_), METH_VARARGS|METH_KEYWORDS, doc_QSqlDatabase_exec_},
    {sipName_hostName, meth_QSqlDatabase_hostName, METH_VARARGS, doc_QSqlDatabase_hostName},
    {sipName_isDriverAvailable, meth_QSqlDatabase_isDriverAvailable, METH_VARARGS, doc_QSqlDatabase_isDriverAvailable},
    {sipName_isOpen, meth_QSqlDatabase_isOpen, METH_VARARGS, doc_QSqlDatabase_isOpen},
    {sipName_isOpenError, meth_QSqlDatabase_isOpenError, METH_VARARGS, doc_QSqlDatabase_isOpenError},
    {sipName_isValid, meth_QSqlDatabase_isValid, METH_VARARGS, doc_QSqlDatabase_isValid},
    {sipName_lastError, meth_QSqlDatabase_lastError, METH_VARARGS, doc_QSqlDatabase_lastError},
    {sipName_numericalPrecisionPolicy, meth_QSqlDatabase_numericalPrecisionPolicy, METH_VARARGS, doc_QSqlDatabase_numericalPrecisionPolicy},
    {sipName_open, meth_QSqlDatabase_open, METH_VARARGS, doc_QSqlDatabase_open},
    {sipName_password, meth_QSqlDatabase_password, METH_VARARGS, doc_QSqlDatabase_password},
    {sipName_port, meth_QSqlDatabase_port, METH_VARARGS, doc_QSqlDatabase_port},
    {sipName_primaryIndex, meth_QSqlDatabase_primaryIndex, METH_VARARGS, doc_QSqlDatabase_primaryIndex},
    {sipName_record, meth_QSqlDatabase_record, METH_VARARGS, doc_QSqlDatabase_record},
    {sipName_registerSqlDriver, meth_QSqlDatabase_registerSqlDriver, METH_VARARGS, doc_QSqlDatabase_registerSqlDriver},
    {sipName_removeDatabase, meth_QSqlDatabase_removeDatabase, METH_VARARGS, doc_QSqlDatabase_removeDatabase},
    {sipName_rollback, meth_QSqlDatabase_rollback, METH_VARARGS, doc_QSqlDatabase_rollback},
    {sipName_setConnectOptions, SIP_MLMETH_CAST(meth_QSqlDatabase_setConnectOptions), METH_VARARGS|METH_KEYWORDS, doc_QSqlDatabase_setConnectOptions},
    {sipName_setDatabaseName, meth_QSqlDatabase_setDatabaseName, METH_VARARGS, doc_QSqlDatabase_setDatabaseName},
    {sipName_setHostName, meth_QSqlDatabase_setHostName, METH_VARARGS, doc_QSqlDatabase_setHostName},
    {sipName_setNumericalPrecisionPolicy, meth_QSqlDatabase_setNumericalPrecisionPolicy, METH_VARARGS, doc_QSqlDatabase_setNumericalPrecisionPolicy},
    {sipName_setPassword, meth_QSqlDatabase_setPassword, METH_VARARGS, doc_QSqlDatabase_setPassword},
    {sipName_setPort, meth_QSqlDatabase_setPort, METH_VARARGS, doc_QSqlDatabase_setPort},
    {sipName_setUserName, meth_QSqlDatabase_setUserName, METH_VARARGS, doc_QSqlDatabase_setUserName},
    {sipName_tables, SIP_MLMETH_CAST(meth_QSqlDatabase_tables), METH_VARARGS|METH_KEYWORDS, doc_QSqlDatabase_tables},
    {sipName_transaction, meth_QSqlDatabase_transaction, METH_VARARGS, doc_QSqlDatabase_transaction},
    {sipName_userName, meth_QSqlDatabase_userName, METH_VARARGS, doc_QSqlDatabase_userName}
};

PyDoc_STRVAR(doc_QSqlDatabase, "\1QSqlDatabase()\n"
"QSqlDatabase(other: QSqlDatabase)\n"
"QSqlDatabase(type: Optional[str])\n"
"QSqlDatabase(driver: Optional[QSqlDriver])");


static pyqt5ClassPluginDef plugin_QSqlDatabase = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef_QtSql_QSqlDatabase = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QSqlDatabase,
        SIP_NULLPTR,
        &plugin_QSqlDatabase,
    },
    {
        sipNameNr_QSqlDatabase,
        {0, 0, 1},
        40, methods_QSqlDatabase,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QSqlDatabase,
    -1,
    sipNameNr_sip_simplewrapper,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_QSqlDatabase,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QSqlDatabase,
    assign_QSqlDatabase,
    array_QSqlDatabase,
    copy_QSqlDatabase,
    release_QSqlDatabase,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QSqlDatabase,
    sizeof (::QSqlDatabase),
};
