//
// Automatically generated by ipdlc.
// Edit at your own risk
//

#ifndef DOMTypes_h
#define DOMTypes_h

#include "mozilla/Attributes.h"
#include "IPCMessageStart.h"
#include "mozilla/RefPtr.h"
#include "nsString.h"
#include "nsTArray.h"
#include "nsTHashtable.h"
#include "mozilla/MozPromise.h"
#include "mozilla/OperatorNewExtensions.h"
#include "mozilla/UniquePtr.h"
#include "mozilla/ipc/ByteBuf.h"
#include "mozilla/ipc/FileDescriptor.h"
#include "mozilla/ipc/IPCForwards.h"
#include "mozilla/ipc/Shmem.h"

// Headers for typedefs
#include "Units.h"
#include "mozilla/HalIPCUtils.h"
#include "mozilla/RemoteLazyInputStream.h"
#include "mozilla/ScrollbarPreferences.h"
#include "mozilla/TimeStamp.h"
#include "mozilla/dom/BrowsingContext.h"
#include "mozilla/dom/LoadURIOptionsBinding.h"
#include "mozilla/dom/NavigationBinding.h"
#include "mozilla/dom/NotificationBinding.h"
#include "mozilla/dom/SessionHistoryEntry.h"
#include "mozilla/dom/UserNavigationInvolvement.h"
#include "mozilla/gfx/Types.h"
#include "mozilla/ipc/BigBuffer.h"
#include "mozilla/ipc/IPCStreamUtils.h"
#include "mozilla/ipc/IPDLStructMember.h"
#include "mozilla/ipc/SerializedStructuredCloneBuffer.h"
#include "mozilla/net/ClassOfService.h"
#include "nsIClassifiedChannel.h"
#include "nsILoadInfo.h"
#include "nsIPolicyContainer.h"
#include "nsIPrincipal.h"
#include "nsIReferrerInfo.h"
#include "nsIURI.h"
#include "nsIVariant.h"
#include "nsIWidgetListener.h"
#include "mozilla/dom/IPCBlob.h"
#include "mozilla/ipc/IPCStream.h"
#include "mozilla/ipc/ProtocolTypes.h"


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct MessagePortIdentifier|
//
namespace mozilla {
namespace dom {
class MessagePortIdentifier final
{
private:
    typedef ::nsID nsID;
    typedef ::uint32_t uint32_t;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    MessagePortIdentifier() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT MessagePortIdentifier(
            const nsID& _uuid,
            const nsID& _destinationUuid,
            const uint32_t& _sequenceId,
            const bool& _neutered) :
        uuid_(_uuid),
        destinationUuid_(_destinationUuid),
        neutered_(_neutered),
        sequenceId_(_sequenceId)
    {
    }

    MOZ_IMPLICIT MessagePortIdentifier(
            nsID&& _uuid,
            nsID&& _destinationUuid,
            uint32_t&& _sequenceId,
            bool&& _neutered) :
        uuid_(std::move(_uuid)),
        destinationUuid_(std::move(_destinationUuid)),
        neutered_(std::move(_neutered)),
        sequenceId_(std::move(_sequenceId))
    {
    }

    nsID&
    uuid()
    {
        return uuid_;
    }
    const nsID&
    uuid() const
    {
        return uuid_;
    }

    nsID&
    destinationUuid()
    {
        return destinationUuid_;
    }
    const nsID&
    destinationUuid() const
    {
        return destinationUuid_;
    }

    uint32_t&
    sequenceId()
    {
        return sequenceId_;
    }
    const uint32_t&
    sequenceId() const
    {
        return sequenceId_;
    }

    bool&
    neutered()
    {
        return neutered_;
    }
    const bool&
    neutered() const
    {
        return neutered_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsID> uuid_;
    ::mozilla::ipc::IPDLStructMember<nsID> destinationUuid_;
    ::mozilla::ipc::IPDLStructMember<bool> neutered_;
    ::mozilla::ipc::IPDLStructMember<uint32_t> sequenceId_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::MessagePortIdentifier>
{
    typedef ::mozilla::dom::MessagePortIdentifier paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ClonedMessageData|
//
namespace mozilla {
namespace dom {
class ClonedMessageData final
{
private:
    typedef ::mozilla::SerializedStructuredCloneBuffer SerializedStructuredCloneBuffer;
    typedef ::mozilla::dom::IPCBlob IPCBlob;
    typedef ::mozilla::ipc::IPCStream IPCStream;
    typedef ::mozilla::dom::MessagePortIdentifier MessagePortIdentifier;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ClonedMessageData() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ClonedMessageData(
            SerializedStructuredCloneBuffer&& _data,
            const nsTArray<IPCBlob>& _blobs,
            const nsTArray<IPCStream>& _inputStreams,
            const nsTArray<MessagePortIdentifier>& _identifiers) :
        data_(std::move(_data)),
        blobs_(_blobs),
        inputStreams_(_inputStreams),
        identifiers_(_identifiers)
    {
    }

    MOZ_IMPLICIT ClonedMessageData(
            SerializedStructuredCloneBuffer&& _data,
            nsTArray<IPCBlob>&& _blobs,
            nsTArray<IPCStream>&& _inputStreams,
            nsTArray<MessagePortIdentifier>&& _identifiers) :
        data_(std::move(_data)),
        blobs_(std::move(_blobs)),
        inputStreams_(std::move(_inputStreams)),
        identifiers_(std::move(_identifiers))
    {
    }

    SerializedStructuredCloneBuffer&
    data()
    {
        return data_;
    }
    const SerializedStructuredCloneBuffer&
    data() const
    {
        return data_;
    }

    nsTArray<IPCBlob>&
    blobs()
    {
        return blobs_;
    }
    const nsTArray<IPCBlob>&
    blobs() const
    {
        return blobs_;
    }

    nsTArray<IPCStream>&
    inputStreams()
    {
        return inputStreams_;
    }
    const nsTArray<IPCStream>&
    inputStreams() const
    {
        return inputStreams_;
    }

    nsTArray<MessagePortIdentifier>&
    identifiers()
    {
        return identifiers_;
    }
    const nsTArray<MessagePortIdentifier>&
    identifiers() const
    {
        return identifiers_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<SerializedStructuredCloneBuffer> data_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<IPCBlob>> blobs_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<IPCStream>> inputStreams_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<MessagePortIdentifier>> identifiers_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ClonedMessageData>
{
    typedef ::mozilla::dom::ClonedMessageData paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ErrorMessageData|
//
namespace mozilla {
namespace dom {
class ErrorMessageData final
{
private:

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ErrorMessageData() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

private:
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ErrorMessageData>
{
    typedef ::mozilla::dom::ErrorMessageData paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union ClonedOrErrorMessageData|
//
namespace mozilla {
namespace dom {
class ClonedOrErrorMessageData final
{
public:
    enum Type {
        T__None,
        TClonedMessageData = 1,
        TErrorMessageData,
        T__Last = TErrorMessageData
    };

private:
    typedef ::mozilla::dom::ClonedMessageData ClonedMessageData;
    typedef ::mozilla::dom::ErrorMessageData ErrorMessageData;
    typedef ClonedMessageData ClonedMessageData__tdef;
    typedef ErrorMessageData ErrorMessageData__tdef;

    ClonedMessageData*
    ptr_ClonedMessageData()
    {
        return (&(mVClonedMessageData));
    }
    const ClonedMessageData*
    constptr_ClonedMessageData() const
    {
        return (&(mVClonedMessageData));
    }
    ErrorMessageData*
    ptr_ErrorMessageData()
    {
        return (&(mVErrorMessageData));
    }
    const ErrorMessageData*
    constptr_ErrorMessageData() const
    {
        return (&(mVErrorMessageData));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT ClonedOrErrorMessageData() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT ClonedOrErrorMessageData(ClonedMessageData&& aOther);

    MOZ_IMPLICIT ClonedOrErrorMessageData(const ErrorMessageData& aOther);

    MOZ_IMPLICIT ClonedOrErrorMessageData(ErrorMessageData&& aOther);

    MOZ_IMPLICIT ClonedOrErrorMessageData(ClonedOrErrorMessageData&& aOther);

    ~ClonedOrErrorMessageData();

    Type
    type() const
    {
        return mType;
    }

    ClonedOrErrorMessageData&
    operator=(ClonedMessageData&& aRhs);

    ClonedOrErrorMessageData&
    operator=(const ErrorMessageData& aRhs);

    ClonedOrErrorMessageData&
    operator=(ErrorMessageData&& aRhs);

    ClonedOrErrorMessageData&
    operator=(ClonedOrErrorMessageData&& aRhs);

    ClonedMessageData&
    get_ClonedMessageData()
    {
        AssertSanity(TClonedMessageData);
        return (*(ptr_ClonedMessageData()));
    }
    const ClonedMessageData&
    get_ClonedMessageData() const
    {
        AssertSanity(TClonedMessageData);
        return (*(constptr_ClonedMessageData()));
    }
    operator ClonedMessageData&()
    {
        return get_ClonedMessageData();
    }
    operator const ClonedMessageData&() const
    {
        return get_ClonedMessageData();
    }

    ErrorMessageData&
    get_ErrorMessageData()
    {
        AssertSanity(TErrorMessageData);
        return (*(ptr_ErrorMessageData()));
    }
    const ErrorMessageData&
    get_ErrorMessageData() const
    {
        AssertSanity(TErrorMessageData);
        return (*(constptr_ErrorMessageData()));
    }
    operator ErrorMessageData&()
    {
        return get_ErrorMessageData();
    }
    operator const ErrorMessageData&() const
    {
        return get_ErrorMessageData();
    }

private:
    union {
        ClonedMessageData mVClonedMessageData;
        ErrorMessageData mVErrorMessageData;
    };
    Type mType;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ClonedOrErrorMessageData>
{
    typedef ::mozilla::dom::ClonedOrErrorMessageData paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct RefMessageData|
//
namespace mozilla {
namespace dom {
class RefMessageData final
{
private:
    typedef ::nsID nsID;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    RefMessageData() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT RefMessageData(const nsID& _uuid) :
        uuid_(_uuid)
    {
    }

    MOZ_IMPLICIT RefMessageData(nsID&& _uuid) :
        uuid_(std::move(_uuid))
    {
    }

    nsID&
    uuid()
    {
        return uuid_;
    }
    const nsID&
    uuid() const
    {
        return uuid_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsID> uuid_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::RefMessageData>
{
    typedef ::mozilla::dom::RefMessageData paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union MessageDataType|
//
namespace mozilla {
namespace dom {
class MessageDataType final
{
public:
    enum Type {
        T__None,
        TClonedMessageData = 1,
        TRefMessageData,
        T__Last = TRefMessageData
    };

private:
    typedef ::mozilla::dom::ClonedMessageData ClonedMessageData;
    typedef ::mozilla::dom::RefMessageData RefMessageData;
    typedef ClonedMessageData ClonedMessageData__tdef;
    typedef RefMessageData RefMessageData__tdef;

    ClonedMessageData*
    ptr_ClonedMessageData()
    {
        return (&(mVClonedMessageData));
    }
    const ClonedMessageData*
    constptr_ClonedMessageData() const
    {
        return (&(mVClonedMessageData));
    }
    RefMessageData*
    ptr_RefMessageData()
    {
        return (&(mVRefMessageData));
    }
    const RefMessageData*
    constptr_RefMessageData() const
    {
        return (&(mVRefMessageData));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT MessageDataType() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT MessageDataType(ClonedMessageData&& aOther);

    MOZ_IMPLICIT MessageDataType(const RefMessageData& aOther);

    MOZ_IMPLICIT MessageDataType(RefMessageData&& aOther);

    MOZ_IMPLICIT MessageDataType(MessageDataType&& aOther);

    ~MessageDataType();

    Type
    type() const
    {
        return mType;
    }

    MessageDataType&
    operator=(ClonedMessageData&& aRhs);

    MessageDataType&
    operator=(const RefMessageData& aRhs);

    MessageDataType&
    operator=(RefMessageData&& aRhs);

    MessageDataType&
    operator=(MessageDataType&& aRhs);

    ClonedMessageData&
    get_ClonedMessageData()
    {
        AssertSanity(TClonedMessageData);
        return (*(ptr_ClonedMessageData()));
    }
    const ClonedMessageData&
    get_ClonedMessageData() const
    {
        AssertSanity(TClonedMessageData);
        return (*(constptr_ClonedMessageData()));
    }
    operator ClonedMessageData&()
    {
        return get_ClonedMessageData();
    }
    operator const ClonedMessageData&() const
    {
        return get_ClonedMessageData();
    }

    RefMessageData&
    get_RefMessageData()
    {
        AssertSanity(TRefMessageData);
        return (*(ptr_RefMessageData()));
    }
    const RefMessageData&
    get_RefMessageData() const
    {
        AssertSanity(TRefMessageData);
        return (*(constptr_RefMessageData()));
    }
    operator RefMessageData&()
    {
        return get_RefMessageData();
    }
    operator const RefMessageData&() const
    {
        return get_RefMessageData();
    }

private:
    union {
        ClonedMessageData mVClonedMessageData;
        RefMessageData mVRefMessageData;
    };
    Type mType;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::MessageDataType>
{
    typedef ::mozilla::dom::MessageDataType paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct MessageData|
//
namespace mozilla {
namespace dom {
class MessageData final
{
private:
    typedef ::nsID nsID;
    typedef ::mozilla::dom::MessageDataType MessageDataType;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    MessageData() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT MessageData(
            const mozilla::Maybe<nsID>& _agentClusterId,
            MessageDataType&& _data) :
        agentClusterId_(_agentClusterId),
        data_(std::move(_data))
    {
    }

    MOZ_IMPLICIT MessageData(
            mozilla::Maybe<nsID>&& _agentClusterId,
            MessageDataType&& _data) :
        agentClusterId_(std::move(_agentClusterId)),
        data_(std::move(_data))
    {
    }

    mozilla::Maybe<nsID>&
    agentClusterId()
    {
        return agentClusterId_;
    }
    const mozilla::Maybe<nsID>&
    agentClusterId() const
    {
        return agentClusterId_;
    }

    MessageDataType&
    data()
    {
        return data_;
    }
    const MessageDataType&
    data() const
    {
        return data_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<nsID>> agentClusterId_;
    ::mozilla::ipc::IPDLStructMember<MessageDataType> data_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::MessageData>
{
    typedef ::mozilla::dom::MessageData paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ScreenDetails|
//
namespace mozilla {
namespace dom {
class ScreenDetails final
{
private:
    typedef ::mozilla::LayoutDeviceIntRect LayoutDeviceIntRect;
    typedef ::mozilla::DesktopIntRect DesktopIntRect;
    typedef ::int32_t int32_t;
    typedef ::uint32_t uint32_t;
    typedef ::mozilla::DesktopToLayoutDeviceScale DesktopToLayoutDeviceScale;
    typedef ::mozilla::CSSToLayoutDeviceScale CSSToLayoutDeviceScale;
    typedef ::mozilla::hal::ScreenOrientation ScreenOrientation;
    typedef ::uint16_t uint16_t;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ScreenDetails() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ScreenDetails(
            const LayoutDeviceIntRect& _rect,
            const DesktopIntRect& _rectDisplayPix,
            const LayoutDeviceIntRect& _availRect,
            const DesktopIntRect& _availRectDisplayPix,
            const int32_t& _pixelDepth,
            const int32_t& _colorDepth,
            const uint32_t& _refreshRate,
            const DesktopToLayoutDeviceScale& _contentsScaleFactor,
            const CSSToLayoutDeviceScale& _defaultCSSScaleFactor,
            const float& _dpi,
            const ScreenOrientation& _orientation,
            const uint16_t& _orientationAngle,
            const bool& _isPseudoDisplay,
            const bool& _isHDR) :
        rect_(_rect),
        rectDisplayPix_(_rectDisplayPix),
        availRect_(_availRect),
        availRectDisplayPix_(_availRectDisplayPix),
        contentsScaleFactor_(_contentsScaleFactor),
        defaultCSSScaleFactor_(_defaultCSSScaleFactor),
        orientation_(_orientation),
        isPseudoDisplay_(_isPseudoDisplay),
        isHDR_(_isHDR),
        pixelDepth_(_pixelDepth),
        colorDepth_(_colorDepth),
        refreshRate_(_refreshRate),
        dpi_(_dpi),
        orientationAngle_(_orientationAngle)
    {
    }

    MOZ_IMPLICIT ScreenDetails(
            LayoutDeviceIntRect&& _rect,
            DesktopIntRect&& _rectDisplayPix,
            LayoutDeviceIntRect&& _availRect,
            DesktopIntRect&& _availRectDisplayPix,
            int32_t&& _pixelDepth,
            int32_t&& _colorDepth,
            uint32_t&& _refreshRate,
            DesktopToLayoutDeviceScale&& _contentsScaleFactor,
            CSSToLayoutDeviceScale&& _defaultCSSScaleFactor,
            float&& _dpi,
            ScreenOrientation&& _orientation,
            uint16_t&& _orientationAngle,
            bool&& _isPseudoDisplay,
            bool&& _isHDR) :
        rect_(std::move(_rect)),
        rectDisplayPix_(std::move(_rectDisplayPix)),
        availRect_(std::move(_availRect)),
        availRectDisplayPix_(std::move(_availRectDisplayPix)),
        contentsScaleFactor_(std::move(_contentsScaleFactor)),
        defaultCSSScaleFactor_(std::move(_defaultCSSScaleFactor)),
        orientation_(std::move(_orientation)),
        isPseudoDisplay_(std::move(_isPseudoDisplay)),
        isHDR_(std::move(_isHDR)),
        pixelDepth_(std::move(_pixelDepth)),
        colorDepth_(std::move(_colorDepth)),
        refreshRate_(std::move(_refreshRate)),
        dpi_(std::move(_dpi)),
        orientationAngle_(std::move(_orientationAngle))
    {
    }

    LayoutDeviceIntRect&
    rect()
    {
        return rect_;
    }
    const LayoutDeviceIntRect&
    rect() const
    {
        return rect_;
    }

    DesktopIntRect&
    rectDisplayPix()
    {
        return rectDisplayPix_;
    }
    const DesktopIntRect&
    rectDisplayPix() const
    {
        return rectDisplayPix_;
    }

    LayoutDeviceIntRect&
    availRect()
    {
        return availRect_;
    }
    const LayoutDeviceIntRect&
    availRect() const
    {
        return availRect_;
    }

    DesktopIntRect&
    availRectDisplayPix()
    {
        return availRectDisplayPix_;
    }
    const DesktopIntRect&
    availRectDisplayPix() const
    {
        return availRectDisplayPix_;
    }

    int32_t&
    pixelDepth()
    {
        return pixelDepth_;
    }
    const int32_t&
    pixelDepth() const
    {
        return pixelDepth_;
    }

    int32_t&
    colorDepth()
    {
        return colorDepth_;
    }
    const int32_t&
    colorDepth() const
    {
        return colorDepth_;
    }

    uint32_t&
    refreshRate()
    {
        return refreshRate_;
    }
    const uint32_t&
    refreshRate() const
    {
        return refreshRate_;
    }

    DesktopToLayoutDeviceScale&
    contentsScaleFactor()
    {
        return contentsScaleFactor_;
    }
    const DesktopToLayoutDeviceScale&
    contentsScaleFactor() const
    {
        return contentsScaleFactor_;
    }

    CSSToLayoutDeviceScale&
    defaultCSSScaleFactor()
    {
        return defaultCSSScaleFactor_;
    }
    const CSSToLayoutDeviceScale&
    defaultCSSScaleFactor() const
    {
        return defaultCSSScaleFactor_;
    }

    float&
    dpi()
    {
        return dpi_;
    }
    const float&
    dpi() const
    {
        return dpi_;
    }

    ScreenOrientation&
    orientation()
    {
        return orientation_;
    }
    const ScreenOrientation&
    orientation() const
    {
        return orientation_;
    }

    uint16_t&
    orientationAngle()
    {
        return orientationAngle_;
    }
    const uint16_t&
    orientationAngle() const
    {
        return orientationAngle_;
    }

    bool&
    isPseudoDisplay()
    {
        return isPseudoDisplay_;
    }
    const bool&
    isPseudoDisplay() const
    {
        return isPseudoDisplay_;
    }

    bool&
    isHDR()
    {
        return isHDR_;
    }
    const bool&
    isHDR() const
    {
        return isHDR_;
    }

private:
    void
    StaticAssertions() const;
    ::mozilla::ipc::IPDLStructMember<LayoutDeviceIntRect> rect_;
    ::mozilla::ipc::IPDLStructMember<DesktopIntRect> rectDisplayPix_;
    ::mozilla::ipc::IPDLStructMember<LayoutDeviceIntRect> availRect_;
    ::mozilla::ipc::IPDLStructMember<DesktopIntRect> availRectDisplayPix_;
    ::mozilla::ipc::IPDLStructMember<DesktopToLayoutDeviceScale> contentsScaleFactor_;
    ::mozilla::ipc::IPDLStructMember<CSSToLayoutDeviceScale> defaultCSSScaleFactor_;
    ::mozilla::ipc::IPDLStructMember<ScreenOrientation> orientation_;
    ::mozilla::ipc::IPDLStructMember<bool> isPseudoDisplay_;
    ::mozilla::ipc::IPDLStructMember<bool> isHDR_;
    ::mozilla::ipc::IPDLStructMember<int32_t> pixelDepth_;
    ::mozilla::ipc::IPDLStructMember<int32_t> colorDepth_;
    ::mozilla::ipc::IPDLStructMember<uint32_t> refreshRate_;
    ::mozilla::ipc::IPDLStructMember<float> dpi_;
    ::mozilla::ipc::IPDLStructMember<uint16_t> orientationAngle_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ScreenDetails>
{
    typedef ::mozilla::dom::ScreenDetails paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct DimensionInfo|
//
namespace mozilla {
namespace dom {
class DimensionInfo final
{
private:
    typedef ::mozilla::CSSRect CSSRect;
    typedef ::mozilla::CSSSize CSSSize;
    typedef ::mozilla::LayoutDeviceIntPoint LayoutDeviceIntPoint;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    DimensionInfo() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT DimensionInfo(
            const CSSRect& _rect,
            const CSSSize& _size,
            const LayoutDeviceIntPoint& _clientOffset,
            const LayoutDeviceIntPoint& _chromeOffset) :
        rect_(_rect),
        size_(_size),
        clientOffset_(_clientOffset),
        chromeOffset_(_chromeOffset)
    {
    }

    MOZ_IMPLICIT DimensionInfo(
            CSSRect&& _rect,
            CSSSize&& _size,
            LayoutDeviceIntPoint&& _clientOffset,
            LayoutDeviceIntPoint&& _chromeOffset) :
        rect_(std::move(_rect)),
        size_(std::move(_size)),
        clientOffset_(std::move(_clientOffset)),
        chromeOffset_(std::move(_chromeOffset))
    {
    }

    CSSRect&
    rect()
    {
        return rect_;
    }
    const CSSRect&
    rect() const
    {
        return rect_;
    }

    CSSSize&
    size()
    {
        return size_;
    }
    const CSSSize&
    size() const
    {
        return size_;
    }

    LayoutDeviceIntPoint&
    clientOffset()
    {
        return clientOffset_;
    }
    const LayoutDeviceIntPoint&
    clientOffset() const
    {
        return clientOffset_;
    }

    LayoutDeviceIntPoint&
    chromeOffset()
    {
        return chromeOffset_;
    }
    const LayoutDeviceIntPoint&
    chromeOffset() const
    {
        return chromeOffset_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<CSSRect> rect_;
    ::mozilla::ipc::IPDLStructMember<CSSSize> size_;
    ::mozilla::ipc::IPDLStructMember<LayoutDeviceIntPoint> clientOffset_;
    ::mozilla::ipc::IPDLStructMember<LayoutDeviceIntPoint> chromeOffset_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::DimensionInfo>
{
    typedef ::mozilla::dom::DimensionInfo paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct FrameScriptInfo|
//
namespace mozilla {
namespace dom {
class FrameScriptInfo final
{
private:
    typedef ::nsString nsString;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    FrameScriptInfo() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT FrameScriptInfo(
            const nsString& _url,
            const bool& _runInGlobalScope) :
        url_(_url),
        runInGlobalScope_(_runInGlobalScope)
    {
    }

    MOZ_IMPLICIT FrameScriptInfo(
            nsString&& _url,
            bool&& _runInGlobalScope) :
        url_(std::move(_url)),
        runInGlobalScope_(std::move(_runInGlobalScope))
    {
    }

    nsString&
    url()
    {
        return url_;
    }
    const nsString&
    url() const
    {
        return url_;
    }

    bool&
    runInGlobalScope()
    {
        return runInGlobalScope_;
    }
    const bool&
    runInGlobalScope() const
    {
        return runInGlobalScope_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsString> url_;
    ::mozilla::ipc::IPDLStructMember<bool> runInGlobalScope_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::FrameScriptInfo>
{
    typedef ::mozilla::dom::FrameScriptInfo paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct CreatedWindowInfo|
//
namespace mozilla {
namespace dom {
class CreatedWindowInfo final
{
private:
    typedef ::nsresult nsresult;
    typedef ::mozilla::dom::FrameScriptInfo FrameScriptInfo;
    typedef ::uint32_t uint32_t;
    typedef ::mozilla::dom::DimensionInfo DimensionInfo;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    CreatedWindowInfo() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT CreatedWindowInfo(
            const nsresult& _rv,
            const bool& _windowOpened,
            const nsTArray<FrameScriptInfo>& _frameScripts,
            const uint32_t& _maxTouchPoints,
            const DimensionInfo& _dimensions) :
        rv_(_rv),
        windowOpened_(_windowOpened),
        frameScripts_(_frameScripts),
        dimensions_(_dimensions),
        maxTouchPoints_(_maxTouchPoints)
    {
    }

    MOZ_IMPLICIT CreatedWindowInfo(
            nsresult&& _rv,
            bool&& _windowOpened,
            nsTArray<FrameScriptInfo>&& _frameScripts,
            uint32_t&& _maxTouchPoints,
            DimensionInfo&& _dimensions) :
        rv_(std::move(_rv)),
        windowOpened_(std::move(_windowOpened)),
        frameScripts_(std::move(_frameScripts)),
        dimensions_(std::move(_dimensions)),
        maxTouchPoints_(std::move(_maxTouchPoints))
    {
    }

    nsresult&
    rv()
    {
        return rv_;
    }
    const nsresult&
    rv() const
    {
        return rv_;
    }

    bool&
    windowOpened()
    {
        return windowOpened_;
    }
    const bool&
    windowOpened() const
    {
        return windowOpened_;
    }

    nsTArray<FrameScriptInfo>&
    frameScripts()
    {
        return frameScripts_;
    }
    const nsTArray<FrameScriptInfo>&
    frameScripts() const
    {
        return frameScripts_;
    }

    uint32_t&
    maxTouchPoints()
    {
        return maxTouchPoints_;
    }
    const uint32_t&
    maxTouchPoints() const
    {
        return maxTouchPoints_;
    }

    DimensionInfo&
    dimensions()
    {
        return dimensions_;
    }
    const DimensionInfo&
    dimensions() const
    {
        return dimensions_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsresult> rv_;
    ::mozilla::ipc::IPDLStructMember<bool> windowOpened_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<FrameScriptInfo>> frameScripts_;
    ::mozilla::ipc::IPDLStructMember<DimensionInfo> dimensions_;
    ::mozilla::ipc::IPDLStructMember<uint32_t> maxTouchPoints_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::CreatedWindowInfo>
{
    typedef ::mozilla::dom::CreatedWindowInfo paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct DocShellLoadStateInit|
//
namespace mozilla {
namespace dom {
class DocShellLoadStateInit final
{
private:
    typedef ::nsIURI nsIURI;
    typedef ::nsIPrincipal nsIPrincipal;
    typedef ::nsIReferrerInfo nsIReferrerInfo;
    typedef ::nsIPolicyContainer nsIPolicyContainer;
    typedef ::nsIInputStream nsIInputStream;
    typedef ::uint64_t uint64_t;
    typedef ::nsString nsString;
    typedef ::nsCString nsCString;
    typedef ::mozilla::dom::MaybeDiscardedBrowsingContext MaybeDiscardedBrowsingContext;
    typedef ::mozilla::dom::LoadingSessionHistoryInfo LoadingSessionHistoryInfo;
    typedef ::uint32_t uint32_t;
    typedef ::mozilla::dom::UserNavigationInvolvement UserNavigationInvolvement;
    typedef ::mozilla::net::ClassificationFlags ClassificationFlags;
    typedef ::int32_t int32_t;
    typedef ::mozilla::dom::NavigationHistoryBehavior NavigationHistoryBehavior;
    typedef ::nsILoadInfo::SchemelessInputType SchemelessInputType;
    typedef ::mozilla::dom::ForceMediaDocument ForceMediaDocument;
    typedef ::nsILoadInfo::HTTPSUpgradeTelemetryType HTTPSUpgradeTelemetryType;
    typedef ::mozilla::dom::ClonedMessageData ClonedMessageData;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    DocShellLoadStateInit() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT DocShellLoadStateInit(
            nsIURI* _URI,
            nsIURI* _OriginalURI,
            nsIURI* _ResultPrincipalURI,
            nsIPrincipal* _TriggeringPrincipal,
            nsIReferrerInfo* _ReferrerInfo,
            nsIPrincipal* _PrincipalToInherit,
            nsIPrincipal* _PartitionedPrincipalToInherit,
            nsIURI* _BaseURI,
            nsIPolicyContainer* _PolicyContainer,
            nsIInputStream* _PostDataStream,
            nsIInputStream* _HeadersStream,
            nsIURI* _UnstrippedURI,
            const uint64_t& _LoadIdentifier,
            const nsString& _Target,
            const nsCString& _TypeHint,
            const nsString& _FileName,
            const MaybeDiscardedBrowsingContext& _SourceBrowsingContext,
            const MaybeDiscardedBrowsingContext& _TargetBrowsingContext,
            const nsCString& _TriggeringRemoteType,
            const nsString& _SrcdocData,
            const mozilla::Maybe<nsCString>& _OriginalURIString,
            const mozilla::Maybe<nsCString>& _RemoteTypeOverride,
            const mozilla::Maybe<LoadingSessionHistoryInfo>& _loadingSessionHistoryInfo,
            const uint32_t& _LoadType,
            const uint32_t& _LoadFlags,
            const uint32_t& _InternalLoadFlags,
            const UserNavigationInvolvement& _userNavigationInvolvement,
            const uint32_t& _TriggeringSandboxFlags,
            const uint64_t& _TriggeringWindowId,
            const bool& _TriggeringStorageAccess,
            const ClassificationFlags& _TriggeringClassificationFlags,
            const mozilla::Maybe<int32_t>& _CancelContentJSEpoch,
            const bool& _ResultPrincipalURIIsSome,
            const bool& _KeepResultPrincipalURIIfSet,
            const bool& _LoadReplace,
            const bool& _InheritPrincipal,
            const bool& _PrincipalIsExplicit,
            const bool& _NotifiedBeforeUnloadListeners,
            const bool& _ForceAllowDataURI,
            const bool& _IsExemptFromHTTPSFirstMode,
            const bool& _OriginalFrameSrc,
            const bool& _ShouldCheckForRecursion,
            const bool& _IsFormSubmission,
            const bool& _FirstParty,
            const bool& _HasValidUserGestureActivation,
            const bool& _TextDirectiveUserActivation,
            const bool& _AllowFocusMove,
            const bool& _IsFromProcessingFrameAttributes,
            const bool& _NeedsCompletelyLoadedDocument,
            const bool& _ShouldNotForceReplaceInOnLoad,
            const mozilla::Maybe<NavigationHistoryBehavior>& _HistoryBehavior,
            const SchemelessInputType& _SchemelessInput,
            const ForceMediaDocument& _forceMediaDocument,
            const HTTPSUpgradeTelemetryType& _HttpsUpgradeTelemetry,
            mozilla::Maybe<ClonedMessageData>&& _NavigationAPIState,
            const bool& _ChannelInitialized,
            const bool& _TryToReplaceWithSessionHistoryLoad,
            const bool& _IsMetaRefresh,
            const bool& _IsCaptivePortalTab) :
        URI_(_URI),
        OriginalURI_(_OriginalURI),
        ResultPrincipalURI_(_ResultPrincipalURI),
        TriggeringPrincipal_(_TriggeringPrincipal),
        ReferrerInfo_(_ReferrerInfo),
        PrincipalToInherit_(_PrincipalToInherit),
        PartitionedPrincipalToInherit_(_PartitionedPrincipalToInherit),
        BaseURI_(_BaseURI),
        PolicyContainer_(_PolicyContainer),
        PostDataStream_(_PostDataStream),
        HeadersStream_(_HeadersStream),
        UnstrippedURI_(_UnstrippedURI),
        Target_(_Target),
        TypeHint_(_TypeHint),
        FileName_(_FileName),
        SourceBrowsingContext_(_SourceBrowsingContext),
        TargetBrowsingContext_(_TargetBrowsingContext),
        TriggeringRemoteType_(_TriggeringRemoteType),
        SrcdocData_(_SrcdocData),
        OriginalURIString_(_OriginalURIString),
        RemoteTypeOverride_(_RemoteTypeOverride),
        loadingSessionHistoryInfo_(_loadingSessionHistoryInfo),
        userNavigationInvolvement_(_userNavigationInvolvement),
        TriggeringStorageAccess_(_TriggeringStorageAccess),
        TriggeringClassificationFlags_(_TriggeringClassificationFlags),
        CancelContentJSEpoch_(_CancelContentJSEpoch),
        ResultPrincipalURIIsSome_(_ResultPrincipalURIIsSome),
        KeepResultPrincipalURIIfSet_(_KeepResultPrincipalURIIfSet),
        LoadReplace_(_LoadReplace),
        InheritPrincipal_(_InheritPrincipal),
        PrincipalIsExplicit_(_PrincipalIsExplicit),
        NotifiedBeforeUnloadListeners_(_NotifiedBeforeUnloadListeners),
        ForceAllowDataURI_(_ForceAllowDataURI),
        IsExemptFromHTTPSFirstMode_(_IsExemptFromHTTPSFirstMode),
        OriginalFrameSrc_(_OriginalFrameSrc),
        ShouldCheckForRecursion_(_ShouldCheckForRecursion),
        IsFormSubmission_(_IsFormSubmission),
        FirstParty_(_FirstParty),
        HasValidUserGestureActivation_(_HasValidUserGestureActivation),
        TextDirectiveUserActivation_(_TextDirectiveUserActivation),
        AllowFocusMove_(_AllowFocusMove),
        IsFromProcessingFrameAttributes_(_IsFromProcessingFrameAttributes),
        NeedsCompletelyLoadedDocument_(_NeedsCompletelyLoadedDocument),
        ShouldNotForceReplaceInOnLoad_(_ShouldNotForceReplaceInOnLoad),
        HistoryBehavior_(_HistoryBehavior),
        SchemelessInput_(_SchemelessInput),
        forceMediaDocument_(_forceMediaDocument),
        HttpsUpgradeTelemetry_(_HttpsUpgradeTelemetry),
        NavigationAPIState_(std::move(_NavigationAPIState)),
        ChannelInitialized_(_ChannelInitialized),
        TryToReplaceWithSessionHistoryLoad_(_TryToReplaceWithSessionHistoryLoad),
        IsMetaRefresh_(_IsMetaRefresh),
        IsCaptivePortalTab_(_IsCaptivePortalTab),
        LoadIdentifier_(_LoadIdentifier),
        TriggeringWindowId_(_TriggeringWindowId),
        LoadType_(_LoadType),
        LoadFlags_(_LoadFlags),
        InternalLoadFlags_(_InternalLoadFlags),
        TriggeringSandboxFlags_(_TriggeringSandboxFlags)
    {
    }

    MOZ_IMPLICIT DocShellLoadStateInit(
            RefPtr<nsIURI>&& _URI,
            RefPtr<nsIURI>&& _OriginalURI,
            RefPtr<nsIURI>&& _ResultPrincipalURI,
            RefPtr<nsIPrincipal>&& _TriggeringPrincipal,
            RefPtr<nsIReferrerInfo>&& _ReferrerInfo,
            RefPtr<nsIPrincipal>&& _PrincipalToInherit,
            RefPtr<nsIPrincipal>&& _PartitionedPrincipalToInherit,
            RefPtr<nsIURI>&& _BaseURI,
            RefPtr<nsIPolicyContainer>&& _PolicyContainer,
            RefPtr<nsIInputStream>&& _PostDataStream,
            RefPtr<nsIInputStream>&& _HeadersStream,
            RefPtr<nsIURI>&& _UnstrippedURI,
            uint64_t&& _LoadIdentifier,
            nsString&& _Target,
            nsCString&& _TypeHint,
            nsString&& _FileName,
            MaybeDiscardedBrowsingContext&& _SourceBrowsingContext,
            MaybeDiscardedBrowsingContext&& _TargetBrowsingContext,
            nsCString&& _TriggeringRemoteType,
            nsString&& _SrcdocData,
            mozilla::Maybe<nsCString>&& _OriginalURIString,
            mozilla::Maybe<nsCString>&& _RemoteTypeOverride,
            mozilla::Maybe<LoadingSessionHistoryInfo>&& _loadingSessionHistoryInfo,
            uint32_t&& _LoadType,
            uint32_t&& _LoadFlags,
            uint32_t&& _InternalLoadFlags,
            UserNavigationInvolvement&& _userNavigationInvolvement,
            uint32_t&& _TriggeringSandboxFlags,
            uint64_t&& _TriggeringWindowId,
            bool&& _TriggeringStorageAccess,
            ClassificationFlags&& _TriggeringClassificationFlags,
            mozilla::Maybe<int32_t>&& _CancelContentJSEpoch,
            bool&& _ResultPrincipalURIIsSome,
            bool&& _KeepResultPrincipalURIIfSet,
            bool&& _LoadReplace,
            bool&& _InheritPrincipal,
            bool&& _PrincipalIsExplicit,
            bool&& _NotifiedBeforeUnloadListeners,
            bool&& _ForceAllowDataURI,
            bool&& _IsExemptFromHTTPSFirstMode,
            bool&& _OriginalFrameSrc,
            bool&& _ShouldCheckForRecursion,
            bool&& _IsFormSubmission,
            bool&& _FirstParty,
            bool&& _HasValidUserGestureActivation,
            bool&& _TextDirectiveUserActivation,
            bool&& _AllowFocusMove,
            bool&& _IsFromProcessingFrameAttributes,
            bool&& _NeedsCompletelyLoadedDocument,
            bool&& _ShouldNotForceReplaceInOnLoad,
            mozilla::Maybe<NavigationHistoryBehavior>&& _HistoryBehavior,
            SchemelessInputType&& _SchemelessInput,
            ForceMediaDocument&& _forceMediaDocument,
            HTTPSUpgradeTelemetryType&& _HttpsUpgradeTelemetry,
            mozilla::Maybe<ClonedMessageData>&& _NavigationAPIState,
            bool&& _ChannelInitialized,
            bool&& _TryToReplaceWithSessionHistoryLoad,
            bool&& _IsMetaRefresh,
            bool&& _IsCaptivePortalTab) :
        URI_(std::move(_URI)),
        OriginalURI_(std::move(_OriginalURI)),
        ResultPrincipalURI_(std::move(_ResultPrincipalURI)),
        TriggeringPrincipal_(std::move(_TriggeringPrincipal)),
        ReferrerInfo_(std::move(_ReferrerInfo)),
        PrincipalToInherit_(std::move(_PrincipalToInherit)),
        PartitionedPrincipalToInherit_(std::move(_PartitionedPrincipalToInherit)),
        BaseURI_(std::move(_BaseURI)),
        PolicyContainer_(std::move(_PolicyContainer)),
        PostDataStream_(std::move(_PostDataStream)),
        HeadersStream_(std::move(_HeadersStream)),
        UnstrippedURI_(std::move(_UnstrippedURI)),
        Target_(std::move(_Target)),
        TypeHint_(std::move(_TypeHint)),
        FileName_(std::move(_FileName)),
        SourceBrowsingContext_(std::move(_SourceBrowsingContext)),
        TargetBrowsingContext_(std::move(_TargetBrowsingContext)),
        TriggeringRemoteType_(std::move(_TriggeringRemoteType)),
        SrcdocData_(std::move(_SrcdocData)),
        OriginalURIString_(std::move(_OriginalURIString)),
        RemoteTypeOverride_(std::move(_RemoteTypeOverride)),
        loadingSessionHistoryInfo_(std::move(_loadingSessionHistoryInfo)),
        userNavigationInvolvement_(std::move(_userNavigationInvolvement)),
        TriggeringStorageAccess_(std::move(_TriggeringStorageAccess)),
        TriggeringClassificationFlags_(std::move(_TriggeringClassificationFlags)),
        CancelContentJSEpoch_(std::move(_CancelContentJSEpoch)),
        ResultPrincipalURIIsSome_(std::move(_ResultPrincipalURIIsSome)),
        KeepResultPrincipalURIIfSet_(std::move(_KeepResultPrincipalURIIfSet)),
        LoadReplace_(std::move(_LoadReplace)),
        InheritPrincipal_(std::move(_InheritPrincipal)),
        PrincipalIsExplicit_(std::move(_PrincipalIsExplicit)),
        NotifiedBeforeUnloadListeners_(std::move(_NotifiedBeforeUnloadListeners)),
        ForceAllowDataURI_(std::move(_ForceAllowDataURI)),
        IsExemptFromHTTPSFirstMode_(std::move(_IsExemptFromHTTPSFirstMode)),
        OriginalFrameSrc_(std::move(_OriginalFrameSrc)),
        ShouldCheckForRecursion_(std::move(_ShouldCheckForRecursion)),
        IsFormSubmission_(std::move(_IsFormSubmission)),
        FirstParty_(std::move(_FirstParty)),
        HasValidUserGestureActivation_(std::move(_HasValidUserGestureActivation)),
        TextDirectiveUserActivation_(std::move(_TextDirectiveUserActivation)),
        AllowFocusMove_(std::move(_AllowFocusMove)),
        IsFromProcessingFrameAttributes_(std::move(_IsFromProcessingFrameAttributes)),
        NeedsCompletelyLoadedDocument_(std::move(_NeedsCompletelyLoadedDocument)),
        ShouldNotForceReplaceInOnLoad_(std::move(_ShouldNotForceReplaceInOnLoad)),
        HistoryBehavior_(std::move(_HistoryBehavior)),
        SchemelessInput_(std::move(_SchemelessInput)),
        forceMediaDocument_(std::move(_forceMediaDocument)),
        HttpsUpgradeTelemetry_(std::move(_HttpsUpgradeTelemetry)),
        NavigationAPIState_(std::move(_NavigationAPIState)),
        ChannelInitialized_(std::move(_ChannelInitialized)),
        TryToReplaceWithSessionHistoryLoad_(std::move(_TryToReplaceWithSessionHistoryLoad)),
        IsMetaRefresh_(std::move(_IsMetaRefresh)),
        IsCaptivePortalTab_(std::move(_IsCaptivePortalTab)),
        LoadIdentifier_(std::move(_LoadIdentifier)),
        TriggeringWindowId_(std::move(_TriggeringWindowId)),
        LoadType_(std::move(_LoadType)),
        LoadFlags_(std::move(_LoadFlags)),
        InternalLoadFlags_(std::move(_InternalLoadFlags)),
        TriggeringSandboxFlags_(std::move(_TriggeringSandboxFlags))
    {
    }

    RefPtr<nsIURI>&
    URI()
    {
        return URI_;
    }
    nsIURI*
    URI() const
    {
        return URI_;
    }

    RefPtr<nsIURI>&
    OriginalURI()
    {
        return OriginalURI_;
    }
    nsIURI*
    OriginalURI() const
    {
        return OriginalURI_;
    }

    RefPtr<nsIURI>&
    ResultPrincipalURI()
    {
        return ResultPrincipalURI_;
    }
    nsIURI*
    ResultPrincipalURI() const
    {
        return ResultPrincipalURI_;
    }

    RefPtr<nsIPrincipal>&
    TriggeringPrincipal()
    {
        return TriggeringPrincipal_;
    }
    nsIPrincipal*
    TriggeringPrincipal() const
    {
        return TriggeringPrincipal_;
    }

    RefPtr<nsIReferrerInfo>&
    ReferrerInfo()
    {
        return ReferrerInfo_;
    }
    nsIReferrerInfo*
    ReferrerInfo() const
    {
        return ReferrerInfo_;
    }

    RefPtr<nsIPrincipal>&
    PrincipalToInherit()
    {
        return PrincipalToInherit_;
    }
    nsIPrincipal*
    PrincipalToInherit() const
    {
        return PrincipalToInherit_;
    }

    RefPtr<nsIPrincipal>&
    PartitionedPrincipalToInherit()
    {
        return PartitionedPrincipalToInherit_;
    }
    nsIPrincipal*
    PartitionedPrincipalToInherit() const
    {
        return PartitionedPrincipalToInherit_;
    }

    RefPtr<nsIURI>&
    BaseURI()
    {
        return BaseURI_;
    }
    nsIURI*
    BaseURI() const
    {
        return BaseURI_;
    }

    RefPtr<nsIPolicyContainer>&
    PolicyContainer()
    {
        return PolicyContainer_;
    }
    nsIPolicyContainer*
    PolicyContainer() const
    {
        return PolicyContainer_;
    }

    RefPtr<nsIInputStream>&
    PostDataStream()
    {
        return PostDataStream_;
    }
    nsIInputStream*
    PostDataStream() const
    {
        return PostDataStream_;
    }

    RefPtr<nsIInputStream>&
    HeadersStream()
    {
        return HeadersStream_;
    }
    nsIInputStream*
    HeadersStream() const
    {
        return HeadersStream_;
    }

    RefPtr<nsIURI>&
    UnstrippedURI()
    {
        return UnstrippedURI_;
    }
    nsIURI*
    UnstrippedURI() const
    {
        return UnstrippedURI_;
    }

    uint64_t&
    LoadIdentifier()
    {
        return LoadIdentifier_;
    }
    const uint64_t&
    LoadIdentifier() const
    {
        return LoadIdentifier_;
    }

    nsString&
    Target()
    {
        return Target_;
    }
    const nsString&
    Target() const
    {
        return Target_;
    }

    nsCString&
    TypeHint()
    {
        return TypeHint_;
    }
    const nsCString&
    TypeHint() const
    {
        return TypeHint_;
    }

    nsString&
    FileName()
    {
        return FileName_;
    }
    const nsString&
    FileName() const
    {
        return FileName_;
    }

    MaybeDiscardedBrowsingContext&
    SourceBrowsingContext()
    {
        return SourceBrowsingContext_;
    }
    const MaybeDiscardedBrowsingContext&
    SourceBrowsingContext() const
    {
        return SourceBrowsingContext_;
    }

    MaybeDiscardedBrowsingContext&
    TargetBrowsingContext()
    {
        return TargetBrowsingContext_;
    }
    const MaybeDiscardedBrowsingContext&
    TargetBrowsingContext() const
    {
        return TargetBrowsingContext_;
    }

    nsCString&
    TriggeringRemoteType()
    {
        return TriggeringRemoteType_;
    }
    const nsCString&
    TriggeringRemoteType() const
    {
        return TriggeringRemoteType_;
    }

    nsString&
    SrcdocData()
    {
        return SrcdocData_;
    }
    const nsString&
    SrcdocData() const
    {
        return SrcdocData_;
    }

    mozilla::Maybe<nsCString>&
    OriginalURIString()
    {
        return OriginalURIString_;
    }
    const mozilla::Maybe<nsCString>&
    OriginalURIString() const
    {
        return OriginalURIString_;
    }

    mozilla::Maybe<nsCString>&
    RemoteTypeOverride()
    {
        return RemoteTypeOverride_;
    }
    const mozilla::Maybe<nsCString>&
    RemoteTypeOverride() const
    {
        return RemoteTypeOverride_;
    }

    mozilla::Maybe<LoadingSessionHistoryInfo>&
    loadingSessionHistoryInfo()
    {
        return loadingSessionHistoryInfo_;
    }
    const mozilla::Maybe<LoadingSessionHistoryInfo>&
    loadingSessionHistoryInfo() const
    {
        return loadingSessionHistoryInfo_;
    }

    uint32_t&
    LoadType()
    {
        return LoadType_;
    }
    const uint32_t&
    LoadType() const
    {
        return LoadType_;
    }

    uint32_t&
    LoadFlags()
    {
        return LoadFlags_;
    }
    const uint32_t&
    LoadFlags() const
    {
        return LoadFlags_;
    }

    uint32_t&
    InternalLoadFlags()
    {
        return InternalLoadFlags_;
    }
    const uint32_t&
    InternalLoadFlags() const
    {
        return InternalLoadFlags_;
    }

    UserNavigationInvolvement&
    userNavigationInvolvement()
    {
        return userNavigationInvolvement_;
    }
    const UserNavigationInvolvement&
    userNavigationInvolvement() const
    {
        return userNavigationInvolvement_;
    }

    uint32_t&
    TriggeringSandboxFlags()
    {
        return TriggeringSandboxFlags_;
    }
    const uint32_t&
    TriggeringSandboxFlags() const
    {
        return TriggeringSandboxFlags_;
    }

    uint64_t&
    TriggeringWindowId()
    {
        return TriggeringWindowId_;
    }
    const uint64_t&
    TriggeringWindowId() const
    {
        return TriggeringWindowId_;
    }

    bool&
    TriggeringStorageAccess()
    {
        return TriggeringStorageAccess_;
    }
    const bool&
    TriggeringStorageAccess() const
    {
        return TriggeringStorageAccess_;
    }

    ClassificationFlags&
    TriggeringClassificationFlags()
    {
        return TriggeringClassificationFlags_;
    }
    const ClassificationFlags&
    TriggeringClassificationFlags() const
    {
        return TriggeringClassificationFlags_;
    }

    mozilla::Maybe<int32_t>&
    CancelContentJSEpoch()
    {
        return CancelContentJSEpoch_;
    }
    const mozilla::Maybe<int32_t>&
    CancelContentJSEpoch() const
    {
        return CancelContentJSEpoch_;
    }

    bool&
    ResultPrincipalURIIsSome()
    {
        return ResultPrincipalURIIsSome_;
    }
    const bool&
    ResultPrincipalURIIsSome() const
    {
        return ResultPrincipalURIIsSome_;
    }

    bool&
    KeepResultPrincipalURIIfSet()
    {
        return KeepResultPrincipalURIIfSet_;
    }
    const bool&
    KeepResultPrincipalURIIfSet() const
    {
        return KeepResultPrincipalURIIfSet_;
    }

    bool&
    LoadReplace()
    {
        return LoadReplace_;
    }
    const bool&
    LoadReplace() const
    {
        return LoadReplace_;
    }

    bool&
    InheritPrincipal()
    {
        return InheritPrincipal_;
    }
    const bool&
    InheritPrincipal() const
    {
        return InheritPrincipal_;
    }

    bool&
    PrincipalIsExplicit()
    {
        return PrincipalIsExplicit_;
    }
    const bool&
    PrincipalIsExplicit() const
    {
        return PrincipalIsExplicit_;
    }

    bool&
    NotifiedBeforeUnloadListeners()
    {
        return NotifiedBeforeUnloadListeners_;
    }
    const bool&
    NotifiedBeforeUnloadListeners() const
    {
        return NotifiedBeforeUnloadListeners_;
    }

    bool&
    ForceAllowDataURI()
    {
        return ForceAllowDataURI_;
    }
    const bool&
    ForceAllowDataURI() const
    {
        return ForceAllowDataURI_;
    }

    bool&
    IsExemptFromHTTPSFirstMode()
    {
        return IsExemptFromHTTPSFirstMode_;
    }
    const bool&
    IsExemptFromHTTPSFirstMode() const
    {
        return IsExemptFromHTTPSFirstMode_;
    }

    bool&
    OriginalFrameSrc()
    {
        return OriginalFrameSrc_;
    }
    const bool&
    OriginalFrameSrc() const
    {
        return OriginalFrameSrc_;
    }

    bool&
    ShouldCheckForRecursion()
    {
        return ShouldCheckForRecursion_;
    }
    const bool&
    ShouldCheckForRecursion() const
    {
        return ShouldCheckForRecursion_;
    }

    bool&
    IsFormSubmission()
    {
        return IsFormSubmission_;
    }
    const bool&
    IsFormSubmission() const
    {
        return IsFormSubmission_;
    }

    bool&
    FirstParty()
    {
        return FirstParty_;
    }
    const bool&
    FirstParty() const
    {
        return FirstParty_;
    }

    bool&
    HasValidUserGestureActivation()
    {
        return HasValidUserGestureActivation_;
    }
    const bool&
    HasValidUserGestureActivation() const
    {
        return HasValidUserGestureActivation_;
    }

    bool&
    TextDirectiveUserActivation()
    {
        return TextDirectiveUserActivation_;
    }
    const bool&
    TextDirectiveUserActivation() const
    {
        return TextDirectiveUserActivation_;
    }

    bool&
    AllowFocusMove()
    {
        return AllowFocusMove_;
    }
    const bool&
    AllowFocusMove() const
    {
        return AllowFocusMove_;
    }

    bool&
    IsFromProcessingFrameAttributes()
    {
        return IsFromProcessingFrameAttributes_;
    }
    const bool&
    IsFromProcessingFrameAttributes() const
    {
        return IsFromProcessingFrameAttributes_;
    }

    bool&
    NeedsCompletelyLoadedDocument()
    {
        return NeedsCompletelyLoadedDocument_;
    }
    const bool&
    NeedsCompletelyLoadedDocument() const
    {
        return NeedsCompletelyLoadedDocument_;
    }

    bool&
    ShouldNotForceReplaceInOnLoad()
    {
        return ShouldNotForceReplaceInOnLoad_;
    }
    const bool&
    ShouldNotForceReplaceInOnLoad() const
    {
        return ShouldNotForceReplaceInOnLoad_;
    }

    mozilla::Maybe<NavigationHistoryBehavior>&
    HistoryBehavior()
    {
        return HistoryBehavior_;
    }
    const mozilla::Maybe<NavigationHistoryBehavior>&
    HistoryBehavior() const
    {
        return HistoryBehavior_;
    }

    SchemelessInputType&
    SchemelessInput()
    {
        return SchemelessInput_;
    }
    const SchemelessInputType&
    SchemelessInput() const
    {
        return SchemelessInput_;
    }

    ForceMediaDocument&
    forceMediaDocument()
    {
        return forceMediaDocument_;
    }
    const ForceMediaDocument&
    forceMediaDocument() const
    {
        return forceMediaDocument_;
    }

    HTTPSUpgradeTelemetryType&
    HttpsUpgradeTelemetry()
    {
        return HttpsUpgradeTelemetry_;
    }
    const HTTPSUpgradeTelemetryType&
    HttpsUpgradeTelemetry() const
    {
        return HttpsUpgradeTelemetry_;
    }

    mozilla::Maybe<ClonedMessageData>&
    NavigationAPIState()
    {
        return NavigationAPIState_;
    }
    const mozilla::Maybe<ClonedMessageData>&
    NavigationAPIState() const
    {
        return NavigationAPIState_;
    }

    bool&
    ChannelInitialized()
    {
        return ChannelInitialized_;
    }
    const bool&
    ChannelInitialized() const
    {
        return ChannelInitialized_;
    }

    bool&
    TryToReplaceWithSessionHistoryLoad()
    {
        return TryToReplaceWithSessionHistoryLoad_;
    }
    const bool&
    TryToReplaceWithSessionHistoryLoad() const
    {
        return TryToReplaceWithSessionHistoryLoad_;
    }

    bool&
    IsMetaRefresh()
    {
        return IsMetaRefresh_;
    }
    const bool&
    IsMetaRefresh() const
    {
        return IsMetaRefresh_;
    }

    bool&
    IsCaptivePortalTab()
    {
        return IsCaptivePortalTab_;
    }
    const bool&
    IsCaptivePortalTab() const
    {
        return IsCaptivePortalTab_;
    }

private:
    void
    StaticAssertions() const;
    ::mozilla::ipc::IPDLStructMember<RefPtr<nsIURI>> URI_;
    ::mozilla::ipc::IPDLStructMember<RefPtr<nsIURI>> OriginalURI_;
    ::mozilla::ipc::IPDLStructMember<RefPtr<nsIURI>> ResultPrincipalURI_;
    ::mozilla::ipc::IPDLStructMember<RefPtr<nsIPrincipal>> TriggeringPrincipal_;
    ::mozilla::ipc::IPDLStructMember<RefPtr<nsIReferrerInfo>> ReferrerInfo_;
    ::mozilla::ipc::IPDLStructMember<RefPtr<nsIPrincipal>> PrincipalToInherit_;
    ::mozilla::ipc::IPDLStructMember<RefPtr<nsIPrincipal>> PartitionedPrincipalToInherit_;
    ::mozilla::ipc::IPDLStructMember<RefPtr<nsIURI>> BaseURI_;
    ::mozilla::ipc::IPDLStructMember<RefPtr<nsIPolicyContainer>> PolicyContainer_;
    ::mozilla::ipc::IPDLStructMember<RefPtr<nsIInputStream>> PostDataStream_;
    ::mozilla::ipc::IPDLStructMember<RefPtr<nsIInputStream>> HeadersStream_;
    ::mozilla::ipc::IPDLStructMember<RefPtr<nsIURI>> UnstrippedURI_;
    ::mozilla::ipc::IPDLStructMember<nsString> Target_;
    ::mozilla::ipc::IPDLStructMember<nsCString> TypeHint_;
    ::mozilla::ipc::IPDLStructMember<nsString> FileName_;
    ::mozilla::ipc::IPDLStructMember<MaybeDiscardedBrowsingContext> SourceBrowsingContext_;
    ::mozilla::ipc::IPDLStructMember<MaybeDiscardedBrowsingContext> TargetBrowsingContext_;
    ::mozilla::ipc::IPDLStructMember<nsCString> TriggeringRemoteType_;
    ::mozilla::ipc::IPDLStructMember<nsString> SrcdocData_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<nsCString>> OriginalURIString_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<nsCString>> RemoteTypeOverride_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<LoadingSessionHistoryInfo>> loadingSessionHistoryInfo_;
    ::mozilla::ipc::IPDLStructMember<UserNavigationInvolvement> userNavigationInvolvement_;
    ::mozilla::ipc::IPDLStructMember<bool> TriggeringStorageAccess_;
    ::mozilla::ipc::IPDLStructMember<ClassificationFlags> TriggeringClassificationFlags_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<int32_t>> CancelContentJSEpoch_;
    ::mozilla::ipc::IPDLStructMember<bool> ResultPrincipalURIIsSome_;
    ::mozilla::ipc::IPDLStructMember<bool> KeepResultPrincipalURIIfSet_;
    ::mozilla::ipc::IPDLStructMember<bool> LoadReplace_;
    ::mozilla::ipc::IPDLStructMember<bool> InheritPrincipal_;
    ::mozilla::ipc::IPDLStructMember<bool> PrincipalIsExplicit_;
    ::mozilla::ipc::IPDLStructMember<bool> NotifiedBeforeUnloadListeners_;
    ::mozilla::ipc::IPDLStructMember<bool> ForceAllowDataURI_;
    ::mozilla::ipc::IPDLStructMember<bool> IsExemptFromHTTPSFirstMode_;
    ::mozilla::ipc::IPDLStructMember<bool> OriginalFrameSrc_;
    ::mozilla::ipc::IPDLStructMember<bool> ShouldCheckForRecursion_;
    ::mozilla::ipc::IPDLStructMember<bool> IsFormSubmission_;
    ::mozilla::ipc::IPDLStructMember<bool> FirstParty_;
    ::mozilla::ipc::IPDLStructMember<bool> HasValidUserGestureActivation_;
    ::mozilla::ipc::IPDLStructMember<bool> TextDirectiveUserActivation_;
    ::mozilla::ipc::IPDLStructMember<bool> AllowFocusMove_;
    ::mozilla::ipc::IPDLStructMember<bool> IsFromProcessingFrameAttributes_;
    ::mozilla::ipc::IPDLStructMember<bool> NeedsCompletelyLoadedDocument_;
    ::mozilla::ipc::IPDLStructMember<bool> ShouldNotForceReplaceInOnLoad_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<NavigationHistoryBehavior>> HistoryBehavior_;
    ::mozilla::ipc::IPDLStructMember<SchemelessInputType> SchemelessInput_;
    ::mozilla::ipc::IPDLStructMember<ForceMediaDocument> forceMediaDocument_;
    ::mozilla::ipc::IPDLStructMember<HTTPSUpgradeTelemetryType> HttpsUpgradeTelemetry_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<ClonedMessageData>> NavigationAPIState_;
    ::mozilla::ipc::IPDLStructMember<bool> ChannelInitialized_;
    ::mozilla::ipc::IPDLStructMember<bool> TryToReplaceWithSessionHistoryLoad_;
    ::mozilla::ipc::IPDLStructMember<bool> IsMetaRefresh_;
    ::mozilla::ipc::IPDLStructMember<bool> IsCaptivePortalTab_;
    ::mozilla::ipc::IPDLStructMember<uint64_t> LoadIdentifier_;
    ::mozilla::ipc::IPDLStructMember<uint64_t> TriggeringWindowId_;
    ::mozilla::ipc::IPDLStructMember<uint32_t> LoadType_;
    ::mozilla::ipc::IPDLStructMember<uint32_t> LoadFlags_;
    ::mozilla::ipc::IPDLStructMember<uint32_t> InternalLoadFlags_;
    ::mozilla::ipc::IPDLStructMember<uint32_t> TriggeringSandboxFlags_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::DocShellLoadStateInit>
{
    typedef ::mozilla::dom::DocShellLoadStateInit paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct TimedChannelInfo|
//
namespace mozilla {
namespace dom {
class TimedChannelInfo final
{
private:
    typedef ::int8_t int8_t;
    typedef ::mozilla::TimeStamp TimeStamp;
    typedef ::nsString nsString;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    TimedChannelInfo() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT TimedChannelInfo(
            const int8_t& _redirectCount,
            const int8_t& _internalRedirectCount,
            const TimeStamp& _asyncOpen,
            const TimeStamp& _channelCreation,
            const TimeStamp& _redirectStart,
            const TimeStamp& _redirectEnd,
            const nsString& _initiatorType,
            const bool& _allRedirectsSameOrigin,
            const bool& _allRedirectsPassTimingAllowCheck,
            const mozilla::Maybe<bool>& _timingAllowCheckForPrincipal,
            const bool& _renderBlocking,
            const TimeStamp& _launchServiceWorkerStart,
            const TimeStamp& _launchServiceWorkerEnd,
            const TimeStamp& _dispatchFetchEventStart,
            const TimeStamp& _dispatchFetchEventEnd,
            const TimeStamp& _handleFetchEventStart,
            const TimeStamp& _handleFetchEventEnd,
            const TimeStamp& _responseStart,
            const TimeStamp& _responseEnd) :
        asyncOpen_(_asyncOpen),
        channelCreation_(_channelCreation),
        redirectStart_(_redirectStart),
        redirectEnd_(_redirectEnd),
        initiatorType_(_initiatorType),
        allRedirectsSameOrigin_(_allRedirectsSameOrigin),
        allRedirectsPassTimingAllowCheck_(_allRedirectsPassTimingAllowCheck),
        timingAllowCheckForPrincipal_(_timingAllowCheckForPrincipal),
        renderBlocking_(_renderBlocking),
        launchServiceWorkerStart_(_launchServiceWorkerStart),
        launchServiceWorkerEnd_(_launchServiceWorkerEnd),
        dispatchFetchEventStart_(_dispatchFetchEventStart),
        dispatchFetchEventEnd_(_dispatchFetchEventEnd),
        handleFetchEventStart_(_handleFetchEventStart),
        handleFetchEventEnd_(_handleFetchEventEnd),
        responseStart_(_responseStart),
        responseEnd_(_responseEnd),
        redirectCount_(_redirectCount),
        internalRedirectCount_(_internalRedirectCount)
    {
    }

    MOZ_IMPLICIT TimedChannelInfo(
            int8_t&& _redirectCount,
            int8_t&& _internalRedirectCount,
            TimeStamp&& _asyncOpen,
            TimeStamp&& _channelCreation,
            TimeStamp&& _redirectStart,
            TimeStamp&& _redirectEnd,
            nsString&& _initiatorType,
            bool&& _allRedirectsSameOrigin,
            bool&& _allRedirectsPassTimingAllowCheck,
            mozilla::Maybe<bool>&& _timingAllowCheckForPrincipal,
            bool&& _renderBlocking,
            TimeStamp&& _launchServiceWorkerStart,
            TimeStamp&& _launchServiceWorkerEnd,
            TimeStamp&& _dispatchFetchEventStart,
            TimeStamp&& _dispatchFetchEventEnd,
            TimeStamp&& _handleFetchEventStart,
            TimeStamp&& _handleFetchEventEnd,
            TimeStamp&& _responseStart,
            TimeStamp&& _responseEnd) :
        asyncOpen_(std::move(_asyncOpen)),
        channelCreation_(std::move(_channelCreation)),
        redirectStart_(std::move(_redirectStart)),
        redirectEnd_(std::move(_redirectEnd)),
        initiatorType_(std::move(_initiatorType)),
        allRedirectsSameOrigin_(std::move(_allRedirectsSameOrigin)),
        allRedirectsPassTimingAllowCheck_(std::move(_allRedirectsPassTimingAllowCheck)),
        timingAllowCheckForPrincipal_(std::move(_timingAllowCheckForPrincipal)),
        renderBlocking_(std::move(_renderBlocking)),
        launchServiceWorkerStart_(std::move(_launchServiceWorkerStart)),
        launchServiceWorkerEnd_(std::move(_launchServiceWorkerEnd)),
        dispatchFetchEventStart_(std::move(_dispatchFetchEventStart)),
        dispatchFetchEventEnd_(std::move(_dispatchFetchEventEnd)),
        handleFetchEventStart_(std::move(_handleFetchEventStart)),
        handleFetchEventEnd_(std::move(_handleFetchEventEnd)),
        responseStart_(std::move(_responseStart)),
        responseEnd_(std::move(_responseEnd)),
        redirectCount_(std::move(_redirectCount)),
        internalRedirectCount_(std::move(_internalRedirectCount))
    {
    }

    int8_t&
    redirectCount()
    {
        return redirectCount_;
    }
    const int8_t&
    redirectCount() const
    {
        return redirectCount_;
    }

    int8_t&
    internalRedirectCount()
    {
        return internalRedirectCount_;
    }
    const int8_t&
    internalRedirectCount() const
    {
        return internalRedirectCount_;
    }

    TimeStamp&
    asyncOpen()
    {
        return asyncOpen_;
    }
    const TimeStamp&
    asyncOpen() const
    {
        return asyncOpen_;
    }

    TimeStamp&
    channelCreation()
    {
        return channelCreation_;
    }
    const TimeStamp&
    channelCreation() const
    {
        return channelCreation_;
    }

    TimeStamp&
    redirectStart()
    {
        return redirectStart_;
    }
    const TimeStamp&
    redirectStart() const
    {
        return redirectStart_;
    }

    TimeStamp&
    redirectEnd()
    {
        return redirectEnd_;
    }
    const TimeStamp&
    redirectEnd() const
    {
        return redirectEnd_;
    }

    nsString&
    initiatorType()
    {
        return initiatorType_;
    }
    const nsString&
    initiatorType() const
    {
        return initiatorType_;
    }

    bool&
    allRedirectsSameOrigin()
    {
        return allRedirectsSameOrigin_;
    }
    const bool&
    allRedirectsSameOrigin() const
    {
        return allRedirectsSameOrigin_;
    }

    bool&
    allRedirectsPassTimingAllowCheck()
    {
        return allRedirectsPassTimingAllowCheck_;
    }
    const bool&
    allRedirectsPassTimingAllowCheck() const
    {
        return allRedirectsPassTimingAllowCheck_;
    }

    mozilla::Maybe<bool>&
    timingAllowCheckForPrincipal()
    {
        return timingAllowCheckForPrincipal_;
    }
    const mozilla::Maybe<bool>&
    timingAllowCheckForPrincipal() const
    {
        return timingAllowCheckForPrincipal_;
    }

    bool&
    renderBlocking()
    {
        return renderBlocking_;
    }
    const bool&
    renderBlocking() const
    {
        return renderBlocking_;
    }

    TimeStamp&
    launchServiceWorkerStart()
    {
        return launchServiceWorkerStart_;
    }
    const TimeStamp&
    launchServiceWorkerStart() const
    {
        return launchServiceWorkerStart_;
    }

    TimeStamp&
    launchServiceWorkerEnd()
    {
        return launchServiceWorkerEnd_;
    }
    const TimeStamp&
    launchServiceWorkerEnd() const
    {
        return launchServiceWorkerEnd_;
    }

    TimeStamp&
    dispatchFetchEventStart()
    {
        return dispatchFetchEventStart_;
    }
    const TimeStamp&
    dispatchFetchEventStart() const
    {
        return dispatchFetchEventStart_;
    }

    TimeStamp&
    dispatchFetchEventEnd()
    {
        return dispatchFetchEventEnd_;
    }
    const TimeStamp&
    dispatchFetchEventEnd() const
    {
        return dispatchFetchEventEnd_;
    }

    TimeStamp&
    handleFetchEventStart()
    {
        return handleFetchEventStart_;
    }
    const TimeStamp&
    handleFetchEventStart() const
    {
        return handleFetchEventStart_;
    }

    TimeStamp&
    handleFetchEventEnd()
    {
        return handleFetchEventEnd_;
    }
    const TimeStamp&
    handleFetchEventEnd() const
    {
        return handleFetchEventEnd_;
    }

    TimeStamp&
    responseStart()
    {
        return responseStart_;
    }
    const TimeStamp&
    responseStart() const
    {
        return responseStart_;
    }

    TimeStamp&
    responseEnd()
    {
        return responseEnd_;
    }
    const TimeStamp&
    responseEnd() const
    {
        return responseEnd_;
    }

private:
    void
    StaticAssertions() const;
    ::mozilla::ipc::IPDLStructMember<TimeStamp> asyncOpen_;
    ::mozilla::ipc::IPDLStructMember<TimeStamp> channelCreation_;
    ::mozilla::ipc::IPDLStructMember<TimeStamp> redirectStart_;
    ::mozilla::ipc::IPDLStructMember<TimeStamp> redirectEnd_;
    ::mozilla::ipc::IPDLStructMember<nsString> initiatorType_;
    ::mozilla::ipc::IPDLStructMember<bool> allRedirectsSameOrigin_;
    ::mozilla::ipc::IPDLStructMember<bool> allRedirectsPassTimingAllowCheck_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<bool>> timingAllowCheckForPrincipal_;
    ::mozilla::ipc::IPDLStructMember<bool> renderBlocking_;
    ::mozilla::ipc::IPDLStructMember<TimeStamp> launchServiceWorkerStart_;
    ::mozilla::ipc::IPDLStructMember<TimeStamp> launchServiceWorkerEnd_;
    ::mozilla::ipc::IPDLStructMember<TimeStamp> dispatchFetchEventStart_;
    ::mozilla::ipc::IPDLStructMember<TimeStamp> dispatchFetchEventEnd_;
    ::mozilla::ipc::IPDLStructMember<TimeStamp> handleFetchEventStart_;
    ::mozilla::ipc::IPDLStructMember<TimeStamp> handleFetchEventEnd_;
    ::mozilla::ipc::IPDLStructMember<TimeStamp> responseStart_;
    ::mozilla::ipc::IPDLStructMember<TimeStamp> responseEnd_;
    ::mozilla::ipc::IPDLStructMember<int8_t> redirectCount_;
    ::mozilla::ipc::IPDLStructMember<int8_t> internalRedirectCount_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::TimedChannelInfo>
{
    typedef ::mozilla::dom::TimedChannelInfo paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ReplacementChannelConfigInit|
//
namespace mozilla {
namespace dom {
class ReplacementChannelConfigInit final
{
private:
    typedef ::uint32_t uint32_t;
    typedef ::mozilla::net::ClassOfService ClassOfService;
    typedef ::nsCString nsCString;
    typedef ::nsIReferrerInfo nsIReferrerInfo;
    typedef ::mozilla::dom::TimedChannelInfo TimedChannelInfo;
    typedef ::mozilla::RemoteLazyInputStream RemoteLazyInputStream;
    typedef ::uint64_t uint64_t;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ReplacementChannelConfigInit() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ReplacementChannelConfigInit(
            const uint32_t& _redirectFlags,
            const ClassOfService& _classOfService,
            const mozilla::Maybe<bool>& _privateBrowsing,
            const mozilla::Maybe<nsCString>& _method,
            nsIReferrerInfo* _referrerInfo,
            const mozilla::Maybe<TimedChannelInfo>& _timedChannelInfo,
            RemoteLazyInputStream* _uploadStream,
            const uint64_t& _uploadStreamLength,
            const bool& _uploadStreamHasHeaders,
            const mozilla::Maybe<nsCString>& _contentType,
            const mozilla::Maybe<nsCString>& _contentLength) :
        classOfService_(_classOfService),
        privateBrowsing_(_privateBrowsing),
        method_(_method),
        referrerInfo_(_referrerInfo),
        timedChannelInfo_(_timedChannelInfo),
        uploadStream_(_uploadStream),
        uploadStreamHasHeaders_(_uploadStreamHasHeaders),
        contentType_(_contentType),
        contentLength_(_contentLength),
        uploadStreamLength_(_uploadStreamLength),
        redirectFlags_(_redirectFlags)
    {
    }

    MOZ_IMPLICIT ReplacementChannelConfigInit(
            uint32_t&& _redirectFlags,
            ClassOfService&& _classOfService,
            mozilla::Maybe<bool>&& _privateBrowsing,
            mozilla::Maybe<nsCString>&& _method,
            RefPtr<nsIReferrerInfo>&& _referrerInfo,
            mozilla::Maybe<TimedChannelInfo>&& _timedChannelInfo,
            RefPtr<RemoteLazyInputStream>&& _uploadStream,
            uint64_t&& _uploadStreamLength,
            bool&& _uploadStreamHasHeaders,
            mozilla::Maybe<nsCString>&& _contentType,
            mozilla::Maybe<nsCString>&& _contentLength) :
        classOfService_(std::move(_classOfService)),
        privateBrowsing_(std::move(_privateBrowsing)),
        method_(std::move(_method)),
        referrerInfo_(std::move(_referrerInfo)),
        timedChannelInfo_(std::move(_timedChannelInfo)),
        uploadStream_(std::move(_uploadStream)),
        uploadStreamHasHeaders_(std::move(_uploadStreamHasHeaders)),
        contentType_(std::move(_contentType)),
        contentLength_(std::move(_contentLength)),
        uploadStreamLength_(std::move(_uploadStreamLength)),
        redirectFlags_(std::move(_redirectFlags))
    {
    }

    uint32_t&
    redirectFlags()
    {
        return redirectFlags_;
    }
    const uint32_t&
    redirectFlags() const
    {
        return redirectFlags_;
    }

    ClassOfService&
    classOfService()
    {
        return classOfService_;
    }
    const ClassOfService&
    classOfService() const
    {
        return classOfService_;
    }

    mozilla::Maybe<bool>&
    privateBrowsing()
    {
        return privateBrowsing_;
    }
    const mozilla::Maybe<bool>&
    privateBrowsing() const
    {
        return privateBrowsing_;
    }

    mozilla::Maybe<nsCString>&
    method()
    {
        return method_;
    }
    const mozilla::Maybe<nsCString>&
    method() const
    {
        return method_;
    }

    RefPtr<nsIReferrerInfo>&
    referrerInfo()
    {
        return referrerInfo_;
    }
    nsIReferrerInfo*
    referrerInfo() const
    {
        return referrerInfo_;
    }

    mozilla::Maybe<TimedChannelInfo>&
    timedChannelInfo()
    {
        return timedChannelInfo_;
    }
    const mozilla::Maybe<TimedChannelInfo>&
    timedChannelInfo() const
    {
        return timedChannelInfo_;
    }

    RefPtr<RemoteLazyInputStream>&
    uploadStream()
    {
        return uploadStream_;
    }
    RemoteLazyInputStream*
    uploadStream() const
    {
        return uploadStream_;
    }

    uint64_t&
    uploadStreamLength()
    {
        return uploadStreamLength_;
    }
    const uint64_t&
    uploadStreamLength() const
    {
        return uploadStreamLength_;
    }

    bool&
    uploadStreamHasHeaders()
    {
        return uploadStreamHasHeaders_;
    }
    const bool&
    uploadStreamHasHeaders() const
    {
        return uploadStreamHasHeaders_;
    }

    mozilla::Maybe<nsCString>&
    contentType()
    {
        return contentType_;
    }
    const mozilla::Maybe<nsCString>&
    contentType() const
    {
        return contentType_;
    }

    mozilla::Maybe<nsCString>&
    contentLength()
    {
        return contentLength_;
    }
    const mozilla::Maybe<nsCString>&
    contentLength() const
    {
        return contentLength_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<ClassOfService> classOfService_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<bool>> privateBrowsing_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<nsCString>> method_;
    ::mozilla::ipc::IPDLStructMember<RefPtr<nsIReferrerInfo>> referrerInfo_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<TimedChannelInfo>> timedChannelInfo_;
    ::mozilla::ipc::IPDLStructMember<RefPtr<RemoteLazyInputStream>> uploadStream_;
    ::mozilla::ipc::IPDLStructMember<bool> uploadStreamHasHeaders_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<nsCString>> contentType_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<nsCString>> contentLength_;
    ::mozilla::ipc::IPDLStructMember<uint64_t> uploadStreamLength_;
    ::mozilla::ipc::IPDLStructMember<uint32_t> redirectFlags_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ReplacementChannelConfigInit>
{
    typedef ::mozilla::dom::ReplacementChannelConfigInit paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union IPDLVariantValue|
//
namespace mozilla {
namespace dom {
class IPDLVariantValue final
{
public:
    enum Type {
        T__None,
        Tbool = 1,
        Tuint8_t,
        Tint16_t,
        Tuint16_t,
        Tint32_t,
        Tuint32_t,
        Tfloat,
        Tdouble,
        TnsID,
        TnsString,
        TnsCString,
        TnsIURI,
        TnsIPrincipal,
        T__Last = TnsIPrincipal
    };

private:
    typedef ::uint8_t uint8_t;
    typedef ::int16_t int16_t;
    typedef ::uint16_t uint16_t;
    typedef ::int32_t int32_t;
    typedef ::uint32_t uint32_t;
    typedef ::nsID nsID;
    typedef ::nsString nsString;
    typedef ::nsCString nsCString;
    typedef ::nsIURI nsIURI;
    typedef ::nsIPrincipal nsIPrincipal;
    typedef bool bool__tdef;
    typedef uint8_t uint8_t__tdef;
    typedef int16_t int16_t__tdef;
    typedef uint16_t uint16_t__tdef;
    typedef int32_t int32_t__tdef;
    typedef uint32_t uint32_t__tdef;
    typedef float float__tdef;
    typedef double double__tdef;
    typedef nsID nsID__tdef;
    typedef nsString nsString__tdef;
    typedef nsCString nsCString__tdef;
    typedef RefPtr<nsIURI> nsIURI__tdef;
    typedef RefPtr<nsIPrincipal> nsIPrincipal__tdef;

    bool*
    ptr_bool()
    {
        return (&(mVbool));
    }
    const bool*
    constptr_bool() const
    {
        return (&(mVbool));
    }
    uint8_t*
    ptr_uint8_t()
    {
        return (&(mVuint8_t));
    }
    const uint8_t*
    constptr_uint8_t() const
    {
        return (&(mVuint8_t));
    }
    int16_t*
    ptr_int16_t()
    {
        return (&(mVint16_t));
    }
    const int16_t*
    constptr_int16_t() const
    {
        return (&(mVint16_t));
    }
    uint16_t*
    ptr_uint16_t()
    {
        return (&(mVuint16_t));
    }
    const uint16_t*
    constptr_uint16_t() const
    {
        return (&(mVuint16_t));
    }
    int32_t*
    ptr_int32_t()
    {
        return (&(mVint32_t));
    }
    const int32_t*
    constptr_int32_t() const
    {
        return (&(mVint32_t));
    }
    uint32_t*
    ptr_uint32_t()
    {
        return (&(mVuint32_t));
    }
    const uint32_t*
    constptr_uint32_t() const
    {
        return (&(mVuint32_t));
    }
    float*
    ptr_float()
    {
        return (&(mVfloat));
    }
    const float*
    constptr_float() const
    {
        return (&(mVfloat));
    }
    double*
    ptr_double()
    {
        return (&(mVdouble));
    }
    const double*
    constptr_double() const
    {
        return (&(mVdouble));
    }
    nsID*
    ptr_nsID()
    {
        return (&(mVnsID));
    }
    const nsID*
    constptr_nsID() const
    {
        return (&(mVnsID));
    }
    nsString*
    ptr_nsString()
    {
        return (&(mVnsString));
    }
    const nsString*
    constptr_nsString() const
    {
        return (&(mVnsString));
    }
    nsCString*
    ptr_nsCString()
    {
        return (&(mVnsCString));
    }
    const nsCString*
    constptr_nsCString() const
    {
        return (&(mVnsCString));
    }
    RefPtr<nsIURI>*
    ptr_nsIURI()
    {
        return (&(mVnsIURI));
    }
    const RefPtr<nsIURI>*
    constptr_nsIURI() const
    {
        return (&(mVnsIURI));
    }
    RefPtr<nsIPrincipal>*
    ptr_nsIPrincipal()
    {
        return (&(mVnsIPrincipal));
    }
    const RefPtr<nsIPrincipal>*
    constptr_nsIPrincipal() const
    {
        return (&(mVnsIPrincipal));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT IPDLVariantValue() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT IPDLVariantValue(const bool& aOther);

    MOZ_IMPLICIT IPDLVariantValue(bool&& aOther);

    MOZ_IMPLICIT IPDLVariantValue(const uint8_t& aOther);

    MOZ_IMPLICIT IPDLVariantValue(uint8_t&& aOther);

    MOZ_IMPLICIT IPDLVariantValue(const int16_t& aOther);

    MOZ_IMPLICIT IPDLVariantValue(int16_t&& aOther);

    MOZ_IMPLICIT IPDLVariantValue(const uint16_t& aOther);

    MOZ_IMPLICIT IPDLVariantValue(uint16_t&& aOther);

    MOZ_IMPLICIT IPDLVariantValue(const int32_t& aOther);

    MOZ_IMPLICIT IPDLVariantValue(int32_t&& aOther);

    MOZ_IMPLICIT IPDLVariantValue(const uint32_t& aOther);

    MOZ_IMPLICIT IPDLVariantValue(uint32_t&& aOther);

    MOZ_IMPLICIT IPDLVariantValue(const float& aOther);

    MOZ_IMPLICIT IPDLVariantValue(float&& aOther);

    MOZ_IMPLICIT IPDLVariantValue(const double& aOther);

    MOZ_IMPLICIT IPDLVariantValue(double&& aOther);

    MOZ_IMPLICIT IPDLVariantValue(const nsID& aOther);

    MOZ_IMPLICIT IPDLVariantValue(nsID&& aOther);

    MOZ_IMPLICIT IPDLVariantValue(const nsString& aOther);

    MOZ_IMPLICIT IPDLVariantValue(nsString&& aOther);

    MOZ_IMPLICIT IPDLVariantValue(const nsCString& aOther);

    MOZ_IMPLICIT IPDLVariantValue(nsCString&& aOther);

    MOZ_IMPLICIT IPDLVariantValue(nsIURI* aOther);

    MOZ_IMPLICIT IPDLVariantValue(RefPtr<nsIURI>&& aOther);

    MOZ_IMPLICIT IPDLVariantValue(nsIPrincipal* aOther);

    MOZ_IMPLICIT IPDLVariantValue(RefPtr<nsIPrincipal>&& aOther);

    MOZ_IMPLICIT IPDLVariantValue(const IPDLVariantValue& aOther);

    MOZ_IMPLICIT IPDLVariantValue(IPDLVariantValue&& aOther);

    ~IPDLVariantValue();

    Type
    type() const
    {
        return mType;
    }

    IPDLVariantValue&
    operator=(const bool& aRhs);

    IPDLVariantValue&
    operator=(bool&& aRhs);

    IPDLVariantValue&
    operator=(const uint8_t& aRhs);

    IPDLVariantValue&
    operator=(uint8_t&& aRhs);

    IPDLVariantValue&
    operator=(const int16_t& aRhs);

    IPDLVariantValue&
    operator=(int16_t&& aRhs);

    IPDLVariantValue&
    operator=(const uint16_t& aRhs);

    IPDLVariantValue&
    operator=(uint16_t&& aRhs);

    IPDLVariantValue&
    operator=(const int32_t& aRhs);

    IPDLVariantValue&
    operator=(int32_t&& aRhs);

    IPDLVariantValue&
    operator=(const uint32_t& aRhs);

    IPDLVariantValue&
    operator=(uint32_t&& aRhs);

    IPDLVariantValue&
    operator=(const float& aRhs);

    IPDLVariantValue&
    operator=(float&& aRhs);

    IPDLVariantValue&
    operator=(const double& aRhs);

    IPDLVariantValue&
    operator=(double&& aRhs);

    IPDLVariantValue&
    operator=(const nsID& aRhs);

    IPDLVariantValue&
    operator=(nsID&& aRhs);

    IPDLVariantValue&
    operator=(const nsString& aRhs);

    IPDLVariantValue&
    operator=(nsString&& aRhs);

    IPDLVariantValue&
    operator=(const nsCString& aRhs);

    IPDLVariantValue&
    operator=(nsCString&& aRhs);

    IPDLVariantValue&
    operator=(nsIURI* aRhs);

    IPDLVariantValue&
    operator=(RefPtr<nsIURI>&& aRhs);

    IPDLVariantValue&
    operator=(nsIPrincipal* aRhs);

    IPDLVariantValue&
    operator=(RefPtr<nsIPrincipal>&& aRhs);

    IPDLVariantValue&
    operator=(const IPDLVariantValue& aRhs);

    IPDLVariantValue&
    operator=(IPDLVariantValue&& aRhs);

    bool&
    get_bool()
    {
        AssertSanity(Tbool);
        return (*(ptr_bool()));
    }
    const bool&
    get_bool() const
    {
        AssertSanity(Tbool);
        return (*(constptr_bool()));
    }
    operator bool&()
    {
        return get_bool();
    }
    operator const bool&() const
    {
        return get_bool();
    }

    uint8_t&
    get_uint8_t()
    {
        AssertSanity(Tuint8_t);
        return (*(ptr_uint8_t()));
    }
    const uint8_t&
    get_uint8_t() const
    {
        AssertSanity(Tuint8_t);
        return (*(constptr_uint8_t()));
    }
    operator uint8_t&()
    {
        return get_uint8_t();
    }
    operator const uint8_t&() const
    {
        return get_uint8_t();
    }

    int16_t&
    get_int16_t()
    {
        AssertSanity(Tint16_t);
        return (*(ptr_int16_t()));
    }
    const int16_t&
    get_int16_t() const
    {
        AssertSanity(Tint16_t);
        return (*(constptr_int16_t()));
    }
    operator int16_t&()
    {
        return get_int16_t();
    }
    operator const int16_t&() const
    {
        return get_int16_t();
    }

    uint16_t&
    get_uint16_t()
    {
        AssertSanity(Tuint16_t);
        return (*(ptr_uint16_t()));
    }
    const uint16_t&
    get_uint16_t() const
    {
        AssertSanity(Tuint16_t);
        return (*(constptr_uint16_t()));
    }
    operator uint16_t&()
    {
        return get_uint16_t();
    }
    operator const uint16_t&() const
    {
        return get_uint16_t();
    }

    int32_t&
    get_int32_t()
    {
        AssertSanity(Tint32_t);
        return (*(ptr_int32_t()));
    }
    const int32_t&
    get_int32_t() const
    {
        AssertSanity(Tint32_t);
        return (*(constptr_int32_t()));
    }
    operator int32_t&()
    {
        return get_int32_t();
    }
    operator const int32_t&() const
    {
        return get_int32_t();
    }

    uint32_t&
    get_uint32_t()
    {
        AssertSanity(Tuint32_t);
        return (*(ptr_uint32_t()));
    }
    const uint32_t&
    get_uint32_t() const
    {
        AssertSanity(Tuint32_t);
        return (*(constptr_uint32_t()));
    }
    operator uint32_t&()
    {
        return get_uint32_t();
    }
    operator const uint32_t&() const
    {
        return get_uint32_t();
    }

    float&
    get_float()
    {
        AssertSanity(Tfloat);
        return (*(ptr_float()));
    }
    const float&
    get_float() const
    {
        AssertSanity(Tfloat);
        return (*(constptr_float()));
    }
    operator float&()
    {
        return get_float();
    }
    operator const float&() const
    {
        return get_float();
    }

    double&
    get_double()
    {
        AssertSanity(Tdouble);
        return (*(ptr_double()));
    }
    const double&
    get_double() const
    {
        AssertSanity(Tdouble);
        return (*(constptr_double()));
    }
    operator double&()
    {
        return get_double();
    }
    operator const double&() const
    {
        return get_double();
    }

    nsID&
    get_nsID()
    {
        AssertSanity(TnsID);
        return (*(ptr_nsID()));
    }
    const nsID&
    get_nsID() const
    {
        AssertSanity(TnsID);
        return (*(constptr_nsID()));
    }
    operator nsID&()
    {
        return get_nsID();
    }
    operator const nsID&() const
    {
        return get_nsID();
    }

    nsString&
    get_nsString()
    {
        AssertSanity(TnsString);
        return (*(ptr_nsString()));
    }
    const nsString&
    get_nsString() const
    {
        AssertSanity(TnsString);
        return (*(constptr_nsString()));
    }
    operator nsString&()
    {
        return get_nsString();
    }
    operator const nsString&() const
    {
        return get_nsString();
    }

    nsCString&
    get_nsCString()
    {
        AssertSanity(TnsCString);
        return (*(ptr_nsCString()));
    }
    const nsCString&
    get_nsCString() const
    {
        AssertSanity(TnsCString);
        return (*(constptr_nsCString()));
    }
    operator nsCString&()
    {
        return get_nsCString();
    }
    operator const nsCString&() const
    {
        return get_nsCString();
    }

    RefPtr<nsIURI>&
    get_nsIURI()
    {
        AssertSanity(TnsIURI);
        return (*(ptr_nsIURI()));
    }
    nsIURI*
    get_nsIURI() const
    {
        AssertSanity(TnsIURI);
        return (*(constptr_nsIURI()));
    }
    operator RefPtr<nsIURI>&()
    {
        return get_nsIURI();
    }
    operator nsIURI*() const
    {
        return get_nsIURI();
    }

    RefPtr<nsIPrincipal>&
    get_nsIPrincipal()
    {
        AssertSanity(TnsIPrincipal);
        return (*(ptr_nsIPrincipal()));
    }
    nsIPrincipal*
    get_nsIPrincipal() const
    {
        AssertSanity(TnsIPrincipal);
        return (*(constptr_nsIPrincipal()));
    }
    operator RefPtr<nsIPrincipal>&()
    {
        return get_nsIPrincipal();
    }
    operator nsIPrincipal*() const
    {
        return get_nsIPrincipal();
    }

private:
    union {
        bool mVbool;
        uint8_t mVuint8_t;
        int16_t mVint16_t;
        uint16_t mVuint16_t;
        int32_t mVint32_t;
        uint32_t mVuint32_t;
        float mVfloat;
        double mVdouble;
        nsID mVnsID;
        nsString mVnsString;
        nsCString mVnsCString;
        RefPtr<nsIURI> mVnsIURI;
        RefPtr<nsIPrincipal> mVnsIPrincipal;
    };
    Type mType;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::IPDLVariantValue>
{
    typedef ::mozilla::dom::IPDLVariantValue paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct IDPLVariant|
//
namespace mozilla {
namespace dom {
class IDPLVariant final
{
private:
    typedef ::uint32_t uint32_t;
    typedef ::mozilla::dom::IPDLVariantValue IPDLVariantValue;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    IDPLVariant() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT IDPLVariant(
            const uint32_t& _type,
            const IPDLVariantValue& _data) :
        data_(_data),
        type_(_type)
    {
    }

    MOZ_IMPLICIT IDPLVariant(
            uint32_t&& _type,
            IPDLVariantValue&& _data) :
        data_(std::move(_data)),
        type_(std::move(_type))
    {
    }

    uint32_t&
    type()
    {
        return type_;
    }
    const uint32_t&
    type() const
    {
        return type_;
    }

    IPDLVariantValue&
    data()
    {
        return data_;
    }
    const IPDLVariantValue&
    data() const
    {
        return data_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<IPDLVariantValue> data_;
    ::mozilla::ipc::IPDLStructMember<uint32_t> type_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::IDPLVariant>
{
    typedef ::mozilla::dom::IDPLVariant paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct IPDLProperty|
//
namespace mozilla {
namespace dom {
class IPDLProperty final
{
private:
    typedef ::nsString nsString;
    typedef ::nsIVariant nsIVariant;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    IPDLProperty() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT IPDLProperty(
            const nsString& _name,
            nsIVariant* _value) :
        name_(_name),
        value_(_value)
    {
    }

    MOZ_IMPLICIT IPDLProperty(
            nsString&& _name,
            RefPtr<nsIVariant>&& _value) :
        name_(std::move(_name)),
        value_(std::move(_value))
    {
    }

    nsString&
    name()
    {
        return name_;
    }
    const nsString&
    name() const
    {
        return name_;
    }

    RefPtr<nsIVariant>&
    value()
    {
        return value_;
    }
    nsIVariant*
    value() const
    {
        return value_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsString> name_;
    ::mozilla::ipc::IPDLStructMember<RefPtr<nsIVariant>> value_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::IPDLProperty>
{
    typedef ::mozilla::dom::IPDLProperty paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct ParentShowInfo|
//
namespace mozilla {
namespace dom {
class ParentShowInfo final
{
private:
    typedef ::nsString nsString;
    typedef ::int32_t int32_t;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    ParentShowInfo() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT ParentShowInfo(
            const nsString& _name,
            const bool& _fakeShowInfo,
            const bool& _isTransparent,
            const float& _dpi,
            const int32_t& _widgetRounding,
            const double& _defaultScale) :
        name_(_name),
        fakeShowInfo_(_fakeShowInfo),
        isTransparent_(_isTransparent),
        defaultScale_(_defaultScale),
        dpi_(_dpi),
        widgetRounding_(_widgetRounding)
    {
    }

    MOZ_IMPLICIT ParentShowInfo(
            nsString&& _name,
            bool&& _fakeShowInfo,
            bool&& _isTransparent,
            float&& _dpi,
            int32_t&& _widgetRounding,
            double&& _defaultScale) :
        name_(std::move(_name)),
        fakeShowInfo_(std::move(_fakeShowInfo)),
        isTransparent_(std::move(_isTransparent)),
        defaultScale_(std::move(_defaultScale)),
        dpi_(std::move(_dpi)),
        widgetRounding_(std::move(_widgetRounding))
    {
    }

    nsString&
    name()
    {
        return name_;
    }
    const nsString&
    name() const
    {
        return name_;
    }

    bool&
    fakeShowInfo()
    {
        return fakeShowInfo_;
    }
    const bool&
    fakeShowInfo() const
    {
        return fakeShowInfo_;
    }

    bool&
    isTransparent()
    {
        return isTransparent_;
    }
    const bool&
    isTransparent() const
    {
        return isTransparent_;
    }

    float&
    dpi()
    {
        return dpi_;
    }
    const float&
    dpi() const
    {
        return dpi_;
    }

    int32_t&
    widgetRounding()
    {
        return widgetRounding_;
    }
    const int32_t&
    widgetRounding() const
    {
        return widgetRounding_;
    }

    double&
    defaultScale()
    {
        return defaultScale_;
    }
    const double&
    defaultScale() const
    {
        return defaultScale_;
    }

private:
    void
    StaticAssertions() const;
    ::mozilla::ipc::IPDLStructMember<nsString> name_;
    ::mozilla::ipc::IPDLStructMember<bool> fakeShowInfo_;
    ::mozilla::ipc::IPDLStructMember<bool> isTransparent_;
    ::mozilla::ipc::IPDLStructMember<double> defaultScale_;
    ::mozilla::ipc::IPDLStructMember<float> dpi_;
    ::mozilla::ipc::IPDLStructMember<int32_t> widgetRounding_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::ParentShowInfo>
{
    typedef ::mozilla::dom::ParentShowInfo paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct OwnerShowInfo|
//
namespace mozilla {
namespace dom {
class OwnerShowInfo final
{
private:
    typedef ::mozilla::LayoutDeviceIntSize LayoutDeviceIntSize;
    typedef ::mozilla::ScrollbarPreference ScrollbarPreference;
    typedef ::nsSizeMode nsSizeMode;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    OwnerShowInfo() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT OwnerShowInfo(
            const LayoutDeviceIntSize& _size,
            const ScrollbarPreference& _scrollbarPreference,
            const nsSizeMode& _sizeMode) :
        size_(_size),
        scrollbarPreference_(_scrollbarPreference),
        sizeMode_(_sizeMode)
    {
    }

    MOZ_IMPLICIT OwnerShowInfo(
            LayoutDeviceIntSize&& _size,
            ScrollbarPreference&& _scrollbarPreference,
            nsSizeMode&& _sizeMode) :
        size_(std::move(_size)),
        scrollbarPreference_(std::move(_scrollbarPreference)),
        sizeMode_(std::move(_sizeMode))
    {
    }

    LayoutDeviceIntSize&
    size()
    {
        return size_;
    }
    const LayoutDeviceIntSize&
    size() const
    {
        return size_;
    }

    ScrollbarPreference&
    scrollbarPreference()
    {
        return scrollbarPreference_;
    }
    const ScrollbarPreference&
    scrollbarPreference() const
    {
        return scrollbarPreference_;
    }

    nsSizeMode&
    sizeMode()
    {
        return sizeMode_;
    }
    const nsSizeMode&
    sizeMode() const
    {
        return sizeMode_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<LayoutDeviceIntSize> size_;
    ::mozilla::ipc::IPDLStructMember<ScrollbarPreference> scrollbarPreference_;
    ::mozilla::ipc::IPDLStructMember<nsSizeMode> sizeMode_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::OwnerShowInfo>
{
    typedef ::mozilla::dom::OwnerShowInfo paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct IPCImage|
//
namespace mozilla {
namespace dom {
class IPCImage final
{
private:
    typedef ::mozilla::ipc::BigBuffer BigBuffer;
    typedef ::uint32_t uint32_t;
    typedef ::mozilla::gfx::SurfaceFormat SurfaceFormat;
    typedef ::mozilla::ImageIntSize ImageIntSize;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    IPCImage() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT IPCImage(
            BigBuffer&& _data,
            const uint32_t& _stride,
            const SurfaceFormat& _format,
            const ImageIntSize& _size) :
        data_(std::move(_data)),
        format_(_format),
        size_(_size),
        stride_(_stride)
    {
    }

    MOZ_IMPLICIT IPCImage(
            BigBuffer&& _data,
            uint32_t&& _stride,
            SurfaceFormat&& _format,
            ImageIntSize&& _size) :
        data_(std::move(_data)),
        format_(std::move(_format)),
        size_(std::move(_size)),
        stride_(std::move(_stride))
    {
    }

    BigBuffer&
    data()
    {
        return data_;
    }
    const BigBuffer&
    data() const
    {
        return data_;
    }

    uint32_t&
    stride()
    {
        return stride_;
    }
    const uint32_t&
    stride() const
    {
        return stride_;
    }

    SurfaceFormat&
    format()
    {
        return format_;
    }
    const SurfaceFormat&
    format() const
    {
        return format_;
    }

    ImageIntSize&
    size()
    {
        return size_;
    }
    const ImageIntSize&
    size() const
    {
        return size_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<BigBuffer> data_;
    ::mozilla::ipc::IPDLStructMember<SurfaceFormat> format_;
    ::mozilla::ipc::IPDLStructMember<ImageIntSize> size_;
    ::mozilla::ipc::IPDLStructMember<uint32_t> stride_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::IPCImage>
{
    typedef ::mozilla::dom::IPCImage paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            paramType&& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct IPCNotificationAction|
//
namespace mozilla {
namespace dom {
class IPCNotificationAction final
{
private:
    typedef ::nsString nsString;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    IPCNotificationAction() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT IPCNotificationAction(
            const nsString& _name,
            const nsString& _title) :
        name_(_name),
        title_(_title)
    {
    }

    MOZ_IMPLICIT IPCNotificationAction(
            nsString&& _name,
            nsString&& _title) :
        name_(std::move(_name)),
        title_(std::move(_title))
    {
    }

    nsString&
    name()
    {
        return name_;
    }
    const nsString&
    name() const
    {
        return name_;
    }

    nsString&
    title()
    {
        return title_;
    }
    const nsString&
    title() const
    {
        return title_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsString> name_;
    ::mozilla::ipc::IPDLStructMember<nsString> title_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::IPCNotificationAction>
{
    typedef ::mozilla::dom::IPCNotificationAction paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct IPCNotificationOptions|
//
namespace mozilla {
namespace dom {
class IPCNotificationOptions final
{
private:
    typedef ::nsString nsString;
    typedef ::mozilla::dom::NotificationDirection NotificationDirection;
    typedef ::uint32_t uint32_t;
    typedef ::mozilla::dom::IPCNotificationAction IPCNotificationAction;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    IPCNotificationOptions() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT IPCNotificationOptions(
            const nsString& _title,
            const NotificationDirection& _dir,
            const nsString& _lang,
            const nsString& _body,
            const nsString& _tag,
            const nsString& _icon,
            const bool& _requireInteraction,
            const bool& _silent,
            const nsTArray<uint32_t>& _vibrate,
            const nsString& _dataSerialized,
            const nsTArray<IPCNotificationAction>& _actions) :
        title_(_title),
        dir_(_dir),
        lang_(_lang),
        body_(_body),
        tag_(_tag),
        icon_(_icon),
        requireInteraction_(_requireInteraction),
        silent_(_silent),
        vibrate_(_vibrate),
        dataSerialized_(_dataSerialized),
        actions_(_actions)
    {
    }

    MOZ_IMPLICIT IPCNotificationOptions(
            nsString&& _title,
            NotificationDirection&& _dir,
            nsString&& _lang,
            nsString&& _body,
            nsString&& _tag,
            nsString&& _icon,
            bool&& _requireInteraction,
            bool&& _silent,
            nsTArray<uint32_t>&& _vibrate,
            nsString&& _dataSerialized,
            nsTArray<IPCNotificationAction>&& _actions) :
        title_(std::move(_title)),
        dir_(std::move(_dir)),
        lang_(std::move(_lang)),
        body_(std::move(_body)),
        tag_(std::move(_tag)),
        icon_(std::move(_icon)),
        requireInteraction_(std::move(_requireInteraction)),
        silent_(std::move(_silent)),
        vibrate_(std::move(_vibrate)),
        dataSerialized_(std::move(_dataSerialized)),
        actions_(std::move(_actions))
    {
    }

    nsString&
    title()
    {
        return title_;
    }
    const nsString&
    title() const
    {
        return title_;
    }

    NotificationDirection&
    dir()
    {
        return dir_;
    }
    const NotificationDirection&
    dir() const
    {
        return dir_;
    }

    nsString&
    lang()
    {
        return lang_;
    }
    const nsString&
    lang() const
    {
        return lang_;
    }

    nsString&
    body()
    {
        return body_;
    }
    const nsString&
    body() const
    {
        return body_;
    }

    nsString&
    tag()
    {
        return tag_;
    }
    const nsString&
    tag() const
    {
        return tag_;
    }

    nsString&
    icon()
    {
        return icon_;
    }
    const nsString&
    icon() const
    {
        return icon_;
    }

    bool&
    requireInteraction()
    {
        return requireInteraction_;
    }
    const bool&
    requireInteraction() const
    {
        return requireInteraction_;
    }

    bool&
    silent()
    {
        return silent_;
    }
    const bool&
    silent() const
    {
        return silent_;
    }

    nsTArray<uint32_t>&
    vibrate()
    {
        return vibrate_;
    }
    const nsTArray<uint32_t>&
    vibrate() const
    {
        return vibrate_;
    }

    nsString&
    dataSerialized()
    {
        return dataSerialized_;
    }
    const nsString&
    dataSerialized() const
    {
        return dataSerialized_;
    }

    nsTArray<IPCNotificationAction>&
    actions()
    {
        return actions_;
    }
    const nsTArray<IPCNotificationAction>&
    actions() const
    {
        return actions_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsString> title_;
    ::mozilla::ipc::IPDLStructMember<NotificationDirection> dir_;
    ::mozilla::ipc::IPDLStructMember<nsString> lang_;
    ::mozilla::ipc::IPDLStructMember<nsString> body_;
    ::mozilla::ipc::IPDLStructMember<nsString> tag_;
    ::mozilla::ipc::IPDLStructMember<nsString> icon_;
    ::mozilla::ipc::IPDLStructMember<bool> requireInteraction_;
    ::mozilla::ipc::IPDLStructMember<bool> silent_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<uint32_t>> vibrate_;
    ::mozilla::ipc::IPDLStructMember<nsString> dataSerialized_;
    ::mozilla::ipc::IPDLStructMember<CopyableTArray<IPCNotificationAction>> actions_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::IPCNotificationOptions>
{
    typedef ::mozilla::dom::IPCNotificationOptions paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct IPCNotification|
//
namespace mozilla {
namespace dom {
class IPCNotification final
{
private:
    typedef ::nsString nsString;
    typedef ::mozilla::dom::IPCNotificationOptions IPCNotificationOptions;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    IPCNotification() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT IPCNotification(
            const nsString& _id,
            const IPCNotificationOptions& _options) :
        id_(_id),
        options_(_options)
    {
    }

    MOZ_IMPLICIT IPCNotification(
            nsString&& _id,
            IPCNotificationOptions&& _options) :
        id_(std::move(_id)),
        options_(std::move(_options))
    {
    }

    nsString&
    id()
    {
        return id_;
    }
    const nsString&
    id() const
    {
        return id_;
    }

    IPCNotificationOptions&
    options()
    {
        return options_;
    }
    const IPCNotificationOptions&
    options() const
    {
        return options_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsString> id_;
    ::mozilla::ipc::IPDLStructMember<IPCNotificationOptions> options_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::IPCNotification>
{
    typedef ::mozilla::dom::IPCNotification paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union IPCNotificationsOrError|
//
namespace mozilla {
namespace dom {
class IPCNotificationsOrError final
{
public:
    enum Type {
        T__None,
        TArrayOfIPCNotification = 1,
        Tnsresult,
        T__Last = Tnsresult
    };

private:
    typedef ::mozilla::dom::IPCNotification IPCNotification;
    typedef ::nsresult nsresult;
    typedef nsTArray<IPCNotification> ArrayOfIPCNotification__tdef;
    typedef nsresult nsresult__tdef;

    nsTArray<IPCNotification>*
    ptr_ArrayOfIPCNotification()
    {
        return (&(mVArrayOfIPCNotification));
    }
    const nsTArray<IPCNotification>*
    constptr_ArrayOfIPCNotification() const
    {
        return (&(mVArrayOfIPCNotification));
    }
    nsresult*
    ptr_nsresult()
    {
        return (&(mVnsresult));
    }
    const nsresult*
    constptr_nsresult() const
    {
        return (&(mVnsresult));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT IPCNotificationsOrError() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT IPCNotificationsOrError(const nsTArray<IPCNotification>& aOther);

    MOZ_IMPLICIT IPCNotificationsOrError(nsTArray<IPCNotification>&& aOther);

    MOZ_IMPLICIT IPCNotificationsOrError(const nsresult& aOther);

    MOZ_IMPLICIT IPCNotificationsOrError(nsresult&& aOther);

    MOZ_IMPLICIT IPCNotificationsOrError(const IPCNotificationsOrError& aOther);

    MOZ_IMPLICIT IPCNotificationsOrError(IPCNotificationsOrError&& aOther);

    ~IPCNotificationsOrError();

    Type
    type() const
    {
        return mType;
    }

    IPCNotificationsOrError&
    operator=(const nsTArray<IPCNotification>& aRhs);

    IPCNotificationsOrError&
    operator=(nsTArray<IPCNotification>&& aRhs);

    IPCNotificationsOrError&
    operator=(const nsresult& aRhs);

    IPCNotificationsOrError&
    operator=(nsresult&& aRhs);

    IPCNotificationsOrError&
    operator=(const IPCNotificationsOrError& aRhs);

    IPCNotificationsOrError&
    operator=(IPCNotificationsOrError&& aRhs);

    nsTArray<IPCNotification>&
    get_ArrayOfIPCNotification()
    {
        AssertSanity(TArrayOfIPCNotification);
        return (*(ptr_ArrayOfIPCNotification()));
    }
    const nsTArray<IPCNotification>&
    get_ArrayOfIPCNotification() const
    {
        AssertSanity(TArrayOfIPCNotification);
        return (*(constptr_ArrayOfIPCNotification()));
    }
    operator nsTArray<IPCNotification>&()
    {
        return get_ArrayOfIPCNotification();
    }
    operator const nsTArray<IPCNotification>&() const
    {
        return get_ArrayOfIPCNotification();
    }

    nsresult&
    get_nsresult()
    {
        AssertSanity(Tnsresult);
        return (*(ptr_nsresult()));
    }
    const nsresult&
    get_nsresult() const
    {
        AssertSanity(Tnsresult);
        return (*(constptr_nsresult()));
    }
    operator nsresult&()
    {
        return get_nsresult();
    }
    operator const nsresult&() const
    {
        return get_nsresult();
    }

private:
    union {
        nsTArray<IPCNotification> mVArrayOfIPCNotification;
        nsresult mVnsresult;
    };
    Type mType;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::IPCNotificationsOrError>
{
    typedef ::mozilla::dom::IPCNotificationsOrError paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC

#endif // ifndef DOMTypes_h
