//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/net/PDataChannelChild.h"
#include "mozilla/ProfilerLabels.h"

#include "mozilla/net/PNeckoChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace net {


MOZ_IMPLICIT PDataChannelChild::PDataChannelChild() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PDataChannelChild);
}

PDataChannelChild::~PDataChannelChild()
{
    MOZ_COUNT_DTOR(PDataChannelChild);
}

auto PDataChannelChild::ActorAlloc() -> void
{
    AddRef();
}

auto PDataChannelChild::ActorDealloc() -> void
{
    Release();
}

auto PDataChannelChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PDataChannelChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PDataChannelChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PDataChannelChild::Manager() const -> PNeckoChild*
{
    return static_cast<PNeckoChild*>(IProtocol::Manager());
}

auto PDataChannelChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PDataChannelChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PDataChannelChild::Send__delete__(PDataChannelChild* actor) -> bool
{
    if (!actor || !actor->CanSend()) {
        NS_WARNING("Attempt to __delete__ missing or closed actor");
        return false;
    }
    UniquePtr<IPC::Message> msg__ = PDataChannel::Msg___delete__((actor)->Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            actor};


    if (mozilla::ipc::LoggingEnabledFor("PDataChannel", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PDataChannelChild",
            actor->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PDataChannel::Msg___delete__", OTHER);

    bool sendok__ = (actor)->ChannelSend(std::move(msg__));

    actor->ActorDisconnected(Deletion);
    return sendok__;
}

auto PDataChannelChild::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PDataChannelChild::OnMessageReceived(const Message& msg__) -> PDataChannelChild::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PDataChannel::Reply___delete____ID:
        {
            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PDataChannelChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PDataChannelChild::Result
{
    return MsgNotKnown;
}



} // namespace net
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::net::PDataChannelChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PDataChannel'
    (aWriter)->WriteSentinel(469763204);
}

auto ParamTraits<::mozilla::net::PDataChannelChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PDataChannel actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PDataChannel'
    if ((!((aReader)->ReadSentinel(469763204)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PDataChannel actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PDataChannelMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PDataChannel)");

        return {};
    }
    return static_cast<::mozilla::net::PDataChannelChild*>(actor);
}

} // namespace IPC
