/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO)

#include "JSVideoColorSpaceInit.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMGlobalObject.h"
#include "JSVideoColorPrimaries.h"
#include "JSVideoMatrixCoefficients.h"
#include "JSVideoTransferCharacteristics.h"
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/ObjectConstructor.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(VIDEO)

template<> ConversionResult<IDLDictionary<VideoColorSpaceInit>> convertDictionary<VideoColorSpaceInit>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    VideoColorSpaceInit result;
    JSValue fullRangeValue;
    if (isNullOrUndefined)
        fullRangeValue = jsUndefined();
    else {
        fullRangeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "fullRange"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto fullRangeConversionResult = convertOptionalWithDefault<IDLNullable<IDLBoolean>>(lexicalGlobalObject, fullRangeValue, [&]() -> ConversionResult<IDLNullable<IDLBoolean>> { return typename Converter<IDLNullable<IDLBoolean>>::ReturnType { std::nullopt }; });
    if (UNLIKELY(fullRangeConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.fullRange = fullRangeConversionResult.releaseReturnValue();
    JSValue matrixValue;
    if (isNullOrUndefined)
        matrixValue = jsUndefined();
    else {
        matrixValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "matrix"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto matrixConversionResult = convertOptionalWithDefault<IDLNullable<IDLEnumeration<VideoMatrixCoefficients>>>(lexicalGlobalObject, matrixValue, [&]() -> ConversionResult<IDLNullable<IDLEnumeration<VideoMatrixCoefficients>>> { return typename Converter<IDLNullable<IDLEnumeration<VideoMatrixCoefficients>>>::ReturnType { std::nullopt }; });
    if (UNLIKELY(matrixConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.matrix = matrixConversionResult.releaseReturnValue();
    JSValue primariesValue;
    if (isNullOrUndefined)
        primariesValue = jsUndefined();
    else {
        primariesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "primaries"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto primariesConversionResult = convertOptionalWithDefault<IDLNullable<IDLEnumeration<VideoColorPrimaries>>>(lexicalGlobalObject, primariesValue, [&]() -> ConversionResult<IDLNullable<IDLEnumeration<VideoColorPrimaries>>> { return typename Converter<IDLNullable<IDLEnumeration<VideoColorPrimaries>>>::ReturnType { std::nullopt }; });
    if (UNLIKELY(primariesConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.primaries = primariesConversionResult.releaseReturnValue();
    JSValue transferValue;
    if (isNullOrUndefined)
        transferValue = jsUndefined();
    else {
        transferValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "transfer"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto transferConversionResult = convertOptionalWithDefault<IDLNullable<IDLEnumeration<VideoTransferCharacteristics>>>(lexicalGlobalObject, transferValue, [&]() -> ConversionResult<IDLNullable<IDLEnumeration<VideoTransferCharacteristics>>> { return typename Converter<IDLNullable<IDLEnumeration<VideoTransferCharacteristics>>>::ReturnType { std::nullopt }; });
    if (UNLIKELY(transferConversionResult.hasException(throwScope)))
        return ConversionResultException { };
    result.transfer = transferConversionResult.releaseReturnValue();
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const VideoColorSpaceInit& dictionary)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    auto fullRangeValue = toJS<IDLNullable<IDLBoolean>>(lexicalGlobalObject, throwScope, dictionary.fullRange);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "fullRange"_s), fullRangeValue);
    auto matrixValue = toJS<IDLNullable<IDLEnumeration<VideoMatrixCoefficients>>>(lexicalGlobalObject, throwScope, dictionary.matrix);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "matrix"_s), matrixValue);
    auto primariesValue = toJS<IDLNullable<IDLEnumeration<VideoColorPrimaries>>>(lexicalGlobalObject, throwScope, dictionary.primaries);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "primaries"_s), primariesValue);
    auto transferValue = toJS<IDLNullable<IDLEnumeration<VideoTransferCharacteristics>>>(lexicalGlobalObject, throwScope, dictionary.transfer);
    RETURN_IF_EXCEPTION(throwScope, { });
    result->putDirect(vm, JSC::Identifier::fromString(vm, "transfer"_s), transferValue);
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(VIDEO)
