/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSubscriptionObserver.h"

#include "JSDOMConvertCallbacks.h"
#include "JSDOMGlobalObject.h"
#include "JSSubscriptionObserverCallback.h"
#include "JSVoidCallback.h"
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<SubscriptionObserver>> convertDictionary<SubscriptionObserver>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    SubscriptionObserver result;
    JSValue completeValue;
    if (isNullOrUndefined)
        completeValue = jsUndefined();
    else {
        completeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "complete"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!completeValue.isUndefined()) {
        auto completeConversionResult = convert<IDLCallbackFunction<JSVoidCallback>>(lexicalGlobalObject, completeValue, *jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject));
        if (UNLIKELY(completeConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.complete = completeConversionResult.releaseReturnValue();
    }
    JSValue errorValue;
    if (isNullOrUndefined)
        errorValue = jsUndefined();
    else {
        errorValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "error"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!errorValue.isUndefined()) {
        auto errorConversionResult = convert<IDLCallbackFunction<JSSubscriptionObserverCallback>>(lexicalGlobalObject, errorValue, *jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject));
        if (UNLIKELY(errorConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.error = errorConversionResult.releaseReturnValue();
    }
    JSValue nextValue;
    if (isNullOrUndefined)
        nextValue = jsUndefined();
    else {
        nextValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "next"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!nextValue.isUndefined()) {
        auto nextConversionResult = convert<IDLCallbackFunction<JSSubscriptionObserverCallback>>(lexicalGlobalObject, nextValue, *jsCast<JSDOMGlobalObject*>(&lexicalGlobalObject));
        if (UNLIKELY(nextConversionResult.hasException(throwScope)))
            return ConversionResultException { };
        result.next = nextConversionResult.releaseReturnValue();
    }
    return result;
}

} // namespace WebCore
