/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLDebugRendererInfo.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMBinding.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

class JSWebGLDebugRendererInfoPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGLDebugRendererInfoPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLDebugRendererInfoPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLDebugRendererInfoPrototype>(vm)) JSWebGLDebugRendererInfoPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLDebugRendererInfoPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLDebugRendererInfoPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLDebugRendererInfoPrototype, JSWebGLDebugRendererInfoPrototype::Base);

/* Hash table for prototype */

static const HashTableValue JSWebGLDebugRendererInfoPrototypeTableValues[] =
{
    { "UNMASKED_VENDOR_WEBGL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x9245 } },
    { "UNMASKED_RENDERER_WEBGL"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x9246 } },
};

const ClassInfo JSWebGLDebugRendererInfoPrototype::s_info = { "WebGLDebugRendererInfo"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLDebugRendererInfoPrototype) };

void JSWebGLDebugRendererInfoPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLDebugRendererInfo::info(), JSWebGLDebugRendererInfoPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWebGLDebugRendererInfo::s_info = { "WebGLDebugRendererInfo"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLDebugRendererInfo) };

JSWebGLDebugRendererInfo::JSWebGLDebugRendererInfo(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLDebugRendererInfo>&& impl)
    : JSDOMWrapper<WebGLDebugRendererInfo>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, WebGLDebugRendererInfo>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSWebGLDebugRendererInfo::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWebGLDebugRendererInfoPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSWebGLDebugRendererInfoPrototype::create(vm, &globalObject, structure);
}

JSObject* JSWebGLDebugRendererInfo::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGLDebugRendererInfo>(vm, globalObject);
}

void JSWebGLDebugRendererInfo::destroy(JSC::JSCell* cell)
{
    JSWebGLDebugRendererInfo* thisObject = static_cast<JSWebGLDebugRendererInfo*>(cell);
    thisObject->JSWebGLDebugRendererInfo::~JSWebGLDebugRendererInfo();
}

JSC::GCClient::IsoSubspace* JSWebGLDebugRendererInfo::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWebGLDebugRendererInfo, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWebGLDebugRendererInfo.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWebGLDebugRendererInfo = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWebGLDebugRendererInfo.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWebGLDebugRendererInfo = std::forward<decltype(space)>(space); }
    );
}

void JSWebGLDebugRendererInfo::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGLDebugRendererInfo*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebGLDebugRendererInfoOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsWebGLDebugRendererInfo = jsCast<JSWebGLDebugRendererInfo*>(handle.slot()->asCell());
    WebGLRenderingContextBase* owner = WTF::getPtr(jsWebGLDebugRendererInfo->wrapped().context());
    if (UNLIKELY(reason))
        *reason = "Reachable from WebGLDebugRendererInfo";
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSWebGLDebugRendererInfoOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLDebugRendererInfo = static_cast<JSWebGLDebugRendererInfo*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsWebGLDebugRendererInfo->wrapped(), jsWebGLDebugRendererInfo);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLDebugRendererInfo@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore22WebGLDebugRendererInfoE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGLDebugRendererInfo>&& impl)
{

    if constexpr (std::is_polymorphic_v<WebGLDebugRendererInfo>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7WebGLDebugRendererInfo@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore22WebGLDebugRendererInfoE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // WebGLDebugRendererInfo has subclasses. If WebGLDebugRendererInfo has subclasses that get passed
        // to toJS() we currently require WebGLDebugRendererInfo you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<WebGLDebugRendererInfo>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGLDebugRendererInfo& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebGLDebugRendererInfo* JSWebGLDebugRendererInfo::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLDebugRendererInfo*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
