/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSSVGAnimatedBoolean.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsSVGAnimatedBooleanConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGAnimatedBoolean_baseVal);
static JSC_DECLARE_CUSTOM_SETTER(setJSSVGAnimatedBoolean_baseVal);
static JSC_DECLARE_CUSTOM_GETTER(jsSVGAnimatedBoolean_animVal);

class JSSVGAnimatedBooleanPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSSVGAnimatedBooleanPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSSVGAnimatedBooleanPrototype* ptr = new (NotNull, JSC::allocateCell<JSSVGAnimatedBooleanPrototype>(vm)) JSSVGAnimatedBooleanPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGAnimatedBooleanPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSSVGAnimatedBooleanPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSSVGAnimatedBooleanPrototype, JSSVGAnimatedBooleanPrototype::Base);

using JSSVGAnimatedBooleanDOMConstructor = JSDOMConstructorNotConstructable<JSSVGAnimatedBoolean>;

template<> const ClassInfo JSSVGAnimatedBooleanDOMConstructor::s_info = { "SVGAnimatedBoolean"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGAnimatedBooleanDOMConstructor) };

template<> JSValue JSSVGAnimatedBooleanDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSSVGAnimatedBooleanDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "SVGAnimatedBoolean"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSSVGAnimatedBoolean::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSSVGAnimatedBooleanPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGAnimatedBooleanConstructor, 0 } },
    { "baseVal"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGAnimatedBoolean_baseVal, setJSSVGAnimatedBoolean_baseVal } },
    { "animVal"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsSVGAnimatedBoolean_animVal, 0 } },
};

const ClassInfo JSSVGAnimatedBooleanPrototype::s_info = { "SVGAnimatedBoolean"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGAnimatedBooleanPrototype) };

void JSSVGAnimatedBooleanPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSSVGAnimatedBoolean::info(), JSSVGAnimatedBooleanPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSSVGAnimatedBoolean::s_info = { "SVGAnimatedBoolean"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSSVGAnimatedBoolean) };

JSSVGAnimatedBoolean::JSSVGAnimatedBoolean(Structure* structure, JSDOMGlobalObject& globalObject, Ref<SVGAnimatedBoolean>&& impl)
    : JSDOMWrapper<SVGAnimatedBoolean>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, SVGAnimatedBoolean>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSSVGAnimatedBoolean::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSSVGAnimatedBooleanPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSSVGAnimatedBooleanPrototype::create(vm, &globalObject, structure);
}

JSObject* JSSVGAnimatedBoolean::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSSVGAnimatedBoolean>(vm, globalObject);
}

JSValue JSSVGAnimatedBoolean::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGAnimatedBooleanDOMConstructor, DOMConstructorID::SVGAnimatedBoolean>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSSVGAnimatedBoolean::destroy(JSC::JSCell* cell)
{
    JSSVGAnimatedBoolean* thisObject = static_cast<JSSVGAnimatedBoolean*>(cell);
    thisObject->JSSVGAnimatedBoolean::~JSSVGAnimatedBoolean();
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGAnimatedBooleanConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSSVGAnimatedBooleanPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSSVGAnimatedBoolean::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsSVGAnimatedBoolean_baseValGetter(JSGlobalObject& lexicalGlobalObject, JSSVGAnimatedBoolean& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.baseVal())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGAnimatedBoolean_baseVal, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGAnimatedBoolean>::get<jsSVGAnimatedBoolean_baseValGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSSVGAnimatedBoolean_baseValSetter(JSGlobalObject& lexicalGlobalObject, JSSVGAnimatedBoolean& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setBaseVal(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSSVGAnimatedBoolean_baseVal, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGAnimatedBoolean>::set<setJSSVGAnimatedBoolean_baseValSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsSVGAnimatedBoolean_animValGetter(JSGlobalObject& lexicalGlobalObject, JSSVGAnimatedBoolean& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.animVal())));
}

JSC_DEFINE_CUSTOM_GETTER(jsSVGAnimatedBoolean_animVal, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSSVGAnimatedBoolean>::get<jsSVGAnimatedBoolean_animValGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSSVGAnimatedBoolean::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSSVGAnimatedBoolean, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForSVGAnimatedBoolean.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForSVGAnimatedBoolean = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForSVGAnimatedBoolean.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForSVGAnimatedBoolean = std::forward<decltype(space)>(space); }
    );
}

void JSSVGAnimatedBoolean::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSSVGAnimatedBoolean*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSSVGAnimatedBooleanOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSSVGAnimatedBooleanOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsSVGAnimatedBoolean = static_cast<JSSVGAnimatedBoolean*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsSVGAnimatedBoolean->wrapped(), jsSVGAnimatedBoolean);
}

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<SVGAnimatedBoolean>&& impl)
{
    return createWrapper<SVGAnimatedBoolean>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, SVGAnimatedBoolean& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

SVGAnimatedBoolean* JSSVGAnimatedBoolean::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSSVGAnimatedBoolean*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
