/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSPeriodicWaveOptions.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>


namespace WebCore {
using namespace JSC;

#if ENABLE(WEB_AUDIO)

template<> PeriodicWaveOptions convertDictionary<PeriodicWaveOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    PeriodicWaveOptions result;
    JSValue disableNormalizationValue;
    if (isNullOrUndefined)
        disableNormalizationValue = jsUndefined();
    else {
        disableNormalizationValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "disableNormalization"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!disableNormalizationValue.isUndefined()) {
        result.disableNormalization = convert<IDLBoolean>(lexicalGlobalObject, disableNormalizationValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.disableNormalization = false;
    JSValue imagValue;
    if (isNullOrUndefined)
        imagValue = jsUndefined();
    else {
        imagValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "imag"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!imagValue.isUndefined()) {
        result.imag = convert<IDLSequence<IDLFloat>>(lexicalGlobalObject, imagValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue realValue;
    if (isNullOrUndefined)
        realValue = jsUndefined();
    else {
        realValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "real"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!realValue.isUndefined()) {
        result.real = convert<IDLSequence<IDLFloat>>(lexicalGlobalObject, realValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    return result;
}

#endif

} // namespace WebCore

#endif // ENABLE(WEB_AUDIO)
