/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSNode.h"

#include "ActiveDOMObject.h"
#include "CustomElementReactionQueue.h"
#include "DOMJITIDLTypeFilter.h"
#include "ElementInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "JSDocument.h"
#include "JSElement.h"
#include "JSNode.h"
#include "JSNodeList.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

template<> Node::GetRootNodeOptions convertDictionary<Node::GetRootNodeOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    Node::GetRootNodeOptions result;
    JSValue composedValue;
    if (isNullOrUndefined)
        composedValue = jsUndefined();
    else {
        composedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composed"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!composedValue.isUndefined()) {
        result.composed = convert<IDLBoolean>(lexicalGlobalObject, composedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.composed = false;
    return result;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsNodePrototypeFunction_getRootNode);
static JSC_DECLARE_HOST_FUNCTION(jsNodePrototypeFunction_hasChildNodes);
static JSC_DECLARE_HOST_FUNCTION(jsNodePrototypeFunction_normalize);
static JSC_DECLARE_HOST_FUNCTION(jsNodePrototypeFunction_cloneNode);
static JSC_DECLARE_HOST_FUNCTION(jsNodePrototypeFunction_isEqualNode);
static JSC_DECLARE_HOST_FUNCTION(jsNodePrototypeFunction_isSameNode);
static JSC_DECLARE_HOST_FUNCTION(jsNodePrototypeFunction_compareDocumentPosition);
static JSC_DECLARE_HOST_FUNCTION(jsNodePrototypeFunction_contains);
static JSC_DECLARE_HOST_FUNCTION(jsNodePrototypeFunction_lookupPrefix);
static JSC_DECLARE_HOST_FUNCTION(jsNodePrototypeFunction_lookupNamespaceURI);
static JSC_DECLARE_HOST_FUNCTION(jsNodePrototypeFunction_isDefaultNamespace);
static JSC_DECLARE_HOST_FUNCTION(jsNodePrototypeFunction_insertBefore);
static JSC_DECLARE_HOST_FUNCTION(jsNodePrototypeFunction_appendChild);
static JSC_DECLARE_HOST_FUNCTION(jsNodePrototypeFunction_replaceChild);
static JSC_DECLARE_HOST_FUNCTION(jsNodePrototypeFunction_removeChild);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsNodeConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsNode_nodeType);
static JSC_DECLARE_CUSTOM_GETTER(jsNode_nodeName);
static JSC_DECLARE_CUSTOM_GETTER(jsNode_baseURI);
static JSC_DECLARE_CUSTOM_GETTER(jsNode_isConnected);
static JSC_DECLARE_CUSTOM_GETTER(jsNode_ownerDocument);
static JSC_DECLARE_CUSTOM_GETTER(jsNode_parentNode);
static JSC_DECLARE_CUSTOM_GETTER(jsNode_parentElement);
static JSC_DECLARE_CUSTOM_GETTER(jsNode_childNodes);
static JSC_DECLARE_CUSTOM_GETTER(jsNode_firstChild);
static JSC_DECLARE_CUSTOM_GETTER(jsNode_lastChild);
static JSC_DECLARE_CUSTOM_GETTER(jsNode_previousSibling);
static JSC_DECLARE_CUSTOM_GETTER(jsNode_nextSibling);
static JSC_DECLARE_CUSTOM_GETTER(jsNode_nodeValue);
static JSC_DECLARE_CUSTOM_SETTER(setJSNode_nodeValue);
static JSC_DECLARE_CUSTOM_GETTER(jsNode_textContent);
static JSC_DECLARE_CUSTOM_SETTER(setJSNode_textContent);

static const JSC::DOMJIT::GetterSetter DOMJITAttributeForNodeNodeType {
    jsNode_nodeType,
#if ENABLE(JIT)
    &compileNodeNodeTypeAttribute,
#else
    nullptr,
#endif
    DOMJIT::IDLResultTypeFilter<IDLUnsignedShort>::value
};

static const JSC::DOMJIT::GetterSetter DOMJITAttributeForNodeOwnerDocument {
    jsNode_ownerDocument,
#if ENABLE(JIT)
    &compileNodeOwnerDocumentAttribute,
#else
    nullptr,
#endif
    DOMJIT::IDLResultTypeFilter<IDLNullable<IDLInterface<Document>>>::value
};

static const JSC::DOMJIT::GetterSetter DOMJITAttributeForNodeParentNode {
    jsNode_parentNode,
#if ENABLE(JIT)
    &compileNodeParentNodeAttribute,
#else
    nullptr,
#endif
    DOMJIT::IDLResultTypeFilter<IDLNullable<IDLInterface<Node>>>::value
};

static const JSC::DOMJIT::GetterSetter DOMJITAttributeForNodeFirstChild {
    jsNode_firstChild,
#if ENABLE(JIT)
    &compileNodeFirstChildAttribute,
#else
    nullptr,
#endif
    DOMJIT::IDLResultTypeFilter<IDLNullable<IDLInterface<Node>>>::value
};

static const JSC::DOMJIT::GetterSetter DOMJITAttributeForNodeLastChild {
    jsNode_lastChild,
#if ENABLE(JIT)
    &compileNodeLastChildAttribute,
#else
    nullptr,
#endif
    DOMJIT::IDLResultTypeFilter<IDLNullable<IDLInterface<Node>>>::value
};

static const JSC::DOMJIT::GetterSetter DOMJITAttributeForNodePreviousSibling {
    jsNode_previousSibling,
#if ENABLE(JIT)
    &compileNodePreviousSiblingAttribute,
#else
    nullptr,
#endif
    DOMJIT::IDLResultTypeFilter<IDLNullable<IDLInterface<Node>>>::value
};

static const JSC::DOMJIT::GetterSetter DOMJITAttributeForNodeNextSibling {
    jsNode_nextSibling,
#if ENABLE(JIT)
    &compileNodeNextSiblingAttribute,
#else
    nullptr,
#endif
    DOMJIT::IDLResultTypeFilter<IDLNullable<IDLInterface<Node>>>::value
};

class JSNodePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSNodePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSNodePrototype* ptr = new (NotNull, JSC::allocateCell<JSNodePrototype>(vm)) JSNodePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSNodePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSNodePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSNodePrototype, JSNodePrototype::Base);

using JSNodeDOMConstructor = JSDOMConstructorNotConstructable<JSNode>;

/* Hash table for constructor */

static const HashTableValue JSNodeConstructorTableValues[] =
{
    { "ELEMENT_NODE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
    { "ATTRIBUTE_NODE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 2 } },
    { "TEXT_NODE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 3 } },
    { "CDATA_SECTION_NODE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 4 } },
    { "ENTITY_REFERENCE_NODE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 5 } },
    { "ENTITY_NODE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 6 } },
    { "PROCESSING_INSTRUCTION_NODE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 7 } },
    { "COMMENT_NODE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 8 } },
    { "DOCUMENT_NODE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 9 } },
    { "DOCUMENT_TYPE_NODE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 10 } },
    { "DOCUMENT_FRAGMENT_NODE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 11 } },
    { "NOTATION_NODE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 12 } },
    { "DOCUMENT_POSITION_DISCONNECTED"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x01 } },
    { "DOCUMENT_POSITION_PRECEDING"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x02 } },
    { "DOCUMENT_POSITION_FOLLOWING"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x04 } },
    { "DOCUMENT_POSITION_CONTAINS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x08 } },
    { "DOCUMENT_POSITION_CONTAINED_BY"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x10 } },
    { "DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x20 } },
};

static_assert(Node::ELEMENT_NODE == 1, "ELEMENT_NODE in Node does not match value from IDL");
static_assert(Node::ATTRIBUTE_NODE == 2, "ATTRIBUTE_NODE in Node does not match value from IDL");
static_assert(Node::TEXT_NODE == 3, "TEXT_NODE in Node does not match value from IDL");
static_assert(Node::CDATA_SECTION_NODE == 4, "CDATA_SECTION_NODE in Node does not match value from IDL");
static_assert(Node::ENTITY_REFERENCE_NODE == 5, "ENTITY_REFERENCE_NODE in Node does not match value from IDL");
static_assert(Node::ENTITY_NODE == 6, "ENTITY_NODE in Node does not match value from IDL");
static_assert(Node::PROCESSING_INSTRUCTION_NODE == 7, "PROCESSING_INSTRUCTION_NODE in Node does not match value from IDL");
static_assert(Node::COMMENT_NODE == 8, "COMMENT_NODE in Node does not match value from IDL");
static_assert(Node::DOCUMENT_NODE == 9, "DOCUMENT_NODE in Node does not match value from IDL");
static_assert(Node::DOCUMENT_TYPE_NODE == 10, "DOCUMENT_TYPE_NODE in Node does not match value from IDL");
static_assert(Node::DOCUMENT_FRAGMENT_NODE == 11, "DOCUMENT_FRAGMENT_NODE in Node does not match value from IDL");
static_assert(Node::NOTATION_NODE == 12, "NOTATION_NODE in Node does not match value from IDL");
static_assert(Node::DOCUMENT_POSITION_DISCONNECTED == 0x01, "DOCUMENT_POSITION_DISCONNECTED in Node does not match value from IDL");
static_assert(Node::DOCUMENT_POSITION_PRECEDING == 0x02, "DOCUMENT_POSITION_PRECEDING in Node does not match value from IDL");
static_assert(Node::DOCUMENT_POSITION_FOLLOWING == 0x04, "DOCUMENT_POSITION_FOLLOWING in Node does not match value from IDL");
static_assert(Node::DOCUMENT_POSITION_CONTAINS == 0x08, "DOCUMENT_POSITION_CONTAINS in Node does not match value from IDL");
static_assert(Node::DOCUMENT_POSITION_CONTAINED_BY == 0x10, "DOCUMENT_POSITION_CONTAINED_BY in Node does not match value from IDL");
static_assert(Node::DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC == 0x20, "DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC in Node does not match value from IDL");

template<> const ClassInfo JSNodeDOMConstructor::s_info = { "Node"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSNodeDOMConstructor) };

template<> JSValue JSNodeDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSNodeDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "Node"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSNode::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
    reifyStaticProperties(vm, JSNode::info(), JSNodeConstructorTableValues, *this);
}

/* Hash table for prototype */

static const HashTableValue JSNodePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsNodeConstructor, 0 } },
    { "nodeType"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMJITAttribute, NoIntrinsic, { HashTableValue::DOMJITAttributeType, &DOMJITAttributeForNodeNodeType, 0 } },
    { "nodeName"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNode_nodeName, 0 } },
    { "baseURI"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNode_baseURI, 0 } },
    { "isConnected"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNode_isConnected, 0 } },
    { "ownerDocument"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMJITAttribute, NoIntrinsic, { HashTableValue::DOMJITAttributeType, &DOMJITAttributeForNodeOwnerDocument, 0 } },
    { "parentNode"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMJITAttribute, NoIntrinsic, { HashTableValue::DOMJITAttributeType, &DOMJITAttributeForNodeParentNode, 0 } },
    { "parentElement"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNode_parentElement, 0 } },
    { "childNodes"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNode_childNodes, 0 } },
    { "firstChild"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMJITAttribute, NoIntrinsic, { HashTableValue::DOMJITAttributeType, &DOMJITAttributeForNodeFirstChild, 0 } },
    { "lastChild"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMJITAttribute, NoIntrinsic, { HashTableValue::DOMJITAttributeType, &DOMJITAttributeForNodeLastChild, 0 } },
    { "previousSibling"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMJITAttribute, NoIntrinsic, { HashTableValue::DOMJITAttributeType, &DOMJITAttributeForNodePreviousSibling, 0 } },
    { "nextSibling"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMJITAttribute, NoIntrinsic, { HashTableValue::DOMJITAttributeType, &DOMJITAttributeForNodeNextSibling, 0 } },
    { "nodeValue"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNode_nodeValue, setJSNode_nodeValue } },
    { "textContent"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNode_textContent, setJSNode_textContent } },
    { "getRootNode"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsNodePrototypeFunction_getRootNode, 0 } },
    { "hasChildNodes"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsNodePrototypeFunction_hasChildNodes, 0 } },
    { "normalize"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsNodePrototypeFunction_normalize, 0 } },
    { "cloneNode"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsNodePrototypeFunction_cloneNode, 0 } },
    { "isEqualNode"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsNodePrototypeFunction_isEqualNode, 1 } },
    { "isSameNode"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsNodePrototypeFunction_isSameNode, 1 } },
    { "compareDocumentPosition"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsNodePrototypeFunction_compareDocumentPosition, 1 } },
    { "contains"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsNodePrototypeFunction_contains, 1 } },
    { "lookupPrefix"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsNodePrototypeFunction_lookupPrefix, 1 } },
    { "lookupNamespaceURI"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsNodePrototypeFunction_lookupNamespaceURI, 1 } },
    { "isDefaultNamespace"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsNodePrototypeFunction_isDefaultNamespace, 1 } },
    { "insertBefore"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsNodePrototypeFunction_insertBefore, 2 } },
    { "appendChild"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsNodePrototypeFunction_appendChild, 1 } },
    { "replaceChild"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsNodePrototypeFunction_replaceChild, 2 } },
    { "removeChild"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsNodePrototypeFunction_removeChild, 1 } },
    { "ELEMENT_NODE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 1 } },
    { "ATTRIBUTE_NODE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 2 } },
    { "TEXT_NODE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 3 } },
    { "CDATA_SECTION_NODE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 4 } },
    { "ENTITY_REFERENCE_NODE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 5 } },
    { "ENTITY_NODE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 6 } },
    { "PROCESSING_INSTRUCTION_NODE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 7 } },
    { "COMMENT_NODE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 8 } },
    { "DOCUMENT_NODE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 9 } },
    { "DOCUMENT_TYPE_NODE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 10 } },
    { "DOCUMENT_FRAGMENT_NODE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 11 } },
    { "NOTATION_NODE"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 12 } },
    { "DOCUMENT_POSITION_DISCONNECTED"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x01 } },
    { "DOCUMENT_POSITION_PRECEDING"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x02 } },
    { "DOCUMENT_POSITION_FOLLOWING"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x04 } },
    { "DOCUMENT_POSITION_CONTAINS"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x08 } },
    { "DOCUMENT_POSITION_CONTAINED_BY"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x10 } },
    { "DOCUMENT_POSITION_IMPLEMENTATION_SPECIFIC"_s, PropertyAttribute::ReadOnly | PropertyAttribute::DontDelete | PropertyAttribute::ConstantInteger, NoIntrinsic, { HashTableValue::ConstantType, 0x20 } },
};

const ClassInfo JSNodePrototype::s_info = { "Node"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSNodePrototype) };

void JSNodePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSNode::info(), JSNodePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSNode::s_info = { "Node"_s, &Base::s_info, nullptr
#if ENABLE(JIT)
, &checkSubClassSnippetForJSNode
#else
, nullptr
#endif
, CREATE_METHOD_TABLE(JSNode) };

JSNode::JSNode(Structure* structure, JSDOMGlobalObject& globalObject, Ref<Node>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

JSObject* JSNode::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSNodePrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSNodePrototype::create(vm, &globalObject, structure);
}

JSObject* JSNode::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSNode>(vm, globalObject);
}

JSValue JSNode::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSNodeDOMConstructor, DOMConstructorID::Node>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsNodeConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSNodePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSNode::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsNode_nodeTypeGetter(JSGlobalObject& lexicalGlobalObject, JSNode& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return thisObject.nodeType(lexicalGlobalObject);
}

JSC_DEFINE_CUSTOM_GETTER(jsNode_nodeType, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNode>::get<jsNode_nodeTypeGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNode_nodeNameGetter(JSGlobalObject& lexicalGlobalObject, JSNode& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.nodeName())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNode_nodeName, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNode>::get<jsNode_nodeNameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNode_baseURIGetter(JSGlobalObject& lexicalGlobalObject, JSNode& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.baseURI())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNode_baseURI, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNode>::get<jsNode_baseURIGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNode_isConnectedGetter(JSGlobalObject& lexicalGlobalObject, JSNode& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.isConnected())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNode_isConnected, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNode>::get<jsNode_isConnectedGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNode_ownerDocumentGetter(JSGlobalObject& lexicalGlobalObject, JSNode& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<Document>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.ownerDocument())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNode_ownerDocument, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNode>::get<jsNode_ownerDocumentGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNode_parentNodeGetter(JSGlobalObject& lexicalGlobalObject, JSNode& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<Node>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.parentNode())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNode_parentNode, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNode>::get<jsNode_parentNodeGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNode_parentElementGetter(JSGlobalObject& lexicalGlobalObject, JSNode& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<Element>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.parentElement())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNode_parentElement, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNode>::get<jsNode_parentElementGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNode_childNodesGetter(JSGlobalObject& lexicalGlobalObject, JSNode& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<NodeList>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.childNodes())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNode_childNodes, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNode>::get<jsNode_childNodesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNode_firstChildGetter(JSGlobalObject& lexicalGlobalObject, JSNode& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<Node>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.firstChild())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNode_firstChild, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNode>::get<jsNode_firstChildGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNode_lastChildGetter(JSGlobalObject& lexicalGlobalObject, JSNode& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<Node>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.lastChild())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNode_lastChild, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNode>::get<jsNode_lastChildGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNode_previousSiblingGetter(JSGlobalObject& lexicalGlobalObject, JSNode& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<Node>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.previousSibling())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNode_previousSibling, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNode>::get<jsNode_previousSiblingGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNode_nextSiblingGetter(JSGlobalObject& lexicalGlobalObject, JSNode& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<Node>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.nextSibling())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNode_nextSibling, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNode>::get<jsNode_nextSiblingGetter>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNode_nodeValueGetter(JSGlobalObject& lexicalGlobalObject, JSNode& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.nodeValue())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNode_nodeValue, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNode>::get<jsNode_nodeValueGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSNode_nodeValueSetter(JSGlobalObject& lexicalGlobalObject, JSNode& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setNodeValue(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSNode_nodeValue, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSNode>::set<setJSNode_nodeValueSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsNode_textContentGetter(JSGlobalObject& lexicalGlobalObject, JSNode& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.textContent())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNode_textContent, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNode>::get<jsNode_textContentGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSNode_textContentSetter(JSGlobalObject& lexicalGlobalObject, JSNode& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionStack customElementReactionStack(lexicalGlobalObject);
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setTextContent(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSNode_textContent, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSNode>::set<setJSNode_textContentSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsNodePrototypeFunction_getRootNodeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSNode>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto options = convert<IDLDictionary<Node::GetRootNodeOptions>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLInterface<Node>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.getRootNode(WTFMove(options)))));
}

JSC_DEFINE_HOST_FUNCTION(jsNodePrototypeFunction_getRootNode, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSNode>::call<jsNodePrototypeFunction_getRootNodeBody>(*lexicalGlobalObject, *callFrame, "getRootNode");
}

static inline JSC::EncodedJSValue jsNodePrototypeFunction_hasChildNodesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSNode>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.hasChildNodes())));
}

JSC_DEFINE_HOST_FUNCTION(jsNodePrototypeFunction_hasChildNodes, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSNode>::call<jsNodePrototypeFunction_hasChildNodesBody>(*lexicalGlobalObject, *callFrame, "hasChildNodes");
}

static inline JSC::EncodedJSValue jsNodePrototypeFunction_normalizeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSNode>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.normalize(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsNodePrototypeFunction_normalize, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSNode>::call<jsNodePrototypeFunction_normalizeBody>(*lexicalGlobalObject, *callFrame, "normalize");
}

static inline JSC::EncodedJSValue jsNodePrototypeFunction_cloneNodeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSNode>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto deep = convert<IDLBoolean>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJSNewlyCreated<IDLInterface<Node>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.cloneNodeForBindings(WTFMove(deep)))));
}

JSC_DEFINE_HOST_FUNCTION(jsNodePrototypeFunction_cloneNode, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSNode>::call<jsNodePrototypeFunction_cloneNodeBody>(*lexicalGlobalObject, *callFrame, "cloneNode");
}

static inline JSC::EncodedJSValue jsNodePrototypeFunction_isEqualNodeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSNode>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto other = convert<IDLNullable<IDLInterface<Node>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "other", "Node", "isEqualNode", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.isEqualNode(WTFMove(other)))));
}

JSC_DEFINE_HOST_FUNCTION(jsNodePrototypeFunction_isEqualNode, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSNode>::call<jsNodePrototypeFunction_isEqualNodeBody>(*lexicalGlobalObject, *callFrame, "isEqualNode");
}

static inline JSC::EncodedJSValue jsNodePrototypeFunction_isSameNodeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSNode>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto other = convert<IDLNullable<IDLInterface<Node>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "other", "Node", "isSameNode", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.isSameNode(WTFMove(other)))));
}

JSC_DEFINE_HOST_FUNCTION(jsNodePrototypeFunction_isSameNode, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSNode>::call<jsNodePrototypeFunction_isSameNodeBody>(*lexicalGlobalObject, *callFrame, "isSameNode");
}

static inline JSC::EncodedJSValue jsNodePrototypeFunction_compareDocumentPositionBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSNode>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto other = convert<IDLInterface<Node>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "other", "Node", "compareDocumentPosition", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUnsignedShort>(*lexicalGlobalObject, throwScope, impl.compareDocumentPosition(*other))));
}

JSC_DEFINE_HOST_FUNCTION(jsNodePrototypeFunction_compareDocumentPosition, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSNode>::call<jsNodePrototypeFunction_compareDocumentPositionBody>(*lexicalGlobalObject, *callFrame, "compareDocumentPosition");
}

static inline JSC::EncodedJSValue jsNodePrototypeFunction_containsBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSNode>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto other = convert<IDLNullable<IDLInterface<Node>>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "other", "Node", "contains", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.contains(WTFMove(other)))));
}

JSC_DEFINE_HOST_FUNCTION(jsNodePrototypeFunction_contains, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSNode>::call<jsNodePrototypeFunction_containsBody>(*lexicalGlobalObject, *callFrame, "contains");
}

static inline JSC::EncodedJSValue jsNodePrototypeFunction_lookupPrefixBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSNode>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto namespaceURI = convert<IDLNullable<IDLAtomStringAdaptor<IDLDOMString>>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, throwScope, impl.lookupPrefix(WTFMove(namespaceURI)))));
}

JSC_DEFINE_HOST_FUNCTION(jsNodePrototypeFunction_lookupPrefix, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSNode>::call<jsNodePrototypeFunction_lookupPrefixBody>(*lexicalGlobalObject, *callFrame, "lookupPrefix");
}

static inline JSC::EncodedJSValue jsNodePrototypeFunction_lookupNamespaceURIBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSNode>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto prefix = convert<IDLNullable<IDLAtomStringAdaptor<IDLDOMString>>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLNullable<IDLDOMString>>(*lexicalGlobalObject, throwScope, impl.lookupNamespaceURI(WTFMove(prefix)))));
}

JSC_DEFINE_HOST_FUNCTION(jsNodePrototypeFunction_lookupNamespaceURI, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSNode>::call<jsNodePrototypeFunction_lookupNamespaceURIBody>(*lexicalGlobalObject, *callFrame, "lookupNamespaceURI");
}

static inline JSC::EncodedJSValue jsNodePrototypeFunction_isDefaultNamespaceBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSNode>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto namespaceURI = convert<IDLNullable<IDLAtomStringAdaptor<IDLDOMString>>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLBoolean>(*lexicalGlobalObject, throwScope, impl.isDefaultNamespace(WTFMove(namespaceURI)))));
}

JSC_DEFINE_HOST_FUNCTION(jsNodePrototypeFunction_isDefaultNamespace, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSNode>::call<jsNodePrototypeFunction_isDefaultNamespaceBody>(*lexicalGlobalObject, *callFrame, "isDefaultNamespace");
}

static inline JSC::EncodedJSValue jsNodePrototypeFunction_insertBeforeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSNode>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto node = convert<IDLInterface<Node>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node", "Node", "insertBefore", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto child = convert<IDLNullable<IDLInterface<Node>>>(*lexicalGlobalObject, argument1.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "child", "Node", "insertBefore", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    invokeFunctorPropagatingExceptionIfNecessary(*lexicalGlobalObject, throwScope, [&] { return impl.insertBefore(*node, WTFMove(child)); });
    return JSValue::encode(argument0.value());
}

JSC_DEFINE_HOST_FUNCTION(jsNodePrototypeFunction_insertBefore, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSNode>::call<jsNodePrototypeFunction_insertBeforeBody>(*lexicalGlobalObject, *callFrame, "insertBefore");
}

static inline JSC::EncodedJSValue jsNodePrototypeFunction_appendChildBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSNode>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto node = convert<IDLInterface<Node>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node", "Node", "appendChild", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    invokeFunctorPropagatingExceptionIfNecessary(*lexicalGlobalObject, throwScope, [&] { return impl.appendChild(*node); });
    return JSValue::encode(argument0.value());
}

JSC_DEFINE_HOST_FUNCTION(jsNodePrototypeFunction_appendChild, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSNode>::call<jsNodePrototypeFunction_appendChildBody>(*lexicalGlobalObject, *callFrame, "appendChild");
}

static inline JSC::EncodedJSValue jsNodePrototypeFunction_replaceChildBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSNode>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 2))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto node = convert<IDLInterface<Node>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "node", "Node", "replaceChild", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->uncheckedArgument(1);
    auto child = convert<IDLInterface<Node>>(*lexicalGlobalObject, argument1.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 1, "child", "Node", "replaceChild", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    invokeFunctorPropagatingExceptionIfNecessary(*lexicalGlobalObject, throwScope, [&] { return impl.replaceChild(*node, *child); });
    return JSValue::encode(argument1.value());
}

JSC_DEFINE_HOST_FUNCTION(jsNodePrototypeFunction_replaceChild, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSNode>::call<jsNodePrototypeFunction_replaceChildBody>(*lexicalGlobalObject, *callFrame, "replaceChild");
}

static inline JSC::EncodedJSValue jsNodePrototypeFunction_removeChildBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSNode>::ClassParameter castedThis)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    CustomElementReactionStack customElementReactionStack(*lexicalGlobalObject);
    auto& impl = castedThis->wrapped();
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto child = convert<IDLInterface<Node>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "child", "Node", "removeChild", "Node"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    invokeFunctorPropagatingExceptionIfNecessary(*lexicalGlobalObject, throwScope, [&] { return impl.removeChild(*child); });
    return JSValue::encode(argument0.value());
}

JSC_DEFINE_HOST_FUNCTION(jsNodePrototypeFunction_removeChild, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSNode>::call<jsNodePrototypeFunction_removeChildBody>(*lexicalGlobalObject, *callFrame, "removeChild");
}

JSC::GCClient::IsoSubspace* JSNode::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSNode, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForNode.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForNode = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForNode.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForNode = std::forward<decltype(space)>(space); }
    );
}

template<typename Visitor>
void JSNode::visitChildrenImpl(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSNode*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitChildren(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

DEFINE_VISIT_CHILDREN(JSNode);

template<typename Visitor>
void JSNode::visitOutputConstraints(JSCell* cell, Visitor& visitor)
{
    auto* thisObject = jsCast<JSNode*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, info());
    Base::visitOutputConstraints(thisObject, visitor);
    thisObject->visitAdditionalChildren(visitor);
}

template void JSNode::visitOutputConstraints(JSCell*, AbstractSlotVisitor&);
template void JSNode::visitOutputConstraints(JSCell*, SlotVisitor&);
void JSNode::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSNode*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

void JSNodeOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsNode = static_cast<JSNode*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsNode->wrapped(), jsNode);
}

Node* JSNode::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSNode*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
