/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLImageElement.h"

#include "ActiveDOMObject.h"
#include "CustomElementReactionQueue.h"
#include "DOMPromiseProxy.h"
#include "DeprecatedGlobalSettings.h"
#include "Document.h"
#include "ElementInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "HTMLNames.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMLegacyFactoryFunction.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsHTMLImageElementPrototypeFunction_decode);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElementConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_alt);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLImageElement_alt);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_src);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLImageElement_src);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_srcset);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLImageElement_srcset);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_sizes);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLImageElement_sizes);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_crossOrigin);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLImageElement_crossOrigin);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_useMap);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLImageElement_useMap);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_isMap);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLImageElement_isMap);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_width);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLImageElement_width);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_height);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLImageElement_height);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_naturalHeight);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_naturalWidth);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_complete);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_currentSrc);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_referrerPolicy);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLImageElement_referrerPolicy);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_decoding);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLImageElement_decoding);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_loading);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLImageElement_loading);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_name);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLImageElement_name);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_lowsrc);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLImageElement_lowsrc);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_align);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLImageElement_align);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_hspace);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLImageElement_hspace);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_vspace);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLImageElement_vspace);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_longDesc);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLImageElement_longDesc);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_border);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLImageElement_border);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_fetchPriority);
static JSC_DECLARE_CUSTOM_SETTER(setJSHTMLImageElement_fetchPriority);
#if ENABLE(ATTACHMENT_ELEMENT)
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_attachmentIdentifier);
#endif
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_x);
static JSC_DECLARE_CUSTOM_GETTER(jsHTMLImageElement_y);

class JSHTMLImageElementPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSHTMLImageElementPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSHTMLImageElementPrototype* ptr = new (NotNull, JSC::allocateCell<JSHTMLImageElementPrototype>(vm)) JSHTMLImageElementPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSHTMLImageElementPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSHTMLImageElementPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSHTMLImageElementPrototype, JSHTMLImageElementPrototype::Base);

using JSHTMLImageElementDOMConstructor = JSDOMConstructorNotConstructable<JSHTMLImageElement>;
using JSHTMLImageElementLegacyFactoryFunction = JSDOMLegacyFactoryFunction<JSHTMLImageElement>;

template<> const ClassInfo JSHTMLImageElementDOMConstructor::s_info = { "HTMLImageElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLImageElementDOMConstructor) };

template<> JSValue JSHTMLImageElementDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSHTMLElement::getConstructor(vm, &globalObject);
}

template<> void JSHTMLImageElementDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "HTMLImageElement"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSHTMLImageElement::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSHTMLImageElementLegacyFactoryFunction::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSHTMLImageElementLegacyFactoryFunction*>(callFrame->jsCallee());
    ASSERT(castedThis);
    auto* context = castedThis->scriptExecutionContext();
    if (UNLIKELY(!context))
        return throwConstructorScriptExecutionContextUnavailableError(*lexicalGlobalObject, throwScope, "HTMLImageElement");
    ASSERT(context->isDocument());
    auto& document = downcast<Document>(*context);
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto width = argument0.value().isUndefined() ? std::optional<Converter<IDLUnsignedLong>::ReturnType>() : std::optional<Converter<IDLUnsignedLong>::ReturnType>(convert<IDLUnsignedLong>(*lexicalGlobalObject, argument0.value()));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto height = argument1.value().isUndefined() ? std::optional<Converter<IDLUnsignedLong>::ReturnType>() : std::optional<Converter<IDLUnsignedLong>::ReturnType>(convert<IDLUnsignedLong>(*lexicalGlobalObject, argument1.value()));
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = HTMLImageElement::createForLegacyFactoryFunction(document, WTFMove(width), WTFMove(height));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<HTMLImageElement>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<HTMLImageElement>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSHTMLImageElementLegacyFactoryFunctionConstruct, JSHTMLImageElementLegacyFactoryFunction::construct);

template<> const ClassInfo JSHTMLImageElementLegacyFactoryFunction::s_info = { "Image"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLImageElementLegacyFactoryFunction) };

template<> JSValue JSHTMLImageElementLegacyFactoryFunction::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSHTMLImageElementLegacyFactoryFunction::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "Image"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSHTMLImageElement::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLImageElementPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElementConstructor, 0 } },
    { "alt"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_alt, setJSHTMLImageElement_alt } },
    { "src"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_src, setJSHTMLImageElement_src } },
    { "srcset"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_srcset, setJSHTMLImageElement_srcset } },
    { "sizes"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_sizes, setJSHTMLImageElement_sizes } },
    { "crossOrigin"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_crossOrigin, setJSHTMLImageElement_crossOrigin } },
    { "useMap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_useMap, setJSHTMLImageElement_useMap } },
    { "isMap"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_isMap, setJSHTMLImageElement_isMap } },
    { "width"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_width, setJSHTMLImageElement_width } },
    { "height"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_height, setJSHTMLImageElement_height } },
    { "naturalHeight"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_naturalHeight, 0 } },
    { "naturalWidth"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_naturalWidth, 0 } },
    { "complete"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_complete, 0 } },
    { "currentSrc"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_currentSrc, 0 } },
    { "referrerPolicy"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_referrerPolicy, setJSHTMLImageElement_referrerPolicy } },
    { "decoding"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_decoding, setJSHTMLImageElement_decoding } },
    { "loading"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_loading, setJSHTMLImageElement_loading } },
    { "name"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_name, setJSHTMLImageElement_name } },
    { "lowsrc"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_lowsrc, setJSHTMLImageElement_lowsrc } },
    { "align"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_align, setJSHTMLImageElement_align } },
    { "hspace"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_hspace, setJSHTMLImageElement_hspace } },
    { "vspace"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_vspace, setJSHTMLImageElement_vspace } },
    { "longDesc"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_longDesc, setJSHTMLImageElement_longDesc } },
    { "border"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_border, setJSHTMLImageElement_border } },
    { "fetchPriority"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_fetchPriority, setJSHTMLImageElement_fetchPriority } },
#if ENABLE(ATTACHMENT_ELEMENT)
    { "attachmentIdentifier"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_attachmentIdentifier, 0 } },
#else
    { { }, 0, NoIntrinsic, { HashTableValue::End } },
#endif
    { "x"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_x, 0 } },
    { "y"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsHTMLImageElement_y, 0 } },
    { "decode"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsHTMLImageElementPrototypeFunction_decode, 0 } },
};

const ClassInfo JSHTMLImageElementPrototype::s_info = { "HTMLImageElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLImageElementPrototype) };

void JSHTMLImageElementPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSHTMLImageElement::info(), JSHTMLImageElementPrototypeTableValues, *this);
    bool hasDisabledRuntimeProperties = false;
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().referrerPolicyAttributeEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "referrerPolicy"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().lazyImageLoadingEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "loading"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(globalObject())->scriptExecutionContext())->settingsValues().fetchPriorityEnabled) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "fetchPriority"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#if ENABLE(ATTACHMENT_ELEMENT)
    if (!DeprecatedGlobalSettings::attachmentElementEnabled()) {
        hasDisabledRuntimeProperties = true;
        auto propertyName = Identifier::fromString(vm, "attachmentIdentifier"_s);
        VM::DeletePropertyModeScope scope(vm, VM::DeletePropertyMode::IgnoreConfigurable);
        DeletePropertySlot slot;
        JSObject::deleteProperty(this, globalObject(), propertyName, slot);
    }
#endif
    if (hasDisabledRuntimeProperties && structure()->isDictionary())
        flattenDictionaryObject(vm);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSHTMLImageElement::s_info = { "HTMLImageElement"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSHTMLImageElement) };

JSHTMLImageElement::JSHTMLImageElement(Structure* structure, JSDOMGlobalObject& globalObject, Ref<HTMLImageElement>&& impl)
    : JSHTMLElement(structure, globalObject, WTFMove(impl))
{
}

static_assert(std::is_base_of<ActiveDOMObject, HTMLImageElement>::value, "Interface is marked as [ActiveDOMObject] but implementation class does not subclass ActiveDOMObject.");

JSObject* JSHTMLImageElement::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSHTMLImageElementPrototype::createStructure(vm, &globalObject, JSHTMLElement::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSHTMLImageElementPrototype::create(vm, &globalObject, structure);
}

JSObject* JSHTMLImageElement::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSHTMLImageElement>(vm, globalObject);
}

JSValue JSHTMLImageElement::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLImageElementDOMConstructor, DOMConstructorID::HTMLImageElement>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSValue JSHTMLImageElement::getLegacyFactoryFunction(VM& vm, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLImageElementLegacyFactoryFunction, DOMConstructorID::HTMLImageElementLegacyFactory>(vm, *jsCast<JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElementConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSHTMLImageElementPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSHTMLImageElement::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsHTMLImageElement_altGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::altAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_alt, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_altGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLImageElement_altSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::altAttr, WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLImageElement_alt, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::set<setJSHTMLImageElement_altSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLImageElement_srcGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.getURLAttributeForBindings(WebCore::HTMLNames::srcAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_src, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_srcGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLImageElement_srcSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLAtomStringAdaptor<IDLUSVString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::srcAttr, WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLImageElement_src, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::set<setJSHTMLImageElement_srcSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLImageElement_srcsetGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.srcsetForBindings())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_srcset, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_srcsetGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLImageElement_srcsetSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLAtomStringAdaptor<IDLUSVString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setSrcsetForBindings(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLImageElement_srcset, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::set<setJSHTMLImageElement_srcsetSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLImageElement_sizesGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::sizesAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_sizes, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_sizesGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLImageElement_sizesSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::sizesAttr, WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLImageElement_sizes, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::set<setJSHTMLImageElement_sizesSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLImageElement_crossOriginGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLAtomStringAdaptor<IDLDOMString>>>(lexicalGlobalObject, throwScope, impl.crossOrigin())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_crossOrigin, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_crossOriginGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLImageElement_crossOriginSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLNullable<IDLAtomStringAdaptor<IDLDOMString>>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setCrossOrigin(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLImageElement_crossOrigin, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::set<setJSHTMLImageElement_crossOriginSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLImageElement_useMapGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::usemapAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_useMap, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_useMapGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLImageElement_useMapSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::usemapAttr, WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLImageElement_useMap, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::set<setJSHTMLImageElement_useMapSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLImageElement_isMapGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.hasAttributeWithoutSynchronization(WebCore::HTMLNames::ismapAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_isMap, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_isMapGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLImageElement_isMapSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLBoolean>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setBooleanAttribute(WebCore::HTMLNames::ismapAttr, WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLImageElement_isMap, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::set<setJSHTMLImageElement_isMapSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLImageElement_widthGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.width())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_width, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_widthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLImageElement_widthSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnsignedLong>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setWidth(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLImageElement_width, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::set<setJSHTMLImageElement_widthSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLImageElement_heightGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.height())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_height, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_heightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLImageElement_heightSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnsignedLong>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setHeight(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLImageElement_height, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::set<setJSHTMLImageElement_heightSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLImageElement_naturalHeightGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.naturalHeight())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_naturalHeight, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_naturalHeightGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLImageElement_naturalWidthGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, impl.naturalWidth())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_naturalWidth, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_naturalWidthGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLImageElement_completeGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.complete())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_complete, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_completeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLImageElement_currentSrcGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUSVString>(lexicalGlobalObject, throwScope, impl.currentSrc())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_currentSrc, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_currentSrcGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLImageElement_referrerPolicyGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.referrerPolicyForBindings())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_referrerPolicy, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_referrerPolicyGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLImageElement_referrerPolicySetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setReferrerPolicyForBindings(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLImageElement_referrerPolicy, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::set<setJSHTMLImageElement_referrerPolicySetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLImageElement_decodingGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.decoding())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_decoding, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_decodingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLImageElement_decodingSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setDecoding(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLImageElement_decoding, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::set<setJSHTMLImageElement_decodingSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLImageElement_loadingGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.loadingForBindings())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_loading, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_loadingGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLImageElement_loadingSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setLoadingForBindings(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLImageElement_loading, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::set<setJSHTMLImageElement_loadingSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLImageElement_nameGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.getNameAttribute())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_name, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_nameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLImageElement_nameSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::nameAttr, WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLImageElement_name, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::set<setJSHTMLImageElement_nameSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLImageElement_lowsrcGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.getURLAttributeForBindings(WebCore::HTMLNames::lowsrcAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_lowsrc, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_lowsrcGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLImageElement_lowsrcSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLAtomStringAdaptor<IDLUSVString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::lowsrcAttr, WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLImageElement_lowsrc, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::set<setJSHTMLImageElement_lowsrcSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLImageElement_alignGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::alignAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_align, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_alignGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLImageElement_alignSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::alignAttr, WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLImageElement_align, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::set<setJSHTMLImageElement_alignSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLImageElement_hspaceGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, std::max(0, impl.getIntegralAttribute(WebCore::HTMLNames::hspaceAttr)))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_hspace, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_hspaceGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLImageElement_hspaceSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnsignedLong>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setUnsignedIntegralAttribute(WebCore::HTMLNames::hspaceAttr, WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLImageElement_hspace, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::set<setJSHTMLImageElement_hspaceSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLImageElement_vspaceGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLUnsignedLong>(lexicalGlobalObject, throwScope, std::max(0, impl.getIntegralAttribute(WebCore::HTMLNames::vspaceAttr)))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_vspace, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_vspaceGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLImageElement_vspaceSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLUnsignedLong>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setUnsignedIntegralAttribute(WebCore::HTMLNames::vspaceAttr, WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLImageElement_vspace, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::set<setJSHTMLImageElement_vspaceSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLImageElement_longDescGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLUSVString>>(lexicalGlobalObject, throwScope, impl.getURLAttributeForBindings(WebCore::HTMLNames::longdescAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_longDesc, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_longDescGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLImageElement_longDescSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLAtomStringAdaptor<IDLUSVString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::longdescAttr, WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLImageElement_longDesc, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::set<setJSHTMLImageElement_longDescSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLImageElement_borderGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLegacyNullToEmptyAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.attributeWithoutSynchronization(WebCore::HTMLNames::borderAttr))));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_border, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_borderGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLImageElement_borderSetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLLegacyNullToEmptyAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setAttributeWithoutSynchronization(WebCore::HTMLNames::borderAttr, WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLImageElement_border, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::set<setJSHTMLImageElement_borderSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsHTMLImageElement_fetchPriorityGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, throwScope, impl.fetchPriorityForBindings())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_fetchPriority, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_fetchPriorityGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSHTMLImageElement_fetchPrioritySetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject, JSValue value)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    CustomElementReactionDisallowedScope customElementReactionDisallowedScope;
    auto& impl = thisObject.wrapped();
    auto nativeValue = convert<IDLAtomStringAdaptor<IDLDOMString>>(lexicalGlobalObject, value);
    RETURN_IF_EXCEPTION(throwScope, false);
    invokeFunctorPropagatingExceptionIfNecessary(lexicalGlobalObject, throwScope, [&] {
        return impl.setFetchPriorityForBindings(WTFMove(nativeValue));
    });
    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSHTMLImageElement_fetchPriority, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::set<setJSHTMLImageElement_fetchPrioritySetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

#if ENABLE(ATTACHMENT_ELEMENT)
static inline JSValue jsHTMLImageElement_attachmentIdentifierGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.attachmentIdentifier())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_attachmentIdentifier, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_attachmentIdentifierGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

#endif

static inline JSValue jsHTMLImageElement_xGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.x())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_x, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_xGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsHTMLImageElement_yGetter(JSGlobalObject& lexicalGlobalObject, JSHTMLImageElement& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLLong>(lexicalGlobalObject, throwScope, impl.y())));
}

JSC_DEFINE_CUSTOM_GETTER(jsHTMLImageElement_y, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSHTMLImageElement>::get<jsHTMLImageElement_yGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsHTMLImageElementPrototypeFunction_decodeBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSHTMLImageElement>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLUndefined>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.decode(WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsHTMLImageElementPrototypeFunction_decode, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSHTMLImageElement>::call<jsHTMLImageElementPrototypeFunction_decodeBody>(*lexicalGlobalObject, *callFrame, "decode");
}

JSC::GCClient::IsoSubspace* JSHTMLImageElement::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSHTMLImageElement, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForHTMLImageElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForHTMLImageElement = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForHTMLImageElement.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForHTMLImageElement = std::forward<decltype(space)>(space); }
    );
}

void JSHTMLImageElement::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSHTMLImageElement*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSHTMLImageElementOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    auto* jsHTMLImageElement = jsCast<JSHTMLImageElement*>(handle.slot()->asCell());
    auto& wrapped = jsHTMLImageElement->wrapped();
    if (!wrapped.isContextStopped() && wrapped.hasPendingActivity()) {
        if (UNLIKELY(reason))
            *reason = "ActiveDOMObject with pending activity";
        return true;
     }
    if (JSNodeOwner::isReachableFromOpaqueRoots(handle, 0, visitor, reason))
        return true;
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSHTMLImageElementOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsHTMLImageElement = static_cast<JSHTMLImageElement*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsHTMLImageElement->wrapped(), jsHTMLImageElement);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7HTMLImageElement@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore16HTMLImageElementE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<HTMLImageElement>&& impl)
{

    if constexpr (std::is_polymorphic_v<HTMLImageElement>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7HTMLImageElement@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore16HTMLImageElementE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // HTMLImageElement has subclasses. If HTMLImageElement has subclasses that get passed
        // to toJS() we currently require HTMLImageElement you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<HTMLImageElement>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, HTMLImageElement& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

HTMLImageElement* JSHTMLImageElement::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSHTMLImageElement*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
