/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUVertexFormat.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(GPUVertexFormat enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("uint8x2"),
        MAKE_STATIC_STRING_IMPL("uint8x4"),
        MAKE_STATIC_STRING_IMPL("sint8x2"),
        MAKE_STATIC_STRING_IMPL("sint8x4"),
        MAKE_STATIC_STRING_IMPL("unorm8x2"),
        MAKE_STATIC_STRING_IMPL("unorm8x4"),
        MAKE_STATIC_STRING_IMPL("snorm8x2"),
        MAKE_STATIC_STRING_IMPL("snorm8x4"),
        MAKE_STATIC_STRING_IMPL("uint16x2"),
        MAKE_STATIC_STRING_IMPL("uint16x4"),
        MAKE_STATIC_STRING_IMPL("sint16x2"),
        MAKE_STATIC_STRING_IMPL("sint16x4"),
        MAKE_STATIC_STRING_IMPL("unorm16x2"),
        MAKE_STATIC_STRING_IMPL("unorm16x4"),
        MAKE_STATIC_STRING_IMPL("snorm16x2"),
        MAKE_STATIC_STRING_IMPL("snorm16x4"),
        MAKE_STATIC_STRING_IMPL("float16x2"),
        MAKE_STATIC_STRING_IMPL("float16x4"),
        MAKE_STATIC_STRING_IMPL("float32"),
        MAKE_STATIC_STRING_IMPL("float32x2"),
        MAKE_STATIC_STRING_IMPL("float32x3"),
        MAKE_STATIC_STRING_IMPL("float32x4"),
        MAKE_STATIC_STRING_IMPL("uint32"),
        MAKE_STATIC_STRING_IMPL("uint32x2"),
        MAKE_STATIC_STRING_IMPL("uint32x3"),
        MAKE_STATIC_STRING_IMPL("uint32x4"),
        MAKE_STATIC_STRING_IMPL("sint32"),
        MAKE_STATIC_STRING_IMPL("sint32x2"),
        MAKE_STATIC_STRING_IMPL("sint32x3"),
        MAKE_STATIC_STRING_IMPL("sint32x4"),
    };
    static_assert(static_cast<size_t>(GPUVertexFormat::Uint8x2) == 0, "GPUVertexFormat::Uint8x2 is not 0 as expected");
    static_assert(static_cast<size_t>(GPUVertexFormat::Uint8x4) == 1, "GPUVertexFormat::Uint8x4 is not 1 as expected");
    static_assert(static_cast<size_t>(GPUVertexFormat::Sint8x2) == 2, "GPUVertexFormat::Sint8x2 is not 2 as expected");
    static_assert(static_cast<size_t>(GPUVertexFormat::Sint8x4) == 3, "GPUVertexFormat::Sint8x4 is not 3 as expected");
    static_assert(static_cast<size_t>(GPUVertexFormat::Unorm8x2) == 4, "GPUVertexFormat::Unorm8x2 is not 4 as expected");
    static_assert(static_cast<size_t>(GPUVertexFormat::Unorm8x4) == 5, "GPUVertexFormat::Unorm8x4 is not 5 as expected");
    static_assert(static_cast<size_t>(GPUVertexFormat::Snorm8x2) == 6, "GPUVertexFormat::Snorm8x2 is not 6 as expected");
    static_assert(static_cast<size_t>(GPUVertexFormat::Snorm8x4) == 7, "GPUVertexFormat::Snorm8x4 is not 7 as expected");
    static_assert(static_cast<size_t>(GPUVertexFormat::Uint16x2) == 8, "GPUVertexFormat::Uint16x2 is not 8 as expected");
    static_assert(static_cast<size_t>(GPUVertexFormat::Uint16x4) == 9, "GPUVertexFormat::Uint16x4 is not 9 as expected");
    static_assert(static_cast<size_t>(GPUVertexFormat::Sint16x2) == 10, "GPUVertexFormat::Sint16x2 is not 10 as expected");
    static_assert(static_cast<size_t>(GPUVertexFormat::Sint16x4) == 11, "GPUVertexFormat::Sint16x4 is not 11 as expected");
    static_assert(static_cast<size_t>(GPUVertexFormat::Unorm16x2) == 12, "GPUVertexFormat::Unorm16x2 is not 12 as expected");
    static_assert(static_cast<size_t>(GPUVertexFormat::Unorm16x4) == 13, "GPUVertexFormat::Unorm16x4 is not 13 as expected");
    static_assert(static_cast<size_t>(GPUVertexFormat::Snorm16x2) == 14, "GPUVertexFormat::Snorm16x2 is not 14 as expected");
    static_assert(static_cast<size_t>(GPUVertexFormat::Snorm16x4) == 15, "GPUVertexFormat::Snorm16x4 is not 15 as expected");
    static_assert(static_cast<size_t>(GPUVertexFormat::Float16x2) == 16, "GPUVertexFormat::Float16x2 is not 16 as expected");
    static_assert(static_cast<size_t>(GPUVertexFormat::Float16x4) == 17, "GPUVertexFormat::Float16x4 is not 17 as expected");
    static_assert(static_cast<size_t>(GPUVertexFormat::Float32) == 18, "GPUVertexFormat::Float32 is not 18 as expected");
    static_assert(static_cast<size_t>(GPUVertexFormat::Float32x2) == 19, "GPUVertexFormat::Float32x2 is not 19 as expected");
    static_assert(static_cast<size_t>(GPUVertexFormat::Float32x3) == 20, "GPUVertexFormat::Float32x3 is not 20 as expected");
    static_assert(static_cast<size_t>(GPUVertexFormat::Float32x4) == 21, "GPUVertexFormat::Float32x4 is not 21 as expected");
    static_assert(static_cast<size_t>(GPUVertexFormat::Uint32) == 22, "GPUVertexFormat::Uint32 is not 22 as expected");
    static_assert(static_cast<size_t>(GPUVertexFormat::Uint32x2) == 23, "GPUVertexFormat::Uint32x2 is not 23 as expected");
    static_assert(static_cast<size_t>(GPUVertexFormat::Uint32x3) == 24, "GPUVertexFormat::Uint32x3 is not 24 as expected");
    static_assert(static_cast<size_t>(GPUVertexFormat::Uint32x4) == 25, "GPUVertexFormat::Uint32x4 is not 25 as expected");
    static_assert(static_cast<size_t>(GPUVertexFormat::Sint32) == 26, "GPUVertexFormat::Sint32 is not 26 as expected");
    static_assert(static_cast<size_t>(GPUVertexFormat::Sint32x2) == 27, "GPUVertexFormat::Sint32x2 is not 27 as expected");
    static_assert(static_cast<size_t>(GPUVertexFormat::Sint32x3) == 28, "GPUVertexFormat::Sint32x3 is not 28 as expected");
    static_assert(static_cast<size_t>(GPUVertexFormat::Sint32x4) == 29, "GPUVertexFormat::Sint32x4 is not 29 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, GPUVertexFormat enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<GPUVertexFormat> parseEnumerationFromString<GPUVertexFormat>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, GPUVertexFormat> mappings[] = {
        { "float16x2", GPUVertexFormat::Float16x2 },
        { "float16x4", GPUVertexFormat::Float16x4 },
        { "float32", GPUVertexFormat::Float32 },
        { "float32x2", GPUVertexFormat::Float32x2 },
        { "float32x3", GPUVertexFormat::Float32x3 },
        { "float32x4", GPUVertexFormat::Float32x4 },
        { "sint16x2", GPUVertexFormat::Sint16x2 },
        { "sint16x4", GPUVertexFormat::Sint16x4 },
        { "sint32", GPUVertexFormat::Sint32 },
        { "sint32x2", GPUVertexFormat::Sint32x2 },
        { "sint32x3", GPUVertexFormat::Sint32x3 },
        { "sint32x4", GPUVertexFormat::Sint32x4 },
        { "sint8x2", GPUVertexFormat::Sint8x2 },
        { "sint8x4", GPUVertexFormat::Sint8x4 },
        { "snorm16x2", GPUVertexFormat::Snorm16x2 },
        { "snorm16x4", GPUVertexFormat::Snorm16x4 },
        { "snorm8x2", GPUVertexFormat::Snorm8x2 },
        { "snorm8x4", GPUVertexFormat::Snorm8x4 },
        { "uint16x2", GPUVertexFormat::Uint16x2 },
        { "uint16x4", GPUVertexFormat::Uint16x4 },
        { "uint32", GPUVertexFormat::Uint32 },
        { "uint32x2", GPUVertexFormat::Uint32x2 },
        { "uint32x3", GPUVertexFormat::Uint32x3 },
        { "uint32x4", GPUVertexFormat::Uint32x4 },
        { "uint8x2", GPUVertexFormat::Uint8x2 },
        { "uint8x4", GPUVertexFormat::Uint8x4 },
        { "unorm16x2", GPUVertexFormat::Unorm16x2 },
        { "unorm16x4", GPUVertexFormat::Unorm16x4 },
        { "unorm8x2", GPUVertexFormat::Unorm8x2 },
        { "unorm8x4", GPUVertexFormat::Unorm8x4 },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<GPUVertexFormat> parseEnumeration<GPUVertexFormat>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<GPUVertexFormat>(value.toWTFString(&lexicalGlobalObject));
}

template<> const char* expectedEnumerationValues<GPUVertexFormat>()
{
    return "\"uint8x2\", \"uint8x4\", \"sint8x2\", \"sint8x4\", \"unorm8x2\", \"unorm8x4\", \"snorm8x2\", \"snorm8x4\", \"uint16x2\", \"uint16x4\", \"sint16x2\", \"sint16x4\", \"unorm16x2\", \"unorm16x4\", \"snorm16x2\", \"snorm16x4\", \"float16x2\", \"float16x4\", \"float32\", \"float32x2\", \"float32x3\", \"float32x4\", \"uint32\", \"uint32x2\", \"uint32x3\", \"uint32x4\", \"sint32\", \"sint32x2\", \"sint32x3\", \"sint32x4\"";
}

} // namespace WebCore
