/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUImageCopyTexture.h"

#include "JSDOMConvertEnumeration.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertUnion.h"
#include "JSGPUOrigin3DDict.h"
#include "JSGPUTexture.h"
#include "JSGPUTextureAspect.h"
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <variant>


namespace WebCore {
using namespace JSC;

template<> GPUImageCopyTexture convertDictionary<GPUImageCopyTexture>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    GPUImageCopyTexture result;
    JSValue aspectValue;
    if (isNullOrUndefined)
        aspectValue = jsUndefined();
    else {
        aspectValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "aspect"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!aspectValue.isUndefined()) {
        result.aspect = convert<IDLEnumeration<GPUTextureAspect>>(lexicalGlobalObject, aspectValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.aspect = GPUTextureAspect::All;
    JSValue mipLevelValue;
    if (isNullOrUndefined)
        mipLevelValue = jsUndefined();
    else {
        mipLevelValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "mipLevel"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!mipLevelValue.isUndefined()) {
        result.mipLevel = convert<IDLEnforceRangeAdaptor<IDLUnsignedLong>>(lexicalGlobalObject, mipLevelValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.mipLevel = 0;
    JSValue originValue;
    if (isNullOrUndefined)
        originValue = jsUndefined();
    else {
        originValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "origin"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!originValue.isUndefined()) {
        result.origin = convert<IDLUnion<IDLSequence<IDLEnforceRangeAdaptor<IDLUnsignedLong>>, IDLDictionary<GPUOrigin3DDict>>>(lexicalGlobalObject, originValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    JSValue textureValue;
    if (isNullOrUndefined)
        textureValue = jsUndefined();
    else {
        textureValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "texture"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!textureValue.isUndefined()) {
        result.texture = convert<IDLInterface<GPUTexture>>(lexicalGlobalObject, textureValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "texture", "GPUImageCopyTexture", "GPUTexture");
        return { };
    }
    return result;
}

} // namespace WebCore
