/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUAdapter.h"

#include "ActiveDOMObject.h"
#include "DOMPromiseProxy.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSGPUAdapterInfo.h"
#include "JSGPUDevice.h"
#include "JSGPUDeviceDescriptor.h"
#include "JSGPUSupportedFeatures.h"
#include "JSGPUSupportedLimits.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/FunctionPrototype.h>
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsGPUAdapterPrototypeFunction_requestDevice);
static JSC_DECLARE_HOST_FUNCTION(jsGPUAdapterPrototypeFunction_requestAdapterInfo);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsGPUAdapterConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUAdapter_name);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUAdapter_features);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUAdapter_limits);
static JSC_DECLARE_CUSTOM_GETTER(jsGPUAdapter_isFallbackAdapter);

class JSGPUAdapterPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSGPUAdapterPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSGPUAdapterPrototype* ptr = new (NotNull, JSC::allocateCell<JSGPUAdapterPrototype>(vm)) JSGPUAdapterPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPUAdapterPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSGPUAdapterPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSGPUAdapterPrototype, JSGPUAdapterPrototype::Base);

using JSGPUAdapterDOMConstructor = JSDOMConstructorNotConstructable<JSGPUAdapter>;

template<> const ClassInfo JSGPUAdapterDOMConstructor::s_info = { "GPUAdapter"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUAdapterDOMConstructor) };

template<> JSValue JSGPUAdapterDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    UNUSED_PARAM(vm);
    return globalObject.functionPrototype();
}

template<> void JSGPUAdapterDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "GPUAdapter"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSGPUAdapter::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSGPUAdapterPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUAdapterConstructor, 0 } },
    { "name"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUAdapter_name, 0 } },
    { "features"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUAdapter_features, 0 } },
    { "limits"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUAdapter_limits, 0 } },
    { "isFallbackAdapter"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsGPUAdapter_isFallbackAdapter, 0 } },
    { "requestDevice"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUAdapterPrototypeFunction_requestDevice, 0 } },
    { "requestAdapterInfo"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsGPUAdapterPrototypeFunction_requestAdapterInfo, 0 } },
};

const ClassInfo JSGPUAdapterPrototype::s_info = { "GPUAdapter"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUAdapterPrototype) };

void JSGPUAdapterPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSGPUAdapter::info(), JSGPUAdapterPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSGPUAdapter::s_info = { "GPUAdapter"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSGPUAdapter) };

JSGPUAdapter::JSGPUAdapter(Structure* structure, JSDOMGlobalObject& globalObject, Ref<GPUAdapter>&& impl)
    : JSDOMWrapper<GPUAdapter>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, GPUAdapter>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSGPUAdapter::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSGPUAdapterPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSGPUAdapterPrototype::create(vm, &globalObject, structure);
}

JSObject* JSGPUAdapter::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSGPUAdapter>(vm, globalObject);
}

JSValue JSGPUAdapter::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSGPUAdapterDOMConstructor, DOMConstructorID::GPUAdapter>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

void JSGPUAdapter::destroy(JSC::JSCell* cell)
{
    JSGPUAdapter* thisObject = static_cast<JSGPUAdapter*>(cell);
    thisObject->JSGPUAdapter::~JSGPUAdapter();
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUAdapterConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSGPUAdapterPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSGPUAdapter::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsGPUAdapter_nameGetter(JSGlobalObject& lexicalGlobalObject, JSGPUAdapter& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.name())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUAdapter_name, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUAdapter>::get<jsGPUAdapter_nameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUAdapter_featuresGetter(JSGlobalObject& lexicalGlobalObject, JSGPUAdapter& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<GPUSupportedFeatures>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.features())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUAdapter_features, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUAdapter>::get<jsGPUAdapter_featuresGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUAdapter_limitsGetter(JSGlobalObject& lexicalGlobalObject, JSGPUAdapter& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<GPUSupportedLimits>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.limits())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUAdapter_limits, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUAdapter>::get<jsGPUAdapter_limitsGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsGPUAdapter_isFallbackAdapterGetter(JSGlobalObject& lexicalGlobalObject, JSGPUAdapter& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.isFallbackAdapter())));
}

JSC_DEFINE_CUSTOM_GETTER(jsGPUAdapter_isFallbackAdapter, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSGPUAdapter>::get<jsGPUAdapter_isFallbackAdapterGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSC::EncodedJSValue jsGPUAdapterPrototypeFunction_requestDeviceBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSGPUAdapter>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    auto* context = jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext();
    if (UNLIKELY(!context))
        return JSValue::encode(jsUndefined());
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto descriptor = convert<IDLDictionary<GPUDeviceDescriptor>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLInterface<GPUDevice>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.requestDevice(*context, WTFMove(descriptor), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPUAdapterPrototypeFunction_requestDevice, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSGPUAdapter>::call<jsGPUAdapterPrototypeFunction_requestDeviceBody>(*lexicalGlobalObject, *callFrame, "requestDevice");
}

static inline JSC::EncodedJSValue jsGPUAdapterPrototypeFunction_requestAdapterInfoBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSGPUAdapter>::ClassParameter castedThis, Ref<DeferredPromise>&& promise)
{
    auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto unmaskHints = argument0.value().isUndefined() ? Converter<IDLSequence<IDLDOMString>>::ReturnType{ } : convert<IDLSequence<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLPromise<IDLInterface<GPUAdapterInfo>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.requestAdapterInfo(WTFMove(unmaskHints), WTFMove(promise)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsGPUAdapterPrototypeFunction_requestAdapterInfo, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSGPUAdapter>::call<jsGPUAdapterPrototypeFunction_requestAdapterInfoBody>(*lexicalGlobalObject, *callFrame, "requestAdapterInfo");
}

JSC::GCClient::IsoSubspace* JSGPUAdapter::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSGPUAdapter, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForGPUAdapter.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForGPUAdapter = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForGPUAdapter.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForGPUAdapter = std::forward<decltype(space)>(space); }
    );
}

void JSGPUAdapter::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSGPUAdapter*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

bool JSGPUAdapterOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, const char** reason)
{
    UNUSED_PARAM(handle);
    UNUSED_PARAM(visitor);
    UNUSED_PARAM(reason);
    return false;
}

void JSGPUAdapterOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsGPUAdapter = static_cast<JSGPUAdapter*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, &jsGPUAdapter->wrapped(), jsGPUAdapter);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7GPUAdapter@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore10GPUAdapterE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<GPUAdapter>&& impl)
{

    if constexpr (std::is_polymorphic_v<GPUAdapter>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7GPUAdapter@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore10GPUAdapterE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // GPUAdapter has subclasses. If GPUAdapter has subclasses that get passed
        // to toJS() we currently require GPUAdapter you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<GPUAdapter>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, GPUAdapter& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

GPUAdapter* JSGPUAdapter::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSGPUAdapter*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
