/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEB_AUDIO)

#include "JSDynamicsCompressorNode.h"

#include "ActiveDOMObject.h"
#include "Document.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSAudioParam.h"
#include "JSBaseAudioContext.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertDictionary.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "JSDynamicsCompressorOptions.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsDynamicsCompressorNodeConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsDynamicsCompressorNode_threshold);
static JSC_DECLARE_CUSTOM_GETTER(jsDynamicsCompressorNode_knee);
static JSC_DECLARE_CUSTOM_GETTER(jsDynamicsCompressorNode_ratio);
static JSC_DECLARE_CUSTOM_GETTER(jsDynamicsCompressorNode_attack);
static JSC_DECLARE_CUSTOM_GETTER(jsDynamicsCompressorNode_release);
static JSC_DECLARE_CUSTOM_GETTER(jsDynamicsCompressorNode_reduction);

class JSDynamicsCompressorNodePrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSDynamicsCompressorNodePrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSDynamicsCompressorNodePrototype* ptr = new (NotNull, JSC::allocateCell<JSDynamicsCompressorNodePrototype>(vm)) JSDynamicsCompressorNodePrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDynamicsCompressorNodePrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSDynamicsCompressorNodePrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSDynamicsCompressorNodePrototype, JSDynamicsCompressorNodePrototype::Base);

using JSDynamicsCompressorNodeDOMConstructor = JSDOMConstructor<JSDynamicsCompressorNode>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSDynamicsCompressorNodeDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSDynamicsCompressorNodeDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (!downcast<Document>(jsCast<JSDOMGlobalObject*>(lexicalGlobalObject)->scriptExecutionContext())->settingsValues().webAudioEnabled) {
        throwTypeError(lexicalGlobalObject, throwScope, "Illegal constructor"_s);
        return JSValue::encode(jsNull());
    }
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto context = convert<IDLInterface<BaseAudioContext>>(*lexicalGlobalObject, argument0.value(), [](JSC::JSGlobalObject& lexicalGlobalObject, JSC::ThrowScope& scope) { throwArgumentTypeError(lexicalGlobalObject, scope, 0, "context", "DynamicsCompressorNode", nullptr, "BaseAudioContext"); });
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto options = convert<IDLDictionary<DynamicsCompressorOptions>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = DynamicsCompressorNode::create(*context, WTFMove(options));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<DynamicsCompressorNode>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<DynamicsCompressorNode>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSDynamicsCompressorNodeDOMConstructorConstruct, JSDynamicsCompressorNodeDOMConstructor::construct);

template<> const ClassInfo JSDynamicsCompressorNodeDOMConstructor::s_info = { "DynamicsCompressorNode"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDynamicsCompressorNodeDOMConstructor) };

template<> JSValue JSDynamicsCompressorNodeDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSAudioNode::getConstructor(vm, &globalObject);
}

template<> void JSDynamicsCompressorNodeDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "DynamicsCompressorNode"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSDynamicsCompressorNode::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSDynamicsCompressorNodePrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsDynamicsCompressorNodeConstructor, 0 } },
    { "threshold"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDynamicsCompressorNode_threshold, 0 } },
    { "knee"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDynamicsCompressorNode_knee, 0 } },
    { "ratio"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDynamicsCompressorNode_ratio, 0 } },
    { "attack"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDynamicsCompressorNode_attack, 0 } },
    { "release"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDynamicsCompressorNode_release, 0 } },
    { "reduction"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsDynamicsCompressorNode_reduction, 0 } },
};

const ClassInfo JSDynamicsCompressorNodePrototype::s_info = { "DynamicsCompressorNode"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDynamicsCompressorNodePrototype) };

void JSDynamicsCompressorNodePrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSDynamicsCompressorNode::info(), JSDynamicsCompressorNodePrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSDynamicsCompressorNode::s_info = { "DynamicsCompressorNode"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSDynamicsCompressorNode) };

JSDynamicsCompressorNode::JSDynamicsCompressorNode(Structure* structure, JSDOMGlobalObject& globalObject, Ref<DynamicsCompressorNode>&& impl)
    : JSAudioNode(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, DynamicsCompressorNode>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSDynamicsCompressorNode::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSDynamicsCompressorNodePrototype::createStructure(vm, &globalObject, JSAudioNode::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSDynamicsCompressorNodePrototype::create(vm, &globalObject, structure);
}

JSObject* JSDynamicsCompressorNode::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSDynamicsCompressorNode>(vm, globalObject);
}

JSValue JSDynamicsCompressorNode::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSDynamicsCompressorNodeDOMConstructor, DOMConstructorID::DynamicsCompressorNode>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsDynamicsCompressorNodeConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSDynamicsCompressorNodePrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSDynamicsCompressorNode::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsDynamicsCompressorNode_thresholdGetter(JSGlobalObject& lexicalGlobalObject, JSDynamicsCompressorNode& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<AudioParam>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.threshold())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDynamicsCompressorNode_threshold, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDynamicsCompressorNode>::get<jsDynamicsCompressorNode_thresholdGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDynamicsCompressorNode_kneeGetter(JSGlobalObject& lexicalGlobalObject, JSDynamicsCompressorNode& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<AudioParam>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.knee())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDynamicsCompressorNode_knee, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDynamicsCompressorNode>::get<jsDynamicsCompressorNode_kneeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDynamicsCompressorNode_ratioGetter(JSGlobalObject& lexicalGlobalObject, JSDynamicsCompressorNode& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<AudioParam>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.ratio())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDynamicsCompressorNode_ratio, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDynamicsCompressorNode>::get<jsDynamicsCompressorNode_ratioGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDynamicsCompressorNode_attackGetter(JSGlobalObject& lexicalGlobalObject, JSDynamicsCompressorNode& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<AudioParam>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.attack())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDynamicsCompressorNode_attack, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDynamicsCompressorNode>::get<jsDynamicsCompressorNode_attackGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDynamicsCompressorNode_releaseGetter(JSGlobalObject& lexicalGlobalObject, JSDynamicsCompressorNode& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLInterface<AudioParam>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.release())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDynamicsCompressorNode_release, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDynamicsCompressorNode>::get<jsDynamicsCompressorNode_releaseGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsDynamicsCompressorNode_reductionGetter(JSGlobalObject& lexicalGlobalObject, JSDynamicsCompressorNode& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLFloat>(lexicalGlobalObject, throwScope, impl.reduction())));
}

JSC_DEFINE_CUSTOM_GETTER(jsDynamicsCompressorNode_reduction, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSDynamicsCompressorNode>::get<jsDynamicsCompressorNode_reductionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSDynamicsCompressorNode::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSDynamicsCompressorNode, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForDynamicsCompressorNode.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForDynamicsCompressorNode = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForDynamicsCompressorNode.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForDynamicsCompressorNode = std::forward<decltype(space)>(space); }
    );
}

void JSDynamicsCompressorNode::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSDynamicsCompressorNode*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7DynamicsCompressorNode@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore22DynamicsCompressorNodeE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<DynamicsCompressorNode>&& impl)
{

    if constexpr (std::is_polymorphic_v<DynamicsCompressorNode>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7DynamicsCompressorNode@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore22DynamicsCompressorNodeE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // DynamicsCompressorNode has subclasses. If DynamicsCompressorNode has subclasses that get passed
        // to toJS() we currently require DynamicsCompressorNode you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<DynamicsCompressorNode>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, DynamicsCompressorNode& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}

#endif // ENABLE(WEB_AUDIO)
