/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCanvasTextBaseline.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>


namespace WebCore {
using namespace JSC;

String convertEnumerationToString(CanvasTextBaseline enumerationValue)
{
    static const NeverDestroyed<String> values[] = {
        MAKE_STATIC_STRING_IMPL("top"),
        MAKE_STATIC_STRING_IMPL("hanging"),
        MAKE_STATIC_STRING_IMPL("middle"),
        MAKE_STATIC_STRING_IMPL("alphabetic"),
        MAKE_STATIC_STRING_IMPL("ideographic"),
        MAKE_STATIC_STRING_IMPL("bottom"),
    };
    static_assert(static_cast<size_t>(CanvasTextBaseline::Top) == 0, "CanvasTextBaseline::Top is not 0 as expected");
    static_assert(static_cast<size_t>(CanvasTextBaseline::Hanging) == 1, "CanvasTextBaseline::Hanging is not 1 as expected");
    static_assert(static_cast<size_t>(CanvasTextBaseline::Middle) == 2, "CanvasTextBaseline::Middle is not 2 as expected");
    static_assert(static_cast<size_t>(CanvasTextBaseline::Alphabetic) == 3, "CanvasTextBaseline::Alphabetic is not 3 as expected");
    static_assert(static_cast<size_t>(CanvasTextBaseline::Ideographic) == 4, "CanvasTextBaseline::Ideographic is not 4 as expected");
    static_assert(static_cast<size_t>(CanvasTextBaseline::Bottom) == 5, "CanvasTextBaseline::Bottom is not 5 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, CanvasTextBaseline enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<CanvasTextBaseline> parseEnumerationFromString<CanvasTextBaseline>(const String& stringValue)
{
    static constexpr std::pair<ComparableASCIILiteral, CanvasTextBaseline> mappings[] = {
        { "alphabetic", CanvasTextBaseline::Alphabetic },
        { "bottom", CanvasTextBaseline::Bottom },
        { "hanging", CanvasTextBaseline::Hanging },
        { "ideographic", CanvasTextBaseline::Ideographic },
        { "middle", CanvasTextBaseline::Middle },
        { "top", CanvasTextBaseline::Top },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); LIKELY(enumerationValue))
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<CanvasTextBaseline> parseEnumeration<CanvasTextBaseline>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<CanvasTextBaseline>(value.toWTFString(&lexicalGlobalObject));
}

template<> const char* expectedEnumerationValues<CanvasTextBaseline>()
{
    return "\"top\", \"hanging\", \"middle\", \"alphabetic\", \"ideographic\", \"bottom\"";
}

} // namespace WebCore
