/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSTransitionEvent.h"

#include "ActiveDOMObject.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructor.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNumbers.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>


namespace WebCore {
using namespace JSC;

template<> CSSTransitionEvent::Init convertDictionary<CSSTransitionEvent::Init>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    VM& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (UNLIKELY(!isNullOrUndefined && !object)) {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return { };
    }
    CSSTransitionEvent::Init result;
    JSValue bubblesValue;
    if (isNullOrUndefined)
        bubblesValue = jsUndefined();
    else {
        bubblesValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "bubbles"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!bubblesValue.isUndefined()) {
        result.bubbles = convert<IDLBoolean>(lexicalGlobalObject, bubblesValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.bubbles = false;
    JSValue cancelableValue;
    if (isNullOrUndefined)
        cancelableValue = jsUndefined();
    else {
        cancelableValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "cancelable"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!cancelableValue.isUndefined()) {
        result.cancelable = convert<IDLBoolean>(lexicalGlobalObject, cancelableValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.cancelable = false;
    JSValue composedValue;
    if (isNullOrUndefined)
        composedValue = jsUndefined();
    else {
        composedValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "composed"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!composedValue.isUndefined()) {
        result.composed = convert<IDLBoolean>(lexicalGlobalObject, composedValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.composed = false;
    JSValue elapsedTimeValue;
    if (isNullOrUndefined)
        elapsedTimeValue = jsUndefined();
    else {
        elapsedTimeValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "elapsedTime"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!elapsedTimeValue.isUndefined()) {
        result.elapsedTime = convert<IDLDouble>(lexicalGlobalObject, elapsedTimeValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.elapsedTime = 0.0;
    JSValue propertyNameValue;
    if (isNullOrUndefined)
        propertyNameValue = jsUndefined();
    else {
        propertyNameValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "propertyName"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!propertyNameValue.isUndefined()) {
        result.propertyName = convert<IDLDOMString>(lexicalGlobalObject, propertyNameValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.propertyName = emptyString();
    JSValue pseudoElementValue;
    if (isNullOrUndefined)
        pseudoElementValue = jsUndefined();
    else {
        pseudoElementValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "pseudoElement"_s));
        RETURN_IF_EXCEPTION(throwScope, { });
    }
    if (!pseudoElementValue.isUndefined()) {
        result.pseudoElement = convert<IDLDOMString>(lexicalGlobalObject, pseudoElementValue);
        RETURN_IF_EXCEPTION(throwScope, { });
    } else
        result.pseudoElement = emptyString();
    return result;
}

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsCSSTransitionEventConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSTransitionEvent_propertyName);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSTransitionEvent_elapsedTime);
static JSC_DECLARE_CUSTOM_GETTER(jsCSSTransitionEvent_pseudoElement);

class JSCSSTransitionEventPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSCSSTransitionEventPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSCSSTransitionEventPrototype* ptr = new (NotNull, JSC::allocateCell<JSCSSTransitionEventPrototype>(vm)) JSCSSTransitionEventPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSTransitionEventPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSCSSTransitionEventPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSCSSTransitionEventPrototype, JSCSSTransitionEventPrototype::Base);

using JSCSSTransitionEventDOMConstructor = JSDOMConstructor<JSCSSTransitionEvent>;

template<> EncodedJSValue JSC_HOST_CALL_ATTRIBUTES JSCSSTransitionEventDOMConstructor::construct(JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame)
{
    VM& vm = lexicalGlobalObject->vm();
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* castedThis = jsCast<JSCSSTransitionEventDOMConstructor*>(callFrame->jsCallee());
    ASSERT(castedThis);
    if (UNLIKELY(callFrame->argumentCount() < 1))
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto type = convert<IDLAtomStringAdaptor<IDLDOMString>>(*lexicalGlobalObject, argument0.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto transitionEventInitDict = convert<IDLDictionary<CSSTransitionEvent::Init>>(*lexicalGlobalObject, argument1.value());
    RETURN_IF_EXCEPTION(throwScope, encodedJSValue());
    auto object = CSSTransitionEvent::create(WTFMove(type), WTFMove(transitionEventInitDict));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    static_assert(TypeOrExceptionOrUnderlyingType<decltype(object)>::isRef);
    auto jsValue = toJSNewlyCreated<IDLInterface<CSSTransitionEvent>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, WTFMove(object));
    if constexpr (IsExceptionOr<decltype(object)>)
        RETURN_IF_EXCEPTION(throwScope, { });
    setSubclassStructureIfNeeded<CSSTransitionEvent>(lexicalGlobalObject, callFrame, asObject(jsValue));
    RETURN_IF_EXCEPTION(throwScope, { });
    return JSValue::encode(jsValue);
}
JSC_ANNOTATE_HOST_FUNCTION(JSCSSTransitionEventDOMConstructorConstruct, JSCSSTransitionEventDOMConstructor::construct);

template<> const ClassInfo JSCSSTransitionEventDOMConstructor::s_info = { "TransitionEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSTransitionEventDOMConstructor) };

template<> JSValue JSCSSTransitionEventDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEvent::getConstructor(vm, &globalObject);
}

template<> void JSCSSTransitionEventDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(1), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "TransitionEvent"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSCSSTransitionEvent::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const HashTableValue JSCSSTransitionEventPrototypeTableValues[] =
{
    { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSTransitionEventConstructor, 0 } },
    { "propertyName"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSTransitionEvent_propertyName, 0 } },
    { "elapsedTime"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSTransitionEvent_elapsedTime, 0 } },
    { "pseudoElement"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsCSSTransitionEvent_pseudoElement, 0 } },
};

const ClassInfo JSCSSTransitionEventPrototype::s_info = { "TransitionEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSTransitionEventPrototype) };

void JSCSSTransitionEventPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSCSSTransitionEvent::info(), JSCSSTransitionEventPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSCSSTransitionEvent::s_info = { "TransitionEvent"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSCSSTransitionEvent) };

JSCSSTransitionEvent::JSCSSTransitionEvent(Structure* structure, JSDOMGlobalObject& globalObject, Ref<CSSTransitionEvent>&& impl)
    : JSEvent(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, CSSTransitionEvent>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSCSSTransitionEvent::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSCSSTransitionEventPrototype::createStructure(vm, &globalObject, JSEvent::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSCSSTransitionEventPrototype::create(vm, &globalObject, structure);
}

JSObject* JSCSSTransitionEvent::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSCSSTransitionEvent>(vm, globalObject);
}

JSValue JSCSSTransitionEvent::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSTransitionEventDOMConstructor, DOMConstructorID::CSSTransitionEvent>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSTransitionEventConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    VM& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSCSSTransitionEventPrototype*>(JSValue::decode(thisValue));
    if (UNLIKELY(!prototype))
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSCSSTransitionEvent::getConstructor(JSC::getVM(lexicalGlobalObject), prototype->globalObject()));
}

static inline JSValue jsCSSTransitionEvent_propertyNameGetter(JSGlobalObject& lexicalGlobalObject, JSCSSTransitionEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.propertyName())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSTransitionEvent_propertyName, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSTransitionEvent>::get<jsCSSTransitionEvent_propertyNameGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsCSSTransitionEvent_elapsedTimeGetter(JSGlobalObject& lexicalGlobalObject, JSCSSTransitionEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDouble>(lexicalGlobalObject, throwScope, impl.elapsedTime())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSTransitionEvent_elapsedTime, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSTransitionEvent>::get<jsCSSTransitionEvent_elapsedTimeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsCSSTransitionEvent_pseudoElementGetter(JSGlobalObject& lexicalGlobalObject, JSCSSTransitionEvent& thisObject)
{
    auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLDOMString>(lexicalGlobalObject, throwScope, impl.pseudoElement())));
}

JSC_DEFINE_CUSTOM_GETTER(jsCSSTransitionEvent_pseudoElement, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSCSSTransitionEvent>::get<jsCSSTransitionEvent_pseudoElementGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

JSC::GCClient::IsoSubspace* JSCSSTransitionEvent::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSCSSTransitionEvent, UseCustomHeapCellType::No>(vm,
        [] (auto& spaces) { return spaces.m_clientSubspaceForCSSTransitionEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForCSSTransitionEvent = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForCSSTransitionEvent.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForCSSTransitionEvent = std::forward<decltype(space)>(space); }
    );
}

void JSCSSTransitionEvent::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSCSSTransitionEvent*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, "url "_s + thisObject->scriptExecutionContext()->url().string());
    Base::analyzeHeap(cell, analyzer);
}

#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7CSSTransitionEvent@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore18CSSTransitionEventE[]; }
#endif
#endif

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<CSSTransitionEvent>&& impl)
{

    if constexpr (std::is_polymorphic_v<CSSTransitionEvent>) {
#if ENABLE(BINDING_INTEGRITY)
        const void* actualVTablePointer = getVTablePointer(impl.ptr());
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7CSSTransitionEvent@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore18CSSTransitionEventE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // CSSTransitionEvent has subclasses. If CSSTransitionEvent has subclasses that get passed
        // to toJS() we currently require CSSTransitionEvent you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
#endif
    }
    return createWrapper<CSSTransitionEvent>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, CSSTransitionEvent& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}


}
