/*
 * Copyright (C) 2013 Google Inc. All rights reserved.
 * Copyright (C) 2013-2016 Apple Inc. All rights reserved.
 * Copyright (C) 2014 University of Washington. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

// DO NOT EDIT THIS FILE. It is automatically generated from Automation.json by the script: Source/JavaScriptCore/inspector/scripts/generate-inspector-protocol-bindings.py

#include "config.h"
#include "AutomationProtocolObjects.h"

#include <wtf/Assertions.h>

namespace Inspector {

namespace Protocol {

namespace AutomationHelpers {

static const ASCIILiteral enum_constant_values[] = {
    "Page"_s,
    "Viewport"_s,
    "LayoutViewport"_s,
    "Window"_s,
    "Tab"_s,
    "InternalError"_s,
    "Timeout"_s,
    "JavaScriptError"_s,
    "JavaScriptTimeout"_s,
    "WindowNotFound"_s,
    "FrameNotFound"_s,
    "NodeNotFound"_s,
    "InvalidNodeIdentifier"_s,
    "InvalidElementState"_s,
    "NoJavaScriptDialog"_s,
    "NotImplemented"_s,
    "MissingParameter"_s,
    "InvalidParameter"_s,
    "InvalidSelector"_s,
    "ElementNotInteractable"_s,
    "ElementNotSelectable"_s,
    "ScreenshotError"_s,
    "UnexpectedAlertOpen"_s,
    "TargetOutOfBounds"_s,
    "None"_s,
    "Eager"_s,
    "Normal"_s,
    "Move"_s,
    "Down"_s,
    "Up"_s,
    "SingleClick"_s,
    "DoubleClick"_s,
    "Left"_s,
    "Middle"_s,
    "Right"_s,
    "CapsLock"_s,
    "Control"_s,
    "Shift"_s,
    "Meta"_s,
    "Alt"_s,
    "ShiftRight"_s,
    "ControlRight"_s,
    "Alternate"_s,
    "AlternateRight"_s,
    "MetaRight"_s,
    "Command"_s,
    "CommandRight"_s,
    "Cancel"_s,
    "Help"_s,
    "Backspace"_s,
    "Clear"_s,
    "Enter"_s,
    "Pause"_s,
    "Escape"_s,
    "PageUp"_s,
    "PageUpRight"_s,
    "PageDown"_s,
    "PageDownRight"_s,
    "End"_s,
    "EndRight"_s,
    "Home"_s,
    "HomeRight"_s,
    "LeftArrow"_s,
    "LeftArrowRight"_s,
    "UpArrow"_s,
    "UpArrowRight"_s,
    "RightArrow"_s,
    "RightArrowRight"_s,
    "DownArrow"_s,
    "DownArrowRight"_s,
    "Insert"_s,
    "InsertRight"_s,
    "Delete"_s,
    "DeleteRight"_s,
    "Space"_s,
    "Semicolon"_s,
    "Equals"_s,
    "Return"_s,
    "NumberPad0"_s,
    "NumberPad1"_s,
    "NumberPad2"_s,
    "NumberPad3"_s,
    "NumberPad4"_s,
    "NumberPad5"_s,
    "NumberPad6"_s,
    "NumberPad7"_s,
    "NumberPad8"_s,
    "NumberPad9"_s,
    "NumberPadMultiply"_s,
    "NumberPadAdd"_s,
    "NumberPadSeparator"_s,
    "NumberPadSubtract"_s,
    "NumberPadDecimal"_s,
    "NumberPadDivide"_s,
    "Function1"_s,
    "Function2"_s,
    "Function3"_s,
    "Function4"_s,
    "Function5"_s,
    "Function6"_s,
    "Function7"_s,
    "Function8"_s,
    "Function9"_s,
    "Function10"_s,
    "Function11"_s,
    "Function12"_s,
    "KeyPress"_s,
    "KeyRelease"_s,
    "InsertByKey"_s,
    "Lax"_s,
    "Strict"_s,
    "GetUserMedia"_s,
    "Null"_s,
    "Mouse"_s,
    "Keyboard"_s,
    "Touch"_s,
    "Wheel"_s,
    "Pen"_s,
    "Pointer"_s,
    "Element"_s,
    "ctap1_u2f"_s,
    "ctap2"_s,
    "ctap2_1"_s,
    "usb"_s,
    "nfc"_s,
    "ble"_s,
    "internal"_s,
};

String getEnumConstantValue(int code) {
    return enum_constant_values[code];
}

// Enums in the 'Automation' Domain

template<> std::optional<Protocol::Automation::CoordinateSystem> parseEnumValueFromString<Protocol::Automation::CoordinateSystem>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Automation::CoordinateSystem::Page,
        (size_t)Protocol::Automation::CoordinateSystem::Viewport,
        (size_t)Protocol::Automation::CoordinateSystem::LayoutViewport,
    };
    for (size_t i = 0; i < 3; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Automation::CoordinateSystem)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::Automation::BrowsingContextPresentation> parseEnumValueFromString<Protocol::Automation::BrowsingContextPresentation>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Automation::BrowsingContextPresentation::Window,
        (size_t)Protocol::Automation::BrowsingContextPresentation::Tab,
    };
    for (size_t i = 0; i < 2; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Automation::BrowsingContextPresentation)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::Automation::ErrorMessage> parseEnumValueFromString<Protocol::Automation::ErrorMessage>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Automation::ErrorMessage::InternalError,
        (size_t)Protocol::Automation::ErrorMessage::Timeout,
        (size_t)Protocol::Automation::ErrorMessage::JavaScriptError,
        (size_t)Protocol::Automation::ErrorMessage::JavaScriptTimeout,
        (size_t)Protocol::Automation::ErrorMessage::WindowNotFound,
        (size_t)Protocol::Automation::ErrorMessage::FrameNotFound,
        (size_t)Protocol::Automation::ErrorMessage::NodeNotFound,
        (size_t)Protocol::Automation::ErrorMessage::InvalidNodeIdentifier,
        (size_t)Protocol::Automation::ErrorMessage::InvalidElementState,
        (size_t)Protocol::Automation::ErrorMessage::NoJavaScriptDialog,
        (size_t)Protocol::Automation::ErrorMessage::NotImplemented,
        (size_t)Protocol::Automation::ErrorMessage::MissingParameter,
        (size_t)Protocol::Automation::ErrorMessage::InvalidParameter,
        (size_t)Protocol::Automation::ErrorMessage::InvalidSelector,
        (size_t)Protocol::Automation::ErrorMessage::ElementNotInteractable,
        (size_t)Protocol::Automation::ErrorMessage::ElementNotSelectable,
        (size_t)Protocol::Automation::ErrorMessage::ScreenshotError,
        (size_t)Protocol::Automation::ErrorMessage::UnexpectedAlertOpen,
        (size_t)Protocol::Automation::ErrorMessage::TargetOutOfBounds,
    };
    for (size_t i = 0; i < 19; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Automation::ErrorMessage)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::Automation::PageLoadStrategy> parseEnumValueFromString<Protocol::Automation::PageLoadStrategy>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Automation::PageLoadStrategy::None,
        (size_t)Protocol::Automation::PageLoadStrategy::Eager,
        (size_t)Protocol::Automation::PageLoadStrategy::Normal,
    };
    for (size_t i = 0; i < 3; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Automation::PageLoadStrategy)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::Automation::MouseInteraction> parseEnumValueFromString<Protocol::Automation::MouseInteraction>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Automation::MouseInteraction::Move,
        (size_t)Protocol::Automation::MouseInteraction::Down,
        (size_t)Protocol::Automation::MouseInteraction::Up,
        (size_t)Protocol::Automation::MouseInteraction::SingleClick,
        (size_t)Protocol::Automation::MouseInteraction::DoubleClick,
    };
    for (size_t i = 0; i < 5; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Automation::MouseInteraction)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::Automation::MouseButton> parseEnumValueFromString<Protocol::Automation::MouseButton>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Automation::MouseButton::None,
        (size_t)Protocol::Automation::MouseButton::Left,
        (size_t)Protocol::Automation::MouseButton::Middle,
        (size_t)Protocol::Automation::MouseButton::Right,
    };
    for (size_t i = 0; i < 4; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Automation::MouseButton)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::Automation::KeyModifier> parseEnumValueFromString<Protocol::Automation::KeyModifier>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Automation::KeyModifier::CapsLock,
        (size_t)Protocol::Automation::KeyModifier::Control,
        (size_t)Protocol::Automation::KeyModifier::Shift,
        (size_t)Protocol::Automation::KeyModifier::Meta,
        (size_t)Protocol::Automation::KeyModifier::Alt,
    };
    for (size_t i = 0; i < 5; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Automation::KeyModifier)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::Automation::VirtualKey> parseEnumValueFromString<Protocol::Automation::VirtualKey>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Automation::VirtualKey::Shift,
        (size_t)Protocol::Automation::VirtualKey::ShiftRight,
        (size_t)Protocol::Automation::VirtualKey::Control,
        (size_t)Protocol::Automation::VirtualKey::ControlRight,
        (size_t)Protocol::Automation::VirtualKey::Alternate,
        (size_t)Protocol::Automation::VirtualKey::AlternateRight,
        (size_t)Protocol::Automation::VirtualKey::Meta,
        (size_t)Protocol::Automation::VirtualKey::MetaRight,
        (size_t)Protocol::Automation::VirtualKey::Command,
        (size_t)Protocol::Automation::VirtualKey::CommandRight,
        (size_t)Protocol::Automation::VirtualKey::Cancel,
        (size_t)Protocol::Automation::VirtualKey::Help,
        (size_t)Protocol::Automation::VirtualKey::Backspace,
        (size_t)Protocol::Automation::VirtualKey::Tab,
        (size_t)Protocol::Automation::VirtualKey::Clear,
        (size_t)Protocol::Automation::VirtualKey::Enter,
        (size_t)Protocol::Automation::VirtualKey::Pause,
        (size_t)Protocol::Automation::VirtualKey::Escape,
        (size_t)Protocol::Automation::VirtualKey::PageUp,
        (size_t)Protocol::Automation::VirtualKey::PageUpRight,
        (size_t)Protocol::Automation::VirtualKey::PageDown,
        (size_t)Protocol::Automation::VirtualKey::PageDownRight,
        (size_t)Protocol::Automation::VirtualKey::End,
        (size_t)Protocol::Automation::VirtualKey::EndRight,
        (size_t)Protocol::Automation::VirtualKey::Home,
        (size_t)Protocol::Automation::VirtualKey::HomeRight,
        (size_t)Protocol::Automation::VirtualKey::LeftArrow,
        (size_t)Protocol::Automation::VirtualKey::LeftArrowRight,
        (size_t)Protocol::Automation::VirtualKey::UpArrow,
        (size_t)Protocol::Automation::VirtualKey::UpArrowRight,
        (size_t)Protocol::Automation::VirtualKey::RightArrow,
        (size_t)Protocol::Automation::VirtualKey::RightArrowRight,
        (size_t)Protocol::Automation::VirtualKey::DownArrow,
        (size_t)Protocol::Automation::VirtualKey::DownArrowRight,
        (size_t)Protocol::Automation::VirtualKey::Insert,
        (size_t)Protocol::Automation::VirtualKey::InsertRight,
        (size_t)Protocol::Automation::VirtualKey::Delete,
        (size_t)Protocol::Automation::VirtualKey::DeleteRight,
        (size_t)Protocol::Automation::VirtualKey::Space,
        (size_t)Protocol::Automation::VirtualKey::Semicolon,
        (size_t)Protocol::Automation::VirtualKey::Equals,
        (size_t)Protocol::Automation::VirtualKey::Return,
        (size_t)Protocol::Automation::VirtualKey::NumberPad0,
        (size_t)Protocol::Automation::VirtualKey::NumberPad1,
        (size_t)Protocol::Automation::VirtualKey::NumberPad2,
        (size_t)Protocol::Automation::VirtualKey::NumberPad3,
        (size_t)Protocol::Automation::VirtualKey::NumberPad4,
        (size_t)Protocol::Automation::VirtualKey::NumberPad5,
        (size_t)Protocol::Automation::VirtualKey::NumberPad6,
        (size_t)Protocol::Automation::VirtualKey::NumberPad7,
        (size_t)Protocol::Automation::VirtualKey::NumberPad8,
        (size_t)Protocol::Automation::VirtualKey::NumberPad9,
        (size_t)Protocol::Automation::VirtualKey::NumberPadMultiply,
        (size_t)Protocol::Automation::VirtualKey::NumberPadAdd,
        (size_t)Protocol::Automation::VirtualKey::NumberPadSeparator,
        (size_t)Protocol::Automation::VirtualKey::NumberPadSubtract,
        (size_t)Protocol::Automation::VirtualKey::NumberPadDecimal,
        (size_t)Protocol::Automation::VirtualKey::NumberPadDivide,
        (size_t)Protocol::Automation::VirtualKey::Function1,
        (size_t)Protocol::Automation::VirtualKey::Function2,
        (size_t)Protocol::Automation::VirtualKey::Function3,
        (size_t)Protocol::Automation::VirtualKey::Function4,
        (size_t)Protocol::Automation::VirtualKey::Function5,
        (size_t)Protocol::Automation::VirtualKey::Function6,
        (size_t)Protocol::Automation::VirtualKey::Function7,
        (size_t)Protocol::Automation::VirtualKey::Function8,
        (size_t)Protocol::Automation::VirtualKey::Function9,
        (size_t)Protocol::Automation::VirtualKey::Function10,
        (size_t)Protocol::Automation::VirtualKey::Function11,
        (size_t)Protocol::Automation::VirtualKey::Function12,
    };
    for (size_t i = 0; i < 70; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Automation::VirtualKey)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::Automation::KeyboardInteractionType> parseEnumValueFromString<Protocol::Automation::KeyboardInteractionType>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Automation::KeyboardInteractionType::KeyPress,
        (size_t)Protocol::Automation::KeyboardInteractionType::KeyRelease,
        (size_t)Protocol::Automation::KeyboardInteractionType::InsertByKey,
    };
    for (size_t i = 0; i < 3; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Automation::KeyboardInteractionType)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::Automation::CookieSameSitePolicy> parseEnumValueFromString<Protocol::Automation::CookieSameSitePolicy>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Automation::CookieSameSitePolicy::None,
        (size_t)Protocol::Automation::CookieSameSitePolicy::Lax,
        (size_t)Protocol::Automation::CookieSameSitePolicy::Strict,
    };
    for (size_t i = 0; i < 3; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Automation::CookieSameSitePolicy)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::Automation::SessionPermission> parseEnumValueFromString<Protocol::Automation::SessionPermission>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Automation::SessionPermission::GetUserMedia,
    };
    for (size_t i = 0; i < 1; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Automation::SessionPermission)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::Automation::InputSourceType> parseEnumValueFromString<Protocol::Automation::InputSourceType>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Automation::InputSourceType::Null,
        (size_t)Protocol::Automation::InputSourceType::Mouse,
        (size_t)Protocol::Automation::InputSourceType::Keyboard,
        (size_t)Protocol::Automation::InputSourceType::Touch,
        (size_t)Protocol::Automation::InputSourceType::Wheel,
        (size_t)Protocol::Automation::InputSourceType::Pen,
    };
    for (size_t i = 0; i < 6; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Automation::InputSourceType)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::Automation::MouseMoveOrigin> parseEnumValueFromString<Protocol::Automation::MouseMoveOrigin>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Automation::MouseMoveOrigin::Viewport,
        (size_t)Protocol::Automation::MouseMoveOrigin::Pointer,
        (size_t)Protocol::Automation::MouseMoveOrigin::Element,
    };
    for (size_t i = 0; i < 3; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Automation::MouseMoveOrigin)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::Automation::AuthenticatorProtocol> parseEnumValueFromString<Protocol::Automation::AuthenticatorProtocol>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Automation::AuthenticatorProtocol::Ctap1_u2f,
        (size_t)Protocol::Automation::AuthenticatorProtocol::Ctap2,
        (size_t)Protocol::Automation::AuthenticatorProtocol::Ctap2_1,
    };
    for (size_t i = 0; i < 3; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Automation::AuthenticatorProtocol)constantValues[i];

    return std::nullopt;
}

template<> std::optional<Protocol::Automation::AuthenticatorTransport> parseEnumValueFromString<Protocol::Automation::AuthenticatorTransport>(const String& protocolString)
{
    static const size_t constantValues[] = {
        (size_t)Protocol::Automation::AuthenticatorTransport::Usb,
        (size_t)Protocol::Automation::AuthenticatorTransport::Nfc,
        (size_t)Protocol::Automation::AuthenticatorTransport::Ble,
        (size_t)Protocol::Automation::AuthenticatorTransport::Internal,
    };
    for (size_t i = 0; i < 4; ++i)
        if (protocolString == enum_constant_values[constantValues[i]])
            return (Protocol::Automation::AuthenticatorTransport)constantValues[i];

    return std::nullopt;
}

} // namespace AutomationHelpers



} // namespace Protocol

} // namespace Inspector
