;;; Guile-QuickCheck
;;; Copyright 2020 Timothy Sample <samplet@ngyro.com>
;;;
;;; This file is part of Guile-QuickCheck.
;;;
;;; Guile-QuickCheck is free software: you can redistribute it and/or
;;; modify it under the terms of the GNU General Public License as
;;; published by the Free Software Foundation, either version 3 of the
;;; License, or (at your option) any later version.
;;;
;;; Guile-QuickCheck is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with Guile-QuickCheck.  If not, see
;;; <https://www.gnu.org/licenses/>.

(define-module (quickcheck result)
  #:use-module (ice-9 match)
  #:use-module (srfi srfi-9 gnu)
  #:export (make-result
            <result>
            result?
            result-status
            result-stamps
            result-args
            result-success?
            result-failure?
            result-discard?
            boolean->result
            result-stamps-cons
            result-args-append))

(define-immutable-record-type <result>
  (make-result status stamps args)
  result?
  (status result-status)
  (stamps result-stamps set-result-stamps)
  (args result-args set-result-args))

(define (result-success? res)
  (match-let ((($ <result> status _ _) res)) 
    (eq? status 'success)))

(define (result-failure? res)
  (match-let ((($ <result> status _ _) res))
    (eq? status 'failure)))

(define (result-discard? res)
  (match-let ((($ <result> status _ _) res))
    (eq? status 'discard)))

(define (boolean->result b)
  (make-result (if b 'success 'failure) '() '()))

(define (result-stamps-cons stamp res)
  (set-result-stamps res (cons stamp (result-stamps res))))

(define (result-args-append args res)
  (set-result-args res (append args (result-args res))))
