/*
 * Decompiled with CFR 0.152.
 */
package com.zeroc.IceGridGUI.Application;

import com.zeroc.IceGrid.AdapterDescriptor;
import com.zeroc.IceGrid.DbEnvDescriptor;
import com.zeroc.IceGrid.PropertyDescriptor;
import com.zeroc.IceGrid.PropertySetDescriptor;
import com.zeroc.IceGrid.ServiceDescriptor;
import com.zeroc.IceGrid.TemplateDescriptor;
import com.zeroc.IceGridGUI.Application.Root;
import com.zeroc.IceGridGUI.Application.ServiceTemplate;
import com.zeroc.IceGridGUI.Application.Templates;
import com.zeroc.IceGridGUI.Application.UpdateFailedException;
import com.zeroc.IceGridGUI.ApplicationActions;
import com.zeroc.IceGridGUI.TreeNodeBase;
import com.zeroc.IceGridGUI.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JPopupMenu;

class ServiceTemplates
extends Templates {
    private Map<String, TemplateDescriptor> _descriptors;
    private static JPopupMenu _popup;

    public static Map<String, TemplateDescriptor> copyDescriptors(Map<String, TemplateDescriptor> descriptors) {
        HashMap<String, TemplateDescriptor> copy = new HashMap<String, TemplateDescriptor>();
        for (Map.Entry<String, TemplateDescriptor> p : descriptors.entrySet()) {
            copy.put(p.getKey(), ServiceTemplate.copyDescriptor(p.getValue()));
        }
        return copy;
    }

    @Override
    public boolean[] getAvailableActions() {
        boolean[] actions = new boolean[20];
        actions[12] = true;
        Object clipboard = this.getCoordinator().getClipboard();
        if (clipboard != null && clipboard instanceof TemplateDescriptor) {
            TemplateDescriptor d = (TemplateDescriptor)clipboard;
            actions[14] = d.descriptor instanceof ServiceDescriptor;
        }
        return actions;
    }

    @Override
    public JPopupMenu getPopupMenu() {
        ApplicationActions actions = this.getCoordinator().getActionsForPopup();
        if (_popup == null) {
            _popup = new JPopupMenu();
            _popup.add(actions.get(12));
        }
        actions.setTarget(this);
        return _popup;
    }

    @Override
    public void newTemplateService() {
        ServiceDescriptor sd = new ServiceDescriptor(new LinkedList<AdapterDescriptor>(), new PropertySetDescriptor(new String[0], new LinkedList<PropertyDescriptor>()), new LinkedList<DbEnvDescriptor>(), new String[0], "", "", "");
        this.newServiceTemplate(new TemplateDescriptor(sd, new LinkedList<String>(), new TreeMap<String, String>()));
    }

    @Override
    public void paste() {
        Object descriptor = this.getCoordinator().getClipboard();
        TemplateDescriptor td = (TemplateDescriptor)descriptor;
        this.newServiceTemplate(td);
    }

    ServiceTemplates(Root parent, Map<String, TemplateDescriptor> descriptors) throws UpdateFailedException {
        super(parent, "Service templates");
        this._descriptors = descriptors;
        for (Map.Entry<String, TemplateDescriptor> p : this._descriptors.entrySet()) {
            this.insertChild(new ServiceTemplate(false, this, p.getKey(), p.getValue()), false);
        }
    }

    @Override
    Utils.Resolver getResolver() {
        return null;
    }

    void newServiceTemplate(TemplateDescriptor descriptor) {
        ServiceTemplate t;
        block2: {
            String id = this.makeNewChildId("NewServiceTemplate");
            t = new ServiceTemplate(this, id, descriptor);
            try {
                this.insertChild(t, true);
            }
            catch (UpdateFailedException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        this.getRoot().setSelectedNode(t);
    }

    @Override
    void tryAdd(String newId, TemplateDescriptor descriptor) throws UpdateFailedException {
        this.insertChild(new ServiceTemplate(true, this, newId, descriptor), true);
        this._descriptors.put(newId, descriptor);
    }

    Map<String, TemplateDescriptor> getUpdates() {
        HashMap<String, TemplateDescriptor> updates = new HashMap<String, TemplateDescriptor>();
        for (TreeNodeBase p : this._children) {
            ServiceTemplate t = (ServiceTemplate)p;
            if (!t.getEditable().isNew() && !t.getEditable().isModified()) continue;
            updates.put(t.getId(), (TemplateDescriptor)t.getDescriptor());
        }
        return updates;
    }

    void commit() {
        this._editable.commit();
        for (TreeNodeBase p : this._children) {
            ServiceTemplate st = (ServiceTemplate)p;
            st.commit();
        }
    }

    void update(Map<String, TemplateDescriptor> descriptors, String[] removeTemplates) throws UpdateFailedException {
        this.removeChildren(removeTemplates);
        ArrayList<ServiceTemplate> newChildren = new ArrayList<ServiceTemplate>();
        LinkedList<ServiceTemplate> updatedChildren = new LinkedList<ServiceTemplate>();
        for (Map.Entry<String, TemplateDescriptor> p : descriptors.entrySet()) {
            String name = p.getKey();
            TemplateDescriptor templateDescriptor = p.getValue();
            ServiceTemplate child = (ServiceTemplate)this.findChild(name);
            if (child == null) {
                newChildren.add(new ServiceTemplate(false, this, name, templateDescriptor));
                continue;
            }
            child.rebuild(templateDescriptor);
            updatedChildren.add(child);
        }
        this.childrenChanged(updatedChildren);
        this.insertChildren(newChildren, true);
    }

    void removeDescriptor(String id) {
        this._descriptors.remove(id);
    }

    @Override
    Object getDescriptor() {
        return this._descriptors;
    }
}

