/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import org.apache.solr.api.EndPoint;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.handler.SolrConfigHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

public class GetConfigAPI {
    private final SolrConfigHandler configHandler;

    public GetConfigAPI(SolrConfigHandler configHandler) {
        this.configHandler = configHandler;
    }

    @EndPoint(path={"/config"}, method={SolrRequest.METHOD.GET}, permission=PermissionNameProvider.Name.CONFIG_READ_PERM)
    public void getAllConfig(SolrQueryRequest req, SolrQueryResponse rsp) {
        this.configHandler.handleRequest(req, rsp);
    }

    @EndPoint(path={"/config/params"}, method={SolrRequest.METHOD.GET}, permission=PermissionNameProvider.Name.CONFIG_READ_PERM)
    public void getAllParamSets(SolrQueryRequest req, SolrQueryResponse rsp) {
        this.configHandler.handleRequest(req, rsp);
    }

    @EndPoint(path={"/config/params/{paramset}"}, method={SolrRequest.METHOD.GET}, permission=PermissionNameProvider.Name.CONFIG_READ_PERM)
    public void getSingleParamSet(SolrQueryRequest req, SolrQueryResponse rsp) {
        this.configHandler.handleRequest(req, rsp);
    }

    @EndPoint(path={"/config/{component}"}, method={SolrRequest.METHOD.GET}, permission=PermissionNameProvider.Name.CONFIG_READ_PERM)
    public void getComponentConfig(SolrQueryRequest req, SolrQueryResponse rsp) {
        this.configHandler.handleRequest(req, rsp);
    }
}

