/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.sentiment;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import opennlp.tools.ml.BeamSearch;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.ml.model.SequenceClassificationModel;
import opennlp.tools.sentiment.SentimentFactory;
import opennlp.tools.util.BaseToolFactory;
import opennlp.tools.util.InvalidFormatException;
import opennlp.tools.util.model.BaseModel;

public class SentimentModel
extends BaseModel {
    private static final String COMPONENT_NAME = "SentimentME";
    private static final String SENTIMENT_MODEL_ENTRY_NAME = "sentiment.model";

    public SentimentModel(String languageCode, MaxentModel sentimentModel, Map<String, String> manifestInfoEntries, SentimentFactory factory) {
        super(COMPONENT_NAME, languageCode, manifestInfoEntries, (BaseToolFactory)factory);
        this.artifactMap.put(SENTIMENT_MODEL_ENTRY_NAME, sentimentModel);
        this.checkArtifactMap();
    }

    public SentimentModel(URL modelURL) throws IOException, InvalidFormatException {
        super(COMPONENT_NAME, modelURL);
    }

    public SentimentModel(File file) throws InvalidFormatException, IOException {
        super(COMPONENT_NAME, file);
    }

    @Deprecated
    public SequenceClassificationModel<String> getSentimentModel() {
        Properties manifest = (Properties)this.artifactMap.get("manifest.properties");
        String beamSizeString = manifest.getProperty("BeamSize");
        int beamSize = 3;
        if (beamSizeString != null) {
            beamSize = Integer.parseInt(beamSizeString);
        }
        return new BeamSearch(beamSize, (MaxentModel)this.artifactMap.get(SENTIMENT_MODEL_ENTRY_NAME));
    }

    public SentimentFactory getFactory() {
        return (SentimentFactory)this.toolFactory;
    }

    public MaxentModel getMaxentModel() {
        return (MaxentModel)this.artifactMap.get(SENTIMENT_MODEL_ENTRY_NAME);
    }
}

