/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.projection;

import java.util.EnumMap;
import org.apache.sis.internal.referencing.provider.ModifiedAzimuthalEquidistant;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.matrix.Matrix2;
import org.apache.sis.referencing.operation.projection.Initializer;
import org.apache.sis.referencing.operation.projection.NormalizedProjection;
import org.apache.sis.referencing.operation.projection.ProjectionException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.OperationMethod;

public class AzimuthalEquidistant
extends NormalizedProjection {
    private static final long serialVersionUID = -6969752149232210847L;
    final double sin\u03c60;
    final double cos\u03c60;

    private static Initializer initializer(OperationMethod operationMethod, Parameters parameters) {
        EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>> enumMap = new EnumMap<NormalizedProjection.ParameterRole, ParameterDescriptor<Double>>(NormalizedProjection.ParameterRole.class);
        enumMap.put(NormalizedProjection.ParameterRole.LATITUDE_OF_CONFORMAL_SPHERE_RADIUS, ModifiedAzimuthalEquidistant.LATITUDE_OF_ORIGIN);
        enumMap.put(NormalizedProjection.ParameterRole.CENTRAL_MERIDIAN, ModifiedAzimuthalEquidistant.LONGITUDE_OF_ORIGIN);
        enumMap.put(NormalizedProjection.ParameterRole.FALSE_EASTING, ModifiedAzimuthalEquidistant.FALSE_EASTING);
        enumMap.put(NormalizedProjection.ParameterRole.FALSE_NORTHING, ModifiedAzimuthalEquidistant.FALSE_NORTHING);
        return new Initializer(operationMethod, parameters, enumMap, null);
    }

    public AzimuthalEquidistant(OperationMethod operationMethod, Parameters parameters) {
        this(AzimuthalEquidistant.initializer(operationMethod, parameters));
    }

    AzimuthalEquidistant(Initializer initializer) {
        super(initializer, null);
        double d = Math.toRadians(initializer.getAndStore(ModifiedAzimuthalEquidistant.LATITUDE_OF_ORIGIN));
        this.cos\u03c60 = Math.cos(d);
        this.sin\u03c60 = Math.sin(d);
    }

    AzimuthalEquidistant(AzimuthalEquidistant azimuthalEquidistant) {
        super(null, azimuthalEquidistant);
        this.cos\u03c60 = azimuthalEquidistant.cos\u03c60;
        this.sin\u03c60 = azimuthalEquidistant.sin\u03c60;
    }

    @Override
    final String[] getInternalParameterNames() {
        return new String[]{"\u03c6\u2080"};
    }

    @Override
    final double[] getInternalParameterValues() {
        return new double[]{this.cos\u03c60 < 0.7853981633974483 ? Math.acos(this.cos\u03c60) : Math.asin(this.sin\u03c60)};
    }

    @Override
    public Matrix transform(double[] dArray, int n, double[] dArray2, int n2, boolean bl) throws ProjectionException {
        double d = dArray[n];
        double d2 = dArray[n + 1];
        double d3 = Math.cos(d);
        double d4 = Math.sin(d);
        double d5 = Math.cos(d2);
        double d6 = Math.sin(d2);
        double d7 = Math.min(1.0, Math.max(-1.0, this.sin\u03c60 * d6 + this.cos\u03c60 * d5 * d3));
        double d8 = Math.acos(d7);
        boolean bl2 = Math.abs(d8) < 1.5706706731410455E-9;
        double d9 = bl2 ? 1.0 : d8 / Math.sin(d8);
        double d10 = d5 * d3;
        double d11 = d5 * d4;
        double d12 = d9 * d11;
        double d13 = d9 * (this.cos\u03c60 * d6 - this.sin\u03c60 * d10);
        if (dArray2 != null) {
            dArray2[n2] = d12;
            dArray2[n2 + 1] = d13;
        }
        if (!bl) {
            return null;
        }
        double d14 = bl2 ? 0.3333333333333333 : (1.0 / d9 - d7) / (1.0 - d7 * d7);
        double d15 = d6 * d3;
        double d16 = d11 * this.cos\u03c60 * d14;
        double d17 = (this.cos\u03c60 * d15 - this.sin\u03c60 * d5) * d14;
        return new Matrix2(d12 * d16 + d9 * d10, d12 * d17 - d9 * d4 * d6, d13 * d16 + d12 * this.sin\u03c60, d13 * d17 + d9 * (this.sin\u03c60 * d15 + this.cos\u03c60 * d5));
    }

    @Override
    protected void inverseTransform(double[] dArray, int n, double[] dArray2, int n2) throws ProjectionException {
        double d = dArray[n];
        double d2 = dArray[n + 1];
        double d3 = Math.hypot(d, d2);
        double d4 = Math.sin(d3);
        double d5 = Math.cos(d3);
        dArray2[n2] = Math.atan2(d * d4, this.cos\u03c60 * d5 * d3 - this.sin\u03c60 * d4 * d2);
        dArray2[n2 + 1] = Math.asin(d3 == 0.0 ? this.sin\u03c60 : this.sin\u03c60 * d5 + this.cos\u03c60 * d4 * (d2 / d3));
    }
}

