/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.extraction;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class ExtractionRequest {
    public final String streamType;
    public final String resourceName;
    public final String contentType;
    public final String charset;
    public final String streamName;
    public final String streamSourceInfo;
    public final Long streamSize;
    public final String resourcePassword;
    public final LinkedHashMap<Pattern, String> passwordsMap;
    public final String extractFormat;
    public final boolean tikaServerRecursive;
    public final Integer tikaServerTimeoutSeconds;
    public final Map<String, String> tikaServerRequestHeaders = new HashMap<String, String>();

    private ExtractionRequest(String streamType, String resourceName, String contentType, String charset, String streamName, String streamSourceInfo, Long streamSize, String resourcePassword, LinkedHashMap<Pattern, String> passwordsMap, String extractFormat, boolean tikaServerRecursive, Integer tikaServerTimeoutSeconds, Map<String, String> tikaServerRequestHeaders) {
        this.streamType = streamType;
        this.resourceName = resourceName;
        this.contentType = contentType;
        this.charset = charset;
        this.streamName = streamName;
        this.streamSourceInfo = streamSourceInfo;
        this.streamSize = streamSize;
        this.resourcePassword = resourcePassword;
        this.passwordsMap = passwordsMap;
        this.extractFormat = extractFormat;
        this.tikaServerRecursive = tikaServerRecursive;
        this.tikaServerTimeoutSeconds = tikaServerTimeoutSeconds;
        if (tikaServerRequestHeaders != null) {
            this.tikaServerRequestHeaders.putAll(tikaServerRequestHeaders);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String streamType;
        private String resourceName;
        private String contentType;
        private String charset;
        private String streamName;
        private String streamSourceInfo;
        private Long streamSize;
        private String resourcePassword;
        private LinkedHashMap<Pattern, String> passwordsMap;
        private String extractFormat;
        private boolean tikaServerRecursive = false;
        private Integer tikaServerTimeoutSeconds;
        private Map<String, String> tikaServerRequestHeaders;

        private Builder() {
        }

        public Builder streamType(String streamType) {
            this.streamType = streamType;
            return this;
        }

        public Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder charset(String charset) {
            this.charset = charset;
            return this;
        }

        public Builder streamName(String streamName) {
            this.streamName = streamName;
            return this;
        }

        public Builder streamSourceInfo(String streamSourceInfo) {
            this.streamSourceInfo = streamSourceInfo;
            return this;
        }

        public Builder streamSize(Long streamSize) {
            this.streamSize = streamSize;
            return this;
        }

        public Builder resourcePassword(String resourcePassword) {
            this.resourcePassword = resourcePassword;
            return this;
        }

        public Builder passwordsMap(LinkedHashMap<Pattern, String> passwordsMap) {
            this.passwordsMap = passwordsMap;
            return this;
        }

        public Builder extractFormat(String extractFormat) {
            this.extractFormat = extractFormat;
            return this;
        }

        public Builder tikaServerRecursive(boolean tikaServerRecursive) {
            this.tikaServerRecursive = tikaServerRecursive;
            return this;
        }

        public Builder tikaServerTimeoutSeconds(Integer tikaServerTimeoutSeconds) {
            this.tikaServerTimeoutSeconds = tikaServerTimeoutSeconds;
            return this;
        }

        public Builder tikaServerRequestHeaders(Map<String, String> tikaServerRequestHeaders) {
            this.tikaServerRequestHeaders = tikaServerRequestHeaders;
            return this;
        }

        public ExtractionRequest build() {
            return new ExtractionRequest(this.streamType, this.resourceName, this.contentType, this.charset, this.streamName, this.streamSourceInfo, this.streamSize, this.resourcePassword, this.passwordsMap, this.extractFormat, this.tikaServerRecursive, this.tikaServerTimeoutSeconds, this.tikaServerRequestHeaders);
        }
    }
}

