"""create recomputable tables

Revision ID: 52ed4b839ab6
Revises: 34ee9496b788
Create Date: 2018-08-15 14:10:27.312487

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = '52ed4b839ab6'
down_revision = '34ee9496b788'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('category',
    sa.Column('cat_id', sa.Integer(), nullable=False),
    sa.Column('cat_title', sa.UnicodeText(), nullable=False),
    sa.Column('cat_pages', sa.Integer(), server_default='0', nullable=False),
    sa.Column('cat_subcats', sa.Integer(), server_default='0', nullable=False),
    sa.Column('cat_files', sa.Integer(), server_default='0', nullable=False),
    sa.PrimaryKeyConstraint('cat_id')
    )
    op.create_index('cat_pages', 'category', ['cat_pages'], unique=False)
    op.create_index('cat_title', 'category', ['cat_title'], unique=True)
    op.create_table('categorylinks',
    sa.Column('cl_from', sa.Integer(), nullable=False),
    sa.Column('cl_to', sa.UnicodeText(), nullable=False),
    sa.Column('cl_sortkey', sa.UnicodeText(), nullable=False),
    sa.Column('cl_sortkey_prefix', sa.UnicodeText(), nullable=False),
    sa.Column('cl_collation', sa.UnicodeText(), server_default='', nullable=False),
    sa.Column('cl_type', sa.Enum('page', 'subcat', 'file', name='cl_type'), server_default='page', nullable=False),
    sa.ForeignKeyConstraint(['cl_from'], ['page.page_id'], ondelete='CASCADE', initially='DEFERRED', deferrable=True)
    )
    op.create_table('externallinks',
    sa.Column('el_id', sa.Integer(), nullable=False),
    sa.Column('el_from', sa.Integer(), nullable=False),
    sa.Column('el_to', sa.UnicodeText(), nullable=False),
    sa.Column('el_index', sa.UnicodeText(), nullable=False),
    sa.ForeignKeyConstraint(['el_from'], ['page.page_id'], ondelete='CASCADE', initially='DEFERRED', deferrable=True),
    sa.PrimaryKeyConstraint('el_id')
    )
    op.create_table('imagelinks',
    sa.Column('il_from', sa.Integer(), nullable=False),
    sa.Column('il_from_namespace', sa.Integer(), nullable=False),
    sa.Column('il_to', sa.UnicodeText(), nullable=False),
    sa.CheckConstraint('il_from_namespace >= 0', name='check_namespace'),
    sa.ForeignKeyConstraint(['il_from'], ['page.page_id'], ondelete='CASCADE', initially='DEFERRED', deferrable=True),
    sa.ForeignKeyConstraint(['il_from_namespace'], ['namespace.ns_id'], )
    )
    op.create_table('iwlinks',
    sa.Column('iwl_from', sa.Integer(), nullable=False),
    sa.Column('iwl_prefix', sa.UnicodeText(), nullable=False),
    sa.Column('iwl_title', sa.UnicodeText(), nullable=False),
    sa.ForeignKeyConstraint(['iwl_from'], ['page.page_id'], ondelete='CASCADE', initially='DEFERRED', deferrable=True),
    sa.ForeignKeyConstraint(['iwl_prefix'], ['interwiki.iw_prefix'], ),
    sa.PrimaryKeyConstraint('iwl_from', 'iwl_prefix', 'iwl_title')
    )
    op.create_index('iwl_prefix_from_title', 'iwlinks', ['iwl_prefix', 'iwl_from', 'iwl_title'], unique=False)
    op.create_index('iwl_prefix_title_from', 'iwlinks', ['iwl_prefix', 'iwl_title', 'iwl_from'], unique=False)
    op.create_table('langlinks',
    sa.Column('ll_from', sa.Integer(), nullable=False),
    sa.Column('ll_lang', sa.UnicodeText(), nullable=False),
    sa.Column('ll_title', sa.UnicodeText(), nullable=False),
    sa.ForeignKeyConstraint(['ll_from'], ['page.page_id'], ondelete='CASCADE', initially='DEFERRED', deferrable=True),
    sa.PrimaryKeyConstraint('ll_from', 'll_lang')
    )
    op.create_index('il_lang_title', 'langlinks', ['ll_lang', 'll_title'], unique=False)
    op.create_table('pagelinks',
    sa.Column('pl_from', sa.Integer(), nullable=False),
    sa.Column('pl_namespace', sa.Integer(), nullable=False),
    sa.Column('pl_title', sa.UnicodeText(), nullable=False),
    sa.CheckConstraint('pl_namespace >= 0', name='check_namespace'),
    sa.ForeignKeyConstraint(['pl_from'], ['page.page_id'], ondelete='CASCADE', initially='DEFERRED', deferrable=True),
    sa.ForeignKeyConstraint(['pl_namespace'], ['namespace.ns_id'], ),
    sa.PrimaryKeyConstraint('pl_from', 'pl_namespace', 'pl_title')
    )
    op.create_table('redirect',
    sa.Column('rd_from', sa.Integer(), nullable=False),
    sa.Column('rd_namespace', sa.Integer(), nullable=False),
    sa.Column('rd_title', sa.UnicodeText(), nullable=False),
    sa.Column('rd_interwiki', sa.UnicodeText(), nullable=True),
    sa.Column('rd_fragment', sa.UnicodeText(), nullable=True),
    sa.CheckConstraint('rd_namespace >= 0', name='check_namespace'),
    sa.ForeignKeyConstraint(['rd_from'], ['page.page_id'], ondelete='CASCADE', initially='DEFERRED', deferrable=True),
    sa.ForeignKeyConstraint(['rd_interwiki'], ['interwiki.iw_prefix'], ),
    sa.ForeignKeyConstraint(['rd_namespace'], ['namespace.ns_id'], ),
    sa.PrimaryKeyConstraint('rd_from')
    )
    op.create_index('rd_namespace_title_from', 'redirect', ['rd_namespace', 'rd_title', 'rd_from'], unique=False)
    op.create_table('templatelinks',
    sa.Column('tl_from', sa.Integer(), nullable=False),
    sa.Column('tl_namespace', sa.Integer(), nullable=False),
    sa.Column('tl_title', sa.UnicodeText(), nullable=False),
    sa.CheckConstraint('tl_namespace >= 0', name='check_namespace'),
    sa.ForeignKeyConstraint(['tl_from'], ['page.page_id'], ondelete='CASCADE', initially='DEFERRED', deferrable=True),
    sa.ForeignKeyConstraint(['tl_namespace'], ['namespace.ns_id'], ),
    sa.PrimaryKeyConstraint('tl_from', 'tl_namespace', 'tl_title')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('templatelinks')
    op.drop_index('rd_namespace_title_from', table_name='redirect')
    op.drop_table('redirect')
    op.drop_table('pagelinks')
    op.drop_index('il_lang_title', table_name='langlinks')
    op.drop_table('langlinks')
    op.drop_index('iwl_prefix_title_from', table_name='iwlinks')
    op.drop_index('iwl_prefix_from_title', table_name='iwlinks')
    op.drop_table('iwlinks')
    op.drop_table('imagelinks')
    op.drop_table('externallinks')
    op.drop_table('categorylinks')
    op.drop_index('cat_title', table_name='category')
    op.drop_index('cat_pages', table_name='category')
    op.drop_table('category')
    # ### end Alembic commands ###
