/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.logging.Level;
import oracle.jdbc.OracleDatabaseException;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.CRC64;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIMsg;
import oracle.jdbc.internal.OracleConnection;

class T4CTTIoer11
extends T4CTTIMsg {
    private static final String CLASS_NAME = T4CTTIoer11.class.getName();
    final int MAXERRBUF = 512;
    long curRowNumber;
    long retCode;
    int arrayElemWError;
    int arrayElemErrno;
    int currCursorID;
    short errorPosition;
    short sqlType;
    byte oerFatal;
    short flags;
    short userCursorOpt;
    short upiParam;
    short warningFlag;
    int osError;
    short stmtNumber;
    short callNumber;
    int pad1;
    long successIters;
    int partitionId;
    int tableId;
    int slotNumber;
    long rba;
    long blockNumber;
    int warnLength = 0;
    int warnFlag = 0;
    int[] errorLength = new int[1];
    byte[] errorMsg;
    byte[] oerepa;
    int startErrorOffset;
    int endErrorOffset;
    int[] batchErrorOffsetArray = null;
    static final int OERFNCF = 32;
    static final int ORA1403 = 1403;
    private static final String _Copyright_2014_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;

    T4CTTIoer11(T4CConnection _conn) {
        super(_conn, (byte)4);
    }

    void init() {
        this.retCode = 0L;
        this.errorMsg = null;
        this.oerepa = null;
        this.startErrorOffset = 0;
        this.endErrorOffset = 0;
        this.batchErrorOffsetArray = null;
    }

    int unmarshal() throws IOException, SQLException {
        return this.unmarshal(false);
    }

    int unmarshal(boolean ignoreORA1403) throws IOException, SQLException {
        this.unmarshalAttributes();
        if (this.retCode != 0L) {
            if (this.retCode == 1403L && ignoreORA1403) {
                this.unmarshalErrorMessageAndIgnore();
            } else {
                this.unmarshalErrorMessage();
            }
        }
        return this.currCursorID;
    }

    void unmarshalErrorMessage() throws IOException, SQLException {
        this.errorMsg = this.meg.unmarshalCLR();
        this.errorLength[0] = this.errorMsg.length;
    }

    void unmarshalErrorMessageAndIgnore() throws IOException, SQLException {
        this.meg.unmarshalCLRAndIgnore();
        this.errorMsg = new byte[0];
        this.errorLength[0] = 0;
    }

    void unmarshalAttributes() throws IOException, SQLException {
        int oermarl;
        int oerepal;
        int maxBatchErrorOffsetArrayLen;
        if (this.connection.getTTCVersion() >= 3) {
            short _endToEndECIDSequenceNumber;
            this.connection.endToEndECIDSequenceNumber = _endToEndECIDSequenceNumber = (short)this.meg.unmarshalUB2();
        }
        this.curRowNumber = this.meg.unmarshalUB4();
        this.retCode = this.meg.unmarshalUB2();
        this.arrayElemWError = this.meg.unmarshalUB2();
        this.arrayElemErrno = this.meg.unmarshalUB2();
        this.currCursorID = this.meg.unmarshalUB2();
        this.errorPosition = this.meg.unmarshalSB2();
        this.sqlType = this.meg.unmarshalUB1();
        this.oerFatal = this.meg.unmarshalSB1();
        this.flags = this.meg.unmarshalSB1();
        this.userCursorOpt = this.meg.unmarshalSB1();
        this.upiParam = this.meg.unmarshalUB1();
        this.warningFlag = this.meg.unmarshalUB1();
        this.rba = this.meg.unmarshalUB4();
        this.partitionId = this.meg.unmarshalUB2();
        this.tableId = this.meg.unmarshalUB1();
        this.blockNumber = this.meg.unmarshalUB4();
        this.slotNumber = this.meg.unmarshalUB2();
        this.osError = this.meg.unmarshalSWORD();
        this.stmtNumber = this.meg.unmarshalUB1();
        this.callNumber = this.meg.unmarshalUB1();
        this.pad1 = this.meg.unmarshalUB2();
        this.successIters = this.meg.unmarshalUB4();
        this.meg.unmarshalDALC(this.connection.tmpBytes128, 0);
        byte[] oerrar = this.meg.unmarshalDALC();
        byte[] oerepaTemp = this.connection.tmpBytes128;
        if (oerrar != null && oerrar.length > 0 && (maxBatchErrorOffsetArrayLen = oerrar.length * 5) > this.connection.tmpBytes128.length) {
            oerepaTemp = new byte[maxBatchErrorOffsetArrayLen];
        }
        if ((oerepal = this.meg.unmarshalDALC(oerepaTemp, 0)) > 0) {
            if (oerepaTemp == this.connection.tmpBytes128) {
                this.oerepa = Arrays.copyOf(oerepaTemp, oerepaTemp.length);
            } else {
                this.oerepa = oerepaTemp;
                oerepaTemp = null;
            }
        } else {
            this.oerepa = null;
        }
        if (this.oerepa != null && oerrar.length > 0) {
            this.processBatchedErrors(oerrar.length);
        }
        if ((oermarl = (int)this.meg.unmarshalUB4()) > 0) {
            this.meg.unmarshalUB1();
            byte[][] extensionTextValues = new byte[oermarl][];
            int[] extensionTextValuesLength = new int[oermarl];
            byte[][] extensionBinaryValues = new byte[oermarl][];
            int[] extensionKeywords = new int[oermarl];
            this.meg.unmarshalKPDKV(extensionTextValues, extensionTextValuesLength, extensionBinaryValues, extensionKeywords);
        }
    }

    private void processBatchedErrors(int errorCount) {
        this.batchErrorOffsetArray = new int[errorCount];
        int position = this.getErrorOffset(this.oerepa, 0);
        this.batchErrorOffsetArray[0] = this.startErrorOffset;
        for (int i = 1; i < errorCount; ++i) {
            position = this.getErrorOffset(this.oerepa, position);
            this.batchErrorOffsetArray[i] = this.endErrorOffset;
        }
    }

    private int getErrorOffset(byte[] oerepa, int position) {
        int len;
        int startPosition = position;
        int errorOffset = 0;
        if (position < oerepa.length && (len = oerepa[position++] & 0xFF) + startPosition < oerepa.length) {
            if (len == 0) {
                errorOffset = 0;
            } else if (len == 1) {
                errorOffset = oerepa[position++] & 0xFF;
            } else if (len == 2) {
                errorOffset = (oerepa[position++] & 0xFF) << 8 | oerepa[position++] & 0xFF;
            } else if (len == 4) {
                errorOffset = (oerepa[position++] & 0xFF) << 24 | (oerepa[position++] & 0xFF) << 16 | (oerepa[position++] & 0xFF) << 8 | oerepa[position++] & 0xFF;
            }
        }
        if (startPosition == 0) {
            this.startErrorOffset = errorOffset;
        } else {
            this.endErrorOffset = errorOffset;
        }
        return position;
    }

    void unmarshalWarning() throws IOException, SQLException {
        this.retCode = this.meg.unmarshalUB2();
        this.warnLength = this.meg.unmarshalUB2();
        this.warnFlag = this.meg.unmarshalUB2();
        if (this.retCode != 0L && this.warnLength > 0) {
            this.errorMsg = this.meg.unmarshalCHR(this.warnLength);
            this.errorLength[0] = this.warnLength;
        }
    }

    void print() throws SQLException {
        if (this.retCode != 0L) {
            this.debugp(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "print", "**** Error Message: {0}", null, null, () -> {
                try {
                    return new Object[]{this.meg.conv.CharBytesToString(this.errorMsg, this.errorLength[0], true)};
                }
                catch (SQLException e) {
                    return new Object[]{"Got an exception generating debug message: " + e.getMessage()};
                }
            });
        } else if (this.warnFlag != 0) {
            this.debugp(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "print", "Warning Message: {0}", null, null, () -> {
                try {
                    return new Object[]{this.meg.conv.CharBytesToString(this.errorMsg, this.warnLength, true)};
                }
                catch (SQLException e) {
                    return new Object[]{"Got an exception generating debug message: " + e.getMessage()};
                }
            });
        }
    }

    void processError() throws SQLException {
        this.processError(true);
    }

    void processError(boolean throwException) throws SQLException {
        this.processError(throwException, null);
    }

    void processError(OracleStatement stmt) throws SQLException {
        this.processError(true, stmt);
    }

    void processError(boolean throwException, OracleStatement stmt) throws SQLException {
        int wrn;
        long errNum;
        if (stmt != null) {
            stmt.numberOfExecutedElementsInBatch = (int)this.successIters;
            stmt.indexOfFailedElementsInBatch = this.batchErrorOffsetArray;
        }
        if ((errNum = this.getRetCode()) != 0L) {
            this.debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "processError", "retCode = {0}", (String)null, (Throwable)null, (Object)errNum);
            this.debugp(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "processError", "errorMsg = {0}", null, null, () -> {
                try {
                    return new Object[]{this.meg.conv.CharBytesToString(this.errorMsg, this.errorLength[0], true)};
                }
                catch (SQLException e) {
                    return new Object[]{"Got an exception generating debug message: " + e.getMessage()};
                }
            });
            switch ((int)errNum) {
                case 28: 
                case 600: 
                case 1012: 
                case 1041: 
                case 3113: 
                case 3114: {
                    this.connection.internalClose();
                    break;
                }
                case 902: 
                case 21700: {
                    this.connection.removeAllDescriptor();
                    break;
                }
                case 41408: 
                case 41409: {
                    if ((this.flags & 0x10) != 16) break;
                    try {
                        this.connection.abort();
                    }
                    catch (Throwable exc) {
                        this.debug(Level.INFO, SecurityLabel.UNKNOWN, CLASS_NAME, "processError", "Error at OERFEXIT abort: {0}", (String)null, (Throwable)null, (Object)exc);
                    }
                    this.connection.internalClose();
                }
            }
            if (throwException) {
                SQLException sqlException = null;
                String message = this.meg.conv.CharBytesToString(this.errorMsg, this.errorLength[0], true);
                if ((int)errNum == 1008 && !message.contains("position 1") && message.contains(" was not provided")) {
                    StringBuilder messageBuilder = new StringBuilder(message);
                    messageBuilder.insert(messageBuilder.indexOf(" was not provided"), ":" + stmt.sqlObject.parameterList[0] + " (position 1)");
                    sqlException = (SQLException)DatabaseError.createSqlException(null, messageBuilder.toString(), (int)errNum).fillInStackTrace();
                } else {
                    sqlException = (SQLException)DatabaseError.createSqlException(null, message, (int)errNum).fillInStackTrace();
                }
                if (this.errorPosition >= 0 && stmt != null) {
                    sqlException.initCause(new OracleDatabaseException(this.errorPosition, (int)this.retCode, this.meg.conv.CharBytesToString(this.errorMsg, this.errorLength[0], true), stmt.sqlObject.actualSql, stmt.sqlObject.originalSql, stmt.isSqlRewritten()));
                }
                throw sqlException;
            }
            return;
        }
        if (!throwException) {
            return;
        }
        if ((this.warningFlag & 1) == 1 && (((wrn = this.warningFlag & 0xFFFFFFFE) & 0x20) == 32 || (wrn & 4) == 4)) {
            SQLException thrownWarning = DatabaseError.createInternallyHandledWarning();
            thrownWarning.fillInStackTrace();
            throw thrownWarning;
        }
        if (this.connection != null && this.connection.plsqlCompilerWarnings && (this.flags & 4) == 4) {
            stmt.foundPlsqlCompilerWarning();
        }
    }

    void processWarning() throws SQLException {
        if (this.retCode != 0L) {
            this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "processWarning", "retCode = {0}", (String)null, (Throwable)null, (Object)this.retCode);
            String warningMessgae = this.meg.conv.CharBytesToString(this.errorMsg, this.errorLength[0], true);
            this.debug(Level.WARNING, SecurityLabel.UNKNOWN, CLASS_NAME, "processWarning", "errorMsg = {0}", (String)null, (Throwable)null, (Object)warningMessgae);
            throw DatabaseError.newSqlWarning(warningMessgae, (int)this.retCode);
        }
    }

    long getCurRowNumber() throws SQLException {
        return this.curRowNumber;
    }

    long getRetCode() {
        return this.retCode;
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }

    long updateChecksum(long localCheckSum) throws SQLException {
        localCheckSum = CRC64.updateChecksum(localCheckSum, this.retCode);
        localCheckSum = CRC64.updateChecksum(localCheckSum, this.curRowNumber);
        localCheckSum = CRC64.updateChecksum(localCheckSum, this.errorPosition);
        localCheckSum = CRC64.updateChecksum(localCheckSum, this.sqlType);
        localCheckSum = CRC64.updateChecksum(localCheckSum, this.oerFatal);
        localCheckSum = CRC64.updateChecksum(localCheckSum, this.flags);
        localCheckSum = CRC64.updateChecksum(localCheckSum, this.userCursorOpt);
        localCheckSum = CRC64.updateChecksum(localCheckSum, this.upiParam);
        localCheckSum = CRC64.updateChecksum(localCheckSum, this.warningFlag);
        localCheckSum = CRC64.updateChecksum(localCheckSum, this.osError);
        localCheckSum = CRC64.updateChecksum(localCheckSum, this.successIters);
        localCheckSum = CRC64.updateChecksum(localCheckSum, this.errorMsg, 0, this.errorMsg.length);
        return localCheckSum;
    }
}

