﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/UUID.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ssm-guiconnect/SSMGuiConnectRequest.h>
#include <aws/ssm-guiconnect/SSMGuiConnect_EXPORTS.h>

#include <utility>

namespace Aws {
namespace SSMGuiConnect {
namespace Model {

/**
 */
class DeleteConnectionRecordingPreferencesRequest : public SSMGuiConnectRequest {
 public:
  AWS_SSMGUICONNECT_API DeleteConnectionRecordingPreferencesRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteConnectionRecordingPreferences"; }

  AWS_SSMGUICONNECT_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>User-provided idempotency token.</p>
   */
  inline const Aws::String& GetClientToken() const { return m_clientToken; }
  inline bool ClientTokenHasBeenSet() const { return m_clientTokenHasBeenSet; }
  template <typename ClientTokenT = Aws::String>
  void SetClientToken(ClientTokenT&& value) {
    m_clientTokenHasBeenSet = true;
    m_clientToken = std::forward<ClientTokenT>(value);
  }
  template <typename ClientTokenT = Aws::String>
  DeleteConnectionRecordingPreferencesRequest& WithClientToken(ClientTokenT&& value) {
    SetClientToken(std::forward<ClientTokenT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_clientToken{Aws::Utils::UUID::PseudoRandomUUID()};
  bool m_clientTokenHasBeenSet = true;
};

}  // namespace Model
}  // namespace SSMGuiConnect
}  // namespace Aws
