"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isEventHandler = exports.isAttributeShorthand = exports.isAttributeName = exports.isInTag = void 0;
function matchesOnly(type, only) {
    return (!only ||
        // We hide the detail that body/window are also like elements in the context of this usage
        (only === 'Element' && ['Element', 'Body', 'Window'].includes(type)) ||
        (only === 'InlineComponent' && type === 'InlineComponent'));
}
/**
 * Returns true if given node is a component or html element, or if the offset is at the end of the node
 * and its parent is a component or html element.
 */
function isInTag(node, offset) {
    return (node?.type === 'InlineComponent' ||
        node?.type === 'Element' ||
        (node?.end === offset &&
            (node?.parent?.type === 'InlineComponent' || node?.parent?.type === 'Element')));
}
exports.isInTag = isInTag;
/**
 * Returns when given node represents an HTML Attribute.
 * Example: The `class` in `<div class=".."`.
 * Note: This method returns `false` for shorthands like `<div {foo}`.
 */
function isAttributeName(node, only) {
    return !!node && node.type === 'Attribute' && matchesOnly(node.parent?.type, only);
}
exports.isAttributeName = isAttributeName;
/**
 * Returns when given node represents an HTML Attribute shorthand or is inside one.
 * Example: The `{foo}` in `<div {foo}`
 */
function isAttributeShorthand(node, only) {
    if (!node) {
        return false;
    }
    do {
        // We could get the expression, or the shorthand, or the attribute
        // Be pragmatic and just go upwards until we can't anymore
        if (isAttributeName(node, only)) {
            return true;
        }
        node = node.parent;
    } while (node);
    return false;
}
exports.isAttributeShorthand = isAttributeShorthand;
/**
 * Returns when given node represents an HTML Attribute shorthand or is inside one.
 * Example: The `on:click={foo}` in `<div on:click={foo}`
 */
function isEventHandler(node, only) {
    return !!node && node.type === 'EventHandler' && matchesOnly(node.parent?.type, only);
}
exports.isEventHandler = isEventHandler;
//# sourceMappingURL=svelte-ast-utils.js.map