#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 postgrest
version:              7.0.1
visibility:           public
id:                   postgrest-7.0.1-FmXKbjLeVrm9iiOtXXMfPS
key:                  postgrest-7.0.1-FmXKbjLeVrm9iiOtXXMfPS
license:              MIT
maintainer:           Steve Chavez <stevechavezast@gmail.com>
author:               Joe Nelson, Adam Baker, Steve Chavez
homepage:             https://postgrest.org
synopsis:             REST API for any Postgres database
description:
    Reads the schema of a PostgreSQL database and creates RESTful routes
    for the tables and views, supporting all HTTP verbs that security
    permits.

category:             Executable, PostgreSQL, Network APIs
abi:                  002332d58ce4412b11df2315dd123e13
exposed:              True
exposed-modules:
    PostgREST.ApiRequest PostgREST.App PostgREST.Auth PostgREST.Config
    PostgREST.DbRequestBuilder PostgREST.DbStructure PostgREST.Error
    PostgREST.Middleware PostgREST.OpenAPI PostgREST.Parsers
    PostgREST.QueryBuilder PostgREST.RangeQuery PostgREST.Statements
    PostgREST.Types

hidden-modules:
    Paths_postgrest PostgREST.Private.Common
    PostgREST.Private.QueryFragment

import-dirs:          /usr/lib/ghc-8.10.2/site-local/postgrest-7.0.1
library-dirs:         /usr/lib/ghc-8.10.2/site-local/postgrest-7.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/i386-linux-ghc-8.10.2/postgrest-7.0.1
hs-libraries:         HSpostgrest-7.0.1-FmXKbjLeVrm9iiOtXXMfPS
depends:
    HTTP-4000.3.15-2Ebke8lFvxnBFZ2SyBooix
    Ranged-sets-0.4.0-LBQ6MHocRCcIxUkm5j3sih
    aeson-1.5.4.1-KnFYQBtHaFk4DA2IEtMGGQ
    ansi-wl-pprint-0.6.9-L88pQgMvqV9AI2vRNcvzML base-4.14.1.0
    base64-bytestring-1.2.0.0-6dXdRY8I98f3BaVIcpr3co
    bytestring-0.10.10.0
    case-insensitive-1.2.1.0-6j421Scg55hFNBQMOoQNh8
    cassava-0.5.2.0-80SsF7MC6mPFYV0Oc3Z3DH
    configurator-pg-0.2.4-BqMqbQ0tnO4It5dvk3K7RZ containers-0.6.2.1
    contravariant-1.5.2-9cUYDQvrBi493NpHNvxLum
    contravariant-extras-0.3.5.2-Ldy95fwviRl4p3iLlHgIiK
    cookie-0.4.5-9B2dS5wCPmq3hZq3aUzZ9g
    either-5.0.1.1-8HRCWQRPznEDXF9UKiKOoX
    gitrev-1.3.1-Het0FatRKM8GuBdILU3orB
    hasql-1.4.4.2-Fs4AonJZKo8L7HEaQPBowM
    hasql-pool-0.5.2-6UXnvR1gKlBEeDnYiRaTiQ
    hasql-transaction-1.0.0.1-CIlMutabK0c6cYxtRuB8oe
    heredoc-0.2.0.0-7c17paDwj1PKOf07g81QlB
    http-types-0.12.3-FxLAfw9EIlw5rHRJhgWond
    insert-ordered-containers-0.2.3.1-ICDHtNKIcfgKhyjHEDcjYK
    interpolatedstring-perl6-1.0.2-ZmV0U2HF5JCvQNAdcxeUA
    jose-0.8.4-I7Iom1ysb7S9gqe4GotMls
    lens-4.19.2-J4C7iMA0wJqLc456sVCppx
    lens-aeson-1.1-IlI0Gv3OoY2FHzx67rWwNg
    network-uri-2.6.3.0-8tJyeRBDup92wNsuQRxrki
    optparse-applicative-0.15.1.0-6f95h1W3JYZMb1TESUiEr parsec-3.1.14.0
    protolude-0.3.0-LoKYjdf8jyCHuxedagwlOm
    regex-tdfa-1.3.1.0-AFxBgVqbB6pDA5wu8Xc5xC
    scientific-0.3.6.2-6esDBuVIamoCg8VHM8Dsd2
    swagger2-2.6-8x7wL0MrMCjIidN4KCaXhh text-1.2.3.2 time-1.9.3
    unordered-containers-0.2.13.0-Fo8OAKTvtDP9k6MoYlsfQq
    vector-0.12.1.2-IO5RJnkQnAxDAG50LdixTd
    wai-3.2.2.1-4aXUvXhxq8PJNiszMuAPDj
    wai-cors-0.2.7-BGWsir4syr7Ab5cpKFaIVV
    wai-extra-3.1.1-C11dfwl8hDU4tlGMaSAP0x
    wai-middleware-static-0.8.3-4xKNrNmNEPhGbkwsy1easY

haddock-interfaces:   /usr/share/doc/postgrest/html/postgrest.haddock
haddock-html:         /usr/share/doc/postgrest/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

