/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_nn extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ae = "avestisk";
        final String metaValue_ar = "arabisk";
        final String metaValue_bo = "tibetansk";
        final String metaValue_el = "gresk";
        final String metaValue_gu = "gujarati";
        final String metaValue_he = "hebraisk";
        final String metaValue_hy = "armensk";
        final String metaValue_ja = "japansk";
        final String metaValue_jv = "javanesisk";
        final String metaValue_ka = "georgisk";
        final String metaValue_km = "khmer";
        final String metaValue_kn = "kannada";
        final String metaValue_ko = "koreansk";
        final String metaValue_lo = "laotisk";
        final String metaValue_ml = "malayalam";
        final String metaValue_mn = "mongolsk";
        final String metaValue_my = "burmesisk";
        final String metaValue_or = "odia";
        final String metaValue_si = "singalesisk";
        final String metaValue_su = "sundanesisk";
        final String metaValue_te = "telugu";
        final String metaValue_th = "thai";
        final String metaValue_tl = "tagalog";
        final String metaValue_ban = "balinesisk";
        final String metaValue_bug = "buginesisk";
        final String metaValue_chr = "cherokee";
        final String metaValue_cop = "koptisk";
        final String metaValue_got = "gotisk";
        final String metaValue_nqo = "n\u2019ko";
        final String metaValue_pal = "pahlavi";
        final String metaValue_peo = "gammalpersisk";
        final String metaValue_phn = "f\u00f8nikisk";
        final String metaValue_uga = "ugaritisk";
        final String metaValue_vai = "vai";
        final String metaValue_zbl = "blissymbol";
        final Object[][] data = new Object[][] {
            { "ksh", "k\u00f8lnsk" },
            { "Ogam", "ogham" },
            { "mwl", "mirandesisk" },
            { "Zsym", "symbol" },
            { "cch", "atsam" },
            { "mwr", "marwari" },
            { "Tagb", "tagbanwa" },
            { "Zsye", "emoji" },
            { "%%NJIVA", "gniva- og njivadialekt" },
            { "egy", "gammalegyptisk" },
            { "raj", "rajasthani" },
            { "Phag", "phags-pa" },
            { "tem", "temne" },
            { "teo", "teso" },
            { "rap", "rapanui" },
            { "ter", "tereno" },
            { "AC", "Ascension" },
            { "rar", "rarotongansk" },
            { "tet", "tetum" },
            { "AD", "Andorra" },
            { "AE", "Dei sameinte arabiske emirata" },
            { "nl_BE", "flamsk" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua og Barbuda" },
            { "type.ca.ethiopic", "etiopisk kalender" },
            { "AI", "Anguilla" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "Teng", "tengwar" },
            { "AO", "Angola" },
            { "AQ", "Antarktis" },
            { "AR", "Argentina" },
            { "Prti", "inskripsjonsparthisk" },
            { "AS", "Amerikansk Samoa" },
            { "AT", "Austerrike" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "AX", "\u00c5land" },
            { "AZ", "Aserbajdsjan" },
            { "%%AREVELA", "austarmensk" },
            { "BA", "Bosnia-Hercegovina" },
            { "BB", "Barbados" },
            { "ceb", "cebuano" },
            { "BD", "Bangladesh" },
            { "kum", "kumyk" },
            { "BE", "Belgia" },
            { "gmh", "mellomh\u00f8gtysk" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "kut", "kutenai" },
            { "myv", "erzia" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Karibisk Nederland" },
            { "BR", "Brasil" },
            { "BS", "Bahamas" },
            { "xog", "soga" },
            { "BT", "Bhutan" },
            { "BV", "Bouvet\u00f8ya" },
            { "BW", "Botswana" },
            { "BY", "Kviterussland" },
            { "BZ", "Belize" },
            { "Visp", "synleg tale" },
            { "type.ca.persian", "persisk kalender" },
            { "type.nu.hebr", "hebraiske tal" },
            { "CA", "Canada" },
            { "CC", "Kokos\u00f8yane" },
            { "mzn", "mazanderani" },
            { "CD", "Kongo-Kinshasa" },
            { "CF", "Den sentralafrikanske republikken" },
            { "CG", "Kongo-Brazzaville" },
            { "CH", "Sveits" },
            { "CI", "Elfenbeinskysten" },
            { "CK", "Cook\u00f8yane" },
            { "CL", "Chile" },
            { "Kthi", "kaithisk" },
            { "CM", "Kamerun" },
            { "CN", "Kina" },
            { "CO", "Colombia" },
            { "CP", "Clipperton\u00f8ya" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Kapp Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Christmas\u00f8ya" },
            { "CY", "Kypros" },
            { "CZ", "Tsjekkia" },
            { "eka", "ekajuk" },
            { "DE", "Tyskland" },
            { "goh", "gammalh\u00f8gtysk" },
            { "ace", "achinesisk" },
            { "cgg", "kiga" },
            { "DG", "Diego Garcia" },
            { "type.nu.deva", "devanagari-siffer" },
            { "DJ", "Djibouti" },
            { "DK", "Danmark" },
            { "ach", "acoli" },
            { "gon", "gondi" },
            { "Brai", "punktskrift" },
            { "Brah", "brahmi" },
            { "DM", "Dominica" },
            { "type.nu.armnlow", "sm\u00e5 armenske tal" },
            { "DO", "Den dominikanske republikken" },
            { "gor", "gorontalo" },
            { "got", metaValue_got },
            { "Mtei", "meitei-mayek" },
            { "zun", "zuni" },
            { "tig", "tigr\u00e9" },
            { "DZ", "Algerie" },
            { "pag", "pangasinan" },
            { "pal", metaValue_pal },
            { "EA", "Ceuta og Melilla" },
            { "chb", "chibcha" },
            { "pam", "pampanga" },
            { "EC", "Ecuador" },
            { "pap", "papiamento" },
            { "ada", "adangme" },
            { "EE", "Estland" },
            { "tiv", "tivi" },
            { "EG", "Egypt" },
            { "EH", "Vest-Sahara" },
            { "chg", "tsjagataisk" },
            { "pau", "palauisk" },
            { "chk", "chuukesisk" },
            { "chn", "chinook" },
            { "chm", "mari" },
            { "chp", "chipewiansk" },
            { "cho", "choctaw" },
            { "chr", metaValue_chr },
            { "ER", "Eritrea" },
            { "ES", "Spania" },
            { "ET", "Etiopia" },
            { "EU", "EU" },
            { "elx", "elamite" },
            { "type.ca.gregorian", "gregoriansk kalender" },
            { "EZ", "eurosona" },
            { "chy", "cheyenne" },
            { "type.nu.gujr", "gujarati-siffer" },
            { "Inds", "indus" },
            { "ady", "adygeisk" },
            { "FI", "Finland" },
            { "FJ", "Fiji" },
            { "FK", "Falklands\u00f8yane" },
            { "FM", "Mikronesiaf\u00f8derasjonen" },
            { "FO", "F\u00e6r\u00f8yane" },
            { "Taml", "tamilsk" },
            { "FR", "Frankrike" },
            { "tkl", "tokelau" },
            { "grb", "grebo" },
            { "root", "rot" },
            { "type.ca.indian", "indisk nasjonalkalender" },
            { "grc", "gammalgresk" },
            { "GA", "Gabon" },
            { "vot", "votisk" },
            { "GB", "Storbritannia" },
            { "pcm", "nigeriansk pidgin" },
            { "GD", "Grenada" },
            { "GE", "Georgia" },
            { "GF", "Fransk Guyana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "Tale", "tai le" },
            { "GI", "Gibraltar" },
            { "afh", "afrihili" },
            { "GL", "Gr\u00f8nland" },
            { "enm", "mellomengelsk" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "Ekvatorial-Guinea" },
            { "GR", "Hellas" },
            { "GS", "S\u00f8r-Georgia og S\u00f8r-Sandwich\u00f8yene" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bissau" },
            { "tli", "tlingit" },
            { "tlh", "klingon" },
            { "Talu", "ny tai lue" },
            { "GY", "Guyana" },
            { "ckb", "sorani" },
            { "zxx", "utan spr\u00e5kleg innhald" },
            { "Vaii", metaValue_vai },
            { "HK", "Hongkong S.A.R. Kina" },
            { "HM", "Heard\u00f8ya og McDonald\u00f8yane" },
            { "HN", "Honduras" },
            { "HR", "Kroatia" },
            { "agq", "aghem" },
            { "gsw", "sveitsertysk" },
            { "HT", "Haiti" },
            { "HU", "Ungarn" },
            { "tmh", "tamasjek" },
            { "IC", "Kanari\u00f8yane" },
            { "peo", metaValue_peo },
            { "ID", "Indonesia" },
            { "IE", "Irland" },
            { "nap", "napolitansk" },
            { "naq", "nama" },
            { "zza", "zaza" },
            { "IL", "Israel" },
            { "IM", "Man" },
            { "IN", "India" },
            { "IO", "Det britiske territoriet I Indiahavet" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Island" },
            { "IT", "Italia" },
            { "Zmth", "matematisk notasjon" },
            { "type.nu.thai", "thailandske siffer" },
            { "%%POSIX", "dataspr\u00e5k" },
            { "type.nu.beng", "bengalske siffer" },
            { "JE", "Jersey" },
            { "type.ca.islamic", "islamsk kalender" },
            { "JM", "Jamaica" },
            { "Beng", "bengalsk" },
            { "JO", "Jordan" },
            { "JP", "Japan" },
            { "%%1606NICT", "nyare mellomfransk til 1606" },
            { "ain", "ainu" },
            { "guz", "gusii" },
            { "tog", "tonga (Nyasa)" },
            { "type.nu.knda", "kannada-siffer" },
            { "Kali", "kayah li" },
            { "type.ca.buddhist", "buddhistisk kalender" },
            { "KE", "Kenya" },
            { "419", "Latin-Amerika" },
            { "KG", "Kirgisistan" },
            { "KH", "Kambodsja" },
            { "KI", "Kiribati" },
            { "KM", "Komorane" },
            { "Knda", metaValue_kn },
            { "KN", "Saint Kitts og Nevis" },
            { "Zinh", "nedarva" },
            { "KP", "Nord-Korea" },
            { "KR", "S\u00f8r-Korea" },
            { "Plrd", "pollard-fonetisk" },
            { "KW", "Kuwait" },
            { "tpi", "tok pisin" },
            { "KY", "Cayman\u00f8yane" },
            { "KZ", "Kasakhstan" },
            { "Cyrl", "kyrillisk" },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "phn", metaValue_phn },
            { "LC", "St. Lucia" },
            { "Cyrs", "kyrillisk (kyrkjeslavisk variant)" },
            { "gwi", "gwichin" },
            { "nds", "l\u00e5gtysk" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "akk", "akkadisk" },
            { "cop", metaValue_cop },
            { "LR", "Liberia" },
            { "Phlv", metaValue_pal },
            { "LS", "Lesotho" },
            { "LT", "Litauen" },
            { "LU", "Luxembourg" },
            { "LV", "Latvia" },
            { "Kana", "katakana" },
            { "LY", "Libya" },
            { "lad", "ladino" },
            { "vun", "vunjo" },
            { "lah", "lahnda" },
            { "lag", "langi" },
            { "Thaa", "thaana" },
            { "MA", "Marokko" },
            { "MC", "Monaco" },
            { "MD", "Moldova" },
            { "ME", "Montenegro" },
            { "MF", "Saint Martin" },
            { "lam", "lamba" },
            { "MG", "Madagaskar" },
            { "Thai", metaValue_th },
            { "MH", "Marshall\u00f8yane" },
            { "ale", "aleutisk" },
            { "MK", "Makedonia" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "MN", "Mongolia" },
            { "new", "newari" },
            { "MO", "Macao S.A.R. Kina" },
            { "MP", "Nord-Marianane" },
            { "MQ", "Martinique" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "alt", "s\u00f8r-altaj" },
            { "MV", "Maldivane" },
            { "MW", "Malawi" },
            { "MX", "Mexico" },
            { "type.ca.japanese", "japansk kalender" },
            { "MY", "Malaysia" },
            { "MZ", "Mosambik" },
            { "Phli", "inskripsjonspahlavi" },
            { "NA", "Namibia" },
            { "type.ca.hebrew", "hebraisk kalender" },
            { "NC", "Ny-Caledonia" },
            { "NE", "Niger" },
            { "NF", "Norfolk\u00f8ya" },
            { "NG", "Nigeria" },
            { "trv", "taroko" },
            { "Phlp", "salmepahlavi" },
            { "NI", "Nicaragua" },
            { "Hmng", "pahawk hmong" },
            { "NL", "Nederland" },
            { "NO", "Noreg" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "Phnx", metaValue_phn },
            { "NU", "Niue" },
            { "rof", "rombo" },
            { "tsi", "tsimshian" },
            { "NZ", "New Zealand" },
            { "rom", "romani" },
            { "Mero", "meroitisk" },
            { "crh", "krimtatarisk" },
            { "ang", "gammalengelsk" },
            { "OM", "Oman" },
            { "anp", "angika" },
            { "crs", "seselwa (fransk-kreolsk)" },
            { "Xpeo", metaValue_peo },
            { "PA", "Panama" },
            { "type.ca.islamic-civil", "islamsk sivil kalender" },
            { "csb", "kasjubisk" },
            { "en_GB", "britisk engelsk" },
            { "PE", "Peru" },
            { "PF", "Fransk Polynesia" },
            { "PG", "Papua Ny-Guinea" },
            { "PH", "Filippinane" },
            { "PK", "Pakistan" },
            { "PL", "Polen" },
            { "ewo", "ewondo" },
            { "PM", "Saint-Pierre-et-Miquelon" },
            { "PN", "Pitcairn" },
            { "PR", "Puerto Rico" },
            { "Bali", metaValue_ban },
            { "PS", "Palestinsk territorium" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "nia", "nias" },
            { "type.nu.greklow", "sm\u00e5 greske tal" },
            { "PY", "Paraguay" },
            { "tum", "tumbuka" },
            { "Hebr", metaValue_he },
            { "QA", "Qatar" },
            { "%%SCOTLAND", "skotsk standard engelsk" },
            { "niu", "niuisk" },
            { "QO", "Ytre Oseania" },
            { "lez", "lezghian" },
            { "%%FONUPA", "det uralske fonetiske alfabetet UPA" },
            { "tvl", "tuvalu" },
            { "Tavt", "tai viet" },
            { "001", "verda" },
            { "002", "Afrika" },
            { "003", "Nord-Amerika" },
            { "RE", "R\u00e9union" },
            { "005", "S\u00f8r-Amerika" },
            { "jbo", "lojban" },
            { "Rjng", "rejang" },
            { "009", "Oseania" },
            { "RO", "Romania" },
            { "RS", "Serbia" },
            { "RU", "Russland" },
            { "RW", "Rwanda" },
            { "Ugar", metaValue_uga },
            { "Mani", "manikeisk" },
            { "Khar", "kharoshthi" },
            { "SA", "Saudi-Arabia" },
            { "pon", "ponapisk" },
            { "Mand", "mandaisk" },
            { "SB", "Salomon\u00f8yane" },
            { "twq", "tasawaq" },
            { "011", "Vest-Afrika" },
            { "SC", "Seychellane" },
            { "SD", "Sudan" },
            { "013", "Sentral-Amerika" },
            { "SE", "Sverige" },
            { "014", "Aust-Afrika" },
            { "arc", "arameisk" },
            { "015", "Nord-Afrika" },
            { "SG", "Singapore" },
            { "SH", "Saint Helena" },
            { "type.lb.strict", "streng lineskiftstil" },
            { "017", "Sentral-Afrika" },
            { "SI", "Slovenia" },
            { "018", "S\u00f8rlege Afrika" },
            { "SJ", "Svalbard og Jan Mayen" },
            { "019", "Amerika" },
            { "SK", "Slovakia" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "arn", "mapudungun" },
            { "arp", "arapaho" },
            { "type.nu.taml", "tamilske tal" },
            { "SR", "Surinam" },
            { "SS", "S\u00f8r-Sudan" },
            { "ST", "S\u00e3o Tom\u00e9 og Pr\u00edncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Syria" },
            { "yao", "yao" },
            { "SZ", "Swaziland" },
            { "arw", "arawak" },
            { "yap", "yapesisk" },
            { "TA", "Tristan da Cunha" },
            { "asa", "asu (Tanzania)" },
            { "type.ms.ussystem", "amerikansk m\u00e5lesystem" },
            { "021", "nordlege Amerika" },
            { "TC", "Turks- og Caicos\u00f8yane" },
            { "yav", "yangben" },
            { "TD", "Tsjad" },
            { "TF", "Dei franske s\u00f8rterritoria" },
            { "TG", "Togo" },
            { "TH", "Thailand" },
            { "TJ", "Tadsjikistan" },
            { "029", "Karibia" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste (Aust-Timor)" },
            { "ybb", "yemba" },
            { "TM", "Turkmenistan" },
            { "%%BOONT", "boontling" },
            { "TN", "Tunisia" },
            { "TO", "Tonga" },
            { "TR", "Tyrkia" },
            { "TT", "Trinidad og Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "ast", "asturisk" },
            { "Orkh", "orkhon" },
            { "TZ", "Tanzania" },
            { "nmg", "kwasio" },
            { "Zzzz", "ukjend skrift" },
            { "UA", "Ukraina" },
            { "rup", "arumensk" },
            { "030", "Aust-Asia" },
            { "tyv", "tuvinisk" },
            { "034", "S\u00f8r-Asia" },
            { "hai", "haida" },
            { "035", "S\u00f8raust-Asia" },
            { "UG", "Uganda" },
            { "type.co.pinyin", "pinyin-sortering" },
            { "039", "S\u00f8r-Europa" },
            { "Sinh", metaValue_si },
            { "UM", "USAs ytre sm\u00e5\u00f8yar" },
            { "UN", "SN" },
            { "US", "USA" },
            { "haw", "hawaiisk" },
            { "type.co.gb2312han", "forenkla kinesisk sortering" },
            { "UY", "Uruguay" },
            { "prg", "pr\u00f8yssisk" },
            { "UZ", "Usbekistan" },
            { "tzm", "sentral-tamazight" },
            { "type.co.stroke", "streksortering" },
            { "nnh", "ngiemboon" },
            { "VA", "Vatikanstaten" },
            { "pro", "gammalproven\u00e7alsk" },
            { "VC", "St. Vincent og Grenadinane" },
            { "VE", "Venezuela" },
            { "VG", "Dei britiske Jomfru\u00f8yane" },
            { "VI", "Dei amerikanske Jomfru\u00f8yane" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "nog", "nogai" },
            { "rwk", "rwa" },
            { "non", "gammalnorsk" },
            { "053", "Australasia" },
            { "%%AREVMDA", "vestarmensk" },
            { "054", "Melanesia" },
            { "WF", "Wallis og Futuna" },
            { "type.co.traditional", "tradisjonell sortering" },
            { "057", "Mikronesia" },
            { "jgo", "ngomba" },
            { "lkt", "lakota" },
            { "wae", "walsertysk" },
            { "WS", "Samoa" },
            { "wal", "wolaytta" },
            { "was", "washo" },
            { "war", "waray" },
            { "awa", "avadhi" },
            { "061", "Polynesia" },
            { "XK", "Kosovo" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "spr\u00e5k utan skrift" },
            { "Olck", "ol-chiki" },
            { "Batk", "batak" },
            { "Blis", metaValue_zbl },
            { "YE", "Jemen" },
            { "nqo", metaValue_nqo },
            { "type.co.standard", "standard sorteringsrekkjef\u00f8lgje" },
            { "fan", "fang" },
            { "%%ROZAJ", "resisk dialekt" },
            { "fat", "fanti" },
            { "Sgnw", "teiknskrift" },
            { "YT", "Mayotte" },
            { "ZA", "S\u00f8r-Afrika" },
            { "type.lb.loose", "laus lineskiftstil" },
            { "Deva", "devanagari" },
            { "type.nu.geor", "georgiske tal" },
            { "Hira", "hiragana" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "ukjent omr\u00e5de" },
            { "Runr", "runer" },
            { "type.ms.metric", "metrisk system" },
            { "type.ca.iso8601", "ISO 8601-kalender" },
            { "lol", "mongo" },
            { "nso", "nordsotho" },
            { "type.nu.telu", "telugu-siffer" },
            { "loz", "lozi" },
            { "jmc", "machame" },
            { "type.nu.hansfin", "forenkla kinesiske finanstal" },
            { "hil", "hiligaynon" },
            { "type.nu.arabext", "utvida arabisk-indiske siffer" },
            { "nus", "nuer" },
            { "dak", "dakota" },
            { "type.nu.fullwide", "siffer med full breidd" },
            { "hit", "hettittisk" },
            { "dar", "dargwa" },
            { "dav", "taita" },
            { "Maya", "maya-hieroglyfar" },
            { "lrc", "nord-lurisk" },
            { "Copt", metaValue_cop },
            { "nwc", "klassisk newarisk" },
            { "udm", "udmurt" },
            { "Khmr", metaValue_km },
            { "Limb", "lumbu" },
            { "sad", "sandawe" },
            { "type.nu.roman", "romartal" },
            { "sah", "sakha" },
            { "sam", "samaritansk arameisk" },
            { "%%SCOUSE", "scouse-dialekt" },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "Tfng", "tifinagh" },
            { "jpr", "j\u00f8depersisk" },
            { "sba", "ngambay" },
            { "Guru", "gurmukhi" },
            { "lua", "luba-lulua" },
            { "sbp", "sangu" },
            { "lui", "luiseno" },
            { "nyn", "nyankole" },
            { "nym", "nyamwezi" },
            { "lun", "lunda" },
            { "nyo", "nyoro" },
            { "luo", "luo" },
            { "fil", "filippinsk" },
            { "hmn", "hmong" },
            { "del", "delaware" },
            { "lus", "lushai" },
            { "bal", "baluchi" },
            { "den", "slavej" },
            { "ban", metaValue_ban },
            { "uga", metaValue_uga },
            { "luy", "olulujia" },
            { "bas", "basa" },
            { "bax", "bamun" },
            { "jrb", "j\u00f8dearabisk" },
            { "nzi", "nzima" },
            { "sco", "skotsk" },
            { "scn", "siciliansk" },
            { "aa", "afar" },
            { "ab", "abkhasisk" },
            { "ae", metaValue_ae },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "am", "amharisk" },
            { "Arab", metaValue_ar },
            { "an", "aragonsk" },
            { "%%SOLBA", "stolvizza- og solbicadialekt" },
            { "Jpan", metaValue_ja },
            { "ar", metaValue_ar },
            { "Hrkt", "japansk stavingsskrifter" },
            { "as", "assamesisk" },
            { "Lina", "line\u00e6r A" },
            { "av", "avarisk" },
            { "Linb", "line\u00e6r B" },
            { "ay", "aymara" },
            { "az", "aserbajdsjansk" },
            { "%%OSOJS", "oseacco- og osojanedialekt" },
            { "ba", "basjkirsk" },
            { "be", "kviterussisk" },
            { "bg", "bulgarsk" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", "bengali" },
            { "bo", metaValue_bo },
            { "dgr", "dogrib" },
            { "br", "bretonsk" },
            { "bs", "bosnisk" },
            { "Mymr", metaValue_my },
            { "type.nu.laoo", "laotiske siffer" },
            { "seh", "sena" },
            { "Nkoo", metaValue_nqo },
            { "sel", "selkupisk" },
            { "ca", "katalansk" },
            { "ses", "Koyraboro Senni" },
            { "ce", "tsjetsjensk" },
            { "ch", "chamorro" },
            { "%%REVISED", "revidert rettskriving" },
            { "co", "korsikansk" },
            { "Orya", metaValue_or },
            { "cr", "cree" },
            { "cs", "tsjekkisk" },
            { "cu", "kyrkjeslavisk" },
            { "cv", "tsjuvansk" },
            { "cy", "walisisk" },
            { "type.nu.ethi", "etiopiske tal" },
            { "Yiii", "yi" },
            { "da", "dansk" },
            { "de", "tysk" },
            { "type.cf.standard", "standard valutaformat" },
            { "bej", "beja" },
            { "din", "dinka" },
            { "Bugi", metaValue_bug },
            { "bem", "bemba" },
            { "sga", "gammalirsk" },
            { "dv", "divehi" },
            { "dz", "dzongkha" },
            { "bez", "bena (Tanzania)" },
            { "type.ca.chinese", "kinesisk kalender" },
            { "dje", "zarma" },
            { "type.nu.grek", "greske tal" },
            { "ee", "ewe" },
            { "type.lb.normal", "normal lineskiftstil" },
            { "ro_MD", "moldavisk" },
            { "el", metaValue_el },
            { "en", "engelsk" },
            { "eo", "esperanto" },
            { "type.co.big5han", "tradisjonell kinesisk sortering" },
            { "es", "spansk" },
            { "et", "estisk" },
            { "Hanb", "han med bopomofo" },
            { "eu", "baskisk" },
            { "Buhd", "buhid" },
            { "Hang", "hangul" },
            { "Samr", "samaritansk" },
            { "shi", "tachelhit" },
            { "hsb", "h\u00f8gsorbisk" },
            { "Hani", "han" },
            { "shn", "shan" },
            { "Hano", "hanunoo" },
            { "fa", "persisk" },
            { "Hans", "forenkla" },
            { "type.nu.latn", "vestlege siffer" },
            { "Hant", "tradisjonell" },
            { "ff", "fulfulde" },
            { "fi", "finsk" },
            { "fj", "fijiansk" },
            { "fon", "fon" },
            { "yue", "kantonesisk" },
            { "fo", "f\u00e6r\u00f8ysk" },
            { "umb", "umbundu" },
            { "fr", "fransk" },
            { "sid", "sidamo" },
            { "fy", "vestfrisisk" },
            { "ga", "irsk" },
            { "gd", "skotsk-g\u00e6lisk" },
            { "gl", "galicisk" },
            { "gn", "guarani" },
            { "bho", "bhojpuri" },
            { "und", "ukjent spr\u00e5k" },
            { "type.ca.ethiopic-amete-alem", "etiopisk amete-alem-kalender" },
            { "gu", metaValue_gu },
            { "gv", "manx" },
            { "ha", "hausa" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "hup", "hupa" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "ho", "hiri motu" },
            { "hr", "kroatisk" },
            { "ht", "haitisk" },
            { "hu", "ungarsk" },
            { "hy", metaValue_hy },
            { "hz", "herero" },
            { "%%FONIPA", "det internasjonale fonetiske alfabetet (IPA)" },
            { "ia", "interlingua" },
            { "Jamo", "jamo" },
            { "id", "indonesisk" },
            { "type.nu.tibt", "tibetanske siffer" },
            { "ie", "interlingue" },
            { "ig", "ibo" },
            { "ii", "sichuan-yi" },
            { "frm", "mellomfransk" },
            { "ik", "inupiak" },
            { "fro", "gammalfransk" },
            { "io", "ido" },
            { "frs", "austfrisisk" },
            { "frr", "nordfrisisk" },
            { "is", "islandsk" },
            { "it", "italiensk" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "Mlym", metaValue_ml },
            { "Sara", "sarati" },
            { "doi", "dogri" },
            { "sma", "s\u00f8rsamisk" },
            { "jv", metaValue_jv },
            { "Shaw", "shavisk" },
            { "mad", "maduresisk" },
            { "smj", "lulesamisk" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "smn", "enaresamisk" },
            { "ka", metaValue_ka },
            { "bla", "siksika" },
            { "mak", "makasar" },
            { "sms", "skoltesamisk" },
            { "man", "mandingo" },
            { "kg", "kikongo" },
            { "Goth", metaValue_got },
            { "ki", "kikuyu" },
            { "mas", "masai" },
            { "kj", "kuanyama" },
            { "kk", "kasakhisk" },
            { "kl", "gr\u00f8nlandsk (kalaallisut)" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "kanuri" },
            { "ks", "kasjmiri" },
            { "Cirt", "cirth" },
            { "Lepc", "lepcha" },
            { "Avst", metaValue_ae },
            { "ku", "kurdisk" },
            { "kv", "komi" },
            { "kw", "kornisk" },
            { "ky", "kirgisisk" },
            { "snk", "soninke" },
            { "la", "latin" },
            { "lb", "luxemburgsk" },
            { "type.nu.mlym", "malayalam-siffer" },
            { "lg", "ganda" },
            { "Roro", "rongorongo" },
            { "li", "limburgisk" },
            { "Tibt", metaValue_bo },
            { "ln", "lingala" },
            { "fur", "friulisk" },
            { "lo", metaValue_lo },
            { "type.ms.uksystem", "britisk m\u00e5lesystem" },
            { "lt", "litauisk" },
            { "lu", "luba-katanga" },
            { "lv", "latvisk" },
            { "sog", "sogdisk" },
            { "mg", "madagassisk" },
            { "mh", "marshallesisk" },
            { "type.co.ducet", "standard Unicode-sorteringsrekkjef\u00f8lgje" },
            { "mi", "maori" },
            { "mk", "makedonsk" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marathi" },
            { "ms", "malayisk" },
            { "mt", "maltesisk" },
            { "my", metaValue_my },
            { "Saur", "saurashtra" },
            { "Armn", metaValue_hy },
            { "mdf", "moksha" },
            { "dsb", "l\u00e5gsorbisk" },
            { "Armi", "armisk" },
            { "na", "nauru" },
            { "type.co.search", "generelt s\u00f8k" },
            { "nb", "bokm\u00e5l" },
            { "nd", "nord-ndebele" },
            { "ne", "nepalsk" },
            { "ng", "ndonga" },
            { "mdr", "mandar" },
            { "nl", "nederlandsk" },
            { "nn", "nynorsk" },
            { "no", "norsk" },
            { "nr", "s\u00f8r-ndebele" },
            { "nv", "navajo" },
            { "kaa", "karakalpakisk" },
            { "ny", "nyanja" },
            { "kac", "kachin" },
            { "kab", "kabyle" },
            { "%%POLYTON", "polytonisk rettskriving" },
            { "oc", "oksitansk" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "men", "mende" },
            { "oj", "ojibwa" },
            { "mer", "meru" },
            { "type.nu.armn", "armenske tal" },
            { "om", "oromo" },
            { "kaw", "kawi" },
            { "or", metaValue_or },
            { "os", "ossetisk" },
            { "kbd", "kabardisk" },
            { "mfe", "morisyen" },
            { "srn", "sranan tongo" },
            { "pa", "panjabi" },
            { "dua", "duala" },
            { "srr", "serer" },
            { "%%LIPAW", "resian, lipovazdialekt" },
            { "pi", "pali" },
            { "pl", "polsk" },
            { "dum", "mellomnederlandsk" },
            { "type.ca.dangi", "dangisk kalender" },
            { "ps", "pashto" },
            { "pt", "portugisisk" },
            { "mga", "mellomirsk" },
            { "key.co", "sorteringsrekkjef\u00f8lgje" },
            { "kcg", "tyap" },
            { "mgh", "Makhuwa-Meetto" },
            { "key.cf", "valutaformat" },
            { "bra", "braj" },
            { "key.ca", "kalender" },
            { "Laoo", metaValue_lo },
            { "mgo", "meta\u2019" },
            { "type.hc.h23", "24-timesystem (0\u201323)" },
            { "type.hc.h24", "24-timesystem (1\u201324)" },
            { "ssy", "saho" },
            { "type.nu.mymr", "burmesiske siffer" },
            { "qu", "quechua" },
            { "zap", "zapotec" },
            { "brx", "bodo" },
            { "Lana", "lanna" },
            { "kde", "makonde" },
            { "Ethi", "etiopisk" },
            { "type.hc.h12", "12-timesystem (1\u201312)" },
            { "type.hc.h11", "12-timesystem (0\u201311)" },
            { "rm", "retoromansk" },
            { "rn", "rundi" },
            { "key.cu", "valuta" },
            { "ro", "rumensk" },
            { "%%SAAHO", "saaho-dialekt" },
            { "type.nu.orya", "odia-siffer" },
            { "type.nu.hanidec", "kinesiske desimaltal" },
            { "ru", "russisk" },
            { "bss", "bakossi" },
            { "zbl", metaValue_zbl },
            { "rw", "kinjarwanda" },
            { "kea", "kabuverdianu" },
            { "mic", "micmac" },
            { "suk", "sukuma" },
            { "sa", "sanskrit" },
            { "sc", "sardinsk" },
            { "sus", "susu" },
            { "sd", "sindhi" },
            { "se", "nordsamisk" },
            { "min", "minangkabau" },
            { "sg", "sango" },
            { "sh", "serbokroatisk" },
            { "si", metaValue_si },
            { "sux", "sumerisk" },
            { "sk", "slovakisk" },
            { "sl", "slovensk" },
            { "sm", "samoansk" },
            { "sn", "shona" },
            { "so", "somali" },
            { "type.nu.arab", "arabisk-indiske siffer" },
            { "sq", "albansk" },
            { "sr", "serbisk" },
            { "ss", "swati" },
            { "type.cf.account", "valutaformat for rekneskapsf\u00f8ring" },
            { "Java", metaValue_jv },
            { "st", "s\u00f8rsotho" },
            { "su", metaValue_su },
            { "%%NEDIS", "natisonedialekt" },
            { "sv", "svensk" },
            { "sw", "swahili" },
            { "type.nu.hantfin", "tradisjonelle kinesiske finanstal" },
            { "ibb", "ibibio" },
            { "iba", "iban" },
            { "ta", "tamil" },
            { "142", "Asia" },
            { "bua", "burjatisk" },
            { "143", "Sentral-Asia" },
            { "te", metaValue_te },
            { "145", "Vest-Asia" },
            { "tg", "tadsjikisk" },
            { "th", metaValue_th },
            { "bug", metaValue_bug },
            { "ti", "tigrinja" },
            { "kfo", "koro" },
            { "tk", "turkmensk" },
            { "tl", metaValue_tl },
            { "tn", "tswana" },
            { "to", "tongansk" },
            { "dyo", "jola-fonyi" },
            { "type.nu.jpan", "japanske tal" },
            { "tr", "tyrkisk" },
            { "ts", "tsonga" },
            { "swb", "shimaore" },
            { "Cakm", "chakma" },
            { "tt", "tatarisk" },
            { "dyu", "dyula" },
            { "tw", "twi" },
            { "ty", "tahitisk" },
            { "%%BISKE", "san giorgio- og biladialekt" },
            { "150", "Europa" },
            { "151", "Aust-Europa" },
            { "154", "Nord-Europa" },
            { "dzg", "dazaga" },
            { "155", "Vest-Europa" },
            { "ug", "uigurisk" },
            { "Kore", metaValue_ko },
            { "Ital", "gammalitalisk" },
            { "Zyyy", "felles" },
            { "uk", "ukrainsk" },
            { "ur", "urdu" },
            { "%%1994", "standardisert resisk ortografi" },
            { "xal", "kalmykisk" },
            { "zen", "zenaga" },
            { "uz", "usbekisk" },
            { "kha", "khasi" },
            { "%%1996", "tysk ortografi fr\u00e5 1996" },
            { "nds_NL", "l\u00e5gsaksisk" },
            { "Sylo", "syloti nagri" },
            { "ve", "venda" },
            { "type.ca.roc", "kalender for Republikken Kina" },
            { "vi", "vietnamesisk" },
            { "kho", "khotanesisk" },
            { "khq", "koyra chiini" },
            { "key.hc", "timesyklus (12 eller 24)" },
            { "%%TARASK", "taraskievica-ortografi" },
            { "vo", "volapyk" },
            { "syc", "klassisk syrisk" },
            { "Osma", "osmanya" },
            { "quc", "k\u2019iche" },
            { "gaa", "ga" },
            { "wa", "vallonsk" },
            { "syr", "syrisk" },
            { "Grek", metaValue_el },
            { "Lydi", "lydisk" },
            { "Xsux", "sumero-akkadisk kileskrift" },
            { "wo", "wolof" },
            { "zgh", "standard marokkansk tamazight" },
            { "ar_001", "moderne standardarabisk" },
            { "Cans", "felles kanadiske urspr\u00e5ksstavingar" },
            { "gay", "gayo" },
            { "Mong", metaValue_mn },
            { "mnc", "mandsju" },
            { "Latf", "latinsk (frakturvariant)" },
            { "gba", "gbaya" },
            { "mni", "manipuri" },
            { "Latn", "latinsk" },
            { "Latg", "latinsk (g\u00e6lisk variant)" },
            { "type.nu.hans", "forenkla kinesiske tal" },
            { "type.nu.hant", "tradisjonelle kinesiske tal" },
            { "xh", "xhosa" },
            { "type.nu.romanlow", "sm\u00e5 romartal" },
            { "byn", "blin" },
            { "Lyci", "lykisk" },
            { "osa", "osage" },
            { "Moon", "moon" },
            { "moh", "mohawk" },
            { "kkj", "kako" },
            { "%%1694ACAD", "eldre nyfransk" },
            { "yi", "jiddisk" },
            { "mos", "mossi" },
            { "Syrc", "syriakisk" },
            { "Dsrt", "deseret" },
            { "yo", "joruba" },
            { "Syrj", "syriakisk (vestleg variant)" },
            { "ota", "ottomansk tyrkisk" },
            { "Syre", "syriakisk (estrangelo-variant)" },
            { "vai", metaValue_vai },
            { "za", "zhuang" },
            { "Cari", "karisk" },
            { "kln", "kalenjin" },
            { "zh", "kinesisk" },
            { "Bopo", "bopomofo" },
            { "Perm", "gammalpermisk" },
            { "key.lb", "lineskiftstil" },
            { "zu", "zulu" },
            { "type.co.phonebook", "telefonkatalogsortering" },
            { "%%MONOTON", "monotonisk rettskriving" },
            { "Geor", metaValue_ka },
            { "kmb", "kimbundu" },
            { "type.nu.jpanfin", "japanske finanstal" },
            { "Cham", "cham" },
            { "gez", "geez" },
            { "Syrn", "syriakisk (austleg variant)" },
            { "Tglg", metaValue_tl },
            { "Egyd", "egyptisk demotisk" },
            { "Egyh", "egyptisk hieratisk" },
            { "ebu", "embu" },
            { "Egyp", "egyptiske hieroglyfar" },
            { "Geok", "khutsuri (asomtavruli og nuskhuri)" },
            { "zh_Hans", "forenkla kinesisk" },
            { "Hung", "gammalungarsk" },
            { "kok", "konkani" },
            { "%%1901", "tradisjonell tysk ortografi" },
            { "kos", "kosraeansk" },
            { "zh_Hant", "tradisjonell kinesisk" },
            { "Sund", metaValue_su },
            { "kpe", "kpelle" },
            { "type.nu.khmr", "khmer-siffer" },
            { "ilo", "iloko" },
            { "%%VALENCIA", "valensisk dialekt" },
            { "Cprt", "kypriotisk" },
            { "%%BAKU1926", "samla tyrkisk-latinsk alfabet" },
            { "mua", "mundang" },
            { "type.nu.guru", "gurmukhi-siffer" },
            { "mul", "fleire spr\u00e5k" },
            { "cad", "caddo" },
            { "key.ms", "m\u00e5lesystem" },
            { "mus", "creek" },
            { "Glag", "glagolittisk" },
            { "gil", "gilbertese" },
            { "Cher", metaValue_chr },
            { "car", "carib" },
            { "type.nu.tamldec", "tamilske siffer" },
            { "krc", "karachay-balkar" },
            { "inh", "ingusjisk" },
            { "krl", "karelsk" },
            { "efi", "efik" },
            { "key.nu", "tal" },
            { "kru", "kurukh" },
            { "ksb", "shambala" },
            { "Telu", metaValue_te },
            { "ksf", "bafia" },
        };
        return data;
    }
}
