# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.open_gl_render_pass import OpenGLRenderPass


class ValuePass(OpenGLRenderPass):
    """
    ValuePass - Renders geometry using the values of a field array as
    fragment colors.
    
    Superclass: OpenGLRenderPass
    
    The output can be used for deferred color mapping. It supports using
    arrays of either point or cell data. The target array can be selected
    by setting an array name/id and a component number. Only opaque
    geometry is supported.
    
    There are two rendering modes available:
    
    * INVERTIBLE_LUT  Encodes array values as RGB data and renders the
      result to the default framebuffer.  It uses a texture as a color
      LUT to map the values to RGB data. Texture size constraints limit
      its precision (currently 12-bit). The implementation of this mode
      is in InternalsInvertible.
    
    * FLOATING_POINT  Renders actual array values as floating point data
      to an internal rgba32f framebuffer.  This class binds and unbinds
      the framebuffer on each render pass. Resources are allocated on
      demand. When rendering point data values are uploaded to the GPU as
    vertex attributes. When rendering cell data values are uploaded as a
      texture buffer. Custom vertex and fragment shaders are defined in
      order to adjust its behavior for either type of data.
    
    @sa
    RenderPass OpenGLRenderPass
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkValuePass, obj, update, **traits)
    
    rendering_mode = traits.Int(1, enter_set=True, auto_set=False, desc=\
        """
        
        """
    )

    def _rendering_mode_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetRenderingMode,
                        self.rendering_mode)

    def get_float_image_data(self, *args):
        """
        V.get_float_image_data(int, int, int, void)
        C++: void GetFloatImageData(int const format, int const width,
            int const height, void *data)
        Interface to get the rendered image in FLOATING_POINT mode.  Low
        level API, a format for the internal gl_read_pixels call can be
        specified. 'data' is expected to be allocated and cleaned-up by
        the caller.
        """
        ret = self._wrap_call(self._vtk_obj.GetFloatImageData, *args)
        return ret

    def get_float_image_data_array(self, *args):
        """
        V.get_float_image_data_array(Renderer) -> FloatArray
        C++: FloatArray *GetFloatImageDataArray(Renderer *ren)
        Interface to get the rendered image in FLOATING_POINT mode. 
        Returns a single component array containing the rendered values.
        \warning The returned array is owned by this class.
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.GetFloatImageDataArray, *my_args)
        return wrap_vtk(ret)

    def _get_float_image_extents(self):
        return self._vtk_obj.GetFloatImageExtents()
    float_image_extents = traits.Property(_get_float_image_extents, desc=\
        """
        Interface to get the rendered image in FLOATING_POINT mode. 
        Image extents of the value array.
        """
    )

    def color_to_value(self, *args):
        """
        V.color_to_value((int, ...), float, float, float)
        C++: void ColorToValue(unsigned char const *color,
            double const min, double const scale, double &value)
        Convert an RGB triplet to a floating point value. This method is
        exposed as a convenience function for testing (_test_value_pass2).
        """
        ret = self._wrap_call(self._vtk_obj.ColorToValue, *args)
        return ret

    def is_floating_point_mode_supported(self):
        """
        V.is_floating_point_mode_supported() -> bool
        C++: bool IsFloatingPointModeSupported()
        Check for extension support.
        """
        ret = self._vtk_obj.IsFloatingPointModeSupported()
        return ret
        

    def set_input_array_to_process(self, *args):
        """
        V.set_input_array_to_process(int, string)
        C++: void SetInputArrayToProcess(int fieldAssociation,
            const char *name)
        V.set_input_array_to_process(int, int)
        C++: void SetInputArrayToProcess(int fieldAssociation,
            int fieldId)"""
        ret = self._wrap_call(self._vtk_obj.SetInputArrayToProcess, *args)
        return ret

    def set_input_component_to_process(self, *args):
        """
        V.set_input_component_to_process(int)
        C++: void SetInputComponentToProcess(int component)"""
        ret = self._wrap_call(self._vtk_obj.SetInputComponentToProcess, *args)
        return ret

    def set_scalar_range(self, *args):
        """
        V.set_scalar_range(float, float)
        C++: void SetScalarRange(double min, double max)"""
        ret = self._wrap_call(self._vtk_obj.SetScalarRange, *args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('rendering_mode', 'GetRenderingMode'),
    ('active_draw_buffers', 'GetActiveDrawBuffers'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'active_draw_buffers',
    'rendering_mode'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ValuePass, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ValuePass properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['active_draw_buffers', 'rendering_mode']),
            title='Edit ValuePass properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ValuePass properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

