/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import org.jruby.MetaClass;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.ir.IRScope;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.runtime.ThreadContext;

public interface Compilable<T> {
    public void setCallCount(int var1);

    public void completeBuild(T var1);

    public IRScope getIRScope();

    public InterpreterContext ensureInstrsReady();

    default public String getOwnerName() {
        RubyModule implClass = this.getImplementationClass();
        return implClass == null ? null : Compilable.resolveFullName(implClass);
    }

    public String getName();

    public String getFile();

    public int getLine();

    public RubyModule getImplementationClass();

    @Deprecated
    default public String getClassName(ThreadContext context) {
        return this.getOwnerName();
    }

    public static String resolveFullName(RubyModule implementationClass) {
        MetaClass metaClass;
        RubyClass realClass;
        String className = implementationClass.isSingleton() ? ((realClass = (metaClass = (MetaClass)implementationClass).getRealClass()) == implementationClass.getRuntime().getClassClass() ? ((RubyClass)metaClass.getAttached()).getName() : realClass.getName()) : implementationClass.getName();
        return className;
    }
}

