/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.map;

import javax.swing.ImageIcon;
import tim.prune.gui.IconManager;
import tim.prune.gui.map.WpIconDefinition;

public abstract class WpIconLibrary {
    public static final int WAYPT_DEFAULT = 0;
    public static final int WAYPT_RING_POINT = 1;
    public static final int WAYPT_PLECTRUM = 2;
    public static final int WAYPT_CIRCLE = 3;
    public static final int WAYPT_PIN = 4;
    public static final int WAYPT_FLAG = 5;
    public static final int WAYPT_NUMBER_OF_ICONS = 6;
    public static final int SIZE_SMALL = 0;
    public static final int SIZE_MEDIUM = 1;
    public static final int SIZE_LARGE = 2;
    private static int[] _PIXEL_OFFSETS = null;

    static {
        int[] nArray = new int[36];
        nArray[6] = 8;
        nArray[7] = 15;
        nArray[8] = 11;
        nArray[9] = 21;
        nArray[10] = 14;
        nArray[11] = 27;
        nArray[12] = 9;
        nArray[13] = 17;
        nArray[14] = 12;
        nArray[15] = 23;
        nArray[16] = 14;
        nArray[17] = 28;
        nArray[18] = 8;
        nArray[19] = 8;
        nArray[20] = 12;
        nArray[21] = 12;
        nArray[22] = 15;
        nArray[23] = 15;
        nArray[24] = 3;
        nArray[25] = 16;
        nArray[26] = 4;
        nArray[27] = 22;
        nArray[28] = 4;
        nArray[29] = 28;
        nArray[30] = 2;
        nArray[31] = 17;
        nArray[32] = 3;
        nArray[33] = 22;
        nArray[34] = 4;
        nArray[35] = 28;
        _PIXEL_OFFSETS = nArray;
    }

    public static Integer[] getWaypointTypes() {
        return new Integer[]{0, 1, 2, 3, 4, 5};
    }

    public static String getIconName(int n) {
        switch (n) {
            case 1: {
                return "ringpt";
            }
            case 2: {
                return "plectrum";
            }
            case 3: {
                return "ring";
            }
            case 4: {
                return "pin";
            }
            case 5: {
                return "flag";
            }
        }
        return "default";
    }

    public static WpIconDefinition getIconDefinition(int n, int n2) {
        String string = WpIconLibrary.getIconName(n);
        String string2 = null;
        switch (n2) {
            case 0: {
                string2 = "_s";
                break;
            }
            case 1: {
                string2 = "_m";
                break;
            }
            case 2: {
                string2 = "_l";
                break;
            }
            default: {
                string2 = "_m";
                n2 = 1;
            }
        }
        int n3 = 0;
        int n4 = 0;
        try {
            n3 = _PIXEL_OFFSETS[n * 6 + n2 * 2];
            n4 = _PIXEL_OFFSETS[n * 6 + n2 * 2 + 1];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        WpIconDefinition wpIconDefinition = new WpIconDefinition(string, n3, n4);
        ImageIcon imageIcon = IconManager.getImageIcon("waypoints/wpicon_" + wpIconDefinition.getName() + string2);
        wpIconDefinition.setIcon(imageIcon);
        return wpIconDefinition;
    }
}

