/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import java.awt.Color;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Nation;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.model.ServerPlayer;

public class SetColorMessage
extends AttributeMessage {
    public static final String TAG = "setColor";
    private static final String COLOR_TAG = "color";
    private static final String NATION_TAG = "nation";

    public SetColorMessage(Nation nation, Color color) {
        super(TAG, NATION_TAG, nation.getId(), COLOR_TAG, String.valueOf(color.getRGB()));
    }

    public SetColorMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super(TAG, xr, NATION_TAG, COLOR_TAG);
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.NORMAL;
    }

    @Override
    public void clientHandler(FreeColClient freeColClient) {
        Game game = freeColClient.getGame();
        Specification spec = game.getSpecification();
        Nation nation = this.getNation(spec);
        Color color = this.getColor();
        if (nation == null) {
            logger.warning("Invalid nation: " + this.toString());
            return;
        }
        if (color == null) {
            logger.warning("Invalid color: " + this.toString());
            return;
        }
        this.pgc(freeColClient).setColorHandler(nation, color);
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        if (serverPlayer == null) {
            logger.warning("setColor from unknown connection");
        }
        Specification spec = freeColServer.getGame().getSpecification();
        Nation nation = this.getNation(spec);
        Color color = this.getColor();
        if (nation == null) {
            return serverPlayer.clientError("Invalid nation: " + this.toString());
        }
        if (color == null) {
            return serverPlayer.clientError("Invalid color: " + this.toString());
        }
        return this.pgc(freeColServer).setColor(serverPlayer, nation, color);
    }

    public Nation getNation(Specification spec) {
        return spec.getNation(this.getStringAttribute(NATION_TAG));
    }

    public Color getColor() {
        Color color = null;
        try {
            int rgb = this.getIntegerAttribute(COLOR_TAG, 0);
            color = new Color(rgb);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return color;
    }
}

