/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.elasticsearch.Version;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.FieldNamesFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.QueryShardContext;

public class ExistsQueryBuilder
extends AbstractQueryBuilder<ExistsQueryBuilder> {
    public static final String NAME = "exists";
    public static final ParseField FIELD_FIELD = new ParseField("field", new String[0]);
    private final String fieldName;

    public ExistsQueryBuilder(String fieldName) {
        if (Strings.isEmpty(fieldName)) {
            throw new IllegalArgumentException("field name is null or empty");
        }
        this.fieldName = fieldName;
    }

    public ExistsQueryBuilder(StreamInput in) throws IOException {
        super(in);
        this.fieldName = in.readString();
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeString(this.fieldName);
    }

    public String fieldName() {
        return this.fieldName;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.field(FIELD_FIELD.getPreferredName(), this.fieldName);
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static ExistsQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldPattern = null;
        String queryName = null;
        float boost = 1.0f;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token.isValue()) {
                if (FIELD_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    fieldPattern = parser.text();
                    continue;
                }
                if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    queryName = parser.text();
                    continue;
                }
                if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                    boost = parser.floatValue();
                    continue;
                }
                throw new ParsingException(parser.getTokenLocation(), "[exists] query does not support [" + currentFieldName + "]", new Object[0]);
            }
            throw new ParsingException(parser.getTokenLocation(), "[exists] unknown token [" + token + "] after [" + currentFieldName + "]", new Object[0]);
        }
        if (fieldPattern == null) {
            throw new ParsingException(parser.getTokenLocation(), "[exists] must be provided with a [field]", new Object[0]);
        }
        ExistsQueryBuilder builder = new ExistsQueryBuilder(fieldPattern);
        builder.queryName(queryName);
        builder.boost(boost);
        return builder;
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        return ExistsQueryBuilder.newFilter(context, this.fieldName);
    }

    public static Query newFilter(QueryShardContext context, String fieldPattern) {
        FieldNamesFieldMapper.FieldNamesFieldType fieldNamesFieldType = (FieldNamesFieldMapper.FieldNamesFieldType)context.getMapperService().fieldType("_field_names");
        if (fieldNamesFieldType == null) {
            return Queries.newMatchNoDocsQuery("Missing types in \"exists\" query.");
        }
        Set<String> fields = context.getObjectMapper(fieldPattern) != null ? Collections.singleton(fieldPattern) : context.simpleMatchToIndexNames(fieldPattern);
        if (context.indexVersionCreated().before(Version.V_6_1_0)) {
            return ExistsQueryBuilder.newLegacyExistsQuery(context, fields);
        }
        if (fields.size() == 1) {
            String field = (String)fields.iterator().next();
            return ExistsQueryBuilder.newFieldExistsQuery(context, field);
        }
        BooleanQuery.Builder boolFilterBuilder = new BooleanQuery.Builder();
        for (String field : fields) {
            boolFilterBuilder.add(ExistsQueryBuilder.newFieldExistsQuery(context, field), BooleanClause.Occur.SHOULD);
        }
        return new ConstantScoreQuery((Query)boolFilterBuilder.build());
    }

    private static Query newLegacyExistsQuery(QueryShardContext context, Collection<String> fields) {
        if (fields.size() == 1) {
            Query filter = ExistsQueryBuilder.newLegacyExistsQuery(context, fields.iterator().next());
            return new ConstantScoreQuery(filter);
        }
        BooleanQuery.Builder boolFilterBuilder = new BooleanQuery.Builder();
        for (String field : fields) {
            Query filter = ExistsQueryBuilder.newLegacyExistsQuery(context, field);
            boolFilterBuilder.add(filter, BooleanClause.Occur.SHOULD);
        }
        return new ConstantScoreQuery((Query)boolFilterBuilder.build());
    }

    private static Query newLegacyExistsQuery(QueryShardContext context, String field) {
        MappedFieldType fieldType = context.fieldMapper(field);
        String fieldName = fieldType != null ? fieldType.name() : field;
        return new TermQuery(new Term("_field_names", fieldName));
    }

    private static Query newFieldExistsQuery(QueryShardContext context, String field) {
        MappedFieldType fieldType = context.getMapperService().fieldType(field);
        if (fieldType == null) {
            if (context.getObjectMapper(field) != null) {
                return ExistsQueryBuilder.newObjectFieldExistsQuery(context, field);
            }
            return Queries.newMatchNoDocsQuery("No field \"" + field + "\" exists in mappings.");
        }
        Query filter = fieldType.existsQuery(context);
        return new ConstantScoreQuery(filter);
    }

    private static Query newObjectFieldExistsQuery(QueryShardContext context, String objField) {
        BooleanQuery.Builder booleanQuery = new BooleanQuery.Builder();
        Set<String> fields = context.simpleMatchToIndexNames(objField + ".*");
        for (String field : fields) {
            Query existsQuery = context.getMapperService().fieldType(field).existsQuery(context);
            booleanQuery.add(existsQuery, BooleanClause.Occur.SHOULD);
        }
        return new ConstantScoreQuery((Query)booleanQuery.build());
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.fieldName);
    }

    @Override
    protected boolean doEquals(ExistsQueryBuilder other) {
        return Objects.equals(this.fieldName, other.fieldName);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }
}

