﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/imagebuilder/Imagebuilder_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/DateTime.h>
#include <aws/imagebuilder/model/VulnerablePackage.h>
#include <aws/imagebuilder/model/CvssScore.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Json
{
  class JsonValue;
  class JsonView;
} // namespace Json
} // namespace Utils
namespace imagebuilder
{
namespace Model
{

  /**
   * <p>Information about package vulnerability findings.</p><p><h3>See Also:</h3>  
   * <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/imagebuilder-2019-12-02/PackageVulnerabilityDetails">AWS
   * API Reference</a></p>
   */
  class PackageVulnerabilityDetails
  {
  public:
    AWS_IMAGEBUILDER_API PackageVulnerabilityDetails();
    AWS_IMAGEBUILDER_API PackageVulnerabilityDetails(Aws::Utils::Json::JsonView jsonValue);
    AWS_IMAGEBUILDER_API PackageVulnerabilityDetails& operator=(Aws::Utils::Json::JsonView jsonValue);
    AWS_IMAGEBUILDER_API Aws::Utils::Json::JsonValue Jsonize() const;


    /**
     * <p>A unique identifier for this vulnerability.</p>
     */
    inline const Aws::String& GetVulnerabilityId() const{ return m_vulnerabilityId; }

    /**
     * <p>A unique identifier for this vulnerability.</p>
     */
    inline bool VulnerabilityIdHasBeenSet() const { return m_vulnerabilityIdHasBeenSet; }

    /**
     * <p>A unique identifier for this vulnerability.</p>
     */
    inline void SetVulnerabilityId(const Aws::String& value) { m_vulnerabilityIdHasBeenSet = true; m_vulnerabilityId = value; }

    /**
     * <p>A unique identifier for this vulnerability.</p>
     */
    inline void SetVulnerabilityId(Aws::String&& value) { m_vulnerabilityIdHasBeenSet = true; m_vulnerabilityId = std::move(value); }

    /**
     * <p>A unique identifier for this vulnerability.</p>
     */
    inline void SetVulnerabilityId(const char* value) { m_vulnerabilityIdHasBeenSet = true; m_vulnerabilityId.assign(value); }

    /**
     * <p>A unique identifier for this vulnerability.</p>
     */
    inline PackageVulnerabilityDetails& WithVulnerabilityId(const Aws::String& value) { SetVulnerabilityId(value); return *this;}

    /**
     * <p>A unique identifier for this vulnerability.</p>
     */
    inline PackageVulnerabilityDetails& WithVulnerabilityId(Aws::String&& value) { SetVulnerabilityId(std::move(value)); return *this;}

    /**
     * <p>A unique identifier for this vulnerability.</p>
     */
    inline PackageVulnerabilityDetails& WithVulnerabilityId(const char* value) { SetVulnerabilityId(value); return *this;}


    /**
     * <p>The packages that this vulnerability impacts.</p>
     */
    inline const Aws::Vector<VulnerablePackage>& GetVulnerablePackages() const{ return m_vulnerablePackages; }

    /**
     * <p>The packages that this vulnerability impacts.</p>
     */
    inline bool VulnerablePackagesHasBeenSet() const { return m_vulnerablePackagesHasBeenSet; }

    /**
     * <p>The packages that this vulnerability impacts.</p>
     */
    inline void SetVulnerablePackages(const Aws::Vector<VulnerablePackage>& value) { m_vulnerablePackagesHasBeenSet = true; m_vulnerablePackages = value; }

    /**
     * <p>The packages that this vulnerability impacts.</p>
     */
    inline void SetVulnerablePackages(Aws::Vector<VulnerablePackage>&& value) { m_vulnerablePackagesHasBeenSet = true; m_vulnerablePackages = std::move(value); }

    /**
     * <p>The packages that this vulnerability impacts.</p>
     */
    inline PackageVulnerabilityDetails& WithVulnerablePackages(const Aws::Vector<VulnerablePackage>& value) { SetVulnerablePackages(value); return *this;}

    /**
     * <p>The packages that this vulnerability impacts.</p>
     */
    inline PackageVulnerabilityDetails& WithVulnerablePackages(Aws::Vector<VulnerablePackage>&& value) { SetVulnerablePackages(std::move(value)); return *this;}

    /**
     * <p>The packages that this vulnerability impacts.</p>
     */
    inline PackageVulnerabilityDetails& AddVulnerablePackages(const VulnerablePackage& value) { m_vulnerablePackagesHasBeenSet = true; m_vulnerablePackages.push_back(value); return *this; }

    /**
     * <p>The packages that this vulnerability impacts.</p>
     */
    inline PackageVulnerabilityDetails& AddVulnerablePackages(VulnerablePackage&& value) { m_vulnerablePackagesHasBeenSet = true; m_vulnerablePackages.push_back(std::move(value)); return *this; }


    /**
     * <p>The source of the vulnerability information.</p>
     */
    inline const Aws::String& GetSource() const{ return m_source; }

    /**
     * <p>The source of the vulnerability information.</p>
     */
    inline bool SourceHasBeenSet() const { return m_sourceHasBeenSet; }

    /**
     * <p>The source of the vulnerability information.</p>
     */
    inline void SetSource(const Aws::String& value) { m_sourceHasBeenSet = true; m_source = value; }

    /**
     * <p>The source of the vulnerability information.</p>
     */
    inline void SetSource(Aws::String&& value) { m_sourceHasBeenSet = true; m_source = std::move(value); }

    /**
     * <p>The source of the vulnerability information.</p>
     */
    inline void SetSource(const char* value) { m_sourceHasBeenSet = true; m_source.assign(value); }

    /**
     * <p>The source of the vulnerability information.</p>
     */
    inline PackageVulnerabilityDetails& WithSource(const Aws::String& value) { SetSource(value); return *this;}

    /**
     * <p>The source of the vulnerability information.</p>
     */
    inline PackageVulnerabilityDetails& WithSource(Aws::String&& value) { SetSource(std::move(value)); return *this;}

    /**
     * <p>The source of the vulnerability information.</p>
     */
    inline PackageVulnerabilityDetails& WithSource(const char* value) { SetSource(value); return *this;}


    /**
     * <p>CVSS scores for one or more vulnerabilities that Amazon Inspector identified
     * for a package.</p>
     */
    inline const Aws::Vector<CvssScore>& GetCvss() const{ return m_cvss; }

    /**
     * <p>CVSS scores for one or more vulnerabilities that Amazon Inspector identified
     * for a package.</p>
     */
    inline bool CvssHasBeenSet() const { return m_cvssHasBeenSet; }

    /**
     * <p>CVSS scores for one or more vulnerabilities that Amazon Inspector identified
     * for a package.</p>
     */
    inline void SetCvss(const Aws::Vector<CvssScore>& value) { m_cvssHasBeenSet = true; m_cvss = value; }

    /**
     * <p>CVSS scores for one or more vulnerabilities that Amazon Inspector identified
     * for a package.</p>
     */
    inline void SetCvss(Aws::Vector<CvssScore>&& value) { m_cvssHasBeenSet = true; m_cvss = std::move(value); }

    /**
     * <p>CVSS scores for one or more vulnerabilities that Amazon Inspector identified
     * for a package.</p>
     */
    inline PackageVulnerabilityDetails& WithCvss(const Aws::Vector<CvssScore>& value) { SetCvss(value); return *this;}

    /**
     * <p>CVSS scores for one or more vulnerabilities that Amazon Inspector identified
     * for a package.</p>
     */
    inline PackageVulnerabilityDetails& WithCvss(Aws::Vector<CvssScore>&& value) { SetCvss(std::move(value)); return *this;}

    /**
     * <p>CVSS scores for one or more vulnerabilities that Amazon Inspector identified
     * for a package.</p>
     */
    inline PackageVulnerabilityDetails& AddCvss(const CvssScore& value) { m_cvssHasBeenSet = true; m_cvss.push_back(value); return *this; }

    /**
     * <p>CVSS scores for one or more vulnerabilities that Amazon Inspector identified
     * for a package.</p>
     */
    inline PackageVulnerabilityDetails& AddCvss(CvssScore&& value) { m_cvssHasBeenSet = true; m_cvss.push_back(std::move(value)); return *this; }


    /**
     * <p>Vulnerabilities that are often related to the findings for the package.</p>
     */
    inline const Aws::Vector<Aws::String>& GetRelatedVulnerabilities() const{ return m_relatedVulnerabilities; }

    /**
     * <p>Vulnerabilities that are often related to the findings for the package.</p>
     */
    inline bool RelatedVulnerabilitiesHasBeenSet() const { return m_relatedVulnerabilitiesHasBeenSet; }

    /**
     * <p>Vulnerabilities that are often related to the findings for the package.</p>
     */
    inline void SetRelatedVulnerabilities(const Aws::Vector<Aws::String>& value) { m_relatedVulnerabilitiesHasBeenSet = true; m_relatedVulnerabilities = value; }

    /**
     * <p>Vulnerabilities that are often related to the findings for the package.</p>
     */
    inline void SetRelatedVulnerabilities(Aws::Vector<Aws::String>&& value) { m_relatedVulnerabilitiesHasBeenSet = true; m_relatedVulnerabilities = std::move(value); }

    /**
     * <p>Vulnerabilities that are often related to the findings for the package.</p>
     */
    inline PackageVulnerabilityDetails& WithRelatedVulnerabilities(const Aws::Vector<Aws::String>& value) { SetRelatedVulnerabilities(value); return *this;}

    /**
     * <p>Vulnerabilities that are often related to the findings for the package.</p>
     */
    inline PackageVulnerabilityDetails& WithRelatedVulnerabilities(Aws::Vector<Aws::String>&& value) { SetRelatedVulnerabilities(std::move(value)); return *this;}

    /**
     * <p>Vulnerabilities that are often related to the findings for the package.</p>
     */
    inline PackageVulnerabilityDetails& AddRelatedVulnerabilities(const Aws::String& value) { m_relatedVulnerabilitiesHasBeenSet = true; m_relatedVulnerabilities.push_back(value); return *this; }

    /**
     * <p>Vulnerabilities that are often related to the findings for the package.</p>
     */
    inline PackageVulnerabilityDetails& AddRelatedVulnerabilities(Aws::String&& value) { m_relatedVulnerabilitiesHasBeenSet = true; m_relatedVulnerabilities.push_back(std::move(value)); return *this; }

    /**
     * <p>Vulnerabilities that are often related to the findings for the package.</p>
     */
    inline PackageVulnerabilityDetails& AddRelatedVulnerabilities(const char* value) { m_relatedVulnerabilitiesHasBeenSet = true; m_relatedVulnerabilities.push_back(value); return *this; }


    /**
     * <p>A link to the source of the vulnerability information.</p>
     */
    inline const Aws::String& GetSourceUrl() const{ return m_sourceUrl; }

    /**
     * <p>A link to the source of the vulnerability information.</p>
     */
    inline bool SourceUrlHasBeenSet() const { return m_sourceUrlHasBeenSet; }

    /**
     * <p>A link to the source of the vulnerability information.</p>
     */
    inline void SetSourceUrl(const Aws::String& value) { m_sourceUrlHasBeenSet = true; m_sourceUrl = value; }

    /**
     * <p>A link to the source of the vulnerability information.</p>
     */
    inline void SetSourceUrl(Aws::String&& value) { m_sourceUrlHasBeenSet = true; m_sourceUrl = std::move(value); }

    /**
     * <p>A link to the source of the vulnerability information.</p>
     */
    inline void SetSourceUrl(const char* value) { m_sourceUrlHasBeenSet = true; m_sourceUrl.assign(value); }

    /**
     * <p>A link to the source of the vulnerability information.</p>
     */
    inline PackageVulnerabilityDetails& WithSourceUrl(const Aws::String& value) { SetSourceUrl(value); return *this;}

    /**
     * <p>A link to the source of the vulnerability information.</p>
     */
    inline PackageVulnerabilityDetails& WithSourceUrl(Aws::String&& value) { SetSourceUrl(std::move(value)); return *this;}

    /**
     * <p>A link to the source of the vulnerability information.</p>
     */
    inline PackageVulnerabilityDetails& WithSourceUrl(const char* value) { SetSourceUrl(value); return *this;}


    /**
     * <p>The severity that the vendor assigned to this vulnerability type.</p>
     */
    inline const Aws::String& GetVendorSeverity() const{ return m_vendorSeverity; }

    /**
     * <p>The severity that the vendor assigned to this vulnerability type.</p>
     */
    inline bool VendorSeverityHasBeenSet() const { return m_vendorSeverityHasBeenSet; }

    /**
     * <p>The severity that the vendor assigned to this vulnerability type.</p>
     */
    inline void SetVendorSeverity(const Aws::String& value) { m_vendorSeverityHasBeenSet = true; m_vendorSeverity = value; }

    /**
     * <p>The severity that the vendor assigned to this vulnerability type.</p>
     */
    inline void SetVendorSeverity(Aws::String&& value) { m_vendorSeverityHasBeenSet = true; m_vendorSeverity = std::move(value); }

    /**
     * <p>The severity that the vendor assigned to this vulnerability type.</p>
     */
    inline void SetVendorSeverity(const char* value) { m_vendorSeverityHasBeenSet = true; m_vendorSeverity.assign(value); }

    /**
     * <p>The severity that the vendor assigned to this vulnerability type.</p>
     */
    inline PackageVulnerabilityDetails& WithVendorSeverity(const Aws::String& value) { SetVendorSeverity(value); return *this;}

    /**
     * <p>The severity that the vendor assigned to this vulnerability type.</p>
     */
    inline PackageVulnerabilityDetails& WithVendorSeverity(Aws::String&& value) { SetVendorSeverity(std::move(value)); return *this;}

    /**
     * <p>The severity that the vendor assigned to this vulnerability type.</p>
     */
    inline PackageVulnerabilityDetails& WithVendorSeverity(const char* value) { SetVendorSeverity(value); return *this;}


    /**
     * <p>The date and time when this vulnerability was first added to the vendor's
     * database.</p>
     */
    inline const Aws::Utils::DateTime& GetVendorCreatedAt() const{ return m_vendorCreatedAt; }

    /**
     * <p>The date and time when this vulnerability was first added to the vendor's
     * database.</p>
     */
    inline bool VendorCreatedAtHasBeenSet() const { return m_vendorCreatedAtHasBeenSet; }

    /**
     * <p>The date and time when this vulnerability was first added to the vendor's
     * database.</p>
     */
    inline void SetVendorCreatedAt(const Aws::Utils::DateTime& value) { m_vendorCreatedAtHasBeenSet = true; m_vendorCreatedAt = value; }

    /**
     * <p>The date and time when this vulnerability was first added to the vendor's
     * database.</p>
     */
    inline void SetVendorCreatedAt(Aws::Utils::DateTime&& value) { m_vendorCreatedAtHasBeenSet = true; m_vendorCreatedAt = std::move(value); }

    /**
     * <p>The date and time when this vulnerability was first added to the vendor's
     * database.</p>
     */
    inline PackageVulnerabilityDetails& WithVendorCreatedAt(const Aws::Utils::DateTime& value) { SetVendorCreatedAt(value); return *this;}

    /**
     * <p>The date and time when this vulnerability was first added to the vendor's
     * database.</p>
     */
    inline PackageVulnerabilityDetails& WithVendorCreatedAt(Aws::Utils::DateTime&& value) { SetVendorCreatedAt(std::move(value)); return *this;}


    /**
     * <p>The date and time when the vendor last updated this vulnerability in their
     * database.</p>
     */
    inline const Aws::Utils::DateTime& GetVendorUpdatedAt() const{ return m_vendorUpdatedAt; }

    /**
     * <p>The date and time when the vendor last updated this vulnerability in their
     * database.</p>
     */
    inline bool VendorUpdatedAtHasBeenSet() const { return m_vendorUpdatedAtHasBeenSet; }

    /**
     * <p>The date and time when the vendor last updated this vulnerability in their
     * database.</p>
     */
    inline void SetVendorUpdatedAt(const Aws::Utils::DateTime& value) { m_vendorUpdatedAtHasBeenSet = true; m_vendorUpdatedAt = value; }

    /**
     * <p>The date and time when the vendor last updated this vulnerability in their
     * database.</p>
     */
    inline void SetVendorUpdatedAt(Aws::Utils::DateTime&& value) { m_vendorUpdatedAtHasBeenSet = true; m_vendorUpdatedAt = std::move(value); }

    /**
     * <p>The date and time when the vendor last updated this vulnerability in their
     * database.</p>
     */
    inline PackageVulnerabilityDetails& WithVendorUpdatedAt(const Aws::Utils::DateTime& value) { SetVendorUpdatedAt(value); return *this;}

    /**
     * <p>The date and time when the vendor last updated this vulnerability in their
     * database.</p>
     */
    inline PackageVulnerabilityDetails& WithVendorUpdatedAt(Aws::Utils::DateTime&& value) { SetVendorUpdatedAt(std::move(value)); return *this;}


    /**
     * <p>Links to web pages that contain details about the vulnerabilities that Amazon
     * Inspector identified for the package.</p>
     */
    inline const Aws::Vector<Aws::String>& GetReferenceUrls() const{ return m_referenceUrls; }

    /**
     * <p>Links to web pages that contain details about the vulnerabilities that Amazon
     * Inspector identified for the package.</p>
     */
    inline bool ReferenceUrlsHasBeenSet() const { return m_referenceUrlsHasBeenSet; }

    /**
     * <p>Links to web pages that contain details about the vulnerabilities that Amazon
     * Inspector identified for the package.</p>
     */
    inline void SetReferenceUrls(const Aws::Vector<Aws::String>& value) { m_referenceUrlsHasBeenSet = true; m_referenceUrls = value; }

    /**
     * <p>Links to web pages that contain details about the vulnerabilities that Amazon
     * Inspector identified for the package.</p>
     */
    inline void SetReferenceUrls(Aws::Vector<Aws::String>&& value) { m_referenceUrlsHasBeenSet = true; m_referenceUrls = std::move(value); }

    /**
     * <p>Links to web pages that contain details about the vulnerabilities that Amazon
     * Inspector identified for the package.</p>
     */
    inline PackageVulnerabilityDetails& WithReferenceUrls(const Aws::Vector<Aws::String>& value) { SetReferenceUrls(value); return *this;}

    /**
     * <p>Links to web pages that contain details about the vulnerabilities that Amazon
     * Inspector identified for the package.</p>
     */
    inline PackageVulnerabilityDetails& WithReferenceUrls(Aws::Vector<Aws::String>&& value) { SetReferenceUrls(std::move(value)); return *this;}

    /**
     * <p>Links to web pages that contain details about the vulnerabilities that Amazon
     * Inspector identified for the package.</p>
     */
    inline PackageVulnerabilityDetails& AddReferenceUrls(const Aws::String& value) { m_referenceUrlsHasBeenSet = true; m_referenceUrls.push_back(value); return *this; }

    /**
     * <p>Links to web pages that contain details about the vulnerabilities that Amazon
     * Inspector identified for the package.</p>
     */
    inline PackageVulnerabilityDetails& AddReferenceUrls(Aws::String&& value) { m_referenceUrlsHasBeenSet = true; m_referenceUrls.push_back(std::move(value)); return *this; }

    /**
     * <p>Links to web pages that contain details about the vulnerabilities that Amazon
     * Inspector identified for the package.</p>
     */
    inline PackageVulnerabilityDetails& AddReferenceUrls(const char* value) { m_referenceUrlsHasBeenSet = true; m_referenceUrls.push_back(value); return *this; }

  private:

    Aws::String m_vulnerabilityId;
    bool m_vulnerabilityIdHasBeenSet = false;

    Aws::Vector<VulnerablePackage> m_vulnerablePackages;
    bool m_vulnerablePackagesHasBeenSet = false;

    Aws::String m_source;
    bool m_sourceHasBeenSet = false;

    Aws::Vector<CvssScore> m_cvss;
    bool m_cvssHasBeenSet = false;

    Aws::Vector<Aws::String> m_relatedVulnerabilities;
    bool m_relatedVulnerabilitiesHasBeenSet = false;

    Aws::String m_sourceUrl;
    bool m_sourceUrlHasBeenSet = false;

    Aws::String m_vendorSeverity;
    bool m_vendorSeverityHasBeenSet = false;

    Aws::Utils::DateTime m_vendorCreatedAt;
    bool m_vendorCreatedAtHasBeenSet = false;

    Aws::Utils::DateTime m_vendorUpdatedAt;
    bool m_vendorUpdatedAtHasBeenSet = false;

    Aws::Vector<Aws::String> m_referenceUrls;
    bool m_referenceUrlsHasBeenSet = false;
  };

} // namespace Model
} // namespace imagebuilder
} // namespace Aws
