﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/athena/Athena_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/athena/model/DataCatalogSummary.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace Athena
{
namespace Model
{
  class ListDataCatalogsResult
  {
  public:
    AWS_ATHENA_API ListDataCatalogsResult();
    AWS_ATHENA_API ListDataCatalogsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_ATHENA_API ListDataCatalogsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    /**
     * <p>A summary list of data catalogs.</p>
     */
    inline const Aws::Vector<DataCatalogSummary>& GetDataCatalogsSummary() const{ return m_dataCatalogsSummary; }

    /**
     * <p>A summary list of data catalogs.</p>
     */
    inline void SetDataCatalogsSummary(const Aws::Vector<DataCatalogSummary>& value) { m_dataCatalogsSummary = value; }

    /**
     * <p>A summary list of data catalogs.</p>
     */
    inline void SetDataCatalogsSummary(Aws::Vector<DataCatalogSummary>&& value) { m_dataCatalogsSummary = std::move(value); }

    /**
     * <p>A summary list of data catalogs.</p>
     */
    inline ListDataCatalogsResult& WithDataCatalogsSummary(const Aws::Vector<DataCatalogSummary>& value) { SetDataCatalogsSummary(value); return *this;}

    /**
     * <p>A summary list of data catalogs.</p>
     */
    inline ListDataCatalogsResult& WithDataCatalogsSummary(Aws::Vector<DataCatalogSummary>&& value) { SetDataCatalogsSummary(std::move(value)); return *this;}

    /**
     * <p>A summary list of data catalogs.</p>
     */
    inline ListDataCatalogsResult& AddDataCatalogsSummary(const DataCatalogSummary& value) { m_dataCatalogsSummary.push_back(value); return *this; }

    /**
     * <p>A summary list of data catalogs.</p>
     */
    inline ListDataCatalogsResult& AddDataCatalogsSummary(DataCatalogSummary&& value) { m_dataCatalogsSummary.push_back(std::move(value)); return *this; }


    /**
     * <p>A token generated by the Athena service that specifies where to continue
     * pagination if a previous request was truncated. To obtain the next set of pages,
     * pass in the NextToken from the response object of the previous page call.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }

    /**
     * <p>A token generated by the Athena service that specifies where to continue
     * pagination if a previous request was truncated. To obtain the next set of pages,
     * pass in the NextToken from the response object of the previous page call.</p>
     */
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }

    /**
     * <p>A token generated by the Athena service that specifies where to continue
     * pagination if a previous request was truncated. To obtain the next set of pages,
     * pass in the NextToken from the response object of the previous page call.</p>
     */
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }

    /**
     * <p>A token generated by the Athena service that specifies where to continue
     * pagination if a previous request was truncated. To obtain the next set of pages,
     * pass in the NextToken from the response object of the previous page call.</p>
     */
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }

    /**
     * <p>A token generated by the Athena service that specifies where to continue
     * pagination if a previous request was truncated. To obtain the next set of pages,
     * pass in the NextToken from the response object of the previous page call.</p>
     */
    inline ListDataCatalogsResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}

    /**
     * <p>A token generated by the Athena service that specifies where to continue
     * pagination if a previous request was truncated. To obtain the next set of pages,
     * pass in the NextToken from the response object of the previous page call.</p>
     */
    inline ListDataCatalogsResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}

    /**
     * <p>A token generated by the Athena service that specifies where to continue
     * pagination if a previous request was truncated. To obtain the next set of pages,
     * pass in the NextToken from the response object of the previous page call.</p>
     */
    inline ListDataCatalogsResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}


    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }

    
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }

    
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }

    
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }

    
    inline ListDataCatalogsResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}

    
    inline ListDataCatalogsResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}

    
    inline ListDataCatalogsResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}

  private:

    Aws::Vector<DataCatalogSummary> m_dataCatalogsSummary;

    Aws::String m_nextToken;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace Athena
} // namespace Aws
