/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AsnState {
    DEPROVISIONED("deprovisioned"),
    FAILED_DEPROVISION("failed-deprovision"),
    FAILED_PROVISION("failed-provision"),
    PENDING_DEPROVISION("pending-deprovision"),
    PENDING_PROVISION("pending-provision"),
    PROVISIONED("provisioned"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AsnState> VALUE_MAP;
    private final String value;

    private AsnState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AsnState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AsnState> knownValues() {
        EnumSet<AsnState> knownValues = EnumSet.allOf(AsnState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AsnState.class, AsnState::toString);
    }
}

