/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.gradle.api.attributes.Attribute;
import org.gradle.internal.Cast;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.isolation.Isolatable;
import org.gradle.internal.logging.text.TreeFormatter;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;
import org.gradle.internal.serialize.kryo.KryoBackedEncoder;
import org.gradle.internal.snapshot.ValueSnapshottingException;
import org.gradle.internal.snapshot.impl.ImplementationValue;
import org.gradle.internal.snapshot.impl.MapEntrySnapshot;
import org.gradle.internal.snapshot.impl.ValueSnapshotterSerializerRegistry;
import org.gradle.internal.state.Managed;
import org.jspecify.annotations.Nullable;

abstract class AbstractValueProcessor {
    private final List<ValueSnapshotterSerializerRegistry> valueSnapshotterSerializerRegistryList;

    protected AbstractValueProcessor(List<ValueSnapshotterSerializerRegistry> valueSnapshotterSerializerRegistryList) {
        this.valueSnapshotterSerializerRegistryList = valueSnapshotterSerializerRegistryList;
    }

    protected <T> T processValue(@Nullable Object value, ValueVisitor<T> visitor) {
        if (value == null) {
            return visitor.nullValue();
        }
        if (value instanceof String) {
            return visitor.stringValue((String)value);
        }
        if (value instanceof Boolean) {
            return visitor.booleanValue((Boolean)value);
        }
        if (value instanceof List) {
            return this.processList((List)value, visitor);
        }
        if (value instanceof Enum) {
            return visitor.enumValue((Enum)value);
        }
        if (value instanceof Class) {
            return visitor.classValue((Class)value);
        }
        Class<?> valueClass = value.getClass();
        if (valueClass.equals(File.class)) {
            return visitor.fileValue((File)value);
        }
        if (value instanceof Number) {
            if (value instanceof Integer) {
                return visitor.integerValue((Integer)value);
            }
            if (value instanceof Long) {
                return visitor.longValue((Long)value);
            }
            if (value instanceof Short) {
                return visitor.shortValue((Short)value);
            }
        }
        if (value instanceof Set) {
            return this.processSet((Set)value, visitor);
        }
        if (value instanceof Map) {
            return this.processMap((Map)value, visitor);
        }
        if (valueClass.isArray()) {
            return this.processArray(value, visitor);
        }
        if (value instanceof Attribute) {
            return visitor.attributeValue((Attribute)value);
        }
        if (value instanceof Managed) {
            return this.processManaged((Managed)value, visitor);
        }
        if (value instanceof Isolatable) {
            return visitor.fromIsolatable((Isolatable)value);
        }
        if (value instanceof HashCode) {
            return visitor.hashCode((HashCode)value);
        }
        if (value instanceof ImplementationValue) {
            ImplementationValue implementationValue = (ImplementationValue)value;
            return visitor.implementationValue(implementationValue.getImplementationClassIdentifier(), implementationValue.getValue());
        }
        for (ValueSnapshotterSerializerRegistry registry : this.valueSnapshotterSerializerRegistryList) {
            if (!registry.canSerialize(valueClass)) continue;
            return AbstractValueProcessor.gradleSerialization(value, registry.build(valueClass), visitor);
        }
        return AbstractValueProcessor.javaSerialization(value, visitor);
    }

    private <T> T processManaged(Managed managed, ValueVisitor<T> visitor) {
        if (managed.isImmutable()) {
            return visitor.managedImmutableValue(managed);
        }
        T state = this.processValue(managed.unpackState(), visitor);
        return visitor.managedValue(managed, state);
    }

    private <T> T processMap(Map<?, ?> map, ValueVisitor<T> visitor) {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)map.size());
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            builder.add((Object)new MapEntrySnapshot(this.processValue(entry.getKey(), visitor), this.processValue(entry.getValue(), visitor)));
        }
        if (map instanceof Properties) {
            return visitor.properties(builder.build());
        }
        return visitor.map(builder.build());
    }

    private <T> T processSet(Set<?> set, ValueVisitor<T> visitor) {
        ImmutableSet.Builder builder = ImmutableSet.builderWithExpectedSize((int)set.size());
        for (Object element : set) {
            builder.add(this.processValue(element, visitor));
        }
        return visitor.set(builder.build());
    }

    private <T> T processList(List<?> value, ValueVisitor<T> visitor) {
        if (value.isEmpty()) {
            return visitor.emptyList();
        }
        return visitor.list(this.processListElements(value, visitor));
    }

    private <T> ImmutableList<T> processListElements(List<?> list, ValueVisitor<T> visitor) {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)list.size());
        for (Object element : list) {
            builder.add(this.processValue(element, visitor));
        }
        return builder.build();
    }

    private <T> T processArray(Object value, ValueVisitor<T> visitor) {
        Class<?> componentType = value.getClass().getComponentType();
        int length = Array.getLength(value);
        if (length == 0) {
            return visitor.emptyArray(componentType);
        }
        if (componentType.isPrimitive()) {
            return visitor.primitiveArray(value);
        }
        return visitor.array(this.processArrayElements(value, length, visitor), componentType);
    }

    private <T> ImmutableList<T> processArrayElements(Object array, int length, ValueVisitor<T> visitor) {
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)length);
        for (int i = 0; i < length; ++i) {
            Object element = Array.get(array, i);
            builder.add(this.processValue(element, visitor));
        }
        return builder.build();
    }

    private static <T> T gradleSerialization(Object value, Serializer<?> serializer, ValueVisitor<T> visitor) {
        return visitor.gradleSerialized(value, AbstractValueProcessor.gradleSerialized(value, serializer));
    }

    private static byte[] gradleSerialized(Object value, Serializer serializer) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (KryoBackedEncoder encoder = new KryoBackedEncoder((OutputStream)outputStream);){
            serializer.write((Encoder)encoder, Cast.uncheckedCast((Object)value));
            encoder.flush();
        }
        catch (Exception e) {
            throw AbstractValueProcessor.newValueSerializationException(value.getClass(), e);
        }
        return outputStream.toByteArray();
    }

    private static <T> T javaSerialization(Object value, ValueVisitor<T> visitor) {
        return visitor.javaSerialized(value, AbstractValueProcessor.javaSerialized(value));
    }

    private static byte[] javaSerialized(Object value) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = new ObjectOutputStream(outputStream);){
            oos.writeObject(value);
            oos.flush();
        }
        catch (IOException e) {
            throw AbstractValueProcessor.newValueSerializationException(value.getClass(), e);
        }
        return outputStream.toByteArray();
    }

    private static ValueSnapshottingException newValueSerializationException(Class<?> valueType, Throwable cause) {
        TreeFormatter formatter = new TreeFormatter();
        formatter.node("Could not serialize value of type ");
        formatter.appendType(valueType);
        return new ValueSnapshottingException(formatter.toString(), cause);
    }

    protected static interface ValueVisitor<T> {
        public T nullValue();

        public T stringValue(String var1);

        public T booleanValue(Boolean var1);

        public T enumValue(Enum<?> var1);

        public T classValue(Class<?> var1);

        public T implementationValue(String var1, Object var2);

        public T fileValue(File var1);

        public T integerValue(Integer var1);

        public T longValue(Long var1);

        public T shortValue(Short var1);

        public T hashCode(HashCode var1);

        public T attributeValue(Attribute<?> var1);

        public T managedValue(Managed var1, T var2);

        public T managedImmutableValue(Managed var1);

        public T fromIsolatable(Isolatable<?> var1);

        public T emptyArray(Class<?> var1);

        public T array(ImmutableList<T> var1, Class<?> var2);

        public T primitiveArray(Object var1);

        public T emptyList();

        public T list(ImmutableList<T> var1);

        public T set(ImmutableSet<T> var1);

        public T map(ImmutableList<MapEntrySnapshot<T>> var1);

        public T properties(ImmutableList<MapEntrySnapshot<T>> var1);

        public T gradleSerialized(Object var1, byte[] var2);

        public T javaSerialized(Object var1, byte[] var2);
    }
}

