/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.internal.build.event.BuildEventListenerFactory;
import org.gradle.internal.build.event.BuildEventSubscriptions;
import org.gradle.internal.build.event.OperationResultPostProcessor;
import org.gradle.internal.build.event.OperationResultPostProcessorFactory;
import org.gradle.internal.operations.BuildOperationAncestryTracker;
import org.gradle.internal.operations.BuildOperationIdFactory;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.tooling.events.OperationType;
import org.gradle.tooling.internal.provider.runner.BuildOperationMapper;
import org.gradle.tooling.internal.provider.runner.BuildPhaseOperationListener;
import org.gradle.tooling.internal.provider.runner.ClientBuildEventGenerator;
import org.gradle.tooling.internal.provider.runner.ClientForwardingBuildOperationListener;
import org.gradle.tooling.internal.provider.runner.ClientForwardingTestMetadataOperationListener;
import org.gradle.tooling.internal.provider.runner.ClientForwardingTestOutputOperationListener;
import org.gradle.tooling.internal.provider.runner.FileDownloadOperationMapper;
import org.gradle.tooling.internal.provider.runner.OperationDependenciesResolver;
import org.gradle.tooling.internal.provider.runner.PluginApplicationTracker;
import org.gradle.tooling.internal.provider.runner.ProgressEventConsumer;
import org.gradle.tooling.internal.provider.runner.ProjectConfigurationOperationMapper;
import org.gradle.tooling.internal.provider.runner.ProjectConfigurationTracker;
import org.gradle.tooling.internal.provider.runner.TaskForTestEventTracker;
import org.gradle.tooling.internal.provider.runner.TaskOperationMapper;
import org.gradle.tooling.internal.provider.runner.TaskOriginTracker;
import org.gradle.tooling.internal.provider.runner.TestOperationMapper;
import org.gradle.tooling.internal.provider.runner.TransformOperationMapper;
import org.gradle.tooling.internal.provider.runner.WorkItemOperationMapper;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class ToolingApiBuildEventListenerFactory
implements BuildEventListenerFactory {
    private final BuildOperationAncestryTracker ancestryTracker;
    private final BuildOperationIdFactory idFactory;
    private final List<OperationResultPostProcessorFactory> postProcessorFactories;

    ToolingApiBuildEventListenerFactory(BuildOperationAncestryTracker ancestryTracker, BuildOperationIdFactory idFactory, List<OperationResultPostProcessorFactory> postProcessorFactories) {
        this.ancestryTracker = ancestryTracker;
        this.idFactory = idFactory;
        this.postProcessorFactories = postProcessorFactories;
    }

    public Iterable<Object> createListeners(BuildEventSubscriptions subscriptions, BuildEventConsumer consumer) {
        if (!subscriptions.isAnyOperationTypeRequested()) {
            return ImmutableList.of();
        }
        ProgressEventConsumer progressEventConsumer = new ProgressEventConsumer(consumer, this.ancestryTracker);
        ImmutableList.Builder listeners = ImmutableList.builder();
        if (subscriptions.isRequested(OperationType.TEST) && subscriptions.isRequested(OperationType.TEST_OUTPUT)) {
            listeners.add((Object)new ClientForwardingTestOutputOperationListener(progressEventConsumer, this.idFactory));
        }
        if (subscriptions.isRequested(OperationType.TEST) && subscriptions.isRequested(OperationType.TEST_METADATA)) {
            listeners.add((Object)new ClientForwardingTestMetadataOperationListener(progressEventConsumer, this.idFactory));
        }
        if (subscriptions.isRequested(OperationType.BUILD_PHASE)) {
            listeners.add((Object)new BuildPhaseOperationListener(progressEventConsumer, this.idFactory));
        }
        listeners.add((Object)this.createClientBuildEventGenerator(subscriptions, consumer, progressEventConsumer));
        return listeners.build();
    }

    private ClientBuildEventGenerator createClientBuildEventGenerator(BuildEventSubscriptions subscriptions, BuildEventConsumer consumer, ProgressEventConsumer progressEventConsumer) {
        BuildOperationListener buildListener = this.createBuildOperationListener(subscriptions, progressEventConsumer);
        OperationDependenciesResolver operationDependenciesResolver = new OperationDependenciesResolver();
        PluginApplicationTracker pluginApplicationTracker = new PluginApplicationTracker(this.ancestryTracker);
        TaskForTestEventTracker testTaskTracker = new TaskForTestEventTracker(this.ancestryTracker);
        ProjectConfigurationTracker projectConfigurationTracker = new ProjectConfigurationTracker(this.ancestryTracker, pluginApplicationTracker);
        TaskOriginTracker taskOriginTracker = new TaskOriginTracker(pluginApplicationTracker);
        TransformOperationMapper transformOperationMapper = new TransformOperationMapper(operationDependenciesResolver);
        operationDependenciesResolver.addLookup(transformOperationMapper);
        List<OperationResultPostProcessor> postProcessors = this.createPostProcessors(subscriptions, consumer);
        TaskOperationMapper taskOperationMapper = new TaskOperationMapper(postProcessors, taskOriginTracker, operationDependenciesResolver);
        operationDependenciesResolver.addLookup(taskOperationMapper);
        ImmutableList mappers = ImmutableList.of((Object)new FileDownloadOperationMapper(), (Object)new TestOperationMapper(testTaskTracker), (Object)new ProjectConfigurationOperationMapper(projectConfigurationTracker), (Object)taskOperationMapper, (Object)transformOperationMapper, (Object)new WorkItemOperationMapper());
        return new ClientBuildEventGenerator(progressEventConsumer, subscriptions, (List<? extends BuildOperationMapper<?, ?>>)mappers, buildListener);
    }

    private List<OperationResultPostProcessor> createPostProcessors(BuildEventSubscriptions subscriptions, BuildEventConsumer consumer) {
        return (List)this.postProcessorFactories.stream().map(factory -> factory.createProcessors(subscriptions, consumer)).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
    }

    private BuildOperationListener createBuildOperationListener(BuildEventSubscriptions subscriptions, ProgressEventConsumer progressEventConsumer) {
        return new ClientForwardingBuildOperationListener(progressEventConsumer, subscriptions, () -> new OperationIdentifier(this.idFactory.nextId()));
    }
}

