﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/waf-regional/WAFRegionalRequest.h>
#include <aws/waf-regional/WAFRegional_EXPORTS.h>
#include <aws/waf-regional/model/LoggingConfiguration.h>

#include <utility>

namespace Aws {
namespace WAFRegional {
namespace Model {

/**
 */
class PutLoggingConfigurationRequest : public WAFRegionalRequest {
 public:
  AWS_WAFREGIONAL_API PutLoggingConfigurationRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "PutLoggingConfiguration"; }

  AWS_WAFREGIONAL_API Aws::String SerializePayload() const override;

  AWS_WAFREGIONAL_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The Amazon Kinesis Data Firehose that contains the inspected traffic
   * information, the redacted fields details, and the Amazon Resource Name (ARN) of
   * the web ACL to monitor.</p>  <p>When specifying <code>Type</code> in
   * <code>RedactedFields</code>, you must use one of the following values:
   * <code>URI</code>, <code>QUERY_STRING</code>, <code>HEADER</code>, or
   * <code>METHOD</code>.</p>
   */
  inline const LoggingConfiguration& GetLoggingConfiguration() const { return m_loggingConfiguration; }
  inline bool LoggingConfigurationHasBeenSet() const { return m_loggingConfigurationHasBeenSet; }
  template <typename LoggingConfigurationT = LoggingConfiguration>
  void SetLoggingConfiguration(LoggingConfigurationT&& value) {
    m_loggingConfigurationHasBeenSet = true;
    m_loggingConfiguration = std::forward<LoggingConfigurationT>(value);
  }
  template <typename LoggingConfigurationT = LoggingConfiguration>
  PutLoggingConfigurationRequest& WithLoggingConfiguration(LoggingConfigurationT&& value) {
    SetLoggingConfiguration(std::forward<LoggingConfigurationT>(value));
    return *this;
  }
  ///@}
 private:
  LoggingConfiguration m_loggingConfiguration;
  bool m_loggingConfigurationHasBeenSet = false;
};

}  // namespace Model
}  // namespace WAFRegional
}  // namespace Aws
