/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import java.util.Map;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.CaseStatement;
import org.codehaus.groovy.ast.stmt.DoWhileStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.SwitchStatement;
import org.codehaus.groovy.ast.stmt.SynchronizedStatement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.WhileStatement;

public abstract class ClassCodeExpressionTransformer
extends ClassCodeVisitorSupport
implements ExpressionTransformer {
    @Override
    public Expression transform(Expression expr) {
        if (expr == null) {
            return null;
        }
        return expr.transformExpression(this);
    }

    @Override
    protected void visitAnnotation(AnnotationNode node) {
        for (Map.Entry<String, Expression> entry : node.getMembers().entrySet()) {
            entry.setValue(this.transform(entry.getValue()));
        }
    }

    @Override
    protected void visitConstructorOrMethod(MethodNode node, boolean isConstructor) {
        for (Parameter p : node.getParameters()) {
            Expression init = p.getInitialExpression();
            if (init == null) continue;
            p.setInitialExpression(this.transform(init));
        }
        super.visitConstructorOrMethod(node, isConstructor);
    }

    @Override
    public void visitClosureExpression(ClosureExpression expr) {
        if (expr.isParameterSpecified()) {
            for (Parameter p : expr.getParameters()) {
                Expression init = p.getInitialExpression();
                if (init == null) continue;
                p.setInitialExpression(this.transform(init));
            }
        }
        super.visitClosureExpression(expr);
    }

    @Override
    public void visitField(FieldNode node) {
        this.visitAnnotations(node);
        Expression init = node.getInitialExpression();
        if (init != null) {
            node.setInitialValueExpression(this.transform(init));
        }
    }

    @Override
    public void visitProperty(PropertyNode node) {
        this.visitAnnotations(node);
        this.visitClassCodeContainer(node.getGetterBlock());
        this.visitClassCodeContainer(node.getSetterBlock());
    }

    @Override
    public void visitAssertStatement(AssertStatement stmt) {
        stmt.setBooleanExpression((BooleanExpression)this.transform(stmt.getBooleanExpression()));
        stmt.setMessageExpression(this.transform(stmt.getMessageExpression()));
    }

    @Override
    public void visitCaseStatement(CaseStatement stmt) {
        stmt.setExpression(this.transform(stmt.getExpression()));
        stmt.getCode().visit(this);
    }

    @Override
    public void visitDoWhileLoop(DoWhileStatement stmt) {
        stmt.getLoopBlock().visit(this);
        stmt.setBooleanExpression((BooleanExpression)this.transform(stmt.getBooleanExpression()));
    }

    @Override
    public void visitExpressionStatement(ExpressionStatement stmt) {
        stmt.setExpression(this.transform(stmt.getExpression()));
    }

    @Override
    public void visitForLoop(ForStatement stmt) {
        this.visitAnnotations(stmt.getVariable());
        stmt.setCollectionExpression(this.transform(stmt.getCollectionExpression()));
        stmt.getLoopBlock().visit(this);
    }

    @Override
    public void visitIfElse(IfStatement stmt) {
        stmt.setBooleanExpression((BooleanExpression)this.transform(stmt.getBooleanExpression()));
        stmt.getIfBlock().visit(this);
        stmt.getElseBlock().visit(this);
    }

    @Override
    public void visitReturnStatement(ReturnStatement stmt) {
        stmt.setExpression(this.transform(stmt.getExpression()));
    }

    @Override
    public void visitSwitch(SwitchStatement stmt) {
        stmt.setExpression(this.transform(stmt.getExpression()));
        for (CaseStatement caseStatement : stmt.getCaseStatements()) {
            caseStatement.visit(this);
        }
        stmt.getDefaultStatement().visit(this);
    }

    @Override
    public void visitSynchronizedStatement(SynchronizedStatement stmt) {
        stmt.setExpression(this.transform(stmt.getExpression()));
        stmt.getCode().visit(this);
    }

    @Override
    public void visitThrowStatement(ThrowStatement stmt) {
        stmt.setExpression(this.transform(stmt.getExpression()));
    }

    @Override
    public void visitWhileLoop(WhileStatement stmt) {
        stmt.setBooleanExpression((BooleanExpression)this.transform(stmt.getBooleanExpression()));
        stmt.getLoopBlock().visit(this);
    }

    protected static void setSourcePosition(Expression target, Expression source) {
        target.setSourcePosition(source);
        if (target instanceof PropertyExpression) {
            ((PropertyExpression)target).getProperty().setSourcePosition(source);
        }
    }
}

