; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=x86_64-unknown-linux-gnu -mattr=-bmi < %s | FileCheck %s --check-prefixes=CHECK,CHECK-NOBMI
; RUN: llc -mtriple=x86_64-unknown-linux-gnu -mattr=+bmi < %s | FileCheck %s --check-prefixes=CHECK,CHECK-BMI

declare i32 @llvm.smax.i32(i32, i32)
declare i32 @llvm.smin.i32(i32, i32)
declare i64 @llvm.smax.i64(i64, i64)
declare i64 @llvm.smin.i64(i64, i64)

define i32 @test_i32_smax(i32 %a) nounwind {
; CHECK-NOBMI-LABEL: test_i32_smax:
; CHECK-NOBMI:       # %bb.0:
; CHECK-NOBMI-NEXT:    xorl %eax, %eax
; CHECK-NOBMI-NEXT:    testl %edi, %edi
; CHECK-NOBMI-NEXT:    cmovgl %edi, %eax
; CHECK-NOBMI-NEXT:    retq
;
; CHECK-BMI-LABEL: test_i32_smax:
; CHECK-BMI:       # %bb.0:
; CHECK-BMI-NEXT:    movl %edi, %eax
; CHECK-BMI-NEXT:    sarl $31, %eax
; CHECK-BMI-NEXT:    andnl %edi, %eax, %eax
; CHECK-BMI-NEXT:    retq
  %r = call i32 @llvm.smax.i32(i32 %a, i32 0)
  ret i32 %r
}

define i32 @test_i32_smin(i32 %a) nounwind {
; CHECK-LABEL: test_i32_smin:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movl %edi, %eax
; CHECK-NEXT:    sarl $31, %eax
; CHECK-NEXT:    andl %edi, %eax
; CHECK-NEXT:    retq
  %r = call i32 @llvm.smin.i32(i32 %a, i32 0)
  ret i32 %r
}

define i64 @test_i64_smax(i64 %a) nounwind {
; CHECK-NOBMI-LABEL: test_i64_smax:
; CHECK-NOBMI:       # %bb.0:
; CHECK-NOBMI-NEXT:    xorl %eax, %eax
; CHECK-NOBMI-NEXT:    testq %rdi, %rdi
; CHECK-NOBMI-NEXT:    cmovgq %rdi, %rax
; CHECK-NOBMI-NEXT:    retq
;
; CHECK-BMI-LABEL: test_i64_smax:
; CHECK-BMI:       # %bb.0:
; CHECK-BMI-NEXT:    movq %rdi, %rax
; CHECK-BMI-NEXT:    sarq $63, %rax
; CHECK-BMI-NEXT:    andnq %rdi, %rax, %rax
; CHECK-BMI-NEXT:    retq
  %r = call i64 @llvm.smax.i64(i64 %a, i64 0)
  ret i64 %r
}

define i64 @test_i64_smin(i64 %a) nounwind {
; CHECK-LABEL: test_i64_smin:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movq %rdi, %rax
; CHECK-NEXT:    sarq $63, %rax
; CHECK-NEXT:    andq %rdi, %rax
; CHECK-NEXT:    retq
  %r = call i64 @llvm.smin.i64(i64 %a, i64 0)
  ret i64 %r
}
