; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt < %s -mtriple=aarch64-linux-gnu -passes="print<cost-model>" -cost-kind=all 2>&1 -disable-output | FileCheck %s

; Verify the cost of scalar bitreverse instructions.

target datalayout = "e-m:e-i8:8:32-i16:16:32-i64:64-i128:128-n32:64-S128"

declare  i8 @llvm.bitreverse.i8(i8)
declare i16 @llvm.bitreverse.i16(i16)
declare i32 @llvm.bitreverse.i32(i32)
declare i64 @llvm.bitreverse.i64(i64)

define i64 @var_bitreverse_i64(i64 %a) {
; CHECK-LABEL: 'var_bitreverse_i64'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %bitreverse = call i64 @llvm.bitreverse.i64(i64 %a)
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i64 %bitreverse
;
  %bitreverse = call i64 @llvm.bitreverse.i64(i64 %a)
  ret i64 %bitreverse
}

define i32 @var_bitreverse_i32(i32 %a) {
; CHECK-LABEL: 'var_bitreverse_i32'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %bitreverse = call i32 @llvm.bitreverse.i32(i32 %a)
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i32 %bitreverse
;
  %bitreverse = call i32 @llvm.bitreverse.i32(i32 %a)
  ret i32 %bitreverse
}

define i16 @var_bitreverse_i16(i16 %a) {
; CHECK-LABEL: 'var_bitreverse_i16'
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %bitreverse = call i16 @llvm.bitreverse.i16(i16 %a)
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i16 %bitreverse
;
  %bitreverse = call i16 @llvm.bitreverse.i16(i16 %a)
  ret i16 %bitreverse
}

define i8 @var_bitreverse_i8(i8 %a) {
; CHECK-LABEL: 'var_bitreverse_i8'
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %bitreverse = call i8 @llvm.bitreverse.i8(i8 %a)
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret i8 %bitreverse
;
  %bitreverse = call i8 @llvm.bitreverse.i8(i8 %a)
  ret i8 %bitreverse
}

; Verify the cost of vector bitreverse instructions.

declare <1 x i64> @llvm.bitreverse.v1i64(<1 x i64>)
declare <2 x i32> @llvm.bitreverse.v2i32(<2 x i32>)
declare <4 x i16> @llvm.bitreverse.v4i16(<4 x i16>)
declare <8 x i8> @llvm.bitreverse.v8i8(<8 x i8>)

declare <2 x i64> @llvm.bitreverse.v2i64(<2 x i64>)
declare <4 x i32> @llvm.bitreverse.v4i32(<4 x i32>)
declare <8 x i16> @llvm.bitreverse.v8i16(<8 x i16>)
declare <16 x i8> @llvm.bitreverse.v16i8(<16 x i8>)

declare <4 x i64> @llvm.bitreverse.v4i64(<4 x i64>)
declare <8 x i32> @llvm.bitreverse.v8i32(<8 x i32>)
declare <16 x i16> @llvm.bitreverse.v16i16(<16 x i16>)
declare <32 x i8> @llvm.bitreverse.v32i8(<32 x i8>)

define <1 x i64> @var_bitreverse_v1i64(<1 x i64> %a) {
; CHECK-LABEL: 'var_bitreverse_v1i64'
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %bitreverse = call <1 x i64> @llvm.bitreverse.v1i64(<1 x i64> %a)
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <1 x i64> %bitreverse
;
  %bitreverse = call <1 x i64> @llvm.bitreverse.v1i64(<1 x i64> %a)
  ret <1 x i64> %bitreverse
}

define <2 x i64> @var_bitreverse_v2i64(<2 x i64> %a) {
; CHECK-LABEL: 'var_bitreverse_v2i64'
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %bitreverse = call <2 x i64> @llvm.bitreverse.v2i64(<2 x i64> %a)
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <2 x i64> %bitreverse
;
  %bitreverse = call <2 x i64> @llvm.bitreverse.v2i64(<2 x i64> %a)
  ret <2 x i64> %bitreverse
}

define <4 x i64> @var_bitreverse_v4i64(<4 x i64> %a) {
; CHECK-LABEL: 'var_bitreverse_v4i64'
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %bitreverse = call <4 x i64> @llvm.bitreverse.v4i64(<4 x i64> %a)
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i64> %bitreverse
;
  %bitreverse = call <4 x i64> @llvm.bitreverse.v4i64(<4 x i64> %a)
  ret <4 x i64> %bitreverse
}

define <2 x i32> @var_bitreverse_v2i32(<2 x i32> %a) {
; CHECK-LABEL: 'var_bitreverse_v2i32'
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %bitreverse = call <2 x i32> @llvm.bitreverse.v2i32(<2 x i32> %a)
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <2 x i32> %bitreverse
;
  %bitreverse = call <2 x i32> @llvm.bitreverse.v2i32(<2 x i32> %a)
  ret <2 x i32> %bitreverse
}

define <4 x i32> @var_bitreverse_v4i32(<4 x i32> %a) {
; CHECK-LABEL: 'var_bitreverse_v4i32'
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %bitreverse = call <4 x i32> @llvm.bitreverse.v4i32(<4 x i32> %a)
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i32> %bitreverse
;
  %bitreverse = call <4 x i32> @llvm.bitreverse.v4i32(<4 x i32> %a)
  ret <4 x i32> %bitreverse
}

define <8 x i32> @var_bitreverse_v8i32(<8 x i32> %a) {
; CHECK-LABEL: 'var_bitreverse_v8i32'
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %bitreverse = call <8 x i32> @llvm.bitreverse.v8i32(<8 x i32> %a)
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i32> %bitreverse
;
  %bitreverse = call <8 x i32> @llvm.bitreverse.v8i32(<8 x i32> %a)
  ret <8 x i32> %bitreverse
}

define <4 x i16> @var_bitreverse_v4i16(<4 x i16> %a) {
; CHECK-LABEL: 'var_bitreverse_v4i16'
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %bitreverse = call <4 x i16> @llvm.bitreverse.v4i16(<4 x i16> %a)
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <4 x i16> %bitreverse
;
  %bitreverse = call <4 x i16> @llvm.bitreverse.v4i16(<4 x i16> %a)
  ret <4 x i16> %bitreverse
}

define <8 x i16> @var_bitreverse_v8i16(<8 x i16> %a) {
; CHECK-LABEL: 'var_bitreverse_v8i16'
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %bitreverse = call <8 x i16> @llvm.bitreverse.v8i16(<8 x i16> %a)
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i16> %bitreverse
;
  %bitreverse = call <8 x i16> @llvm.bitreverse.v8i16(<8 x i16> %a)
  ret <8 x i16> %bitreverse
}

define <16 x i16> @var_bitreverse_v16i16(<16 x i16> %a) {
; CHECK-LABEL: 'var_bitreverse_v16i16'
; CHECK-NEXT:  Cost Model: Found costs of 4 for: %bitreverse = call <16 x i16> @llvm.bitreverse.v16i16(<16 x i16> %a)
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i16> %bitreverse
;
  %bitreverse = call <16 x i16> @llvm.bitreverse.v16i16(<16 x i16> %a)
  ret <16 x i16> %bitreverse
}

define <8 x i8> @var_bitreverse_v8i8(<8 x i8> %a) {
; CHECK-LABEL: 'var_bitreverse_v8i8'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %bitreverse = call <8 x i8> @llvm.bitreverse.v8i8(<8 x i8> %a)
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <8 x i8> %bitreverse
;
  %bitreverse = call <8 x i8> @llvm.bitreverse.v8i8(<8 x i8> %a)
  ret <8 x i8> %bitreverse
}

define <16 x i8> @var_bitreverse_v16i8(<16 x i8> %a) {
; CHECK-LABEL: 'var_bitreverse_v16i8'
; CHECK-NEXT:  Cost Model: Found costs of 1 for: %bitreverse = call <16 x i8> @llvm.bitreverse.v16i8(<16 x i8> %a)
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <16 x i8> %bitreverse
;
  %bitreverse = call <16 x i8> @llvm.bitreverse.v16i8(<16 x i8> %a)
  ret <16 x i8> %bitreverse
}

define <32 x i8> @var_bitreverse_v32i8(<32 x i8> %a) {
; CHECK-LABEL: 'var_bitreverse_v32i8'
; CHECK-NEXT:  Cost Model: Found costs of 2 for: %bitreverse = call <32 x i8> @llvm.bitreverse.v32i8(<32 x i8> %a)
; CHECK-NEXT:  Cost Model: Found costs of RThru:0 CodeSize:1 Lat:1 SizeLat:1 for: ret <32 x i8> %bitreverse
;
  %bitreverse = call <32 x i8> @llvm.bitreverse.v32i8(<32 x i8> %a)
  ret <32 x i8> %bitreverse
}
