import { addErrorMessage, setResponseValueAndErrors } from "../errorMessages.mjs";
export function parseNumberDef(def, refs) {
    const res = {
        type: 'number',
    };
    if (!def.checks)
        return res;
    for (const check of def.checks) {
        switch (check.kind) {
            case 'int':
                res.type = 'integer';
                addErrorMessage(res, 'type', check.message, refs);
                break;
            case 'min':
                if (refs.target === 'jsonSchema7') {
                    if (check.inclusive) {
                        setResponseValueAndErrors(res, 'minimum', check.value, check.message, refs);
                    }
                    else {
                        setResponseValueAndErrors(res, 'exclusiveMinimum', check.value, check.message, refs);
                    }
                }
                else {
                    if (!check.inclusive) {
                        res.exclusiveMinimum = true;
                    }
                    setResponseValueAndErrors(res, 'minimum', check.value, check.message, refs);
                }
                break;
            case 'max':
                if (refs.target === 'jsonSchema7') {
                    if (check.inclusive) {
                        setResponseValueAndErrors(res, 'maximum', check.value, check.message, refs);
                    }
                    else {
                        setResponseValueAndErrors(res, 'exclusiveMaximum', check.value, check.message, refs);
                    }
                }
                else {
                    if (!check.inclusive) {
                        res.exclusiveMaximum = true;
                    }
                    setResponseValueAndErrors(res, 'maximum', check.value, check.message, refs);
                }
                break;
            case 'multipleOf':
                setResponseValueAndErrors(res, 'multipleOf', check.value, check.message, refs);
                break;
        }
    }
    return res;
}
//# sourceMappingURL=number.mjs.map