from __future__ import annotations

from colour.utilities import LazyCanonicalMapping

# isort: split

from .aces import (
    RGB_COLOURSPACE_ACES2065_1,
    RGB_COLOURSPACE_ACESCC,
    RGB_COLOURSPACE_ACESCCT,
    RGB_COLOURSPACE_ACESCG,
    RGB_COLOURSPACE_ACESPROXY,
)
from .adobe_rgb_1998 import RGB_COLOURSPACE_ADOBE_RGB1998
from .adobe_wide_gamut_rgb import RGB_COLOURSPACE_ADOBE_WIDE_GAMUT_RGB
from .apple_rgb import RGB_COLOURSPACE_APPLE_RGB
from .arri import (
    RGB_COLOURSPACE_ARRI_WIDE_GAMUT_3,
    RGB_COLOURSPACE_ARRI_WIDE_GAMUT_4,
)
from .best_rgb import RGB_COLOURSPACE_BEST_RGB
from .beta_rgb import RGB_COLOURSPACE_BETA_RGB
from .blackmagic_design import RGB_COLOURSPACE_BLACKMAGIC_WIDE_GAMUT
from .canon_cinema_gamut import RGB_COLOURSPACE_CINEMA_GAMUT
from .cie_rgb import RGB_COLOURSPACE_CIE_RGB
from .color_match_rgb import RGB_COLOURSPACE_COLOR_MATCH_RGB
from .davinci_wide_gamut import RGB_COLOURSPACE_DAVINCI_WIDE_GAMUT
from .dcdm_xyz import RGB_COLOURSPACE_DCDM_XYZ
from .dci_p3 import RGB_COLOURSPACE_DCI_P3, RGB_COLOURSPACE_DCI_P3_P
from .display_p3 import RGB_COLOURSPACE_DISPLAY_P3
from .dji_d_gamut import RGB_COLOURSPACE_DJI_D_GAMUT
from .don_rgb_4 import RGB_COLOURSPACE_DON_RGB_4
from .ebu_3213_e import RGB_COLOURSPACE_EBU_3213_E
from .eci_rgb_v2 import RGB_COLOURSPACE_ECI_RGB_V2
from .ekta_space_ps5 import RGB_COLOURSPACE_EKTA_SPACE_PS_5
from .filmlight import (
    RGB_COLOURSPACE_FILMLIGHT_E_GAMUT,
    RGB_COLOURSPACE_FILMLIGHT_E_GAMUT_2,
)
from .fujifilm import RGB_COLOURSPACE_F_GAMUT, RGB_COLOURSPACE_F_GAMUT_C
from .gopro import RGB_COLOURSPACE_PROTUNE_NATIVE
from .itur_bt_470 import RGB_COLOURSPACE_BT470_525, RGB_COLOURSPACE_BT470_625
from .itur_bt_709 import RGB_COLOURSPACE_BT709
from .itur_bt_2020 import RGB_COLOURSPACE_BT2020
from .itut_h_273 import (
    RGB_COLOURSPACE_H273_22_UNSPECIFIED,
    RGB_COLOURSPACE_H273_GENERIC_FILM,
)
from .max_rgb import RGB_COLOURSPACE_MAX_RGB
from .nikon_n_gamut import RGB_COLOURSPACE_N_GAMUT
from .p3_d65 import RGB_COLOURSPACE_P3_D65
from .pal_secam import RGB_COLOURSPACE_PAL_SECAM
from .panasonic_v_gamut import RGB_COLOURSPACE_V_GAMUT
from .red import (
    RGB_COLOURSPACE_DRAGON_COLOR,
    RGB_COLOURSPACE_DRAGON_COLOR_2,
    RGB_COLOURSPACE_RED_COLOR,
    RGB_COLOURSPACE_RED_COLOR_2,
    RGB_COLOURSPACE_RED_COLOR_3,
    RGB_COLOURSPACE_RED_COLOR_4,
    RGB_COLOURSPACE_RED_WIDE_GAMUT_RGB,
)
from .rimm_romm_rgb import (
    RGB_COLOURSPACE_ERIMM_RGB,
    RGB_COLOURSPACE_PROPHOTO_RGB,
    RGB_COLOURSPACE_RIMM_RGB,
    RGB_COLOURSPACE_ROMM_RGB,
)

# isort: split

from .plasa_ansi_e154 import RGB_COLOURSPACE_PLASA_ANSI_E154
from .russell_rgb import RGB_COLOURSPACE_RUSSELL_RGB
from .sharp import RGB_COLOURSPACE_SHARP_RGB
from .smpte_240m import RGB_COLOURSPACE_SMPTE_240M
from .smpte_c import RGB_COLOURSPACE_SMPTE_C

# isort: split

from .ntsc import RGB_COLOURSPACE_NTSC1953, RGB_COLOURSPACE_NTSC1987

# isort: split

from .sony import (
    RGB_COLOURSPACE_S_GAMUT,
    RGB_COLOURSPACE_S_GAMUT3,
    RGB_COLOURSPACE_S_GAMUT3_CINE,
    RGB_COLOURSPACE_VENICE_S_GAMUT3,
    RGB_COLOURSPACE_VENICE_S_GAMUT3_CINE,
)
from .srgb import RGB_COLOURSPACE_sRGB
from .xtreme_rgb import RGB_COLOURSPACE_XTREME_RGB

# isort: split

from colour.models.rgb import RGB_Colourspace

from .color_interop_forum import (
    RGB_COLOURSPACE_G18_REC709_SCENE,
    RGB_COLOURSPACE_G22_ADOBERGB_SCENE,
    RGB_COLOURSPACE_G22_AP1_SCENE,
    RGB_COLOURSPACE_G22_REC709_SCENE,
    RGB_COLOURSPACE_LIN_ADOBERGB_SCENE,
    RGB_COLOURSPACE_LIN_CIEXYZD65_SCENE,
    RGB_COLOURSPACE_LIN_P3D65_SCENE,
    RGB_COLOURSPACE_LIN_REC709_SCENE,
    RGB_COLOURSPACE_LIN_REC2020_SCENE,
    RGB_COLOURSPACE_SRGB_AP1_SCENE,
    RGB_COLOURSPACE_SRGB_P3D65_SCENE,
    RGB_COLOURSPACE_SRGB_REC709_SCENE,
    RGB_COLOURSPACES_TEXTURE_ASSETS_AND_CG_RENDERING_CIF,
)

RGB_COLOURSPACES: LazyCanonicalMapping = LazyCanonicalMapping(
    dict(
        sorted(
            (colourspace.name, colourspace)
            for colourspace in locals().values()
            if isinstance(colourspace, RGB_Colourspace)
        )
    )
)
RGB_COLOURSPACES.__doc__ = """
Aggregated *RGB* colourspaces.

Aliases:

-   'aces': RGB_COLOURSPACE_ACES2065_1.name
-   'adobe1998': RGB_COLOURSPACE_ADOBE_RGB1998.name
-   'prophoto': RGB_COLOURSPACE_PROPHOTO_RGB.name
"""

RGB_COLOURSPACES["aces"] = RGB_COLOURSPACES[RGB_COLOURSPACE_ACES2065_1.name]
RGB_COLOURSPACES["adobe1998"] = RGB_COLOURSPACES[RGB_COLOURSPACE_ADOBE_RGB1998.name]
RGB_COLOURSPACES["prophoto"] = RGB_COLOURSPACES[RGB_COLOURSPACE_PROPHOTO_RGB.name]

RGB_COLOURSPACES.update(RGB_COLOURSPACES_TEXTURE_ASSETS_AND_CG_RENDERING_CIF)

__all__ = [
    "RGB_COLOURSPACE_ACES2065_1",
    "RGB_COLOURSPACE_ACESCC",
    "RGB_COLOURSPACE_ACESCCT",
    "RGB_COLOURSPACE_ACESCG",
    "RGB_COLOURSPACE_ACESPROXY",
]
__all__ += [
    "RGB_COLOURSPACE_ADOBE_RGB1998",
]
__all__ += [
    "RGB_COLOURSPACE_ADOBE_WIDE_GAMUT_RGB",
]
__all__ += [
    "RGB_COLOURSPACE_APPLE_RGB",
]
__all__ += [
    "RGB_COLOURSPACE_ARRI_WIDE_GAMUT_3",
    "RGB_COLOURSPACE_ARRI_WIDE_GAMUT_4",
]
__all__ += [
    "RGB_COLOURSPACE_BEST_RGB",
]
__all__ += [
    "RGB_COLOURSPACE_BETA_RGB",
]
__all__ += [
    "RGB_COLOURSPACE_BLACKMAGIC_WIDE_GAMUT",
]
__all__ += [
    "RGB_COLOURSPACE_CINEMA_GAMUT",
]
__all__ += [
    "RGB_COLOURSPACE_CIE_RGB",
]
__all__ += [
    "RGB_COLOURSPACE_COLOR_MATCH_RGB",
]
__all__ += [
    "RGB_COLOURSPACE_DAVINCI_WIDE_GAMUT",
]
__all__ += [
    "RGB_COLOURSPACE_DCDM_XYZ",
]
__all__ += [
    "RGB_COLOURSPACE_DCI_P3",
    "RGB_COLOURSPACE_DCI_P3_P",
]
__all__ += [
    "RGB_COLOURSPACE_DISPLAY_P3",
]
__all__ += [
    "RGB_COLOURSPACE_DJI_D_GAMUT",
]
__all__ += [
    "RGB_COLOURSPACE_DON_RGB_4",
]
__all__ += [
    "RGB_COLOURSPACE_EBU_3213_E",
]
__all__ += [
    "RGB_COLOURSPACE_ECI_RGB_V2",
]
__all__ += [
    "RGB_COLOURSPACE_EKTA_SPACE_PS_5",
]
__all__ += [
    "RGB_COLOURSPACE_FILMLIGHT_E_GAMUT",
    "RGB_COLOURSPACE_FILMLIGHT_E_GAMUT_2",
]
__all__ += [
    "RGB_COLOURSPACE_F_GAMUT",
    "RGB_COLOURSPACE_F_GAMUT_C",
]
__all__ += [
    "RGB_COLOURSPACE_PROTUNE_NATIVE",
]
__all__ += [
    "RGB_COLOURSPACE_BT470_525",
    "RGB_COLOURSPACE_BT470_625",
]
__all__ += [
    "RGB_COLOURSPACE_BT709",
]
__all__ += [
    "RGB_COLOURSPACE_BT2020",
]
__all__ += [
    "RGB_COLOURSPACE_H273_22_UNSPECIFIED",
    "RGB_COLOURSPACE_H273_GENERIC_FILM",
]
__all__ += [
    "RGB_COLOURSPACE_MAX_RGB",
]
__all__ += [
    "RGB_COLOURSPACE_N_GAMUT",
]
__all__ += [
    "RGB_COLOURSPACE_P3_D65",
]
__all__ += [
    "RGB_COLOURSPACE_PAL_SECAM",
]
__all__ += [
    "RGB_COLOURSPACE_V_GAMUT",
]
__all__ += [
    "RGB_COLOURSPACE_DRAGON_COLOR",
    "RGB_COLOURSPACE_DRAGON_COLOR_2",
    "RGB_COLOURSPACE_RED_COLOR",
    "RGB_COLOURSPACE_RED_COLOR_2",
    "RGB_COLOURSPACE_RED_COLOR_3",
    "RGB_COLOURSPACE_RED_COLOR_4",
    "RGB_COLOURSPACE_RED_WIDE_GAMUT_RGB",
]
__all__ += [
    "RGB_COLOURSPACE_ERIMM_RGB",
    "RGB_COLOURSPACE_PROPHOTO_RGB",
    "RGB_COLOURSPACE_RIMM_RGB",
    "RGB_COLOURSPACE_ROMM_RGB",
]
__all__ += [
    "RGB_COLOURSPACE_PLASA_ANSI_E154",
]
__all__ += [
    "RGB_COLOURSPACE_RUSSELL_RGB",
]
__all__ += [
    "RGB_COLOURSPACE_SHARP_RGB",
]
__all__ += [
    "RGB_COLOURSPACE_SMPTE_240M",
]
__all__ += [
    "RGB_COLOURSPACE_SMPTE_C",
]
__all__ += [
    "RGB_COLOURSPACE_NTSC1953",
    "RGB_COLOURSPACE_NTSC1987",
]
__all__ += [
    "RGB_COLOURSPACE_S_GAMUT",
    "RGB_COLOURSPACE_S_GAMUT3",
    "RGB_COLOURSPACE_S_GAMUT3_CINE",
    "RGB_COLOURSPACE_VENICE_S_GAMUT3",
    "RGB_COLOURSPACE_VENICE_S_GAMUT3_CINE",
]
__all__ += [
    "RGB_COLOURSPACE_sRGB",
]
__all__ += [
    "RGB_COLOURSPACE_XTREME_RGB",
]
__all__ += [
    "RGB_COLOURSPACE_G18_REC709_SCENE",
    "RGB_COLOURSPACE_G22_ADOBERGB_SCENE",
    "RGB_COLOURSPACE_G22_AP1_SCENE",
    "RGB_COLOURSPACE_G22_REC709_SCENE",
    "RGB_COLOURSPACE_LIN_ADOBERGB_SCENE",
    "RGB_COLOURSPACE_LIN_CIEXYZD65_SCENE",
    "RGB_COLOURSPACE_LIN_P3D65_SCENE",
    "RGB_COLOURSPACE_LIN_REC709_SCENE",
    "RGB_COLOURSPACE_LIN_REC2020_SCENE",
    "RGB_COLOURSPACE_SRGB_AP1_SCENE",
    "RGB_COLOURSPACE_SRGB_P3D65_SCENE",
    "RGB_COLOURSPACE_SRGB_REC709_SCENE",
    "RGB_COLOURSPACES_TEXTURE_ASSETS_AND_CG_RENDERING_CIF",
]
